/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.name;

import java.io.IOException;
import java.io.Writer;
import oracle.javatools.exports.name.ElementName;

public final class PackageName
extends ElementName {
    public static final PackageName DEFAULT_PACKAGE = new PackageName("");
    public static final PackageName JAVA_LANG = new PackageName("java.lang");
    public static final PackageName JAVA_IO = new PackageName("java.io");
    public static final PackageName ORACLE_JDBC_DRIVER = new PackageName("oracle.jdbc.driver");
    public static final PackageName WEBLOGIC_WTC_JATMI = new PackageName("weblogic.wtc.jatmi");
    static final PackageName[] INITIAL_PACKAGES = new PackageName[]{DEFAULT_PACKAGE, JAVA_LANG, JAVA_IO, ORACLE_JDBC_DRIVER, WEBLOGIC_WTC_JATMI};
    public static final PackageName[] EMPTY_ARRAY = new PackageName[0];
    private final String name;
    private int hash;

    PackageName(String name) {
        this.name = name;
    }

    public boolean isDefault() {
        return this.name.isEmpty();
    }

    @Override
    public int getLevel() {
        return 0;
    }

    @Override
    public ElementName getParent() {
        return null;
    }

    @Override
    public PackageName getPackage() {
        return this;
    }

    @Override
    public String getSimpleName() {
        return this.name.substring(this.name.lastIndexOf(46) + 1);
    }

    @Override
    public String getSourceName() {
        return this.name;
    }

    public int getQualifiedNameLength() {
        return this.name.length();
    }

    public int getQualifiedNamePrefixLength() {
        int length = this.name.length();
        return length == 0 ? 0 : length + 1;
    }

    @Override
    public String getQualifiedSourceName() {
        return this.name;
    }

    StringBuilder appendQualifiedSourceNamePrefix(StringBuilder builder) {
        return this.name.isEmpty() ? builder : builder.append(this.name).append('.');
    }

    @Override
    public String getBinaryName() {
        return this.name.replace('.', '/');
    }

    @Override
    public String getQualifiedBinaryName() {
        return this.name.replace('.', '/');
    }

    StringBuilder appendQualifiedBinaryName(StringBuilder builder) {
        int length = this.name.length();
        for (int i = 0; i < length; ++i) {
            char c = this.name.charAt(i);
            builder.append(c == '.' ? (char)'/' : (char)c);
        }
        return builder;
    }

    StringBuilder appendQualifiedBinaryNamePrefix(StringBuilder builder) {
        return this.name.isEmpty() ? builder : this.appendQualifiedBinaryName(builder).append('/');
    }

    public StringBuilder appendDirectory(StringBuilder builder, char separator) {
        int length = this.name.length();
        if (length == 0) {
            return builder;
        }
        for (int i = 0; i < length; ++i) {
            char c = this.name.charAt(i);
            builder.append(c == '.' ? separator : c);
        }
        return builder.append(separator);
    }

    public void writeDirectory(Writer writer, char separator) throws IOException {
        int length = this.name.length();
        if (length == 0) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            char c = this.name.charAt(i);
            writer.write(c == '.' ? separator : c);
        }
        writer.write(separator);
    }

    @Override
    public String getQualifiedHybridName() {
        return this.name;
    }

    int getQualifiedHybridNamePrefixLength() {
        return this.name.length() + 1;
    }

    StringBuilder appendQualifiedHybridName(StringBuilder builder) {
        return builder.append(this.name);
    }

    StringBuilder appendQualifiedHybridNamePrefix(StringBuilder builder) {
        return builder.append(this.name).append('/');
    }

    @Override
    public void writeSourceName(Writer writer) throws IOException {
        writer.write(this.name);
    }

    @Override
    public void writeQualifiedSourceName(Writer writer) throws IOException {
        this.writeSourceName(writer);
    }

    protected void writeQualifiedSourceNamePrefix(Writer writer) throws IOException {
        if (this.name.isEmpty()) {
            return;
        }
        this.writeSourceName(writer);
        writer.write(46);
    }

    @Override
    public void writeQualifiedHybridName(Writer writer) throws IOException {
        this.writeSourceName(writer);
    }

    void writeQualifiedHybridNamePrefix(Writer writer) throws IOException {
        this.writeSourceName(writer);
        writer.write(47);
    }

    boolean startsQualifiedName(String qualifiedBinaryName) {
        int length = this.name.length();
        if (qualifiedBinaryName.length() < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char s;
            char k = this.name.charAt(i);
            if (k == (s = qualifiedBinaryName.charAt(i)) || k == '.' && s == '/') continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(ElementName that) {
        if (this == that) {
            return 0;
        }
        int comparison = this.name.compareTo(that.getPackage().name);
        return comparison != 0 ? comparison : Integer.compare(0, that.getLevel());
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof PackageName && this.name.equals(((PackageName)that).name);
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h != 0) {
            return h;
        }
        int length = this.name.length();
        for (int i = 0; i < length; ++i) {
            int c = this.name.charAt(i);
            if (c == 46) {
                c = 36;
            }
            h = 31 * h + c;
        }
        this.hash = h;
        return this.hash;
    }
}

