/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.specification;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.exports.Access;
import oracle.javatools.exports.name.FieldName;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.PackageName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.specification.ExportDomain;
import oracle.javatools.exports.specification.ExportSpecification;
import oracle.javatools.exports.specification.PackageExportSpecification;
import oracle.javatools.exports.specification.TypeExportSpecification;

public class ExportSpecificationWriter {
    private Charset encoding = StandardCharsets.UTF_8;

    public void write(ExportSpecification specification, Path path) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, this.encoding, new OpenOption[0]);){
            this.write(specification, writer);
        }
    }

    public void write(ExportSpecification specification, URL url) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(URLFileSystem.openOutputStream(url), this.encoding));){
            this.write(specification, writer);
        }
    }

    private void write(ExportSpecification specification, BufferedWriter writer) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"");
        writer.write(this.encoding.name());
        writer.write("\" ?>");
        writer.newLine();
        writer.write("<lib-exports");
        if (specification.getSource() != null) {
            writer.write(" source=\"");
            writer.write(specification.getSource());
            writer.write(34);
        }
        if (specification.getOwner() != null) {
            writer.write(" owner=\"");
            writer.write(specification.getOwner());
            writer.write(34);
        }
        writer.write(" xmlns=\"http://xmlns.oracle.com/ide/export\"");
        int rootCloses = 0;
        for (String string : specification.getConsumers()) {
            if (rootCloses++ == 0) {
                writer.write(62);
                writer.newLine();
            }
            ExportSpecificationWriter.writeIndent(1, writer);
            writer.write("<consumer team=\"");
            writer.write(string.trim());
            writer.write("\"/>");
            writer.newLine();
        }
        ExportDomain domain = specification.getDomain();
        if (!domain.isUniversal()) {
            if (rootCloses++ == 0) {
                writer.write(62);
                writer.newLine();
            }
            for (ExportDomain.Subdomain subdomain : domain.getSubdomains()) {
                if (rootCloses++ == 0) {
                    writer.write(62);
                    writer.newLine();
                }
                ExportSpecificationWriter.writeIndent(1, writer);
                writer.write("<domain name=\"");
                String name = subdomain.getName();
                writer.write(name, 0, name.length() - 1);
                List<String> exceptions = subdomain.getExceptions();
                if (!exceptions.isEmpty()) {
                    writer.write("\">");
                    writer.newLine();
                    for (String exception : exceptions) {
                        ExportSpecificationWriter.writeIndent(2, writer);
                        writer.write("<except name=\"");
                        writer.write(exception, 0, exception.length() - 1);
                        writer.write("\"/>");
                        writer.newLine();
                    }
                    ExportSpecificationWriter.writeIndent(1, writer);
                    writer.write("</domain>");
                } else {
                    writer.write("\"/>");
                }
                writer.newLine();
            }
        }
        ArrayList<PackageName> arrayList = new ArrayList<PackageName>(specification.getPackageNames());
        Collections.sort(arrayList);
        for (PackageName packageName : arrayList) {
            PackageExportSpecification packag = specification.getPackage(packageName);
            if (rootCloses++ == 0) {
                writer.write(62);
                writer.newLine();
            }
            ExportSpecificationWriter.writeIndent(1, writer);
            writer.write("<package name=\"");
            packageName.writeSourceName(writer);
            writer.write(34);
            Access defaultTypeAccess = packag.getDefaultMemberAccess();
            if (packag.getTypeNames().isEmpty()) {
                if (defaultTypeAccess != Access.EXPORTED) {
                    writer.write(" members=\"");
                    writer.write(defaultTypeAccess.toString());
                    writer.write(34);
                }
                writer.write("/>");
                writer.newLine();
                continue;
            }
            ArrayList<TypeName> types = new ArrayList<TypeName>(packag.getTypeNames());
            Collections.sort(types);
            Access packageAccess = null;
            for (TypeName typeName : types) {
                packageAccess = packag.getType(typeName).getAccess();
                assert (Access.isExportedOrRestricted(packageAccess));
                if (!packageAccess.isExported()) continue;
                break;
            }
            if (packageAccess.isRestricted()) {
                writer.write(" members=\"restricted\"");
            }
            writer.write(62);
            writer.newLine();
            for (TypeName typeName : types) {
                TypeExportSpecification type = packag.getType(typeName);
                String typeKind = packag.isInterface(typeName) ? "interface" : "class";
                Access typeAccess = type.getAccess();
                Access typeExtension = type.getExtension();
                assert (Access.isExportedOrRestricted(typeAccess));
                ExportSpecificationWriter.writeIndent(2, writer);
                writer.write(60);
                writer.write(typeKind);
                writer.write(" name=\"");
                typeName.writeSourceName(writer);
                writer.write(34);
                if (typeAccess != packageAccess) {
                    writer.write(" access=\"");
                    writer.write(typeAccess.toString());
                    writer.write(34);
                }
                if (typeExtension != typeAccess) {
                    writer.write(" extension=\"");
                    writer.write(typeExtension.toString());
                    writer.write(34);
                }
                Access defaultMemberAccess = type.getDefaultMemberAccess();
                if (type.getMemberNames().isEmpty()) {
                    if (defaultMemberAccess != typeAccess) {
                        writer.write(" members=\"");
                        writer.write(defaultMemberAccess.toString());
                        writer.write(34);
                    }
                    writer.write("/>");
                    writer.newLine();
                    continue;
                }
                writer.write(62);
                writer.newLine();
                ArrayList<MemberName> members = new ArrayList<MemberName>(type.getMemberNames());
                Collections.sort(members);
                for (MemberName memberName : members) {
                    Access memberAccess = type.getMember(memberName);
                    ExportSpecificationWriter.writeIndent(3, writer);
                    writer.write("<");
                    writer.write(memberName.getKind().toLowerCase());
                    if (memberName instanceof FieldName) {
                        writer.write(32);
                    }
                    writer.write(" name=\"");
                    memberName.writeSourceName(writer);
                    writer.write(34);
                    if (memberAccess != typeAccess) {
                        writer.write(" access=\"");
                        writer.write(memberAccess.toString());
                        writer.write(34);
                    }
                    writer.write("/>");
                    writer.newLine();
                }
                ExportSpecificationWriter.writeIndent(2, writer);
                writer.write("</");
                writer.write(typeKind);
                writer.write(62);
                writer.newLine();
            }
            ExportSpecificationWriter.writeIndent(1, writer);
            writer.write("</package>");
            writer.newLine();
        }
        writer.write(rootCloses++ == 0 ? "/>" : "</lib-exports>");
        writer.newLine();
    }

    private static void writeIndent(int depth, BufferedWriter writer) throws IOException {
        for (int i = 0; i < depth; ++i) {
            writer.write("  ");
        }
    }
}

