/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.specification;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import oracle.javatools.exports.Access;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.specification.Merge;

public class TypeExportSpecification {
    public static final TypeExportSpecification DEFAULT_EXPORTED = new TypeExportSpecification(Access.EXPORTED, Access.EXPORTED, null, Access.EXPORTED);
    public static final TypeExportSpecification DEFAULT_RESTRICTED = new TypeExportSpecification(Access.RESTRICTED, Access.RESTRICTED, null, Access.RESTRICTED);
    public static final TypeExportSpecification DEFAULT_CONCEALED = new TypeExportSpecification(Access.CONCEALED, Access.CONCEALED, null, Access.CONCEALED);
    public static final TypeExportSpecification DEFAULT_NULL = new TypeExportSpecification(null, null, null, null);
    private final Access access;
    private final Access extension;
    private final Map<MemberName, Access> members;
    private final Access defaultMemberAccess;

    public TypeExportSpecification(Access access, Access extension, Map<MemberName, Access> members, Access defaultMemberAccess) {
        if (extension == null && access != null) {
            throw new IllegalStateException("extension null when access not");
        }
        if (members == null) {
            members = Collections.emptyMap();
        }
        if (defaultMemberAccess == null) {
            defaultMemberAccess = access;
        }
        if (Access.isMoreExported(extension, access)) {
            throw new IllegalStateException("extension more exported than access");
        }
        if (!members.isEmpty() && !Access.isConcealed(defaultMemberAccess)) {
            throw new IllegalStateException("members itemized but default member access not concealed");
        }
        for (Access memberAccess : members.values()) {
            if (!Access.isMoreExported(memberAccess, access)) continue;
            throw new IllegalStateException("member access more exported than access");
        }
        if (Access.isMoreExported(defaultMemberAccess, access)) {
            throw new IllegalStateException("default member access more exported than access");
        }
        this.access = access;
        this.extension = extension;
        this.members = members;
        this.defaultMemberAccess = defaultMemberAccess;
    }

    public Merge<TypeExportSpecification> merge(TypeExportSpecification that) {
        Access thatAccess;
        if (!Access.isExportedOrRestricted(this.access)) {
            throw new IllegalStateException("merging concealed or uncontrolled type: " + this);
        }
        if (!Access.isExportedOrRestricted(that.access)) {
            throw new IllegalStateException("merging concealed or uncontrolled type: " + that);
        }
        Merge<TypeExportSpecification> merge = new Merge<TypeExportSpecification>(this, that, "type export specification", new Object[0]);
        if (merge.completeIfEqual()) {
            return merge;
        }
        Access thisAccess = this.getAccess();
        Merge<Access> mergedAccess = new Merge<Access>(thisAccess, thatAccess = that.getAccess(), "access", new Object[0]);
        if (!mergedAccess.completeIfEqual()) {
            mergedAccess.completeWarning(Access.mostExported(thisAccess, thatAccess));
        }
        merge.addMerge(mergedAccess);
        Access thisExtension = this.getExtension();
        Access thatExtension = that.getExtension();
        Merge<Access> mergedExtension = new Merge<Access>(thisExtension, thatExtension, "extension", new Object[0]);
        if (!mergedExtension.completeIfEqual()) {
            mergedExtension.completeWarning(Access.mostExported(thisExtension, thatExtension));
        }
        merge.addMerge(mergedExtension);
        Access thisDefaultMemberAccess = this.getDefaultMemberAccess();
        Access thatDefaultMemberAccess = that.getDefaultMemberAccess();
        Merge<Access> mergedDefaultMemberAccess = new Merge<Access>(thisDefaultMemberAccess, thatDefaultMemberAccess, "default member access", new Object[0]);
        Access adjustedAccess = null;
        if (!mergedDefaultMemberAccess.completeIfEqual()) {
            mergedDefaultMemberAccess.completeWarning(Access.mostExported(thisDefaultMemberAccess, thatDefaultMemberAccess));
            adjustedAccess = mergedDefaultMemberAccess.getValue();
        }
        merge.addMerge(mergedDefaultMemberAccess);
        Map<MemberName, Access> thisMembers = this.members;
        Map<MemberName, Access> thatMembers = that.members;
        Merge<Map<MemberName, Access>> mergedMembers = new Merge<Map<MemberName, Access>>(thisMembers, thatMembers, "members", new Object[0]);
        if (!mergedMembers.completeIfEqual()) {
            if (thisMembers.isEmpty() && Access.isExported(thisAccess)) {
                mergedMembers.complete(thisMembers);
            } else if (thatMembers.isEmpty() && Access.isExported(thatAccess)) {
                mergedMembers.complete(thatMembers);
            } else if (thisMembers.isEmpty() && Access.isConcealedOrNull(thisAccess)) {
                mergedMembers.complete(thatMembers);
            } else if (thatMembers.isEmpty() && Access.isConcealedOrNull(thatAccess)) {
                mergedMembers.complete(thisMembers);
            } else {
                if (adjustedAccess != null) {
                    Map<MemberName, Access> moreExportedMembers;
                    LinkedHashMap<MemberName, Access> lessExportedMembers;
                    if (adjustedAccess == thisDefaultMemberAccess) {
                        lessExportedMembers = new LinkedHashMap<MemberName, Access>(thatMembers);
                        thatMembers = lessExportedMembers;
                        moreExportedMembers = thisMembers;
                    } else {
                        lessExportedMembers = new LinkedHashMap<MemberName, Access>(thisMembers);
                        thisMembers = lessExportedMembers;
                        moreExportedMembers = thatMembers;
                    }
                    Iterator i = lessExportedMembers.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry entry = i.next();
                        if (moreExportedMembers.containsKey(entry.getKey())) continue;
                        Merge<Access> mergedMember = new Merge<Access>((Access)((Object)entry.getValue()), adjustedAccess, "member", new Object[0]);
                        if (!mergedMember.completeIfEqual()) {
                            mergedMember.completeWarning(Access.mostExported((Access)((Object)entry.getValue()), adjustedAccess));
                        }
                        if (adjustedAccess == mergedMember.getValue()) {
                            i.remove();
                            continue;
                        }
                        entry.setValue(mergedMember.getValue());
                        merge.addMerge(mergedMember);
                    }
                }
                Map<MemberName, Access> union = new LinkedHashMap<MemberName, Access>(thisMembers);
                for (Map.Entry<MemberName, Access> entry : thatMembers.entrySet()) {
                    Access thatMember;
                    MemberName memberName = entry.getKey();
                    Access thisMember = union.putIfAbsent(memberName, thatMember = entry.getValue());
                    if (thisMember == null) continue;
                    Merge<Access> mergedMember = new Merge<Access>(thisMember, thatMember, "member", new Object[0]);
                    if (!mergedMember.completeIfEqual()) {
                        mergedMember.completeWarning(Access.mostExported(thisMember, thatMember));
                    }
                    union.put(memberName, mergedMember.getValue());
                    mergedMembers.addMerge(mergedMember);
                }
                if (union.isEmpty()) {
                    union = Collections.emptyMap();
                }
                mergedMembers.complete(union);
            }
        }
        merge.addMerge(mergedMembers);
        merge.complete(new TypeExportSpecification(mergedAccess.getValue(), mergedExtension.getValue(), mergedMembers.getValue(), mergedDefaultMemberAccess.getValue()));
        return merge;
    }

    public Access getAccess() {
        return this.access;
    }

    public Access getExtension() {
        return this.extension;
    }

    public Access getMember(MemberName name) {
        return this.members.getOrDefault(name, this.defaultMemberAccess);
    }

    public Access getMemberUnqualified(MemberName name) {
        for (Map.Entry<MemberName, Access> entry : this.members.entrySet()) {
            if (name.compareToUnqualified(entry.getKey()) != 0) continue;
            return entry.getValue();
        }
        return this.defaultMemberAccess;
    }

    public boolean isMemberExplicit(MemberName name) {
        return this.members.containsKey(name);
    }

    public boolean isMemberExplicitUnqualified(MemberName name) {
        boolean result = false;
        for (MemberName key : this.members.keySet()) {
            if (name.compareToUnqualified(key) != 0) continue;
            result = true;
        }
        return result;
    }

    Set<MemberName> getMemberNames() {
        return this.members.keySet();
    }

    public Access getDefaultMemberAccess() {
        return this.defaultMemberAccess;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TypeExportSpecification)) {
            return false;
        }
        TypeExportSpecification that = (TypeExportSpecification)object;
        if (this.access != that.access) {
            return false;
        }
        if (this.extension != that.extension) {
            return false;
        }
        if (this.defaultMemberAccess != that.defaultMemberAccess) {
            return false;
        }
        return Objects.equals(this.members, that.members);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.access);
        builder.append(this.members == null ? "[*]" : this.members);
        builder.append((Object)this.defaultMemberAccess);
        return builder.toString();
    }
}

