/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.uses;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import oracle.javatools.exports.name.ElementKind;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.uses.TypeUses;

public class PackageUses {
    private final boolean controlled;
    private Map<TypeName, TypeUses> types = Collections.emptyMap();

    public PackageUses(boolean controlled) {
        this.controlled = controlled;
    }

    public boolean isControlled() {
        return this.controlled;
    }

    public Set<TypeName> getTypeNames() {
        return this.types.keySet();
    }

    public TypeUses getTypeUses(TypeName name) {
        return this.types.get(name);
    }

    TypeUses addType(TypeName name, ElementKind kind, boolean modelled) {
        if (this.types.isEmpty()) {
            this.types = new LinkedHashMap<TypeName, TypeUses>();
        }
        return this.types.computeIfAbsent(name, k -> new TypeUses(kind, this.controlled, modelled));
    }

    public int getTotalReferences() {
        int total = 0;
        for (TypeUses type : this.types.values()) {
            total += type.getReferences();
        }
        return total;
    }
}

