/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.uses;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import oracle.javatools.exports.name.ElementKind;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.uses.MemberUses;
import oracle.javatools.exports.uses.TypeOrMemberUses;

public class TypeUses
implements TypeOrMemberUses {
    private final ElementKind kind;
    private final boolean controlled;
    private final boolean modelled;
    private Map<MemberName, MemberUses> members = Collections.emptyMap();
    private short references;
    private short extensions;
    private short concrete;
    private short workspaces;

    public TypeUses(ElementKind kind, boolean controlled, boolean modelled) {
        this.kind = kind;
        this.controlled = controlled;
        this.modelled = modelled;
    }

    MemberUses addMember(MemberName name, boolean modelled, MemberName migratedTo) {
        if (this.members.isEmpty()) {
            this.members = new LinkedHashMap<MemberName, MemberUses>();
        }
        return this.members.computeIfAbsent(name, k -> new MemberUses(name.getKind(), modelled, migratedTo));
    }

    void addReferences(short references, short extensions, short concrete) {
        this.references = (short)(this.references + references);
        this.extensions = (short)(this.extensions + extensions);
        this.concrete = (short)(this.concrete + concrete);
        this.workspaces = (short)(this.workspaces + 1);
    }

    public ElementKind getKind() {
        return this.kind;
    }

    public boolean isControlled() {
        return this.controlled;
    }

    @Override
    public boolean isModelled() {
        return this.modelled;
    }

    @Override
    public String getLabel() {
        return this.getKind().toLowerCase();
    }

    @Override
    public short getReferences() {
        return this.references;
    }

    public short getExtensions() {
        return this.extensions;
    }

    public short getConcrete() {
        return this.concrete;
    }

    @Override
    public short getWorkspaces() {
        return this.workspaces;
    }

    public Set<MemberName> getMemberNames() {
        return this.members.keySet();
    }

    public MemberUses getMemberUses(MemberName name) {
        return this.members.get(name);
    }

    public int getTotalReferences() {
        int total = this.references;
        for (MemberUses member : this.members.values()) {
            total += member.getReferences();
        }
        return total;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.references).append(" reference");
        if (this.references != 1) {
            builder.append('s');
        }
        builder.append(", ").append(this.extensions).append(" extension");
        if (this.extensions != 1) {
            builder.append('s');
        }
        if (this.extensions > 0) {
            builder.append(" (").append(this.concrete).append(')');
        }
        builder.append(", ").append(this.workspaces).append(" workspace");
        if (this.workspaces != 1) {
            builder.append('s');
        }
        return builder.toString();
    }
}

