/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.uses;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import oracle.javatools.exports.Access;
import oracle.javatools.exports.classpath.ClassPathModel;
import oracle.javatools.exports.classpath.Field;
import oracle.javatools.exports.classpath.Member;
import oracle.javatools.exports.classpath.Type;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Scope;
import oracle.javatools.exports.name.ConstructorName;
import oracle.javatools.exports.name.ElementKind;
import oracle.javatools.exports.name.FieldName;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.MethodName;
import oracle.javatools.exports.name.PackageName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.name.TypeOrMemberName;
import oracle.javatools.exports.specification.ExportDomain;
import oracle.javatools.exports.specification.ExportSpecification;
import oracle.javatools.exports.specification.PackageExportSpecification;
import oracle.javatools.exports.specification.TypeExportSpecification;
import oracle.javatools.exports.uses.MemberUses;
import oracle.javatools.exports.uses.PackageUses;
import oracle.javatools.exports.uses.TypeUses;

public class UsesModel {
    private final ClassPathModel model;
    private final ExportDomain domain;
    private final Map<PackageName, PackageUses> packages = new LinkedHashMap<PackageName, PackageUses>();
    private Set<String> sources = Collections.emptySet();

    public UsesModel(ClassPathModel model) {
        this.model = model;
        this.domain = model.getDomain();
    }

    public UsesModel(ExportDomain domain) {
        this.model = null;
        this.domain = domain;
    }

    public UsesModel() {
        this.model = null;
        this.domain = new ExportDomain(new String[0]);
    }

    void addSource(String source) {
        switch (this.sources.size()) {
            case 0: {
                this.sources = Collections.singleton(source);
                break;
            }
            case 1: {
                this.sources = new HashSet<String>(this.sources);
            }
            default: {
                this.sources.add(source);
            }
        }
    }

    void addReferences(TypeOrMemberName typeOrMemberName, ElementKind typeKind, short references, short extensions, short concrete) {
        Type type;
        TypeName typeName = typeOrMemberName.getType();
        PackageUses packageUses = this.addPackage(typeName.getPackage());
        if (this.model == null) {
            TypeUses typeUses = packageUses.addType(typeName, typeKind, false);
            if (typeOrMemberName.isType()) {
                typeUses.addReferences(references, extensions, concrete);
            } else {
                MemberUses memberUses = typeUses.addMember((MemberName)typeOrMemberName, false, null);
                memberUses.addReferences(references);
            }
            return;
        }
        TypeUses typeUses = packageUses.getTypeUses(typeName);
        if (typeUses != null && typeOrMemberName.isType()) {
            typeUses.addReferences(references, extensions, concrete);
            return;
        }
        if (typeUses == null) {
            type = this.model.getType(typeName);
            typeUses = packageUses.addType(typeName, typeKind, type != null);
            if (typeOrMemberName.isType()) {
                typeUses.addReferences(references, extensions, concrete);
                return;
            }
            if (type == null) {
                this.model.getLog().warning("uses-missing-" + (Object)((Object)typeKind), "used %s %s not found in %s", new Object[]{typeKind, typeName, this.model});
                MemberUses memberUses = typeUses.addMember((MemberName)typeOrMemberName, false, null);
                memberUses.addReferences(references);
                return;
            }
        } else {
            if (!typeUses.isModelled()) {
                MemberUses memberUses = typeUses.addMember((MemberName)typeOrMemberName, false, null);
                memberUses.addReferences(references);
                return;
            }
            MemberUses memberUses = typeUses.getMemberUses((MemberName)typeOrMemberName);
            if (memberUses != null) {
                memberUses.addReferences(references);
                return;
            }
            type = this.model.getType(typeName);
            if (type == null) {
                memberUses = typeUses.addMember((MemberName)typeOrMemberName, false, null);
                memberUses.addReferences(references);
                return;
            }
        }
        MemberName memberName = (MemberName)typeOrMemberName;
        Object member = type.getDeclaredMember(memberName);
        Collection<Object> matches = Collections.emptySet();
        if (member == null) {
            switch (memberName.getKind()) {
                case CONSTRUCTOR: {
                    matches = type.getApplicableConstructors((ConstructorName)memberName);
                    break;
                }
                case METHOD: {
                    matches = type.getApplicableMethods((MethodName)memberName).stream().map(oem -> oem.getMethod()).collect(Collectors.toList());
                    break;
                }
                case FIELD: {
                    Field field = type.getDeclaredOrInheritedField((FieldName)memberName);
                    if (field == null) break;
                    matches = Collections.singleton(field);
                }
            }
        }
        MemberName targetMemberName = null;
        if (!matches.isEmpty()) {
            Member targetMember = (Member)matches.iterator().next();
            Type targetType = targetMember.getParent();
            targetMemberName = targetMember.getName();
            PackageUses targetPackageUses = this.addPackage(targetMemberName.getPackage());
            TypeUses targetTypeUses = targetPackageUses.addType(targetType.getName(), targetType.getKind(), true);
            MemberUses targetMemberUses = targetTypeUses.addMember(targetMemberName, true, null);
            targetMemberUses.addMigratedFrom(typeName);
            targetMemberUses.addReferences(references);
        }
        MemberUses memberUses = typeUses.addMember(memberName, member != null, targetMemberName);
        memberUses.addReferences(references);
        if (member == null) {
            Log log = this.model.getLog();
            log.trace("uses-replacements", "replacement(s) for %s is %s in %s", memberName, UsesModel.list(matches, t -> t.getQualifiedSourceName()), this.model);
            String kind = memberName.getKind().toLowerCase();
            switch (matches.size()) {
                case 0: {
                    log.warning("uses-missing-" + kind, "used %s %s not found in %s", kind, memberName, this.model);
                    break;
                }
                case 1: {
                    log.warning("uses-replaced-" + kind, "used %s %s replaced by %s in %s", kind, memberName, targetMemberName, ((Member)matches.iterator().next()).getType().getRoot().getPath());
                    break;
                }
                default: {
                    log.warning("uses-ambiguous-" + kind, "used %s %s ambiguously replaced by %s in %s", kind, memberName, UsesModel.list(matches, t -> t.getQualifiedSourceName()), this.model);
                }
            }
        }
    }

    private PackageUses addPackage(PackageName name) {
        return this.packages.computeIfAbsent(name, p -> new PackageUses(this.domain.dominates(name)));
    }

    public String getSource() {
        return this.sources.isEmpty() ? "unknown" : String.join((CharSequence)", ", this.sources);
    }

    public ClassPathModel getModel() {
        return this.model;
    }

    public ExportDomain getDomain() {
        return this.domain;
    }

    public Set<PackageName> getPackageNames() {
        return this.packages.keySet();
    }

    public PackageUses getPackageUses(PackageName name) {
        return this.packages.get(name);
    }

    public TypeUses getTypeUses(TypeName typeName) {
        PackageUses packag = this.getPackageUses(typeName.getPackage());
        if (packag == null) {
            return null;
        }
        return packag.getTypeUses(typeName);
    }

    public MemberUses getMemberUses(MemberName memberName) {
        TypeUses type = this.getTypeUses(memberName.getType());
        if (type == null) {
            return null;
        }
        return type.getMemberUses(memberName);
    }

    private static <T> Object list(final Collection<T> list, final Function<T, String> formatter) {
        return new Object(){

            public String toString() {
                Iterator iterator = list.iterator();
                switch (list.size()) {
                    case 0: {
                        return "<empty>";
                    }
                    case 1: {
                        return (String)formatter.apply(iterator.next());
                    }
                    case 2: {
                        return (String)formatter.apply(iterator.next()) + " and " + (String)formatter.apply(iterator.next());
                    }
                }
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < list.size() - 1; ++i) {
                    builder.append((String)formatter.apply(iterator.next())).append(", ");
                }
                builder.append("and ").append((String)formatter.apply(iterator.next()));
                return builder.toString();
            }
        };
    }

    public ExportSpecification createExportSpecification(Scope scope, String owner, Set<String> consumers, Access access) {
        if (access == null) {
            access = Access.EXPORTED;
        }
        LinkedHashMap<PackageName, PackageExportSpecification> packages = new LinkedHashMap<PackageName, PackageExportSpecification>();
        ArrayList<PackageName> packageNames = new ArrayList<PackageName>(this.getPackageNames());
        Collections.sort(packageNames);
        for (PackageName packageName : packageNames) {
            if (!this.domain.dominates(packageName)) continue;
            PackageUses packag = this.getPackageUses(packageName);
            LinkedHashMap<TypeName, TypeExportSpecification> types = new LinkedHashMap<TypeName, TypeExportSpecification>();
            LinkedHashSet interfaces = new LinkedHashSet();
            ArrayList<TypeName> typeNames = new ArrayList<TypeName>(packag.getTypeNames());
            Collections.sort(typeNames);
            for (TypeName typeName : typeNames) {
                TypeUses type = packag.getTypeUses(typeName);
                LinkedHashMap<MemberName, Access> members = new LinkedHashMap<MemberName, Access>();
                ArrayList<MemberName> memberNames = new ArrayList<MemberName>(type.getMemberNames());
                Collections.sort(memberNames);
                for (MemberName memberName : memberNames) {
                    members.put(memberName, access);
                }
                types.put(typeName, new TypeExportSpecification(access, access, members, Access.CONCEALED));
                if (!type.getKind().isInterface()) continue;
                interfaces.add(typeName);
            }
            packages.put(packageName, new PackageExportSpecification(Access.CONCEALED, types.isEmpty() ? Collections.emptyMap() : types, interfaces.isEmpty() ? Collections.emptySet() : interfaces, null));
        }
        return new ExportSpecification(scope, owner, this.getSource(), consumers, this.domain, packages.isEmpty() ? Collections.emptyMap() : packages);
    }
}

