/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.view.wedge;

import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;

class OffsetDifferenceBlock
extends SequenceCompareDifference {
    public static final int TYPE_NOCHANGE = 0;
    public static final int TYPE_CHANGE = 2;
    private final TextBuffer _firstTextBuffer;
    private final TextBuffer _secondTextBuffer;
    private final TextBuffer _ancestorTextBuffer;
    private Offset _firstStartOffset;
    private Offset _firstEndOffset;
    private Offset _secondStartOffset;
    private Offset _secondEndOffset;
    private Offset _ancestorStartOffset;
    private Offset _ancestorEndOffset;

    public OffsetDifferenceBlock(int kind, TextBuffer firstTextBuffer, TextBuffer secondTextBuffer, TextBuffer ancestorTextBuffer) {
        super(kind);
        this._firstTextBuffer = firstTextBuffer;
        this._secondTextBuffer = secondTextBuffer;
        this._ancestorTextBuffer = ancestorTextBuffer;
        this._firstStart = -1;
        this._firstLength = -1;
        this._secondStart = -1;
        this._secondLength = -1;
        this._ancestorStart = -1;
        this._ancestorLength = -1;
    }

    protected OffsetDifferenceBlock(OffsetDifferenceBlock offsetDifferenceBlock) {
        super((SequenceCompareDifference)offsetDifferenceBlock);
        this._firstTextBuffer = offsetDifferenceBlock._firstTextBuffer;
        this._secondTextBuffer = offsetDifferenceBlock._secondTextBuffer;
        this._ancestorTextBuffer = offsetDifferenceBlock._ancestorTextBuffer;
        this.setFirstStart(offsetDifferenceBlock.getStart(ContributorKind.FIRST));
        this.setFirstLength(offsetDifferenceBlock.getLength(ContributorKind.FIRST));
        this.setSecondStart(offsetDifferenceBlock.getStart(ContributorKind.SECOND));
        this.setSecondLength(offsetDifferenceBlock.getLength(ContributorKind.SECOND));
        this.setAncestorStart(offsetDifferenceBlock.getStart(ContributorKind.ANCESTOR));
        this.setAncestorLength(offsetDifferenceBlock.getLength(ContributorKind.ANCESTOR));
    }

    public int getMaxLength() {
        return Math.max(Math.max(this.getLength(ContributorKind.FIRST), this.getLength(ContributorKind.SECOND)), this.getLength(ContributorKind.ANCESTOR));
    }

    public void evaluateOffsets() {
        if (this._firstStartOffset == null && this._firstStart >= 0) {
            this._firstStartOffset = Offset.createOffset(this._firstTextBuffer, this._firstStart);
        }
        if (this._firstEndOffset == null && this._firstStart >= 0 && this._firstLength >= 0) {
            this._firstEndOffset = Offset.createOffset(this._firstTextBuffer, this._firstStart + this._firstLength);
        }
        if (this._secondStartOffset == null && this._secondStart >= 0) {
            this._secondStartOffset = Offset.createOffset(this._secondTextBuffer, this._secondStart);
        }
        if (this._secondEndOffset == null && this._secondStart >= 0 && this._secondLength >= 0) {
            this._secondEndOffset = Offset.createOffset(this._secondTextBuffer, this._secondStart + this._secondLength);
        }
        if (this._ancestorStartOffset == null && this._ancestorStart >= 0) {
            this._ancestorStartOffset = Offset.createOffset(this._ancestorTextBuffer, this._ancestorStart);
        }
        if (this._ancestorEndOffset == null && this._ancestorStart >= 0 && this._ancestorLength >= 0) {
            this._ancestorEndOffset = Offset.createOffset(this._ancestorTextBuffer, this._ancestorStart + this._ancestorLength);
        }
    }

    public void resetStart(ContributorKind contributor) {
        if (contributor == ContributorKind.ANCESTOR && this._ancestorStartOffset != null) {
            this._ancestorStartOffset.cleanup();
            this._ancestorStartOffset = null;
        }
        if (contributor == ContributorKind.FIRST && this._secondStartOffset != null) {
            this._secondStartOffset.cleanup();
            this._secondStartOffset = null;
        }
        if (contributor == ContributorKind.SECOND && this._firstStartOffset != null) {
            this._firstStartOffset.cleanup();
            this._firstStartOffset = null;
        }
    }

    public void resetLength(ContributorKind contributor) {
        if (contributor == ContributorKind.ANCESTOR && this._ancestorEndOffset != null) {
            this._ancestorEndOffset.cleanup();
            this._ancestorEndOffset = null;
        }
        if (contributor == ContributorKind.FIRST && this._secondEndOffset != null) {
            this._secondEndOffset.cleanup();
            this._secondEndOffset = null;
        }
        if (contributor == ContributorKind.SECOND && this._firstEndOffset != null) {
            this._firstEndOffset.cleanup();
            this._firstEndOffset = null;
        }
    }

    public void setStart(ContributorKind contributor, int start) {
        if (contributor == ContributorKind.ANCESTOR) {
            this.setAncestorStart(start);
        }
        if (contributor == ContributorKind.FIRST) {
            this.setFirstStart(start);
        }
        if (contributor == ContributorKind.SECOND) {
            this.setSecondStart(start);
        }
    }

    public void setLength(ContributorKind contributor, int length) {
        if (contributor == ContributorKind.ANCESTOR) {
            this.setAncestorLength(length);
        }
        if (contributor == ContributorKind.FIRST) {
            this.setFirstLength(length);
        }
        if (contributor == ContributorKind.SECOND) {
            this.setSecondLength(length);
        }
    }

    public int getStart(ContributorKind contributor) {
        if (contributor == ContributorKind.ANCESTOR) {
            return this._ancestorStartOffset != null ? this._ancestorStartOffset.getLineFromOffset() : this._ancestorStart;
        }
        if (contributor == ContributorKind.FIRST) {
            return this._firstStartOffset != null ? this._firstStartOffset.getLineFromOffset() : this._firstStart;
        }
        if (contributor == ContributorKind.SECOND) {
            return this._secondStartOffset != null ? this._secondStartOffset.getLineFromOffset() : this._secondStart;
        }
        assert (false);
        return -1;
    }

    public int getLength(ContributorKind contributor) {
        if (contributor == ContributorKind.ANCESTOR) {
            return this._ancestorEndOffset != null ? this._ancestorEndOffset.getLineFromOffset() - this.getStart(ContributorKind.ANCESTOR) : this._ancestorLength;
        }
        if (contributor == ContributorKind.FIRST) {
            return this._firstEndOffset != null ? this._firstEndOffset.getLineFromOffset() - this.getStart(ContributorKind.FIRST) : this._firstLength;
        }
        if (contributor == ContributorKind.SECOND) {
            return this._secondEndOffset != null ? this._secondEndOffset.getLineFromOffset() - this.getStart(ContributorKind.SECOND) : this._secondLength;
        }
        assert (false);
        return -1;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Kind=");
        str.append(this.getKind() == 2 ? "TYPE_CHANGE" : "TYPE_NOCHANGE");
        str.append("; Id=");
        str.append(this.getId());
        str.append("; 1 Start=");
        str.append(String.valueOf(this.getStart(ContributorKind.FIRST)));
        str.append("; 1 Length=");
        str.append(String.valueOf(this.getLength(ContributorKind.FIRST)));
        str.append("; 2 Start=");
        str.append(String.valueOf(this.getStart(ContributorKind.SECOND)));
        str.append("; 2 Length=");
        str.append(String.valueOf(this.getLength(ContributorKind.SECOND)));
        str.append("; A Start=");
        str.append(String.valueOf(this.getStart(ContributorKind.ANCESTOR)));
        str.append("; A Length=");
        str.append(String.valueOf(this.getLength(ContributorKind.ANCESTOR)));
        str.append("; Resolved=");
        str.append(String.valueOf(this.isResolved()));
        str.append(";");
        return str.toString();
    }

    public Object clone() {
        return new OffsetDifferenceBlock(this);
    }

    public static final OffsetDifferenceBlock[] createOffsetDifferenceBlocks(SequenceCompareDifference[] differenceBlocks, TextBuffer firstTextBuffer, TextBuffer secondTextBuffer, TextBuffer ancestorTextBuffer) {
        OffsetDifferenceBlock[] offsetDifferenceBlocks = new OffsetDifferenceBlock[differenceBlocks.length];
        for (int i = 0; i < offsetDifferenceBlocks.length; ++i) {
            offsetDifferenceBlocks[i] = new OffsetDifferenceBlock(differenceBlocks[i].getKind(), firstTextBuffer, secondTextBuffer, ancestorTextBuffer);
            offsetDifferenceBlocks[i].setId(differenceBlocks[i].getId());
            offsetDifferenceBlocks[i].setConflict(differenceBlocks[i].isConflict());
            offsetDifferenceBlocks[i].setResolved(differenceBlocks[i].isResolved());
            offsetDifferenceBlocks[i].setFirstStart(differenceBlocks[i].getStart(ContributorKind.FIRST));
            offsetDifferenceBlocks[i].setFirstLength(differenceBlocks[i].getLength(ContributorKind.FIRST));
            offsetDifferenceBlocks[i].setSecondStart(differenceBlocks[i].getStart(ContributorKind.SECOND));
            offsetDifferenceBlocks[i].setSecondLength(differenceBlocks[i].getLength(ContributorKind.SECOND));
            offsetDifferenceBlocks[i].setAncestorStart(differenceBlocks[i].getStart(ContributorKind.ANCESTOR));
            offsetDifferenceBlocks[i].setAncestorLength(differenceBlocks[i].getLength(ContributorKind.ANCESTOR));
        }
        return offsetDifferenceBlocks;
    }

    private static class Offset {
        private final OffsetMark _offsetMark;
        private final TextBuffer _textBuffer;

        private Offset(TextBuffer textBuffer, OffsetMark offsetMark) {
            this._textBuffer = textBuffer;
            this._offsetMark = offsetMark;
        }

        static Offset createOffset(TextBuffer textBuffer, int line) {
            LineMap lineMap = textBuffer.getLineMap();
            if (lineMap.getLineEndOffset(line) < lineMap.getLineStartOffset(line)) {
                return new Offset(textBuffer, null);
            }
            return new Offset(textBuffer, textBuffer.addOffsetMark(textBuffer.getLineMap().getLineStartOffset(line), false));
        }

        int getLineFromOffset() {
            return this._offsetMark != null ? this._textBuffer.getLineMap().getLineFromOffset(this._offsetMark.getOffset()) : this._textBuffer.getLineMap().getLineCount();
        }

        void cleanup() {
            if (this._offsetMark != null) {
                this._textBuffer.removeOffsetMark(this._offsetMark);
            }
        }
    }
}

