/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.php;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.editor.language.html.HTMLBlockRenderer;
import oracle.javatools.editor.language.php.PHPBlockRenderer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.html.HTMLLexer;
import oracle.javatools.parser.html.HTMLTokens;
import oracle.javatools.parser.html.TagLexer;

public class PHPHTMLBlockRenderer
extends HTMLBlockRenderer
implements HTMLTokens {
    protected PHPBlockRenderer phpRenderer;
    protected TagLexer scratchTagLexer;
    protected LexerToken scratchTagToken;

    public PHPHTMLBlockRenderer(TextBuffer textBuffer) {
        super(textBuffer);
        this.phpRenderer = new PHPBlockRenderer(textBuffer);
    }

    @Override
    protected Lexer createLexer() {
        HTMLLexer lexer = new HTMLLexer();
        lexer.setRecognizeScripts(true);
        lexer.setRecognizePHP(true);
        return lexer;
    }

    @Override
    protected void renderToken(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        switch (token) {
            case 31: {
                int newClipStart = Math.max(tokenStart, clipStart);
                int newClipEnd = Math.min(tokenEnd, clipEnd);
                this.renderPHPTag(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            case 32: {
                int newClipStart = Math.max(tokenStart, clipStart);
                int newClipEnd = Math.min(tokenEnd, clipEnd);
                this.renderPHPASPTag(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            default: {
                super.renderToken(fragmentsList, token, tokenStart, tokenEnd, clipStart, clipEnd);
            }
        }
    }

    @Override
    protected String mapTokenToStyleName(int token) {
        switch (token) {
            case 31: 
            case 32: {
                throw new IllegalStateException("Should be sub-rendering tags");
            }
        }
        return super.mapTokenToStyleName(token);
    }

    @Override
    protected BlockRenderer getRenderer(TextBuffer textBuffer, int scriptStart, int scriptEnd) {
        int token;
        if (this.scratchTagLexer == null) {
            this.scratchTagLexer = new TagLexer();
            this.scratchTagLexer.setRecognizeJSP(false);
            this.scratchTagLexer.setSkipSymbols(true);
            this.scratchTagToken = this.scratchTagLexer.createLexerToken();
        }
        this.scratchTagLexer.setTextBuffer((ReadTextBuffer)textBuffer);
        this.scratchTagLexer.setPosition(scriptStart);
        PHPBlockRenderer rendererToUse = null;
        String lastName = null;
        while ((token = this.scratchTagLexer.lex(this.scratchTagToken)) != 0) {
            int tokenStart = this.scratchTagToken.getStartOffset();
            int tokenEnd = this.scratchTagToken.getEndOffset();
            String tokenString = textBuffer.getString(tokenStart, tokenEnd - tokenStart).trim();
            if (tokenStart >= scriptEnd) break;
            if (token == 21) {
                lastName = tokenString;
                continue;
            }
            if (token != 22) continue;
            String value = tokenString;
            if (value.startsWith("\"") || value.startsWith("'")) {
                value = value.substring(1);
            }
            if (value.endsWith("\"") || value.endsWith("'")) {
                value = value.substring(0, value.length() - 1);
            }
            if ((!lastName.equalsIgnoreCase("language") || !value.regionMatches(true, 0, "php", 0, 3)) && (!lastName.equalsIgnoreCase("type") || !value.regionMatches(true, 0, "text/php", 0, 8))) continue;
            rendererToUse = this.phpRenderer;
            break;
        }
        this.scratchTagLexer.setTextBuffer(null);
        if (rendererToUse != null) {
            return rendererToUse;
        }
        return super.getRenderer(textBuffer, scriptStart, scriptEnd);
    }

    protected void renderPHPTag(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        int prefixEnd;
        int prefixStart = Math.max(clipStart, tokenStart);
        if (prefixStart < (prefixEnd = Math.min(clipEnd, tokenStart + 2))) {
            fragmentsList.add("html-symbol-style", prefixStart, prefixEnd);
        }
        int blockStart = tokenStart + 2;
        int blockEnd = tokenEnd;
        int blockClipStart = Math.max(clipStart, blockStart);
        int blockClipEnd = Math.min(clipEnd, blockEnd);
        TextBuffer textBuffer = this.getTextBuffer();
        if (blockEnd - blockStart >= 5) {
            int phpPos = blockStart;
            char p1Char = textBuffer.getChar(phpPos++);
            char hChar = textBuffer.getChar(phpPos++);
            char p2Char = textBuffer.getChar(phpPos++);
            if (!(p1Char != 'p' && p1Char != 'P' || hChar != 'h' && hChar != 'H' || p2Char != 'p' && p2Char != 'P')) {
                prefixStart = Math.max(clipStart, blockStart);
                if (prefixStart < (prefixEnd = Math.min(clipEnd, blockStart + 3))) {
                    fragmentsList.add("html-element-style", prefixStart, prefixEnd);
                }
                blockStart = tokenStart + 5;
                blockClipStart = Math.max(clipStart, blockStart);
            }
        }
        boolean hasTagEnd = false;
        if (blockEnd - blockStart >= 2) {
            int tagEndStart = blockEnd - 2;
            char quesChar = textBuffer.getChar(tagEndStart++);
            char gtChar = textBuffer.getChar(tagEndStart);
            if (quesChar == '?' && gtChar == '>') {
                hasTagEnd = true;
                blockEnd = tokenEnd - 2;
                blockClipEnd = Math.min(clipEnd, blockEnd);
            }
        }
        this.phpRenderer.renderBlock(fragmentsList, blockStart, blockEnd, blockClipStart, blockClipEnd);
        if (hasTagEnd && (prefixStart = Math.max(clipStart, tokenEnd - 2)) < (prefixEnd = Math.min(clipEnd, tokenEnd))) {
            fragmentsList.add("html-symbol-style", prefixStart, prefixEnd);
        }
    }

    protected void renderPHPASPTag(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        int prefixEnd;
        int prefixStart = Math.max(clipStart, tokenStart);
        if (prefixStart < (prefixEnd = Math.min(clipEnd, tokenStart + 2))) {
            fragmentsList.add("html-symbol-style", prefixStart, prefixEnd);
        }
        int blockStart = tokenStart + 2;
        int blockEnd = tokenEnd;
        int blockClipStart = Math.max(clipStart, blockStart);
        int blockClipEnd = Math.min(clipEnd, blockEnd);
        TextBuffer textBuffer = this.getTextBuffer();
        if (blockStart < blockEnd && textBuffer.getChar(blockStart) == '=') {
            prefixStart = Math.max(clipStart, blockStart);
            if (prefixStart < (prefixEnd = Math.min(clipEnd, blockStart + 1))) {
                fragmentsList.add("html-symbol-style", prefixStart, prefixEnd);
            }
            blockStart = tokenStart + 3;
            blockClipStart = Math.max(clipStart, blockStart);
        }
        boolean hasTagEnd = false;
        if (blockEnd - blockStart >= 2) {
            int tagEndStart = blockEnd - 2;
            char percChar = textBuffer.getChar(tagEndStart++);
            char gtChar = textBuffer.getChar(tagEndStart);
            if (percChar == '%' && gtChar == '>') {
                hasTagEnd = true;
                blockEnd = tokenEnd - 2;
                blockClipEnd = Math.min(clipEnd, blockEnd);
            }
        }
        this.phpRenderer.renderBlock(fragmentsList, blockStart, blockEnd, blockClipStart, blockClipEnd);
        if (hasTagEnd && (prefixStart = Math.max(clipStart, tokenEnd - 2)) < (prefixEnd = Math.min(clipEnd, tokenEnd))) {
            fragmentsList.add("html-symbol-style", prefixStart, prefixEnd);
        }
    }
}

