/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import java.util.logging.Logger;
import oracle.json.common.Configuration;
import oracle.json.common.ConnectionPool;
import oracle.json.common.JsonFactoryProvider;
import oracle.soda.rdbms.impl.cache.CacheOfDescriptorCaches;

public final class SharedServices {
    private static final Logger log = Logger.getLogger(SharedServices.class.getName());
    private final Configuration conf;
    private final ConnectionPool connPool;
    private final CacheOfDescriptorCaches cacheOfDescriptorCaches;
    private final JsonFactoryProvider jProvider = new JsonFactoryProvider();

    public SharedServices(Configuration configuration, boolean bl) {
        this.conf = configuration;
        this.cacheOfDescriptorCaches = new CacheOfDescriptorCaches(100, 100);
        this.connPool = bl ? configuration.createConnectionPool() : null;
    }

    public SharedServices(Configuration configuration) {
        this(configuration, true);
    }

    public JsonFactoryProvider getJsonFactoryProvider() {
        return this.jProvider;
    }

    public ConnectionPool getConnectionPool() {
        return this.connPool;
    }

    public CacheOfDescriptorCaches getCacheOfDescriptorCaches() {
        return this.cacheOfDescriptorCaches;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public synchronized void destroy() {
        if (this.connPool != null) {
            log.fine("Closing connection pool");
            this.connPool.shutdown();
        }
    }
}

