/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import java.util.ArrayList;
import java.util.Formatter;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;

public class PathParser {
    private static final char STEP_SEPARATOR = '.';
    private static final char SEG_DELIMITER = '`';
    private static final char SQL_DELIMITER = '\"';
    private static final char ESCAPE_CHAR = '\\';
    private static final char ARRAY_START = '[';
    private static final char ARRAY_STOP = ']';
    private static final char WILD_STEP = '*';
    private static final char ROOT_STEP = '$';
    private static final char CONTEXT_STEP = '@';
    private final String pathString;
    private static final String ALPHA_NUM_UNDER = "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final int IS_DIGIT_POS = "_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".indexOf(48);

    public PathParser(String string) {
        this.pathString = string;
    }

    private String buildStep(StringBuilder stringBuilder, int n, boolean bl, boolean bl2) throws QueryException {
        String string;
        if (bl && !bl2) {
            if (stringBuilder.length() == 1) {
                this.throwPathException(QueryMessage.EX_EMPTY_PATH_STEP, n);
            }
            if (stringBuilder.length() == 2) {
                char c = stringBuilder.charAt(1);
                if (c == '$' || c == '@') {
                    this.throwPathException(QueryMessage.EX_PATH_SYNTAX_ERROR, n);
                }
                if (c == '*') {
                    bl = false;
                }
            }
        }
        if (!bl) {
            string = stringBuilder.substring(1);
        } else {
            stringBuilder.append('\"');
            string = stringBuilder.toString();
        }
        stringBuilder.setLength(1);
        return string;
    }

    private String buildArrayStep(StringBuilder stringBuilder) {
        stringBuilder.append(']');
        String string = stringBuilder.toString();
        stringBuilder.setLength(0);
        stringBuilder.append('\"');
        return string;
    }

    private void throwException(QueryMessage queryMessage, Object ... objectArray) throws QueryException {
        throw new QueryException(queryMessage.get(objectArray));
    }

    private void throwPathException(QueryMessage queryMessage, int n) throws QueryException {
        this.throwException(queryMessage, this.pathString, Integer.toString(n));
    }

    private void throwArrayException(String string) throws QueryException {
        this.throwException(QueryMessage.EX_BAD_ARRAY_SUBSCRIPT, this.pathString, string);
    }

    private void validateArrayStep(String string) throws QueryException {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        for (int i = 1; i < string.length() - 1; ++i) {
            char c = string.charAt(i);
            if (c == '*') {
                if (!bl) {
                    this.throwArrayException(string);
                }
                bl = false;
                bl2 = false;
                continue;
            }
            if (c == ',') {
                if (!bl3) {
                    this.throwArrayException(string);
                }
                bl3 = false;
                bl5 = false;
                bl4 = false;
                bl6 = false;
                bl9 = true;
                continue;
            }
            if ("0123456789".indexOf(c) >= 0) {
                if (!bl2) {
                    this.throwArrayException(string);
                }
                bl = false;
                bl3 = true;
                bl4 = true;
                bl9 = false;
                continue;
            }
            if (" \t\n\r".indexOf(c) >= 0) {
                if (bl7) {
                    this.throwArrayException(string);
                }
                if (bl4) {
                    bl2 = false;
                    bl5 = !bl6;
                    bl3 = true;
                    continue;
                }
                if (!bl8) continue;
                bl2 = true;
                bl8 = false;
                bl9 = true;
                continue;
            }
            if (c == 't') {
                if (!bl5) {
                    this.throwArrayException(string);
                }
                bl7 = true;
                bl3 = false;
                bl4 = false;
                continue;
            }
            if (c == 'o') {
                if (!bl7) {
                    this.throwArrayException(string);
                }
                bl7 = false;
                bl5 = false;
                bl6 = true;
                bl8 = true;
                continue;
            }
            this.throwArrayException(string);
        }
        if (bl) {
            this.throwArrayException(string);
        }
        if (bl7 || bl8 || bl9) {
            this.throwArrayException(string);
        }
    }

    public String[] splitAndSQLEscape() throws QueryException {
        if (this.pathString == null) {
            this.throwException(QueryMessage.EX_EMPTY_PATH, new Object[0]);
        }
        return this.splitSteps(true);
    }

    public String[] splitSteps(boolean bl) throws QueryException {
        if (this.pathString == null) {
            this.throwException(QueryMessage.EX_EMPTY_PATH, new Object[0]);
        }
        char[] cArray = this.pathString.toCharArray();
        int n = cArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(10);
        StringBuilder stringBuilder = new StringBuilder(Math.max(n * 2 + 2, 128));
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = false;
        boolean bl7 = false;
        int n2 = 0;
        stringBuilder.append('\"');
        if (n == 0) {
            bl5 = false;
            bl4 = bl;
        }
        block12: while (n2 < cArray.length) {
            Object object;
            char c = cArray[n2];
            switch (c) {
                case '`': {
                    if (bl6 || bl7) {
                        this.throwPathException(QueryMessage.EX_MISSING_STEP_DOT, n2);
                    }
                    if (!bl2) {
                        if (stringBuilder.length() > 1) {
                            this.throwPathException(QueryMessage.EX_BAD_BACKQUOTE, n2);
                        }
                        bl2 = true;
                        ++n2;
                        continue block12;
                    }
                    if (++n2 < cArray.length && (c = cArray[n2]) == '`') {
                        stringBuilder.append(c);
                        ++n2;
                        bl4 = bl;
                        continue block12;
                    }
                    if (stringBuilder.length() == 1) {
                        bl4 = bl;
                    }
                    bl2 = false;
                    bl7 = true;
                    continue block12;
                }
                case ']': {
                    if (bl3) {
                        bl3 = false;
                        object = this.buildArrayStep(stringBuilder);
                        this.validateArrayStep((String)object);
                        arrayList.add((String)object);
                        bl6 = true;
                        ++n2;
                        continue block12;
                    }
                    if (!bl2 && c == ']') {
                        this.throwPathException(QueryMessage.EX_PATH_SYNTAX_ERROR, n2);
                    }
                }
                case '.': 
                case '[': {
                    if (bl2 || bl3) break;
                    boolean bl8 = bl3 = c == '[';
                    if (stringBuilder.length() > 1 || bl7) {
                        arrayList.add(this.buildStep(stringBuilder, n2, bl4, bl7));
                    } else if (!bl3) {
                        if (!bl6) {
                            arrayList.add(this.buildStep(stringBuilder, n2, true, bl7));
                        }
                    } else if (!bl5) {
                        arrayList.add(this.buildStep(stringBuilder, n2, true, bl7));
                    }
                    bl7 = false;
                    bl5 = bl3;
                    bl4 = false;
                    bl6 = false;
                    ++n2;
                    if (bl3) {
                        stringBuilder.setLength(0);
                        stringBuilder.append('[');
                        continue block12;
                    }
                    if (n2 < cArray.length) continue block12;
                    bl4 = bl;
                    continue block12;
                }
            }
            if (bl6 || bl7) {
                this.throwPathException(QueryMessage.EX_MISSING_STEP_DOT, n2);
            }
            bl5 = true;
            if (c == '\'') {
                if (bl) {
                    stringBuilder.append(c);
                }
                stringBuilder.append(c);
                bl4 = bl;
            } else if (c == '\"' || c == '\\') {
                bl4 = bl;
                if (bl) {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c);
            } else if (bl && (c < ' ' || c == '\u007f')) {
                stringBuilder.append('\\');
                switch (c) {
                    case '\n': {
                        stringBuilder.append('n');
                        break;
                    }
                    case '\r': {
                        stringBuilder.append('r');
                        break;
                    }
                    case '\t': {
                        stringBuilder.append('t');
                        break;
                    }
                    case '\b': {
                        stringBuilder.append('b');
                        break;
                    }
                    case '\f': {
                        stringBuilder.append('f');
                        break;
                    }
                    default: {
                        object = new Formatter(stringBuilder);
                        ((Formatter)object).format("u%04x", c);
                        ((Formatter)object).close();
                    }
                }
                bl4 = bl;
            } else {
                if (!bl4 && bl) {
                    int n3 = ALPHA_NUM_UNDER.indexOf(c);
                    if (n3 < 0) {
                        bl4 = true;
                    } else if (stringBuilder.length() == 1 && n3 >= IS_DIGIT_POS) {
                        bl4 = true;
                    }
                }
                stringBuilder.append(c);
            }
            ++n2;
        }
        if (bl3) {
            this.throwException(QueryMessage.EX_UNCLOSED_STEP, "array", this.pathString);
        }
        if (bl2) {
            this.throwException(QueryMessage.EX_UNCLOSED_STEP, "quote", this.pathString);
        }
        if (stringBuilder.length() > 1 || !bl5 || bl7) {
            if (stringBuilder.length() == 1 && !bl7) {
                bl4 = true;
            }
            arrayList.add(this.buildStep(stringBuilder, n2, bl4, bl7));
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }
}

