/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;

public class ByteArray {
    private static final String hexDigits = "0123456789ABCDEFabcdef";
    public static final String DEFAULT_ENCODING = "utf-8";
    public static final Charset DEFAULT_CHARSET = Charset.forName("utf-8");
    private static final String EMPTY_STRING = "";
    private static final int DEFAULT_SIZE = 256;
    private byte[] buffer;
    private int position = 0;

    public ByteArray(int n) {
        int n2;
        for (n2 = 256; n2 < n; n2 <<= 1) {
        }
        this.buffer = new byte[n2];
    }

    public ByteArray() {
        this(256);
    }

    protected void extend(int n) {
        int n2;
        for (n2 = this.buffer.length; n2 < this.position + n; n2 <<= 1) {
        }
        if (n2 > this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, n2);
        }
    }

    protected int capacity() {
        return this.buffer.length - this.position;
    }

    public byte[] toArray() {
        return Arrays.copyOf(this.buffer, this.position);
    }

    public byte[] getArray() {
        return this.buffer;
    }

    public int getLength() {
        return this.position;
    }

    public void reset() {
        this.position = 0;
    }

    public void append(byte[] byArray) {
        this.append(byArray, 0, byArray.length);
    }

    public void append(byte[] byArray, int n, int n2) {
        if (n2 > 0 && byArray != null) {
            this.extend(n2);
            System.arraycopy(byArray, n, this.buffer, this.position, n2);
            this.position += n2;
        }
    }

    public void append(InputStream inputStream) throws IOException {
        while (inputStream != null) {
            int n;
            if (this.capacity() < 256) {
                this.extend(256);
            }
            if ((n = inputStream.read(this.buffer, this.position, this.capacity() - 100)) < 0) {
                inputStream.close();
                break;
            }
            this.position += n;
        }
    }

    public String getString(Charset charset) {
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        if (this.position == 0) {
            return EMPTY_STRING;
        }
        return new String(this.buffer, 0, this.position, charset);
    }

    public String getString() {
        return this.getString(null);
    }

    public static ByteArray loadStream(InputStream inputStream) throws IOException {
        ByteArray byteArray = new ByteArray(inputStream.available());
        byteArray.append(inputStream);
        return byteArray;
    }

    public static String rawToHex(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 * 2];
        int n3 = 0;
        for (int i = n; i < n2 + n; ++i) {
            byte by = byArray[i];
            int n4 = by >> 4 & 0xF;
            cArray[n3++] = (char)(n4 < 10 ? 48 + n4 : 65 + n4 - 10);
            n4 = by & 0xF;
            cArray[n3++] = (char)(n4 < 10 ? 48 + n4 : 65 + n4 - 10);
        }
        return new String(cArray);
    }

    public static String rawToHex(byte[] byArray) {
        return ByteArray.rawToHex(byArray, 0, byArray.length);
    }

    public static boolean isHex(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (hexDigits.indexOf(cArray[i]) >= 0) continue;
            return false;
        }
        return true;
    }

    public static byte[] hexToRaw(String string) {
        int n;
        boolean bl;
        int n2 = string.length();
        int n3 = (n2 + 1) / 2;
        int n4 = 0;
        boolean bl2 = bl = (n2 & 1) == 1;
        if (n3 == 0) {
            n3 = 1;
        }
        byte[] byArray = new byte[n3];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2 && (n = hexDigits.indexOf(string.charAt(n6++))) >= 0) {
            if (n > 15) {
                n -= 6;
            }
            n4 <<= 4;
            n4 |= n;
            if (bl) {
                byArray[n5++] = (byte)n4;
                n4 = 0;
            }
            bl = !bl;
        }
        while (n5 < n3) {
            byArray[n5++] = 0;
        }
        return byArray;
    }

    public static int compareBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n;
        int n8 = n3;
        int n9 = n6 = n2 > n4 ? n4 : n2;
        if (byArray == null || byArray2 == null) {
            if (byArray != null) {
                return 1;
            }
            if (byArray2 != null) {
                return -1;
            }
            return 0;
        }
        while (n6 > 0) {
            if ((n5 = byArray[n7++] - byArray2[n8++]) != 0) {
                return n5;
            }
            --n6;
        }
        n5 = n2 - n4;
        return n5;
    }

    public static int compareBytes(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return 0;
        }
        int n = byArray == null ? 0 : byArray.length;
        int n2 = byArray2 == null ? 0 : byArray2.length;
        return ByteArray.compareBytes(byArray, 0, n, byArray2, 0, n2);
    }

    public static int findPattern(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n3;
        int n5 = n2 - n;
        if (byArray != null && byArray2 != null && n4 > 0) {
            int n6 = n;
            while (n5 >= n4) {
                if (ByteArray.compareBytes(byArray, n6, n4, byArray2, 0, n4) == 0) {
                    return n6;
                }
                --n5;
                ++n6;
            }
        }
        return -1;
    }

    public static String bytesToString(byte[] byArray, int n, int n2, Charset charset) throws CharacterCodingException {
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        if (n2 == 0) {
            return EMPTY_STRING;
        }
        CharsetDecoder charsetDecoder = charset.newDecoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPORT);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.put(byArray, n, n2);
        byteBuffer.flip();
        return charsetDecoder.decode(byteBuffer).toString();
    }

    public static String bytesToString(byte[] byArray) throws CharacterCodingException {
        return ByteArray.bytesToString(byArray, DEFAULT_CHARSET);
    }

    public static String bytesToString(byte[] byArray, Charset charset) throws CharacterCodingException {
        if (byArray == null) {
            return EMPTY_STRING;
        }
        return ByteArray.bytesToString(byArray, 0, byArray.length, charset);
    }

    public static String bytesToString(byte[] byArray, int n, int n2) throws CharacterCodingException {
        return ByteArray.bytesToString(byArray, n, n2, DEFAULT_CHARSET);
    }

    public static String bytesToString(ByteArray byteArray) throws CharacterCodingException {
        return ByteArray.bytesToString(byteArray.buffer, 0, byteArray.position);
    }
}

