/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator;

import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Properties;
import javax.swing.Icon;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.navigator.ColoredDisplayable;
import oracle.dbtools.raptor.navigator.WrappedException;
import oracle.dbtools.raptor.navigator.db.AbstractConnectionNode;
import oracle.dbtools.raptor.navigator.db.BaseConnectionNode;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorHook;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DisconnectVetoException;
import oracle.ide.db.model.DatabaseNode;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.db.DBException;
import oracle.javatools.util.WeakCache;

public final class DbaConnection
extends AbstractConnectionNode
implements DatabaseNode,
ColoredDisplayable {
    private static ConnectionDisconnectListener s_listener;
    private Icon m_icon;
    private String m_type;
    private Project m_proj;

    public static DbaConnection findConnectionNode(URL uRL) {
        return (DbaConnection)DbaConnection.findConnectionNodeImpl((URL)uRL);
    }

    public static DbaConnection findOrCreateConnectionNode(URL uRL) {
        DbaConnection dbaConnection = null;
        String string = DBURLFormatHelper.getConnectionName((URL)uRL);
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        boolean bl = properties != null && "Oracle".equals(properties.getProperty("RaptorConnectionType"));
        WeakCache weakCache = DbaConnection.getNodeCache();
        BaseConnectionNode baseConnectionNode = (BaseConnectionNode)weakCache.get((Object)uRL);
        if (baseConnectionNode == null) {
            if (bl) {
                dbaConnection = new DbaConnection();
                dbaConnection.setURL(uRL);
            }
        } else if (baseConnectionNode instanceof DbaConnection) {
            if (bl) {
                dbaConnection = (DbaConnection)baseConnectionNode;
            } else {
                weakCache.remove((Object)uRL);
            }
        }
        return dbaConnection;
    }

    private static synchronized void initListener() {
        if (s_listener == null) {
            s_listener = new ConnectionDisconnectListener(){

                public void connectionDisconnected(ConnectionDetails connectionDetails) {
                    String string = connectionDetails.getQualifiedConnectionName();
                    URL uRL = DBURLFormatHelper.getURL((String)"sqldev.dbanav", (String)string);
                    DbaConnection dbaConnection = DbaConnection.findConnectionNode(uRL);
                    if (dbaConnection != null) {
                        dbaConnection.closeConnection();
                        UpdateMessage.fireObjectClosed((Subject)dbaConnection);
                    }
                }

                public void checkDisconnect(ConnectionDetails connectionDetails) throws DisconnectVetoException {
                }
            };
            Connections.getInstance().addConnectionDisconnectListener(s_listener);
        }
    }

    public DbaConnection() {
        DbaConnection.initListener();
        Attributes attributes = this.getAttributes();
        attributes.clear();
        attributes.set(ElementAttributes.CLOSEABLE | ElementAttributes.NAVIGABLE);
    }

    public DbaConnection(String string) {
        this();
        this.setURL(DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string));
    }

    protected boolean closeConnectionImpl() {
        return Connections.getInstance().closeConnection(this.getQualifiedConnectionName());
    }

    protected Connection openConnectionImpl() throws IOException {
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(this.getQualifiedConnectionName());
            if (connection == null) {
                throw new WrappedException((Throwable)new ConnectionCanceledException());
            }
        }
        catch (DBException dBException) {
            throw new WrappedException((Throwable)dBException);
        }
        catch (RuntimeException runtimeException) {
            throw new WrappedException((Throwable)runtimeException);
        }
        return connection;
    }

    public String getQualifiedConnectionName() {
        return DBURLFormatHelper.getConnectionName((URL)this.getURL());
    }

    public String getConnectionName() {
        return Connections.getConnectionName((String)this.getQualifiedConnectionName());
    }

    public String getStoreName() {
        return Connections.getStoreName((String)this.getQualifiedConnectionName());
    }

    public String getShortLabel() {
        return this.getConnectionName();
    }

    public Icon getIcon() {
        Properties properties = Connections.getInstance().getConnectionInfo(this.getQualifiedConnectionName());
        if (properties == null) {
            return null;
        }
        String string = properties.getProperty("RaptorConnectionType");
        if (this.m_type == null || !this.m_type.equals(string) || this.m_icon == null) {
            this.m_icon = DbaConnection.loadIcon(this.getQualifiedConnectionName());
            this.m_type = properties.getProperty("RaptorConnectionType");
        }
        return this.m_icon;
    }

    public static Icon loadIcon(String string) {
        ConnectionType connectionType;
        String string2;
        Icon icon = null;
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties != null && (string2 = properties.getProperty("RaptorConnectionType")) != null && (connectionType = NavigatorHook.getHookInstance((String)"sqldev.nav").getConnectionType(string2)) != null) {
            icon = connectionType.getIcon();
        }
        if (icon == null) {
            icon = RaptorImage.getIcon((String)"db.png");
        }
        return icon;
    }

    public String getToolTipText() {
        return this.getShortLabel();
    }

    public String getLongLabel() {
        String string = this.getQualifiedConnectionName();
        return Connections.getDisplayName((String)string);
    }

    public String getMetaData(String string) {
        try {
            String string2 = null;
            Connection connection = Connections.getInstance().getConnection(this.getQualifiedConnectionName());
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            string2 = databaseMetaData.getDatabaseProductName();
            string2 = string2 + " " + databaseMetaData.getDatabaseMajorVersion();
            string2 = string2 + "." + databaseMetaData.getDatabaseMinorVersion();
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Color getColor() {
        return Connections.getInstance().getConnectionColor(this.getQualifiedConnectionName());
    }
}

