/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import java.awt.Component;
import java.io.File;
import java.net.InetAddress;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.CloneUtils;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.FileObject;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.TransferProgress;
import oracle.dbtools.raptor.ssh.SshFilter;
import oracle.dbtools.raptor.ssh.core.Client;
import oracle.dbtools.raptor.ssh.core.HostConnection;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ui.actions.ActionContext;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.JavaActionDialog;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.transfer.TransferManager;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.file.FileSet;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.location.SshSessionLocation;
import oracle.dbtools.transfer.task.TransferTask;
import oracle.dbtools.transfer.task.TransferTaskByteProgressMonitor;
import oracle.dbtools.transfer.task.TransferTaskProgressListener;
import oracle.dbtools.transfer.task.TransferTaskProgressListenerAdapter;
import oracle.ide.Ide;
import org.apache.sshd.client.session.ClientSession;

public class CloneToCloudAction
extends JavaActionDialog {
    private static final String OBJECT_NAME = "ObjectName";
    private static final String CONNECTION_NAME = "destConn";
    private static final String POST_ACTION = "postAction";
    private static final String NETWORK_TYPE = "networkType";
    private static HashMap<String, String> _connMap = new HashMap();
    private static final String seperator = System.getProperty("file.separator");
    private ArrayList<FileObject> _files = new ArrayList();
    private String sourceXmlFile;
    private String destXmlFile;
    private String sourcePath;
    private String destPath;
    private String destConName;
    private DBUtil dest;
    private DBUtil source;
    private boolean sftpError = false;
    private boolean tablesExist = false;
    private int jobId = -1;
    private boolean _error = false;
    private boolean _canceled = false;
    private Throwable _throwable = null;
    private ClientSession session;
    private static final String HELP_ID = "f1_dba_clone_cloud_html";
    private boolean transferTaskDone;
    private static boolean NO_COMPAT_CHECK = false;

    protected String getHelpId() {
        return HELP_ID;
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("CLONE_TO_CLOUD");
    }

    protected List<ActionControl> createControls(Connection connection) {
        String string2;
        _connMap.clear();
        List<String> list = Arrays.asList(Connections.getInstance().getConnNames((Connections.NameFilter)SshFilter.INSTANCE));
        for (String string2 : list) {
            _connMap.put(Connections.getDisplayName((String)string2), string2);
        }
        String string3 = this.getObjectName();
        string2 = new TextBoxActionControl(OBJECT_NAME, DbaNavigatorResources.getString("SOURCE_PDB"), string3);
        string2.setEditable(false);
        ComboBoxActionControl comboBoxActionControl = new ComboBoxActionControl(CONNECTION_NAME, DbaNavigatorResources.getString("DESTINATION_CONN"), _connMap.keySet().toArray(new String[0]), Connections.getDisplayName((String)this.getDBObject().getConnectionName()));
        ComboBoxActionControl comboBoxActionControl2 = new ComboBoxActionControl(NETWORK_TYPE, DbaNavigatorResources.getString("NETWORK_TYPE_LABEL"), new String[]{DbaNavigatorResources.getString("NETWORK_TYPE_EXTREMELY_SLOW"), DbaNavigatorResources.getString("NETWORK_TYPE_TYPICAL"), DbaNavigatorResources.getString("NETWORK_TYPE_EXTREMELY_FAST")}, DbaNavigatorResources.getString("NETWORK_TYPE_TYPICAL"));
        ComboBoxActionControl comboBoxActionControl3 = new ComboBoxActionControl(POST_ACTION, DbaNavigatorResources.getString("POST_CLONE_LABEL"), new String[]{DbaNavigatorResources.getString("POST_CLONE_DELETE"), DbaNavigatorResources.getString("POST_CLONE_REPLUG")}, DbaNavigatorResources.getString("POST_CLONE_REPLUG"));
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)string2);
        arrayList.add((ActionControl)comboBoxActionControl);
        arrayList.add((ActionControl)comboBoxActionControl2);
        arrayList.add((ActionControl)comboBoxActionControl3);
        return arrayList;
    }

    private Throwable check_error(DBUtil dBUtil, String string) {
        Throwable throwable = null;
        SQLException sQLException = dBUtil.getLastException();
        if (sQLException != null) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, string);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, Integer.toString(sQLException.getErrorCode()));
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, sQLException.getMessage());
            throwable = sQLException.getCause();
            return throwable;
        }
        return throwable;
    }

    protected void doAction(ActionContext actionContext) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(DbaNavigatorResources.getString("CLONE_TO_CLOUD"), true, IRaptorTaskRunMode.TASKVIEWER){

            protected Void doWork() throws TaskException {
                CloneToCloudAction.this._error = false;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("NAME", CloneToCloudAction.this.getObjectName());
                String string = CloneToCloudAction.this.getObjectName() + ".XML";
                try {
                    FileObject fileObject;
                    String string2;
                    Object object;
                    String string3;
                    Object object22;
                    Object object3;
                    ActionDialog.Values values = CloneToCloudAction.this.getValues();
                    CloneToCloudAction.this.destConName = values.get(CloneToCloudAction.CONNECTION_NAME);
                    try {
                        object3 = Connections.getInstance().getDatabase(CloneToCloudAction.this.destConName, true);
                        int n = object3.getDatabaseVersion();
                        if (n < 12) {
                            CloneToCloudAction.this._error = true;
                            throw new Exception(DbaNavigatorResources.getString("PDB_FAIL2"));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setMessage(DbaNavigatorResources.getString("PDB_CREATE_DEST_SCRIPT"));
                    CloneToCloudAction.this.dest = DBUtil.getInstance((String)((String)_connMap.get(CloneToCloudAction.this.destConName)));
                    CloneToCloudAction.this.checkJobStatus();
                    this.setMessage(DbaNavigatorResources.getString("PDB_CREATE_SOURCE_SCRIPT"));
                    CloneToCloudAction.this.source = DBUtil.getInstance((String)CloneToCloudAction.this.getDBObject().getConnectionName());
                    this.setMessage("Gathering source file information");
                    object3 = CloneToCloudAction.this.dest.executeReturnOneCol("select name from v$datafile where con_id = (SELECT CON_ID FROM V$CONTAINERS WHERE name = 'CDB$ROOT') and rownum = 1", (Map)null);
                    CloneToCloudAction.this.destPath = ((String)object3).substring(0, ((String)object3).lastIndexOf("/") + 1) + CloneToCloudAction.this.getObjectName() + "/";
                    List list = CloneToCloudAction.this.source.executeReturnList("select name from gv$datafile where con_id = (SELECT PDB_ID FROM DBA_PDBS WHERE PDB_NAME = :NAME)", hashMap);
                    for (Object object22 : list) {
                        string3 = (String)object22.get("NAME");
                        CloneToCloudAction.this.sourcePath = new File(string3).getParent() + seperator;
                        object = new File(string3);
                        long l = ((File)object).length();
                        string2 = CloneToCloudAction.this.destPath + ((File)object).getName();
                        fileObject = new FileObject(((File)object).getName(), string3, string2, CloneToCloudAction.this.getObjectName(), l);
                        CloneToCloudAction.this._files.add(fileObject);
                    }
                    this.setMessage(DbaNavigatorResources.getString("PDB_VERIFY1"));
                    File file = new File(((FileObject)CloneToCloudAction.this._files.get(0)).getSourceName());
                    if (!file.exists()) {
                        CloneToCloudAction.this._error = true;
                        throw new Exception(DbaNavigatorResources.getString("PDB_FAIL1"));
                    }
                    CloneToCloudAction.this.sourceXmlFile = CloneToCloudAction.this.sourcePath + string;
                    this.setMessage(DbaNavigatorResources.getString("PDB_VERIFY2"));
                    object22 = CloneToCloudAction.this.dest.executeReturnOneCol("select cdb from v$database", hashMap);
                    if (((String)object22).equals("NO")) {
                        CloneToCloudAction.this._error = true;
                        throw new Exception(DbaNavigatorResources.getString("PDB_FAIL2"));
                    }
                    this.setMessage(DbaNavigatorResources.getString("PDB_VERIFY3"));
                    string3 = CloneToCloudAction.this.dest.executeReturnOneCol("select count(0) cnt from gv$pdbs where name = :NAME", hashMap);
                    if (!string3.equals("0")) {
                        CloneToCloudAction.this._error = true;
                        throw new Exception(DbaNavigatorResources.getString("PDB_FAIL3"));
                    }
                    this.setMessage(DbaNavigatorResources.getString("PDB_VERIFY4"));
                    object = CloneToCloudAction.this.source.executeReturnOneCol("select open_mode from gv$pdbs WHERE NAME = :NAME", hashMap);
                    if (!((String)object).equals("MOUNTED")) {
                        CloneToCloudAction.this.source.executeUpdate("ALTER PLUGGABLE DATABASE " + CloneToCloudAction.this.getObjectName() + " CLOSE IMMEDIATE", (List)null);
                        if ((CloneToCloudAction.this._throwable = CloneToCloudAction.this.check_error(CloneToCloudAction.this.source, DbaNavigatorResources.getString("PDB_FAIL4"))) != null) {
                            CloneToCloudAction.this._error = true;
                            try {
                                throw CloneToCloudAction.this._throwable;
                            }
                            catch (Throwable throwable) {
                                throw new Exception(DbaNavigatorResources.getString("PDB_MOVE_GENERIC_ERROR"));
                            }
                        }
                    }
                    this.setMessage(DbaNavigatorResources.getString("PDB_STEP1") + " " + CloneToCloudAction.this.getObjectName());
                    CloneToCloudAction.this.source.executeUpdate("ALTER PLUGGABLE DATABASE " + CloneToCloudAction.this.getObjectName() + " UNPLUG INTO '" + CloneToCloudAction.this.sourceXmlFile + "'", (List)null);
                    if ((CloneToCloudAction.this._throwable = CloneToCloudAction.this.check_error(CloneToCloudAction.this.source, DbaNavigatorResources.getString("PDB_STEP1_FAIL"))) != null) {
                        CloneToCloudAction.this._error = true;
                        try {
                            throw CloneToCloudAction.this._throwable;
                        }
                        catch (Throwable throwable) {
                            throw new Exception(DbaNavigatorResources.getString("PDB_MOVE_GENERIC_ERROR"));
                        }
                    }
                    this.setMessage(DbaNavigatorResources.getString("PDB_STEP2"));
                    CloneToCloudAction.this.source.executeUpdate("DROP PLUGGABLE DATABASE " + CloneToCloudAction.this.getObjectName() + " KEEP DATAFILES", (List)null);
                    if ((CloneToCloudAction.this._throwable = CloneToCloudAction.this.check_error(CloneToCloudAction.this.source, DbaNavigatorResources.getString("PDB_STEP2_FAIL"))) != null) {
                        CloneToCloudAction.this._error = true;
                        try {
                            throw CloneToCloudAction.this._throwable;
                        }
                        catch (Throwable throwable) {
                            throw new Exception(DbaNavigatorResources.getString("PDB_MOVE_GENERIC_ERROR"));
                        }
                    }
                    Properties properties = Connections.getInstance().getConnectionInfo((String)_connMap.get(CloneToCloudAction.this.destConName));
                    String string4 = (String)properties.get("SshHost.NAME");
                    string2 = Client.getInstance().getStore();
                    fileObject = string2.getHostDescriptor(string4);
                    HostConnection hostConnection = Client.getInstance().openConnection((HostDescriptor)fileObject);
                    CloneToCloudAction.this.session = hostConnection.getSession();
                    CloneToCloudAction.this.destXmlFile = CloneToCloudAction.this.destPath + string;
                    try {
                        Object object4;
                        Object object52;
                        this.setMessage(DbaNavigatorResources.getString("PDB_STEP3"));
                        try {
                            if (!CloneUtils.pathExists(CloneToCloudAction.this.session, CloneToCloudAction.this.destPath)) {
                                CloneUtils.mkdir(CloneToCloudAction.this.session, CloneToCloudAction.this.destPath);
                            }
                        }
                        catch (Exception exception) {
                            CloneToCloudAction.this._error = true;
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, DbaNavigatorResources.getString("PDB_STEP3_FAIL"));
                            throw new Exception(exception);
                        }
                        this.setMessage(DbaNavigatorResources.getString("PDB_STEP4"));
                        try {
                            if (CloneUtils.pathExists(CloneToCloudAction.this.session, CloneToCloudAction.this.destXmlFile)) {
                                CloneUtils.rmFile(CloneToCloudAction.this.session, CloneToCloudAction.this.destXmlFile);
                            }
                            CloneUtils.upload(CloneToCloudAction.this.session, CloneToCloudAction.this.sourceXmlFile, CloneToCloudAction.this.destXmlFile);
                        }
                        catch (Exception exception) {
                            CloneToCloudAction.this._error = true;
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, DbaNavigatorResources.getString("PDB_STEP4_FAIL"));
                            throw new Exception(exception);
                        }
                        CloneToCloudAction.this.createMoveRows(CloneToCloudAction.this._files);
                        this.setMessage(DbaNavigatorResources.getString("PDB_STEP5"));
                        boolean bl = CloneToCloudAction.this.getValues().get(CloneToCloudAction.NETWORK_TYPE).equals(DbaNavigatorResources.getString("NETWORK_TYPE_EXTREMELY_FAST"));
                        boolean bl2 = CloneToCloudAction.this.getValues().get(CloneToCloudAction.NETWORK_TYPE).equals(DbaNavigatorResources.getString("NETWORK_TYPE_EXTREMELY_SLOW"));
                        long l = System.nanoTime();
                        SshSessionLocation sshSessionLocation = new SshSessionLocation(CloneToCloudAction.this.session);
                        Location location = Location.getLocal();
                        FileSet fileSet = new FileSet();
                        HashMap<String, FileObject> hashMap2 = new HashMap<String, FileObject>();
                        for (Object object52 : CloneToCloudAction.this._files) {
                            object4 = ((FileObject)object52).getSourceName();
                            fileSet.add((String)object4);
                            hashMap2.put((String)object4, (FileObject)object52);
                        }
                        fileSet.setLocation(location);
                        for (Object object52 : fileSet.getFileInfos((Location)sshSessionLocation, CloneToCloudAction.this.destPath)) {
                            object4 = new TransferProgress(CloneToCloudAction.this.tablesExist ? (String)_connMap.get(CloneToCloudAction.this.destConName) : null, (FileObject)hashMap2.get(object52.getPath().toString()));
                            ((TransferProgress)object4).setJob(CloneToCloudAction.this.jobId);
                            ((TransferProgress)object4).init(0, null, null, object52.getLength());
                            object52.addListener((TransferTaskProgressListener)new TTProgressListener((TransferProgress)object4));
                            if (!bl) continue;
                            object52.initFileChunks(-1L);
                        }
                        TransferTask transferTask = TransferManager.INSTANCE.createTransferTask("CloneToCloudTransferTask", IRaptorTaskRunMode.NO_GUI, fileSet, (Location)sshSessionLocation, CloneToCloudAction.this.destPath);
                        transferTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                                CloneToCloudAction.this.sftpError = true;
                                CloneToCloudAction.this.cleanUp();
                                CloneToCloudAction.this._error = true;
                                Throwable throwable = raptorTaskEvent.getThrowable();
                                if (throwable != null) {
                                    this.setMessage(throwable.getMessage());
                                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, throwable.getMessage(), throwable);
                                }
                                this.done();
                            }

                            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                                this.done();
                            }

                            private void done() {
                                CloneToCloudAction.this.transferTaskDone = true;
                            }
                        });
                        transferTask.getProgressMonitor().addListener((TransferTaskProgressListener)new TransferTaskByteProgressMonitor((RaptorTask)this, FileInfo.CHUNK_SIZE * 4L));
                        this.setMessage("Transfering " + fileSet.getPaths().size() + " files to the cloud.");
                        CloneToCloudAction.this.transferTaskDone = false;
                        if (bl2) {
                            transferTask.setParallelism(3);
                            transferTask.setParallelismLocked(true);
                        }
                        RaptorTaskManager.getInstance().addTask((RaptorTask)transferTask);
                        while (!CloneToCloudAction.this.transferTaskDone) {
                            Thread.sleep(5000L);
                        }
                        object52 = new DecimalFormat("#0.0000");
                        double d = (double)(System.nanoTime() - l) / 1.0E9;
                        String string5 = "PDB File transfer " + ((NumberFormat)object52).format(d) + " seconds";
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, string5);
                        this.setMessage(string5);
                        if (!CloneToCloudAction.this.sftpError) {
                            CloneToCloudAction.this.updateAllFileStatus("COMPLETE");
                            this.setMessage(DbaNavigatorResources.getString("PDB_STEP7"));
                            Boolean bl3 = CloneToCloudAction.this.checkCompatible(CloneToCloudAction.this.destXmlFile, CloneToCloudAction.this.getObjectName(), (String)_connMap.get(CloneToCloudAction.this.destConName));
                            if (bl3.booleanValue()) {
                                this.setMessage(DbaNavigatorResources.getString("PDB_STEP8"));
                                CloneToCloudAction.this.dest.executeUpdate("CREATE PLUGGABLE DATABASE " + CloneToCloudAction.this.getObjectName() + " USING '" + CloneToCloudAction.this.destXmlFile + "' SOURCE_FILE_NAME_CONVERT=('" + CloneToCloudAction.this.sourcePath + "','" + CloneToCloudAction.this.destPath + "') NOCOPY STORAGE UNLIMITED TEMPFILE REUSE", (List)null);
                                if ((CloneToCloudAction.this._throwable = CloneToCloudAction.this.check_error(CloneToCloudAction.this.dest, DbaNavigatorResources.getString("PDB_STEP8_FAIL"))) != null) {
                                    CloneToCloudAction.this._error = true;
                                    try {
                                        throw CloneToCloudAction.this._throwable;
                                    }
                                    catch (Throwable throwable) {
                                        throw new Exception(DbaNavigatorResources.getString("PDB_MOVE_GENERIC_ERROR"));
                                    }
                                }
                                this.setMessage(DbaNavigatorResources.getString("PDB_STEP9"));
                                CloneToCloudAction.this.dest.executeUpdate("ALTER PLUGGABLE DATABASE " + CloneToCloudAction.this.getObjectName() + " OPEN READ WRITE", (List)null);
                                if ((CloneToCloudAction.this._throwable = CloneToCloudAction.this.check_error(CloneToCloudAction.this.dest, DbaNavigatorResources.getString("PDB_STEP9_FAIL"))) != null) {
                                    CloneToCloudAction.this._error = true;
                                    try {
                                        throw CloneToCloudAction.this._throwable;
                                    }
                                    catch (Throwable throwable) {
                                        throw new Exception(DbaNavigatorResources.getString("PDB_MOVE_GENERIC_ERROR"));
                                    }
                                }
                            } else {
                                CloneToCloudAction.this._error = true;
                                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), DbaNavigatorResources.getString("PDB_COMPAT_FAIL_MSG"), DbaNavigatorResources.getString("PDB_COMPAT_FAIL_TITLE"), 0);
                            }
                        } else {
                            CloneToCloudAction.this.updateJobStatus("ERROR");
                        }
                    }
                    catch (Exception exception) {
                        CloneToCloudAction.this.cleanUp();
                        CloneToCloudAction.this._error = true;
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getMessage(), exception);
                    }
                    if (CloneToCloudAction.this.getValues().get(CloneToCloudAction.POST_ACTION).equals(DbaNavigatorResources.getString("POST_CLONE_REPLUG"))) {
                        this.setMessage(DbaNavigatorResources.getString("PDB_STEP10"));
                        CloneToCloudAction.this.source.executeUpdate("CREATE PLUGGABLE DATABASE " + CloneToCloudAction.this.getObjectName() + " USING '" + CloneToCloudAction.this.sourceXmlFile + "' SOURCE_FILE_NAME_CONVERT=NONE NOCOPY STORAGE UNLIMITED TEMPFILE REUSE", (List)null);
                        if ((CloneToCloudAction.this._throwable = CloneToCloudAction.this.check_error(CloneToCloudAction.this.source, DbaNavigatorResources.getString("PDB_STEP10_FAIL"))) != null) {
                            CloneToCloudAction.this._error = true;
                            try {
                                throw CloneToCloudAction.this._throwable;
                            }
                            catch (Throwable throwable) {
                                throw new Exception(DbaNavigatorResources.getString("PDB_MOVE_GENERIC_ERROR"));
                            }
                        }
                        this.setMessage(DbaNavigatorResources.getString("PDB_STEP11"));
                        CloneToCloudAction.this.source.executeUpdate("ALTER PLUGGABLE DATABASE " + CloneToCloudAction.this.getObjectName() + " OPEN READ WRITE", (List)null);
                        if ((CloneToCloudAction.this._throwable = CloneToCloudAction.this.check_error(CloneToCloudAction.this.source, DbaNavigatorResources.getString("PDB_STEP11_FAIL"))) != null) {
                            CloneToCloudAction.this._error = true;
                            try {
                                throw CloneToCloudAction.this._throwable;
                            }
                            catch (Throwable throwable) {
                                throw new Exception(DbaNavigatorResources.getString("PDB_MOVE_GENERIC_ERROR"));
                            }
                        }
                    }
                    this.setMessage(DbaNavigatorResources.getString("PDB_DONE"));
                    if (CloneToCloudAction.this._error) {
                        CloneToCloudAction.this.updateAllStatus("ERROR");
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), DbaNavigatorResources.getString("PDB_MOVE_ERROR_MSG"), DbaNavigatorResources.getString("PDB_MOVE_ERROR_TITLE"), 2);
                    } else if (!CloneToCloudAction.this._canceled) {
                        CloneToCloudAction.this.updateJobStatus("COMPLETE");
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), DbaNavigatorResources.getString("PDB_MOVE_DONE_MSG"), DbaNavigatorResources.getString("PDB_MOVE_DONE_TITLE"), 1);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getMessage(), exception);
                    CloneToCloudAction.this.updateAllStatus("ERROR");
                }
                return null;
            }
        };
        raptorTask.setCancellable(true);
        raptorTask.setPausable(false);
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                CloneToCloudAction.this.cleanUp();
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                CloneToCloudAction.this.cleanUp();
            }
        });
        DBObject dBObject = this.getDBObject();
        ObjectAction objectAction = this.getObjectAction();
        if (null == objectAction) {
            objectAction = new ObjectAction();
            objectAction.setReloadParent(true);
        }
        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject);
        IRaptorTaskListener iRaptorTaskListener = ObjectActionController.getRaptorTaskListener((ObjectActionController.ObjectActionPostProcess)objectActionPostProcess);
        raptorTask.getDescriptor().addListener(iRaptorTaskListener);
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void cleanUp() {
        this.updateAllStatus("ERROR");
    }

    private boolean createMoveRows(ArrayList<FileObject> arrayList) {
        if (!this.tablesExist) {
            return true;
        }
        try {
            Connection connection = Connections.getInstance().getConnection(_connMap.get(this.destConName));
            String string = "begin INSERT INTO \"C##DBAAS_MONITOR\".\"SQLDEV_JOBS\" (ACTION, STATUS, HOST_NAME, PDB_NAME) VALUES ('PDB_MOVE', 'WORKING', ?, ?) RETURNING id into ?; end;";
            CallableStatement callableStatement = connection.prepareCall(string);
            callableStatement.setString(1, InetAddress.getLocalHost().getHostName());
            callableStatement.setString(2, this.getObjectName());
            callableStatement.registerOutParameter(3, 4);
            callableStatement.execute();
            this.jobId = callableStatement.getInt(3);
            if (!this.createFileRows(this.jobId, arrayList)) {
                connection.rollback();
            }
            connection.commit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    private boolean createFileRows(int n, ArrayList<FileObject> arrayList) {
        if (!this.tablesExist) {
            return true;
        }
        try {
            for (FileObject fileObject : this._files) {
                String string = "begin INSERT INTO \"C##DBAAS_MONITOR\".\"SQLDEV_JOB_FILES\" (JOB_ID, FILE_NAME, FILE_SIZE, PERCENT_MOVED, STATUS) VALUES (?, ?, ?, 0, 'MOVING'); end;";
                CallableStatement callableStatement = Connections.getInstance().getConnection(_connMap.get(this.destConName)).prepareCall(string);
                callableStatement.setInt(1, n);
                callableStatement.setString(2, fileObject.getDestName());
                callableStatement.setFloat(3, (float)fileObject.getSize());
                callableStatement.execute();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    private void checkJobStatus() {
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(_connMap.get(this.destConName));
            String string = "select count(1) from \"C##DBAAS_MONITOR\".\"SQLDEV_JOBS\" ";
            CallableStatement callableStatement = connection.prepareCall(string);
            callableStatement.execute();
            this.tablesExist = true;
        }
        catch (Exception exception) {
            this.tablesExist = false;
        }
    }

    private void updateJobStatus(String string) {
        if (!this.tablesExist) {
            return;
        }
        if (this.jobId == -1) {
            return;
        }
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(_connMap.get(this.destConName));
            String string2 = "UPDATE \"C##DBAAS_MONITOR\".\"SQLDEV_JOBS\" SET STATUS = ? WHERE ID = ? AND STATUS != 'ERROR' ";
            CallableStatement callableStatement = connection.prepareCall(string2);
            callableStatement.setString(1, string);
            callableStatement.setInt(2, this.jobId);
            callableStatement.executeUpdate();
            connection.commit();
        }
        catch (Exception exception) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void updateAllFileStatus(String string) {
        if (!this.tablesExist) {
            return;
        }
        if (this.jobId == -1) {
            return;
        }
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(_connMap.get(this.destConName));
            String string2 = "UPDATE \"C##DBAAS_MONITOR\".\"SQLDEV_JOB_FILES\" SET STATUS = ? WHERE JOB_ID = ? AND STATUS != 'COMPLETE'";
            CallableStatement callableStatement = connection.prepareCall(string2);
            callableStatement.setString(1, string);
            callableStatement.setInt(2, this.jobId);
            callableStatement.executeUpdate();
            connection.commit();
        }
        catch (Exception exception) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void updateAllStatus(String string) {
        if (!this.tablesExist) {
            return;
        }
        if (this.jobId == -1) {
            return;
        }
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(_connMap.get(this.destConName));
            String string2 = "UPDATE \"C##DBAAS_MONITOR\".\"SQLDEV_JOB_FILES\" SET STATUS = ? WHERE JOB_ID = ? AND STATUS != 'COMPLETE'";
            CallableStatement callableStatement = connection.prepareCall(string2);
            callableStatement.setString(1, string);
            callableStatement.setInt(2, this.jobId);
            callableStatement.executeUpdate();
            string2 = "UPDATE \"C##DBAAS_MONITOR\".\"SQLDEV_JOBS\" SET STATUS = ? WHERE ID = ?";
            callableStatement = connection.prepareCall(string2);
            callableStatement.setString(1, string);
            callableStatement.setInt(2, this.jobId);
            callableStatement.executeUpdate();
            connection.commit();
        }
        catch (Exception exception) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private boolean checkCompatible(String string, String string2, String string3) {
        if (NO_COMPAT_CHECK) {
            return true;
        }
        String string4 = "";
        try {
            String string5 = "DECLARE    compat boolean;    isOK Varchar2(10); BEGIN   compat := DBMS_PDB.CHECK_PLUG_COMPATIBILITY(?,?);  IF (compat) then     isOk := 'GOOD';  ELSE     isOk := 'BAD';  END IF; ? := isOk; END;";
            CallableStatement callableStatement = Connections.getInstance().getConnection(string3).prepareCall(string5);
            callableStatement.setString(1, string);
            callableStatement.setString(2, string2);
            callableStatement.registerOutParameter(3, 12);
            callableStatement.execute();
            string4 = callableStatement.getString(3);
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getMessage(), exception);
        }
        return string4.equals("GOOD");
    }

    public static class TTProgressListener
    extends TransferTaskProgressListenerAdapter {
        private TransferProgress progress;

        TTProgressListener(TransferProgress transferProgress) {
            this.progress = transferProgress;
        }

        public boolean count(long l) {
            return this.progress.count(l);
        }

        public void end() {
            this.progress.end();
        }

        public void init(int n, String string, String string2, long l) {
            this.progress.init(n, string, string2, l);
        }
    }
}

