/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.services;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ObjectOperationDialog;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class StartStopAction
extends ObjectOperationDialog {
    private static final String INSTANCE = "Instance";
    private final Map<String, String> instanceNameMap = new HashMap<String, String>();

    protected String getTitle() {
        Operation operation = this.getOperation();
        String string = operation == Operation.START ? DbaNavigatorResources.getString("START_SERVICE_TITLE") : DbaNavigatorResources.getString("STOP_SERVICE_TITLE");
        return string;
    }

    protected String getObjectLabel() {
        return DbaNavigatorResources.getString("SERVICE_NAME_LABEL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        DBUtil dBUtil;
        Object object;
        Object object2;
        boolean bl = this.getOperation() == Operation.START;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = DbaNavigatorResources.getString("ALL_INSTANCES_LABEL");
        arrayList.add(string);
        this.instanceNameMap.put(string, "DBMS_SERVICE.ALL_INSTANCES");
        String string2 = DbaNavigatorResources.getString("CURRENT_INSTANCE_LABEL");
        arrayList.add(string2);
        this.instanceNameMap.put(string2, "NULL");
        if (Connections.getInstance().lock(connection)) {
            object2 = null;
            try {
                object = new HashMap<String, String>();
                ((HashMap)object).put("NAME", this.getObjectName());
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                object2 = dBUtil.executeOracleQuery(this.getQuery(connection, "getServiceInstances"), (Map)object);
                if (object2 != null) {
                    while (object2.next()) {
                        String string3 = object2.getString("INSTANCE_NAME");
                        int n = object2.getInt("INST_ID");
                        boolean bl2 = object2.getString("STARTED").equals("YES");
                        if (bl == bl2) continue;
                        String string4 = string3 + " (" + n + ")";
                        arrayList.add(string4);
                        this.instanceNameMap.put(string4, "'" + string3 + "'");
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                DBUtil.closeResultSet((ResultSet)object2);
                Connections.getInstance().unlock(connection);
            }
        }
        object2 = new String[arrayList.size()];
        arrayList.toArray((T[])object2);
        object = super.createControls(connection);
        dBUtil = new ComboBoxActionControl(INSTANCE, DbaNavigatorResources.getString("INSTANCE_LABEL"), (String[])object2, object2[0]);
        object.add(dBUtil);
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = values.get(INSTANCE);
        if (string != null && !string.isEmpty()) {
            String string2 = this.instanceNameMap.get(string);
            boolean bl = this.getOperation() == Operation.START;
            stringBuilder.append("BEGIN\n");
            if (bl) {
                stringBuilder.append("    DBMS_SERVICE.START_SERVICE('").append(this.getObjectName()).append("', ").append(string2).append(");\n");
            } else {
                stringBuilder.append("    DBMS_SERVICE.STOP_SERVICE('").append(this.getObjectName()).append("', ").append(string2).append(");\n");
            }
            stringBuilder.append("END;\n");
        }
        return stringBuilder.toString();
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    private static enum Operation {
        START,
        STOP;

    }
}

