/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.displays.performancereport;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dba.navigator.displays.DisplayArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.ui.PopupButton;

public class RowSelectionPanel
extends JPanel {
    private Connection conn;
    private Map<String, ?> binds;
    private String[] tableColNames;
    private String query;
    private JTextField rowIdent;
    private JPanel popupContent;
    private JLabel loadingLabel;
    private JTable popupTable;
    private JScrollPane scrollPane;
    private DefaultTableModel tableModel;
    private PanelPopupButton popupButton;
    private boolean tablePopulationInitiated;
    private boolean tableReloadRequired;
    private PropertyChangeSupport changeSupport;
    private boolean multiSelect;
    private String selectedItemId = "";

    public RowSelectionPanel(Connection connection, String string, Map<String, ?> map, String[] stringArray, int n) {
        this(connection, string, map, stringArray, n, false);
    }

    public RowSelectionPanel(Connection connection, String string, Map<String, ?> hashMap, String[] stringArray, int n, boolean bl) {
        this.setLayout(new GridBagLayout());
        this.conn = connection;
        this.tableColNames = stringArray;
        this.query = string;
        this.binds = hashMap != null ? hashMap : new HashMap();
        this.multiSelect = bl;
        this.changeSupport = new PropertyChangeSupport(this);
        this.rowIdent = new JTextField(n);
        this.rowIdent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                RowSelectionPanel.this.updatedSelectedItemId();
            }
        });
        this.popupButton = new PanelPopupButton();
        this.popupButton.setText(DisplayArb.getString("PERF_BROWSE"));
        this.add((Component)this.rowIdent, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)((Object)this.popupButton), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public String getSelectedItemId() {
        return this.selectedItemId;
    }

    public void reset(Map<String, ?> map) {
        this.reset(map, true);
    }

    public void reset(Map<String, ?> hashMap, boolean bl) {
        HashMap hashMap2 = this.binds = hashMap != null ? hashMap : new HashMap();
        if (this.tablePopulationInitiated) {
            if (bl) {
                this.rowIdent.setText("");
            }
            this.tableReloadRequired = true;
        }
    }

    public void setSelectedItemId(String string) {
        this.selectedItemId = string;
        this.rowIdent.setText(string);
    }

    private boolean updatedSelectedItemId() {
        boolean bl;
        String string = this.rowIdent.getText();
        boolean bl2 = bl = !string.equals(this.selectedItemId);
        if (bl) {
            String string2 = this.selectedItemId;
            this.selectedItemId = string;
            this.changeSupport.firePropertyChange(null, string2, this.selectedItemId);
        }
        return bl;
    }

    private void openPopupAndPopulateIfNeeded() {
        if (!this.tablePopulationInitiated) {
            this.tablePopulationInitiated = true;
            this.initPopupComponents();
            this.loadPopupContent();
        } else if (this.tableReloadRequired) {
            this.tableReloadRequired = false;
            while (this.tableModel.getRowCount() > 0) {
                this.tableModel.removeRow(0);
            }
            this.loadPopupContent();
        }
        this.popupButton.openPopup();
    }

    private void initPopupComponents() {
        this.popupContent = new JPanel();
        this.popupContent.setLayout(new GridBagLayout());
        this.loadingLabel = new JLabel(DisplayArb.getString("PERF_LOADING"));
        this.tableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.popupTable = new JTable(this.tableModel);
        this.popupTable.getSelectionModel().setSelectionMode(this.multiSelect ? 2 : 0);
        Dimension dimension = this.popupTable.getPreferredScrollableViewportSize();
        dimension.setSize(dimension.getWidth(), (double)(this.popupTable.getRowHeight() * 10));
        this.popupTable.setPreferredScrollableViewportSize(dimension);
        this.scrollPane = new JScrollPane(this.popupTable);
        for (String string : this.tableColNames) {
            this.tableModel.addColumn(string);
        }
        this.popupButton.setPopupContent(this.popupContent);
        this.popupTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    Point point = mouseEvent.getPoint();
                    int n = RowSelectionPanel.this.popupTable.rowAtPoint(point);
                    if (n >= 0) {
                        RowSelectionPanel.this.popupButton.closePopup();
                    }
                }
            }
        });
        this.popupTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && keyEvent.isControlDown()) {
                    RowSelectionPanel.this.popupButton.closePopup();
                }
            }
        });
    }

    private void loadPopupContent() {
        this.popupContent.removeAll();
        this.popupContent.add((Component)this.loadingLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.popupContent.add((Component)this.scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
        RaptorTask<Void> raptorTask = new RaptorTask<Void>("", true, IRaptorTaskRunMode.NO_GUI){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doWork() throws TaskException {
                ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
                if (Connections.getInstance().lock(RowSelectionPanel.this.conn)) {
                    ResultSet resultSet;
                    block7: {
                        resultSet = null;
                        try {
                            DBUtil dBUtil = DBUtil.getInstance((Connection)RowSelectionPanel.this.conn);
                            dBUtil.setRaiseError(true);
                            resultSet = dBUtil.executeOracleQuery(RowSelectionPanel.this.query, RowSelectionPanel.this.binds);
                            if (resultSet == null) break block7;
                            while (resultSet.next()) {
                                Object[] objectArray = new Object[RowSelectionPanel.this.tableColNames.length];
                                for (int i = 0; i < RowSelectionPanel.this.tableColNames.length; ++i) {
                                    objectArray[i] = resultSet.getString(i + 1);
                                }
                                arrayList.add(objectArray);
                            }
                        }
                        catch (SQLException sQLException) {
                            try {
                                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                            }
                            catch (Throwable throwable) {
                                DBUtil.closeResultSet(resultSet);
                                Connections.getInstance().unlock(RowSelectionPanel.this.conn);
                                throw throwable;
                            }
                            DBUtil.closeResultSet((ResultSet)resultSet);
                            Connections.getInstance().unlock(RowSelectionPanel.this.conn);
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(RowSelectionPanel.this.conn);
                }
                SwingUtilities.invokeLater(() -> RowSelectionPanel.this.displayPopupContent(arrayList));
                return null;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void displayPopupContent(List<Object[]> list) {
        this.popupContent.remove(this.loadingLabel);
        this.popupContent.repaint();
        for (Object[] objectArray : list) {
            this.tableModel.addRow(objectArray);
        }
    }

    class PanelPopupButton
    extends PopupButton {
        PanelPopupButton() {
            this.setMargin(new Insets(4, 1, 4, 1));
        }

        void openPopup() {
            super.showPopup();
        }

        void closePopup() {
            int[] nArray = RowSelectionPanel.this.popupTable.getSelectedRows();
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (int n : nArray) {
                String string = RowSelectionPanel.this.tableModel.getValueAt(n, 0).toString();
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string);
            }
            RowSelectionPanel.this.rowIdent.setText(stringBuilder.toString());
            RowSelectionPanel.this.updatedSelectedItemId();
            this.hidePopup();
        }

        protected void showPopup() {
            RowSelectionPanel.this.openPopupAndPopulateIfNeeded();
        }
    }
}

