/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.viewers.parameters;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.controls.display.EditableGridInfo;
import oracle.dbtools.raptor.controls.grid.GridCellUpdateInfo;
import oracle.dbtools.raptor.controls.grid.IRaptorGridCellUpdated;
import oracle.dbtools.raptor.controls.grid.IRaptorGridUpdate;
import oracle.dbtools.raptor.controls.grid.RaptorGridCell;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public class ParameterUpdateAction
implements IRaptorGridUpdate,
IRaptorGridCellUpdated {
    private JEWTDialog dlg;
    private JCheckBox mem;
    private JCheckBox spfile;
    private String scope;
    private boolean commit = false;
    private int numError = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
        Object object;
        this.resetState();
        Connection connection = Connections.getInstance().getConnection(string);
        String string2 = "SELECT DECODE(value, NULL, 'PFILE', 'SPFILE') Type FROM sys.v_$parameter WHERE name = 'spfile'";
        if (Connections.getInstance().lock(connection)) {
            try {
                object = DBUtil.getInstance((Connection)connection).executeReturnOneCol(string2);
                this.showDialog((String)object);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        if (this.commit) {
            if (this.mem.isSelected() && this.spfile.isSelected()) {
                this.scope = "BOTH";
            } else if (this.mem.isSelected()) {
                this.scope = "MEMORY";
            } else if (this.spfile.isSelected()) {
                this.scope = "SPFILE";
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbaNavigatorResources.getString("INVALID_SCOPE"), (String)DbaNavigatorResources.getString("INVALID_SCOPE_TITLE"), null);
                return 1;
            }
            object = new HashMap();
            if (Connections.getInstance().lock(connection)) {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    for (RaptorGridRowModel raptorGridRowModel : list) {
                        String string3 = ParameterUpdateAction.getSQL(raptorGridRowModel, this.scope);
                        list2.add(string3);
                        boolean bl = dBUtil.execute(string3, (Map)object);
                        if (bl) continue;
                        ++this.numError;
                        dBUtil.setRaiseError(false);
                        list2.add(dBUtil.getCurrentError());
                    }
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
                return this.numError;
            }
            return 1;
        }
        return 1;
    }

    private void resetState() {
        this.commit = false;
        this.numError = 0;
    }

    public GridCellUpdateInfo cellUpdated(String string, RaptorGridRowModel raptorGridRowModel, int n, int n2, Object object) {
        return null;
    }

    private void showDialog(String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.mem = new JCheckBox(DbaNavigatorResources.getString("PARAM_MEMORY"));
        this.mem.setSelected(true);
        this.spfile = new JCheckBox(DbaNavigatorResources.getString("PARAM_SPFILE"));
        jPanel.add((Component)this.mem, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
        if (string.equals("SPFILE")) {
            jPanel.add((Component)this.spfile, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
        }
        jPanel.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        String string2 = DbaNavigatorResources.getString("PARAMETER_TITLE");
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string2, (int)10);
        this.dlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParameterUpdateAction.this.commit = true;
                ParameterUpdateAction.this.dlg.dispose();
            }
        });
        Dimension dimension = jPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 200;
        int n2 = (int)dimension.getWidth() + 200;
        this.dlg.setSize(n2, n);
        this.dlg.setMinimumSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        WizardLauncher.runDialog((JDialog)this.dlg);
    }

    public void setGridInfo(EditableGridInfo editableGridInfo) {
    }

    static String getSQL(RaptorGridRowModel raptorGridRowModel, String string) {
        String string2;
        List list = raptorGridRowModel.getRow();
        String string3 = null;
        Object object = ((RaptorGridCell)list.get(1)).getCellData();
        string3 = object != null ? object.toString() : "";
        Object object2 = ((RaptorGridCell)list.get(3)).getCellData();
        if (object2 != null) {
            string2 = object2.toString().trim();
            if (string2.equalsIgnoreCase("Boolean") || string2.equalsIgnoreCase("Integer") || string2.equalsIgnoreCase("Big integer")) {
                string3 = string3.trim();
            } else {
                String string4 = string3.trim();
                if (string4.length() < 1 || string4.charAt(0) != '\'') {
                    string3 = "'" + string3;
                }
                if (string4.length() < 2 || string4.charAt(string4.length() - 1) != '\'') {
                    string3 = string3 + "'";
                }
            }
        }
        string2 = "ALTER SYSTEM SET " + ((RaptorGridCell)list.get(0)).getCellData() + "=" + string3;
        string2 = ((RaptorGridCell)list.get(2)).getCellData() != null ? string2 + " COMMENT='" + ((RaptorGridCell)list.get(2)).getCellData() + "'" : string2 + " COMMENT=''";
        string2 = string2 + " SCOPE=" + string;
        return string2;
    }
}

