/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapump.imp;

import java.awt.Component;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extract.models.ExtractListModel;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizCommon;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizardArb;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp.DpExpWizSource;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.imp.DpImpWizMain;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public class DpImpWizScan {
    private boolean _masterOnly = true;
    private boolean getLogFile = false;
    private String storeFirstDir = null;
    private CallableStatement call = null;

    String ignoreMoreInfo(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        return "BEGIN\n" + string + "EXCEPTION\nWHEN success_with_info then null;\nEND;\n";
    }

    void getDrivingTable(ExtractListModel extractListModel, CanProceedHolder canProceedHolder, final DefaultTraversablePanel defaultTraversablePanel) throws TraversalException {
        block108: {
            String string12;
            String string2;
            Object object2;
            boolean bl = false;
            boolean bl2 = (Boolean)extractListModel.getPropertyValue("IMP_DWCS_OPTS_ENABLED");
            boolean bl3 = (Boolean)extractListModel.getPropertyValue("IMP_DP_OPTS_ENABLED");
            this._masterOnly = true;
            Connection connection = null;
            try {
                connection = Connections.getInstance().getConnection((String)extractListModel.getPropertyValue("KEY_CNAME"));
            }
            catch (DBException dBException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
                throw new TraversalException((Object)dBException);
            }
            Connection connection2 = connection;
            String string3 = DBUtil.getInstance((Connection)connection2).executeOracleReturnOneCol("select DBMS_SCHEDULER.GENERATE_JOB_NAME('IMP_SD_') from dual", new HashMap());
            ArrayList arrayList = (ArrayList)extractListModel.getPropertyValue("IMP_OUTPUTDIRFILESIZE");
            if (arrayList == null || arrayList.size() == 0) {
                throw new TraversalException(DpWizardArb.getString("NO_IMPORT_FILE"), DpWizardArb.getString("IMPORT_FILE"));
            }
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            for (Object object2 : arrayList) {
                int n = 1;
                string2 = ", directory => '" + DpWizCommon.stripDir(object2[0], true).replace("'", "''") + "'";
                if (object2[0].equals("CREDENTIAL:NULL")) {
                    string2 = ", directory => NULL";
                }
                if (object2[0].startsWith("CREDENTIAL:")) {
                    n = 5;
                }
                if (object2[0].startsWith("DIRECTORY:") && string7.equals("")) {
                    string7 = object2[0];
                }
                string4 = string4 + "        dbms_datapump.add_file(handle => h1, filename => '" + object2[1].replace("'", "''") + "'" + string2 + ", filetype => " + n + "); \n";
            }
            if (string5.equals("")) {
                string5 = string7;
            }
            String string8 = string5;
            if (string6.equals("")) {
                string6 = (String)extractListModel.getPropertyValue("DP_EXP_JNAME") + ".SQL";
            } else if (!string6.toUpperCase().endsWith(".SQL")) {
                string6 = string6 + ".SQL";
            }
            String string9 = string6;
            this.storeFirstDir = string8;
            object2 = "        dbms_datapump.add_file(handle => h1, filename => '" + string9.replace("'", "''") + "', directory => '" + DpWizCommon.stripDir(string8, true).replace("'", "''") + "', filetype => dbms_datapump.KU$_FILE_TYPE_SQL_FILE);\n";
            String string10 = "";
            string2 = (String)extractListModel.getPropertyValue("DP_KEY_BRANCH");
            if (string2.equals("DP_SCHEMA")) {
                string2 = "SCHEMA";
            } else if (string2.equals("IMP_FULL")) {
                string2 = "FULL";
            } else if (string2.equals("DP_TABLESPACE")) {
                string2 = "TABLESPACE";
            } else if (string2.equals("DP_TABLE")) {
                string2 = "TABLE";
            }
            String string11 = "";
            if (bl2 || bl3) {
                for (String string12 : DpWizCommon.getDWCSCanned(bl2, bl3).replaceAll("^", "    ").split("\\n")) {
                    string11 = string11 + this.ignoreMoreInfo(string12 + "\n");
                }
            }
            String[] stringArray = "    When Others then \n        minimumError:=SQLERRM||chr(10);\n        errorMessage:=SQLERRM||chr(10);\n        DECLARE\n             ind NUMBER;              -- Loop index\n           -- h1 NUMBER;               -- Data Pump job handle\n            percent_done NUMBER;     -- Percentage of job complete\n            job_state VARCHAR2(30);  -- To keep track of job state\n            le ku$_LogEntry;         -- For WIP and error messages\n           js ku$_JobStatus;        -- The job status from get_status\n            jd ku$_JobDesc;          -- The job description from get_status\n            sts ku$_Status;          -- The status object returned by get_status\n        BEGIN \n            --on error try getstatus\n            if (hsetflag=true) then \n                dbms_datapump.get_status(h1,\n                dbms_datapump.ku$_status_job_error +\n                dbms_datapump.ku$_status_job_status +\n                dbms_datapump.ku$_status_wip,-1,job_state,sts);\n                js := sts.job_status;\n        -- If any work-in-progress (WIP) or Error messages were received for the job,\n        -- display them.\n                if (bitand(sts.mask,dbms_datapump.ku$_status_wip) != 0)\n                then\n                    le := sts.wip;\n                else\n                    if (bitand(sts.mask,dbms_datapump.ku$_status_job_error) != 0)\n                    then\n                        le := sts.error;\n                    else\n                        le := null;\n                    end if;\n                end if;\n                if le is not null\n                then\n                    ind := le.FIRST;\n                    if ind is not null \n                    then\n                        errorMessage:=errorMessage||('dbms_datapump.get_status('||h1||'...)'||chr(10));\n                    end if;\n                    while ind is not null loop\n                        errorMessage:=errorMessage||(le(ind).LogText||chr(10));\n                        ind := le.NEXT(ind);\n                    end loop;\n                end if;\n            END IF;\n        EXCEPTION \n        when others then errorMessage:=minimumError;\n        END;\nBEGIN\nIF (hsetflag=true) THEN\nDBMS_DATAPUMP.DETACH(h1);\nEND IF;\nEXCEPTION\nWHEN OTHERS THEN NULL;\nEND;\n    END;\n";
            String string13 = "";
            char[] cArray = (char[])DpWizCommon.getOrInitializeList(extractListModel, "IMP_ENCRYPTION_PASSWORD", new char[0]);
            if (cArray != null && cArray.length != 0) {
                string13 = string13 + "    dbms_datapump.set_parameter(handle => h1, name => 'ENCRYPTION_PASSWORD', value => :ENCRYPTIONBIND);\n";
            }
            string12 = "";
            string12 = "        dbms_datapump.set_parameter(handle => h1, name => 'MASTER_ONLY', value => 1);\n";
            String string14 = "IMPORT";
            String string15 = "Declare\n    h1   NUMBER;\n    success_with_info EXCEPTION;\n    PRAGMA EXCEPTION_INIT(success_with_info, -31627);\n    hsetflag BOOLEAN:= false;\n    errorMessage VARCHAR2(4000 byte):='';\n    minimumError VARCHAR2(4000 byte):='';\nbegin\n    begin\n" + this.ignoreMoreInfo("        h1 := dbms_datapump.open (operation => '" + string14 + "', job_mode => 'FULL', job_name => '" + string3.replace("'", "''") + "', version => 'COMPATIBLE');\n") + "        hsetflag:=true;\n" + string11 + this.ignoreMoreInfo("        dbms_datapump.set_parallel(handle => h1, degree => 1);\n") + this.ignoreMoreInfo(string10) + string12 + this.ignoreMoreInfo(string4) + this.ignoreMoreInfo(string13) + this.ignoreMoreInfo("        dbms_datapump.start_job(handle => h1, skip_current => 0, abort_step => 0);\n") + "        Declare\n            jobState  user_datapump_jobs.state%TYPE := 'INITIAL';\n            sts ku$_Status;\n            js ku$_JobStatus;\n        BEGIN\n                dbms_datapump.get_status(h1,\n                dbms_datapump.ku$_status_job_error +\n                dbms_datapump.ku$_status_job_status +\n                dbms_datapump.ku$_status_wip,1,jobState,sts);\n        END;\n" + this.ignoreMoreInfo("        dbms_datapump.detach(handle => h1);\n") + "    EXCEPTION\n" + (String)stringArray + "    :errorOut := errorMessage;\nEND;\n";
            String string16 = "DECLARE\n    hsetflag boolean := false;\n    h1 number;\n    c number;\n    retVal varchar2(4000 byte) := '';\n    noSuchJob varchar2(4000 byte) := '';\n    errorMessage varchar2(4000 byte) := '';\n    minimumError VARCHAR2(4000 byte):='';\n    jobState  user_datapump_jobs.state%TYPE := 'INITIAL';\n    success_with_info EXCEPTION;\n    PRAGMA EXCEPTION_INIT(success_with_info, -31627);\n    no_such_job EXCEPTION;\n    PRAGMA EXCEPTION_INIT(no_such_job, -31626);\nBEGIN \nBEGIN \n" + this.ignoreMoreInfo("    h1:=DBMS_DATAPUMP.ATTACH('" + string3.replace("'", "''") + "', USER);\n") + "        hsetflag := true;\n        Declare\n            sts ku$_Status;\n            js ku$_JobStatus;\n        BEGIN\n" + this.ignoreMoreInfo("                dbms_datapump.get_status(h1,\n                dbms_datapump.ku$_status_job_error +\n                dbms_datapump.ku$_status_job_status +\n                dbms_datapump.ku$_status_wip,2,jobState,sts);\n") + "        END;\n" + this.ignoreMoreInfo("    DBMS_DATAPUMP.detach(h1);\n") + "        hsetflag := false;         retVal:=jobState;\nEXCEPTION WHEN NO_SUCH_JOB THEN noSuchJob:=SQLERRM||chr(10);\n" + (String)stringArray + "    :retValx := retVal;\n    :noSuchJobx := noSuchJob;\n    :errorOut := errorMessage;\nEND; \n";
            boolean bl4 = false;
            boolean bl5 = true;
            Statement statement = null;
            try {
                Object object3;
                String string17;
                Object object4;
                Object object5;
                Object object6;
                List list;
                block107: {
                    Connection connection3 = connection2;
                    String string18 = "";
                    if (Connections.getInstance().lock(connection3, true)) {
                        try {
                            if (!(extractListModel.getPropertyValue("IMP_THIS_CNAME") != null && extractListModel.getPropertyValue("IMP_THIS_FNAME") != null && extractListModel.getPropertyValue("IMP_THIS_JNAME") != null && extractListModel.getPropertyValue("IMP_THIS_CNAME").equals(extractListModel.getPropertyValue("KEY_CNAME")) && this.arrayListStringArraysAreEqual((ArrayList)extractListModel.getPropertyValue("IMP_THIS_FNAME"), (ArrayList)extractListModel.getPropertyValue("IMP_OUTPUTDIRFILESIZE")) && extractListModel.getPropertyValue("IMP_THIS_JNAME").equals(extractListModel.getPropertyValue("DP_EXP_JNAME")))) {
                                list = new ArrayList<String>();
                                object6 = (String)extractListModel.getPropertyValue("IMP_DELETE_ME");
                                if (object6 != null) {
                                    object5 = null;
                                    try {
                                        object5 = Connections.getInstance().getConnection((String)extractListModel.getPropertyValue("IMP_DELETE_ME_CNAME"));
                                    }
                                    catch (DBException dBException) {
                                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
                                        if (this.call != null) {
                                            try {
                                                this.call.close();
                                            }
                                            catch (SQLException sQLException) {
                                                // empty catch block
                                            }
                                        }
                                        if (statement != null) {
                                            try {
                                                statement.close();
                                            }
                                            catch (SQLException sQLException) {
                                                // empty catch block
                                            }
                                        }
                                        Connections.getInstance().unlock(connection3);
                                        if (bl5) {
                                            this.deleteFiles(extractListModel, string8, string9);
                                        }
                                        return;
                                    }
                                    this.deleteTable((Connection)object5, (String)object6);
                                }
                                extractListModel.setProperty("IMP_DELETE_ME", null);
                                ((ArrayList)list).add(string3);
                                object5 = DBUtil.getInstance((Connection)connection2).executeReturnOneCol("select table_name from user_tables where table_name=:1", list);
                                if (object5 != null) {
                                    throw new TraversalException(DpWizardArb.format("IMP_DRIVING_TABLE_ALREADY_EXISTS_RENAME_JOB", string3), DpWizardArb.getString("FAILED_TO_GET_METADATA"));
                                }
                                extractListModel.setProperty("IMP_DELETE_ME", (Object)string3);
                                extractListModel.setProperty("IMP_DELETE_ME_CNAME", extractListModel.getPropertyValue("KEY_CNAME"));
                                DpImpWizMain.primeDeleteTable(connection2, string3);
                                this.call = connection3.prepareCall(string15);
                                object4 = null;
                                cArray = (char[])DpWizCommon.getOrInitializeList(extractListModel, "IMP_ENCRYPTION_PASSWORD", new char[0]);
                                if (cArray != null && cArray.length != 0) {
                                    object4 = cArray;
                                }
                                int n = 0;
                                if (object4 != null) {
                                    this.call.setString(1, String.valueOf((char[])object4));
                                    n = 1;
                                }
                                this.call.registerOutParameter(1 + n, 12);
                                extractListModel.setProperty("IMP_THIS_CNAME", null);
                                canProceedHolder.canProceed();
                                this.call.execute();
                                extractListModel.setProperty("LASTJNAME", (Object)string3);
                                canProceedHolder.canProceed();
                                extractListModel.setProperty("IMP_THIS_CNAME", extractListModel.getPropertyValue("KEY_CNAME"));
                                extractListModel.setProperty("IMP_THIS_FNAME", extractListModel.getPropertyValue("IMP_OUTPUTDIRFILESIZE"));
                                extractListModel.setProperty("IMP_THIS_JNAME", extractListModel.getPropertyValue("DP_EXP_JNAME"));
                                string18 = this.call.getString(1 + n);
                                if (string18 != null && !string18.startsWith("ORA-31627:")) {
                                    throw new TraversalException(DpWizardArb.format("IMP_EXCEPTION", this.shortenError(string18).replace("\n", System.getProperty("line.separator"))), DpWizardArb.getString("FAILED_TO_GET_METADATA"));
                                }
                                string17 = "";
                                object3 = "";
                                String string19 = "";
                                boolean bl6 = false;
                                while (true) {
                                    try {
                                        List list2;
                                        statement = connection3.prepareCall(string16);
                                        statement.registerOutParameter(1, 12);
                                        statement.registerOutParameter(2, 12);
                                        statement.registerOutParameter(3, 12);
                                        canProceedHolder.canProceed();
                                        statement.execute();
                                        canProceedHolder.canProceed();
                                        string18 = statement.getString(1);
                                        string19 = statement.getString(2);
                                        object3 = statement.getString(3);
                                        if (string19 != null && !string19.equals("")) {
                                            list2 = DBUtil.getInstance((Connection)connection3).executeReturnList("select TO_CHAR(ERROR_COUNT) ERROR_COUNT, STATE from \"" + string3 + "\" where operation = '" + string14 + "' and job_mode = 'FULL' and name = '" + string3 + "'", new HashMap());
                                            if (list2 != null && list2.size() == 1) {
                                                Map map = (Map)list2.get(0);
                                                if (map.get("ERROR_COUNT").equals("0") && map.get("STATE").equals("COMPLETED")) break;
                                                throw new TraversalException(DpWizardArb.format("IMP_ERROR_COUNT_STATUS", (String)map.get("ERROR_COUNT"), (String)map.get("STATE")), DpWizardArb.getString("FAILED_TO_GET_METADATA"));
                                            }
                                            throw new TraversalException(DpWizardArb.getString("IMP_CANNOT_GET_STATUS_ROW"), DpWizardArb.getString("FAILED_TO_GET_METADATA"));
                                        }
                                        if (object3 != null && !((String)object3).equals("") && !((String)object3).startsWith("ORA-39002:")) {
                                            throw new TraversalException(DpWizardArb.format("IMP_EXCEPTION", this.shortenError((String)object3).replace("\n", System.getProperty("line.separator"))), DpWizardArb.getString("FAILED_TO_GET_METADATA"));
                                        }
                                        if (string18 != null && (string18.equals("COMPLETED") || string18.equals("NOT RUNNING")) && this._masterOnly) {
                                            list2 = DBUtil.getInstance((Connection)connection3).executeReturnList("select TO_CHAR(ERROR_COUNT) ERROR_COUNT, STATE from \"" + string3 + "\" where operation = 'IMPORT' and job_mode = 'FULL' and name = '" + string3.replace("'", "''") + "'", new HashMap());
                                            if (list2 != null && list2.size() == 1) {
                                                Map map = (Map)list2.get(0);
                                                if (map.get("ERROR_COUNT").equals("0") && map.get("STATE").equals("COMPLETED")) break;
                                                throw new TraversalException(DpWizardArb.format("IMP_ERROR_COUNT_STATUS", (String)map.get("ERROR_COUNT"), (String)map.get("STATE")), DpWizardArb.getString("FAILED_TO_GET_METADATA"));
                                            }
                                            throw new TraversalException(DpWizardArb.getString("IMP_CANNOT_GET_STATUS_ROW"), DpWizardArb.getString("FAILED_TO_GET_METADATA"));
                                        }
                                        if (string18 != null && string18.equals("STOPPED")) {
                                            throw new TraversalException(DpWizardArb.format("IMP_EXCEPTION", string18), DpWizardArb.getString("FAILED_TO_GET_METADATA"));
                                        }
                                    }
                                    catch (SQLException sQLException) {
                                        throw new TraversalException(DpWizardArb.format("IMP_EXCEPTION", sQLException.getMessage().replace("\n", System.getProperty("line.separator"))), DpWizardArb.getString("FAILED_TO_GET_METADATA"));
                                    }
                                    finally {
                                        if (statement != null) {
                                            try {
                                                statement.close();
                                            }
                                            catch (SQLException sQLException) {}
                                        }
                                    }
                                    if (bl6) break;
                                    try {
                                        Thread.sleep(2000L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                                this.resetModelOnSuccessfullLoad(extractListModel);
                                break block107;
                            }
                            bl5 = false;
                            string3 = (String)extractListModel.getPropertyValue("LASTJNAME");
                        }
                        catch (SQLException sQLException) {
                            if (sQLException.getMessage().length() > 11 && (sQLException.getMessage().startsWith("ORA-01013:") || sQLException.getMessage().startsWith("ORA-03111:"))) {
                                bl = true;
                                throw new TraversalException(null, null);
                            }
                            throw new TraversalException(DpWizardArb.format("IMP_EXCEPTION", sQLException.getLocalizedMessage()), DpWizardArb.getString("FAILED_TO_GET_METADATA"));
                        }
                        catch (ExecutionException executionException) {
                            bl = true;
                            throw new TraversalException(null, null);
                        }
                        finally {
                            if (this.call != null) {
                                try {
                                    this.call.close();
                                }
                                catch (SQLException sQLException) {}
                            }
                            if (statement != null) {
                                try {
                                    statement.close();
                                }
                                catch (SQLException sQLException) {}
                            }
                            Connections.getInstance().unlock(connection3);
                        }
                    }
                }
                list = null;
                object6 = null;
                object5 = string2;
                if (string2.equals("SCHEMA")) {
                    object5 = "USER";
                }
                if ((object4 = DBUtil.getInstance((Connection)connection2).executeReturnOneCol("select object_type_path from \"" + string3 + "\" where object_type_path is not null AND object_type_path like '%/%' and rownum <2", new HashMap())) == null) {
                    object4 = "";
                } else if ((((String)(object4 = ((String)object4).substring(0, ((String)object4).indexOf("/")))).equals("DATABASE_EXPORT") || ((String)object4).equals("TABLE_EXPORT") || ((String)object4).equals("TABLESPACE_EXPORT") || ((String)object4).equals("SCHEMA_EXPORT")) && string2.equals("SCHEMA") && (((String)object4).equals("TABLE_EXPORT") || ((String)object4).equals("TABLESPACE_EXPORT"))) {
                    throw new TraversalException(DpWizardArb.getString("META_DATA_DOES_NOT_MATCH"), DpWizardArb.getString("INCOMPATIBLE_FILE_AND_OPTION"));
                }
                extractListModel.setProperty("IMP_SCHEMA_RAW", (Object)DBUtil.getInstance((Connection)connection2).executeReturnList("select distinct jname.object_schema original_object_name from \"" + (String)extractListModel.getPropertyValue("LASTJNAME") + "\" jname where jname.object_schema is not null and jname.object_type_path is not null order by original_object_name", new HashMap()));
                extractListModel.setProperty("IMP_TABLESPACE_RAW", (Object)DBUtil.getInstance((Connection)connection2).executeReturnList("select distinct object_tablespace object_tablespace from \"" + (String)extractListModel.getPropertyValue("LASTJNAME") + "\" where object_tablespace is not null order by object_tablespace ", new HashMap()));
                if (!((String)object5).equals("FULL")) {
                    DBUtil.getInstance((Connection)connection2).getLastException();
                    object6 = DBUtil.getInstance((Connection)connection2).executeReturnList("select 'TABLE' object_type, object_name original_object_name, original_object_schema from \"" + string3 + "\" where completed_rows is not null and object_name is not null  and original_object_schema is not null and OBJECT_TYPE='TABLE_DATA' order by original_object_schema, original_object_name", new HashMap());
                    SQLException sQLException = DBUtil.getInstance((Connection)connection2).getLastException();
                    if (sQLException != null) {
                        this.deleteTable(connection2, string3);
                        throw new TraversalException(DpWizardArb.format("IMP_EXCEPTION", sQLException.getMessage()), DpWizardArb.getString("FAILED_TO_GET_METADATA"));
                    }
                    if (((String)object5).equals("USER")) {
                        list = DBUtil.getInstance((Connection)connection2).executeReturnList("select distinct jname.object_schema original_object_name from \"" + string3 + "\" jname where jname.object_schema is not null and jname.object_type_path is not null order by original_object_name", new HashMap());
                    } else if (((String)object5).equals("TABLE")) {
                        list = DBUtil.getInstance((Connection)connection2).executeReturnList("select distinct object_name original_object_name, original_object_schema from \"" + string3 + "\" where (OBJECT_TYPE='TABLE' or OBJECT_TYPE='TABLE_DATA') and object_name is not null order by original_object_schema, original_object_name", new HashMap());
                    } else if (((String)object5).equals("TABLESPACE")) {
                        list = DBUtil.getInstance((Connection)connection2).executeReturnList("select distinct object_tablespace original_object_name  from \"" + string3 + "\" where object_tablespace is not null  order by original_object_name", new HashMap());
                    }
                    sQLException = DBUtil.getInstance((Connection)connection2).getLastException();
                    if (sQLException != null) {
                        this.deleteTable(connection2, string3);
                        throw new TraversalException(DpWizardArb.format("IMP_EXCEPTION", sQLException.getMessage()), DpWizardArb.getString("FAILED_TO_GET_METADATA"));
                    }
                    extractListModel.setProperty("IMP_OBJ_LIST", list);
                    extractListModel.setProperty("IMP_DATA_LIST", object6);
                    if (!(list != null && list.size() != 0 || object6 != null && object6.size() != 0 && !((DpExpWizSource.MetadataEnum)((Object)DpWizCommon.getOrInitializeList(extractListModel, "DP_KEY_STOREMETA", (Object)DpExpWizSource.MetadataEnum.BOTH))).equals((Object)DpExpWizSource.MetadataEnum.DDL))) {
                        throw new TraversalException(DpWizardArb.format("NO_ENTRY_OF_TYPE", string2), DpWizardArb.getString("FAILED_TO_GET_METADATA"));
                    }
                }
                SQLException sQLException = DBUtil.getInstance((Connection)connection2).getLastException();
                string17 = DBUtil.getInstance((Connection)connection2).executeReturnOneCol("select property from \"" + string3 + "\" where operation='EXPORT' and rownum<2", new HashMap());
                sQLException = DBUtil.getInstance((Connection)connection2).getLastException();
                if (sQLException != null) {
                    break block108;
                }
                if (string17 == null || string17.equals("")) break block108;
                try {
                    object3 = Long.parseLong(string17);
                    try {
                        DpWizCommon.checkTZVersion((Long)object3, (Long)DpWizCommon.getOrInitializeList(extractListModel, "EXP_TIMEZONE_VERSION", null));
                    }
                    catch (TraversalException traversalException) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    MessageDialog.information((Component)defaultTraversablePanel, (Object)traversalException.getLocalizedMessage(), null, null);
                                }
                                catch (Exception exception) {
                                    Logger.getLogger(DpImpWizScan.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                                }
                            }
                        });
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            catch (TraversalException traversalException) {
                bl4 = true;
                this.cleanup(extractListModel);
                if (bl) {
                    canProceedHolder.setBackButtonOnError();
                }
                throw traversalException;
            }
            finally {
                if (bl5) {
                    this.deleteFiles(extractListModel, string8, string9);
                }
            }
        }
    }

    private String shortenError(String string) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        if (string.indexOf("ORA-31640:") == -1) {
            return string;
        }
        for (String string2 : stringArray = string.split("\\r?\\n")) {
            if (!string2.startsWith("ORA-31640:")) continue;
            return string2;
        }
        return string;
    }

    private boolean arrayListStringArraysAreEqual(ArrayList<String[]> arrayList, ArrayList<String[]> arrayList2) {
        if (arrayList == null && arrayList2 == null) {
            return true;
        }
        if (arrayList == null || arrayList2 == null) {
            return false;
        }
        if (arrayList.size() != arrayList2.size()) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (this.compareStringArray(arrayList.get(i), arrayList2.get(i))) continue;
            return false;
        }
        return true;
    }

    private void resetModelOnSuccessfullLoad(ExtractListModel extractListModel) {
        extractListModel.setProperty("IMP_DATAFILES_STORAGE", new ArrayList());
        extractListModel.setProperty("IMP_SCHEMAS_STORAGE", new ArrayList());
        extractListModel.setProperty("IMP_TABLESPACES_STORAGE", new ArrayList());
        extractListModel.setProperty("IMP_TABLE_LIST", null);
        extractListModel.setProperty("DP_TABLESPACE_LIST", null);
        extractListModel.setProperty("DP_SCHEMA_LIST", null);
        extractListModel.setProperty("DP_EXP_THREAD_NUMBER", null);
    }

    private boolean compareStringArray(String[] stringArray, String[] stringArray2) {
        if (stringArray == null && stringArray2 == null) {
            return true;
        }
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(stringArray2[i])) continue;
            return false;
        }
        return true;
    }

    public void deleteTable(Connection connection, String string) {
        DBUtil.getInstance((Connection)connection).execute("begin execute immediate('drop table \"" + string + "\" purge '); exception when others then null; end;");
    }

    private void deleteFiles(ExtractListModel extractListModel, String string, String string2) {
        if (!this._masterOnly) {
            // empty if block
        }
    }

    void wait15forNoJobOrError(ExtractListModel extractListModel) {
        Connection connection;
        SQLException sQLException = null;
        boolean bl = false;
        int n = 0;
        Connection connection2 = null;
        try {
            connection2 = Connections.getInstance().getConnection((String)extractListModel.getPropertyValue("KEY_CNAME"));
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
            return;
        }
        Connection connection3 = connection = connection2;
        PreparedStatement preparedStatement = null;
        try {
            while (n < 15) {
                if (!Connections.getInstance().lock(connection3, true)) continue;
                try {
                    sQLException = null;
                    preparedStatement = connection3.prepareStatement("DECLARE\n    h1 number;\n    c number;\n    h1got boolean := false;\n    no_such_job EXCEPTION;\n    PRAGMA EXCEPTION_INIT(no_such_job, -31626);\nBEGIN \n    h1:=DBMS_DATAPUMP.ATTACH(:1, USER);\n    h1got := true;\n    DBMS_DATAPUMP.STOP_JOB(h1,1,0,0);\n     BEGIN\n         dbms_datapump.detach(handle => h1); \n     EXCEPTION\n          when dbms_datapump.INVALID_HANDLE then null;\n          when dbms_datapump.SUCCESS_WITH_INFO then null;\n          when dbms_datapump.NO_SUCH_JOB then null;\n     END;\nEXCEPTION WHEN NO_SUCH_JOB THEN NULL;\nWHEN OTHERS THEN \n    BEGIN \n        IF (h1got=true) THEN \n            DBMS_DATAPUMP.DETACH(h1);\n        END IF;\n    EXCEPTION\n    WHEN OTHERS THEN NULL;\n    END;\n    RAISE;\nEND; \n");
                    preparedStatement.setString(1, (String)extractListModel.getPropertyValue("LASTJNAME"));
                    preparedStatement.execute();
                    bl = false;
                }
                catch (SQLException sQLException2) {
                    sQLException = sQLException2;
                    if (sQLException2.getMessage().startsWith("ORA-39002:")) {
                        bl = true;
                        continue;
                    }
                    bl = false;
                    throw sQLException2;
                }
                finally {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (SQLException sQLException3) {}
                    }
                    Connections.getInstance().unlock(connection3);
                    continue;
                }
                if (bl && (n += 2) < 15) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
        catch (SQLException sQLException4) {
            sQLException = sQLException4;
        }
        if (sQLException != null) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, DpWizardArb.format("CLEANUP_MAY_FAIL", sQLException.getMessage()));
        }
    }

    private void cleanup(ExtractListModel extractListModel) {
        Object object;
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection((String)extractListModel.getPropertyValue("KEY_CNAME"));
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
            return;
        }
        Connection connection2 = connection;
        this.wait15forNoJobOrError(extractListModel);
        ArrayList arrayList = new ArrayList();
        String string = (String)extractListModel.getPropertyValue("IMP_DELETE_ME");
        if (string != null) {
            object = null;
            try {
                object = Connections.getInstance().getConnection((String)extractListModel.getPropertyValue("IMP_DELETE_ME_CNAME"));
            }
            catch (DBException dBException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
                return;
            }
            this.deleteTable((Connection)object, string);
        }
        extractListModel.setProperty("IMP_DELETE_ME", null);
        this.deleteTable(connection2, (String)extractListModel.getPropertyValue("DP_EXP_JNAME"));
        extractListModel.setProperty("IMP_THIS_CNAME", null);
        if (this.storeFirstDir != null && !this.storeFirstDir.equals("") && (String)extractListModel.getPropertyValue("DP_EXP_JNAME") != null) {
            object = this.storeFirstDir;
            String string2 = (String)extractListModel.getPropertyValue("DP_EXP_JNAME");
            this.deleteFiles(extractListModel, DpWizCommon.stripDir((String)object, true), string2);
        }
    }

    public void cancel() {
    }

    public static interface CanProceedHolder {
        public void canProceed() throws ExecutionException;

        public void setBackButtonOnError();
    }
}

