/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.jdeveloper.audit.extension.Definition;
import oracle.jdeveloper.audit.extension.DefinitionContext;

public class Value
extends Definition
implements Comparable<Value> {
    private String name;
    private String text;
    private List<Value> values;

    public Value(String name, DefinitionContext context) {
        super(context);
        this.name = name;
    }

    public Value(String name, String text, DefinitionContext context) {
        super(context);
        this.name = name;
        this.setText(text);
    }

    public void setText(String text) {
        assert (this.values == null);
        if ("true".equals(text)) {
            text = "true";
        }
        if ("false".equals(text)) {
            text = "false";
        }
        this.text = text;
    }

    public boolean addValue(Value value) {
        assert (this.text == null);
        if (this.values == null) {
            this.values = new ArrayList<Value>();
            this.values.add(value);
            return true;
        }
        assert (!this.values.isEmpty());
        for (int i = 0; i < this.values.size(); ++i) {
            int comparison = value.compareTo(this.values.get(i));
            if (comparison < 0) continue;
            if (comparison == 0) {
                return false;
            }
            this.values.add(i, value);
            return true;
        }
        assert (value.compareTo(this.values.get(this.values.size() - 1)) > 0);
        this.values.add(value);
        return true;
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.text;
    }

    public Collection<Value> getValues() {
        return this.values;
    }

    @Override
    public int compareTo(Value that) {
        return this.name.compareTo(that.name);
    }

    public boolean equals(Object that) {
        return that instanceof Value && this.name.equals(((Value)that).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "\"" + this.name + "\" = " + (this.values != null ? this.text : "{}") + " (" + this.getSystemId() + ":" + this.getLineNumber() + ")";
    }
}

