/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.util.Log;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.AuditPreferences;
import oracle.jdeveloper.audit.AuditProvider;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.bean.BeanCustomizer;
import oracle.jdeveloper.audit.extension.AuditHook;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.ExtensionBeanFactory;
import oracle.jdeveloper.audit.extension.TypeDefinition;
import oracle.jdeveloper.audit.model.ContentRootFactory;
import oracle.jdeveloper.audit.model.ModelType;
import oracle.jdeveloper.audit.model.ModelTypeFactory;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.Auditor;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.service.ProfileRepository;
import oracle.jdeveloper.audit.service.Transformer;
import oracle.jdevimpl.audit.core.DefaultAuditModel;
import oracle.jdevimpl.audit.core.DefaultAuditor;
import oracle.jdevimpl.audit.core.DefaultExtensionBeanFactory;
import oracle.jdevimpl.audit.core.DefaultProfile;
import oracle.jdevimpl.audit.core.DefaultTransformer;
import oracle.jdevimpl.audit.log.AuditLogPage;
import oracle.jdevimpl.audit.model.DefaultModelTypeFactory;
import oracle.jdevimpl.audit.model.DirectoryModelType;
import oracle.jdevimpl.audit.model.ProjectModelType;
import oracle.jdevimpl.audit.model.RootModelType;
import oracle.jdevimpl.audit.model.WorkspaceModelType;

public class DefaultAuditManager
extends AuditManager {
    private final List<AuditProvider> providers = new ArrayList<AuditProvider>();
    private List<URL> styleSheets;
    private List<URL> profileStyleSheets;
    private Map<Class<?>, BeanCustomizer> beanCustomizers;
    private volatile DefaultModelTypeFactory defaultModelTypeFactory;
    private volatile Collection<TypeDefinition<ContentRootFactory>> contentRootFactories;
    private static final Log LOG = new Log("audit-initialization");

    @Override
    public void register(AuditProvider provider) {
        LOG.trace("registering {0}", (Object)provider);
        this.providers.add(provider);
    }

    @Override
    public AuditPreferences getPreferences() {
        return oracle.jdevimpl.audit.preferences.AuditPreferences.getAuditPreferences();
    }

    @Override
    public ExtensionBeanFactory getDefaultExtensionBeanFactory() {
        return new DefaultExtensionBeanFactory(new BeanDefinition[0]);
    }

    @Override
    public ProfileRepository getDefaultProfileRepository() {
        return ProfileRepository.getDefaultRepository();
    }

    @Override
    public ModelTypeFactory createModelTypeFactory(ModelType ... modelTypes) {
        ArrayList<ModelType> types = new ArrayList<ModelType>();
        types.add(new RootModelType());
        types.add(new WorkspaceModelType());
        types.add(new ProjectModelType());
        types.add(new DirectoryModelType());
        types.addAll(Arrays.asList(modelTypes));
        return new DefaultModelTypeFactory(types, null, this.getContentRootFactories());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelTypeFactory getDefaultModelTypeFactory() {
        AuditHook hook = AuditHook.getAuditHook();
        Collection<TypeDefinition<ContentRootFactory>> contentRootFactories = this.getContentRootFactories();
        DefaultAuditManager defaultAuditManager = this;
        synchronized (defaultAuditManager) {
            if (this.defaultModelTypeFactory == null) {
                this.defaultModelTypeFactory = new DefaultModelTypeFactory(null, hook.getModels(), contentRootFactories);
            }
        }
        return this.defaultModelTypeFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<TypeDefinition<ContentRootFactory>> getContentRootFactories() {
        AuditHook hook = AuditHook.getAuditHook();
        DefaultAuditManager defaultAuditManager = this;
        synchronized (defaultAuditManager) {
            if (this.contentRootFactories == null) {
                this.contentRootFactories = hook.getRootFactories();
            }
        }
        return this.contentRootFactories;
    }

    @Override
    public Profile createProfile(String name) {
        return new DefaultProfile(name, DefaultProfile.ALL_ENABLED);
    }

    @Override
    public Profile createProfile(String name, BeanDefinition ... beans) {
        return new DefaultProfile((ExtensionBeanFactory)new DefaultExtensionBeanFactory(beans), name, DefaultProfile.ALL_ENABLED);
    }

    @Override
    public Profile createProfile(String name, String ... ids) {
        return new DefaultProfile(name, ids);
    }

    @Override
    public Auditor createAuditor(Class<? extends Analyzer> ... analyzers) {
        return this.createAuditor(this.getDefaultModelTypeFactory(), analyzers);
    }

    @Override
    public Auditor createAuditor(ModelTypeFactory factory, Class<? extends Analyzer> ... analyzers) {
        try {
            return new DefaultAuditor(factory, analyzers);
        }
        catch (NoClassDefFoundError e) {
            String EOL = System.getProperty("line.separator");
            String[] PLEA = new String[]{"Please describe this installation if possible (e.g., make pullsan or make release in JDEVADF view", "(note role if any), unzip of Java edition, install of Studio Edition, etc). Build command history", "(e.g., module clean or rebuild commands) may also be relevant."};
            File product = new File(Ide.getOracleHomeDirectory());
            File oracle = product.getParentFile();
            File built = new File(oracle, "built");
            StringBuilder builder = new StringBuilder();
            builder.append(e).append(EOL).append(EOL);
            for (String line : PLEA) {
                builder.append("  ").append(line).append(EOL);
            }
            builder.append(EOL);
            DefaultAuditManager.appendJsp(builder, new File(oracle, "modules"), true, EOL);
            DefaultAuditManager.appendJsp(builder, new File(product, "modules"), false, EOL);
            DefaultAuditManager.appendDir(builder, built, EOL);
            DefaultAuditManager.appendDir(builder, new File(built, "dist-wls"), EOL);
            throw new UnexpectedExceptionError(builder.toString(), (Throwable)e);
        }
    }

    private static StringBuilder appendJsp(StringBuilder builder, File modules, boolean contents, String EOL) {
        File jsp = null;
        String[] names = modules.list();
        builder.append("  ");
        if (names == null) {
            builder.append(modules);
            if (modules.exists()) {
                builder.append(" empty");
            } else {
                builder.append(" not found");
            }
        } else {
            for (String name : names) {
                if (!name.startsWith("javax.jsp")) continue;
                jsp = new File(modules, name);
                break;
            }
            builder.append(modules).append(" found").append(EOL).append("  ");
            if (jsp != null) {
                builder.append(jsp).append(" found");
            } else {
                builder.append(modules).append(File.separator).append("javax.jsp* not found");
                if (contents) {
                    builder.append(", but found:");
                    for (String name : names) {
                        if (name.startsWith("com.bea")) continue;
                        builder.append(EOL).append("    ").append(modules).append(File.separator).append(name);
                    }
                }
            }
        }
        builder.append(EOL);
        return builder;
    }

    private static StringBuilder appendDir(StringBuilder builder, File dir, String EOL) {
        builder.append("  ").append(dir);
        if (dir.exists()) {
            builder.append(" found");
        } else {
            builder.append(" not found");
        }
        builder.append(EOL);
        return builder;
    }

    @Override
    public AuditModel createModel() {
        return new DefaultAuditModel();
    }

    @Override
    public AuditModel runShowLogPage(Context context, Auditor auditor, String label, Thread.UncaughtExceptionHandler handler) {
        return AuditLogPage.runShow(context, auditor, label, handler);
    }

    @Override
    public void showLogPage(final Context context, final Auditor auditor, final AuditModel model, final String label) {
        if (SwingUtilities.isEventDispatchThread()) {
            AuditLogPage.auditLogPage(context, auditor, model, label).show();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AuditLogPage.auditLogPage(context, auditor, model, label).show();
                }
            });
        }
    }

    @Override
    public Transformer createTransformer() {
        return new DefaultTransformer();
    }

    @Override
    public Collection<URL> getStyleSheets() {
        if (this.styleSheets != null) {
            return this.styleSheets;
        }
        this.styleSheets = new ArrayList<URL>();
        for (AuditProvider provider : this.providers) {
            URL[] urls = provider.getStyleSheets();
            if (urls == null) continue;
            for (URL url : urls) {
                if (url == null) continue;
                this.styleSheets.add(url);
            }
        }
        return this.styleSheets;
    }

    @Override
    public Collection<URL> getProfileStyleSheets() {
        if (this.profileStyleSheets != null) {
            return this.profileStyleSheets;
        }
        this.profileStyleSheets = new ArrayList<URL>();
        for (AuditProvider provider : this.providers) {
            URL[] urls = provider.getProfileStyleSheets();
            if (urls == null) continue;
            for (URL url : urls) {
                if (url == null) continue;
                this.profileStyleSheets.add(url);
            }
        }
        return this.profileStyleSheets;
    }

    @Override
    public Map<Class<?>, BeanCustomizer> getBeanCustomizers() {
        if (this.beanCustomizers == null) {
            this.beanCustomizers = new HashMap();
            for (AuditProvider provider : this.providers) {
                Class[] classes = provider.getBeanCustomizers();
                if (classes == null) continue;
                for (Class clas : classes) {
                    try {
                        BeanCustomizer object = (BeanCustomizer)clas.newInstance();
                        Class<?> type = object.getType();
                        if (!this.beanCustomizers.containsKey(type)) {
                            this.beanCustomizers.put(type, object);
                            continue;
                        }
                        Log.error((String)"duplicate customizer {0} for type {1}", (Object)object, type);
                    }
                    catch (Throwable e) {
                        Log.error((String)"exception instantiating customizer {0}: {1}", (Object)clas, (Object)e);
                    }
                }
            }
            this.beanCustomizers = Collections.unmodifiableMap(this.beanCustomizers);
        }
        return this.beanCustomizers;
    }
}

