/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.log;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.service.AuditModelFilter;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdevimpl.audit.util.Cache;

public class RuleFilter
extends AuditModelFilter {
    private String key;
    private Set<String> excludes = new HashSet<String>();

    public RuleFilter() {
    }

    public RuleFilter(String persistenceKey) {
        this.key = persistenceKey;
        List list = (List)Cache.get(this.key, Collections.EMPTY_LIST);
        this.excludes.addAll(list);
    }

    @Override
    public boolean isVisible(Object construct) {
        Violation violation = this.getModel().getViolation(construct);
        return violation == null || this.isEnabled(violation.getRule());
    }

    public void setEnabled(Rule rule, boolean enabled) {
        if (enabled) {
            this.excludes.remove(rule.id());
        } else {
            this.excludes.add(rule.id());
        }
        this.write();
    }

    public boolean isEnabled(Rule rule) {
        return !this.excludes.contains(rule.id());
    }

    public void enableAll() {
        this.excludes.clear();
        this.write();
    }

    public int getDisabledCount() {
        return this.excludes.size();
    }

    private void write() {
        if (this.key != null) {
            Cache.put(this.key, new ArrayList<String>(this.excludes));
        }
        this.fireStateChanged();
    }
}

