/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.report;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.util.Log;
import oracle.jdevimpl.audit.report.AuditReporter;
import oracle.jdevimpl.audit.report.XmlReportType;

public abstract class XmlReporter<T>
implements AuditReporter {
    private T model;
    private URL outputFile;
    private String title;
    private String encoding = IdeUtil.getIdeIanaEncoding();
    private PrintWriter writer;
    private int indent = 2;
    private int depth = 0;
    private static final Log LOG = new Log("report");
    private static final char[][] ESCAPES = new char[][]{{'?', 'N', 'U', 'L', '?'}, {'?', 'S', 'O', 'H', '?'}, {'?', 'S', 'T', 'X', '?'}, {'?', 'E', 'T', 'X', '?'}, {'?', 'E', 'O', 'T', '?'}, {'?', 'E', 'N', 'Q', '?'}, {'?', 'A', 'C', 'K', '?'}, {'?', 'B', 'E', 'L', '?'}, {'?', 'B', 'S', '?'}, {'\t'}, {'\n'}, {'?', 'V', 'T', '?'}, {'?', 'F', 'F', '?'}, {'\r'}, {'?', 'S', 'O', '?'}, {'?', 'S', 'I', '?'}, {'?', 'D', 'L', 'E', '?'}, {'?', 'D', 'C', '1', '?'}, {'?', 'D', 'C', '2', '?'}, {'?', 'D', 'C', '3', '?'}, {'?', 'D', 'C', '4', '?'}, {'?', 'N', 'A', 'K', '?'}, {'?', 'S', 'Y', 'N', '?'}, {'?', 'E', 'T', 'B', '?'}, {'?', 'C', 'A', 'N', '?'}, {'?', 'E', 'M', '?'}, {'?', 'S', 'U', 'B', '?'}, {'?', 'E', 'S', 'C', '?'}, {'?', 'F', 'S', '?'}, {'?', 'G', 'S', '?'}, {'?', 'R', 'S', '?'}, {'?', 'U', 'S', '?'}, {' '}, {'!'}, {'\"'}, {'#'}, {'$'}, {'%'}, {'&', 'a', 'm', 'p', ';'}, {'\''}, {'('}, {')'}, {'*'}, {'+'}, {','}, {'-'}, {'.'}, {'/'}, {'0'}, {'1'}, {'2'}, {'3'}, {'4'}, {'5'}, {'6'}, {'7'}, {'8'}, {'9'}, {':'}, {';'}, {'&', 'l', 't', ';'}, {'='}, {'>'}, {'?'}, {'@'}, {'A'}, {'B'}, {'C'}, {'D'}, {'E'}, {'F'}, {'G'}, {'H'}, {'I'}, {'J'}, {'K'}, {'L'}, {'M'}, {'N'}, {'O'}, {'P'}, {'Q'}, {'R'}, {'S'}, {'T'}, {'U'}, {'V'}, {'W'}, {'X'}, {'Y'}, {'Z'}, {'['}, {'\\'}, {']'}, {'^'}, {'_'}, {'`'}, {'a'}, {'b'}, {'c'}, {'d'}, {'e'}, {'f'}, {'g'}, {'h'}, {'i'}, {'j'}, {'k'}, {'l'}, {'m'}, {'n'}, {'o'}, {'p'}, {'q'}, {'r'}, {'s'}, {'t'}, {'u'}, {'v'}, {'w'}, {'x'}, {'y'}, {'z'}, {'{'}, {'|'}, {'}'}, {'~'}, {'?', 'D', 'E', 'L', '?'}, {'?', 'P', 'A', 'D', '?'}, {'?', 'H', 'O', 'P', '?'}, {'?', 'B', 'P', 'H', '?'}, {'?', 'N', 'B', 'H', '?'}, {'?', 'I', 'N', 'D', '?'}, {'?', 'N', 'E', 'L', '?'}, {'?', 'S', 'S', 'A', '?'}, {'?', 'E', 'S', 'A', '?'}, {'?', 'H', 'T', 'S', '?'}, {'?', 'H', 'T', 'J', '?'}, {'?', 'L', 'T', 'S', '?'}, {'?', 'P', 'L', 'D', '?'}, {'?', 'P', 'L', 'U', '?'}, {'?', 'R', 'I', '?'}, {'?', 'S', 'S', '2', '?'}, {'?', 'S', 'S', '3', '?'}, {'?', 'D', 'C', 'S', '?'}, {'?', 'P', 'U', '1', '?'}, {'?', 'P', 'U', '2', '?'}, {'?', 'S', 'T', 'S', '?'}, {'?', 'C', 'C', 'H', '?'}, {'?', 'M', 'W', '?'}, {'?', 'S', 'P', 'A', '?'}, {'?', 'E', 'P', 'A', '?'}, {'?', 'S', 'O', 'S', '?'}, {'?', 'S', 'G', 'C', 'I', '?'}, {'?', 'S', 'C', 'I', '?'}, {'?', 'C', 'S', 'I', '?'}, {'?', 'S', 'T', '?'}, {'?', 'O', 'S', 'C', '?'}, {'?', 'P', 'M', '?'}, {'?', 'A', 'P', 'C', '?'}};
    protected String lineBreakSequence;

    public abstract XmlReportType getType();

    protected abstract void writeModel(T var1) throws Exception;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (encoding == null) {
            encoding = IdeUtil.getIdeIanaEncoding();
        }
        this.encoding = encoding;
    }

    public URL getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(URL destination) {
        LOG.trace("setting destination to {0}", (Object)destination);
        this.outputFile = destination;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setModel(T model) {
        this.model = model;
    }

    public T getModel() {
        return this.model;
    }

    @Override
    public void report() throws InvocationTargetException {
        try {
            LOG.trace("creating output stream {0}", (Object)this.outputFile);
            BufferedOutputStream output = this.outputFile == null ? new BufferedOutputStream(new StandardOutputStream()) : new BufferedOutputStream(URLFileSystem.openOutputStream((URL)this.outputFile));
            this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)output, this.getEncoding())));
            this.writeXmlDeclaration();
            this.writeModel(this.model);
        }
        catch (InterruptedException e) {
            throw new InvocationTargetException(e);
        }
        catch (Throwable e) {
            LOG.trace("unexpected exception creating report {0}: {1}", (Object)this.outputFile, (Object)e);
            throw new InvocationTargetException(e);
        }
        finally {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        Node node = NodeFactory.find((URL)this.outputFile);
        if (node != null) {
            try {
                node.revert();
            }
            catch (IOException e) {
                LOG.trace("unexpected exception reverting report {0}: {1}", (Object)this.outputFile, (Object)e);
                throw new InvocationTargetException(e);
            }
        }
    }

    protected void indent() {
        ++this.depth;
    }

    protected void undent() {
        --this.depth;
    }

    protected void writeXmlDeclaration() {
        this.writeLine("<?xml version=\"1.0\" encoding=\"" + this.getEncoding() + "\" standalone=\"yes\"?>");
    }

    protected void writeTextElement(String name, Object object) {
        this.writeTextElement(name, null, object);
    }

    protected void writeTextElement(String name, String[] attributes, Object object) {
        String text;
        String string = text = object != null ? String.valueOf(object) : "";
        if ("".equals(text)) {
            this.writeBeginTag(name, attributes, true, true);
        } else {
            this.writeBeginTag(name, attributes, false, false);
            this.writeText(text);
            this.writeEndTag(name, false);
        }
    }

    protected void writeText(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c <= '\u009f') {
                this.writer.write(ESCAPES[c]);
                continue;
            }
            this.writer.write(c);
        }
    }

    protected void writeBeginTag(String name) {
        this.writeBeginTag(name, null, false, true);
    }

    protected void writeBeginTag(String name, String[] attributes, boolean empty, boolean wrap) {
        this.writeIndent();
        this.writer.print('<');
        this.writeName(name);
        if (attributes != null) {
            for (int i = 0; i < attributes.length; i += 2) {
                this.writer.print(' ');
                this.writer.print(attributes[i]);
                this.writer.print("=\"");
                this.writer.print(attributes[i + 1]);
                this.writer.print('\"');
            }
        }
        if (empty) {
            this.writer.print('/');
        }
        this.writer.print('>');
        if (wrap) {
            this.newline();
        }
        if (!empty) {
            this.indent();
        }
    }

    protected void writeEndTag(String name) {
        this.writeEndTag(name, true);
    }

    protected void writeEndTag(String name, boolean indent) {
        this.undent();
        if (indent) {
            this.writeIndent();
        }
        this.writer.print("</");
        this.writeName(name);
        this.writer.print('>');
        this.newline();
    }

    protected void writeName(String name) {
        this.writer.print(name);
    }

    protected void writeIndent() {
        int count = this.depth * this.indent;
        while (count-- > 0) {
            this.writer.write(32);
        }
    }

    protected void writeLine(String text) {
        this.writeIndent();
        this.writer.print(text);
        this.newline();
    }

    protected void newline() {
        if (this.lineBreakSequence == null) {
            this.lineBreakSequence = Ide.getEnvironOptions().getLineBreakSequence();
        }
        this.writer.write(this.lineBreakSequence);
    }

    static class StandardOutputStream
    extends PrintStream {
        public StandardOutputStream() {
            super(System.out, false);
        }

        @Override
        public void close() {
            this.flush();
        }
    }
}

