/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.usages;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.NoRouteToHostException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.raptor.usages.ServerLocation;
import oracle.dbtools.raptor.usages.ServerLocationsParser;
import oracle.dbtools.raptor.usages.UsageClient;
import oracle.dbtools.util.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.xml.sax.SAXException;

final class ServerLocations {
    static String _masterServerURL;

    ServerLocations() {
    }

    static Set<ServerLocation> getServers(UsageClient usageClient) {
        HashSet<ServerLocation> hashSet = new HashSet<ServerLocation>();
        try {
            HttpGet httpGet = new HttpGet(ServerLocations.getMasterUsageServerURL());
            List<ServerLocation> list = usageClient.executeRequest((HttpUriRequest)httpGet, new ResponseHandler<List<ServerLocation>>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public List<ServerLocation> handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
                    StatusLine statusLine = httpResponse.getStatusLine();
                    HttpEntity httpEntity = httpResponse.getEntity();
                    if (statusLine.getStatusCode() >= 300) {
                        throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                    }
                    if (httpEntity == null) {
                        throw new ClientProtocolException("Response contains no content");
                    }
                    ContentType contentType = ContentType.getOrDefault((HttpEntity)httpEntity);
                    Charset charset = contentType.getCharset();
                    if (charset == null) {
                        charset = Charset.defaultCharset();
                    }
                    try (InputStream inputStream = httpEntity.getContent();){
                        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
                        List<ServerLocation> list = new ServerLocationsParser().parse(inputStreamReader);
                        return list;
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        throw new IOException(parserConfigurationException);
                    }
                    catch (SAXException sAXException) {
                        throw new IOException(sAXException);
                    }
                }
            });
            for (ServerLocation serverLocation : list) {
                hashSet.add(serverLocation);
            }
        }
        catch (NoRouteToHostException noRouteToHostException) {
            Logger.severe(ServerLocations.class, (String)"Failed to upload usage logs to server. Possible cause: proxy may not be configured correctly.", (Throwable)noRouteToHostException);
        }
        catch (Exception exception) {
            Logger.severe(ServerLocations.class, (String)"Failed to upload usage logs to server.", (Throwable)exception);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    static String getMasterUsageServerURL() {
        if (_masterServerURL == null) {
            String string = System.getProperty("ide.update.usage.servers");
            if (string == null || string.trim().length() == 0) {
                string = "http://download.oracle.com/otn-pub/jdeveloper/cfu/usage.xml";
            }
            _masterServerURL = string;
        }
        return _masterServerURL;
    }
}

