/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ide.Service;
import javax.ide.build.BuildListener;
import javax.ide.build.spi.BuildSystemHook;
import javax.ide.command.Context;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.spi.ProviderNotFoundException;

public abstract class BuildSystem
extends Service {
    private final List _listeners = new ArrayList();

    protected BuildSystem() {
    }

    protected final boolean hasListeners() {
        return !this._listeners.isEmpty();
    }

    protected final Collection getListeners() {
        return Collections.unmodifiableList(new ArrayList(this._listeners));
    }

    @Override
    protected void initialize() {
        BuildSystemHook hook = (BuildSystemHook)ExtensionRegistry.getExtensionRegistry().getHook(BuildSystemHook.ELEMENT);
        this._listeners.addAll(hook.getListeners());
    }

    public final void addBuildListener(BuildListener l) {
        this._listeners.add(l);
    }

    public final void removeBuildListener(BuildListener l) {
        this._listeners.remove(l);
    }

    public abstract void build(Context var1);

    public abstract boolean isBuilding();

    public static BuildSystem getBuildSystem() {
        try {
            return (BuildSystem)BuildSystem.getService(BuildSystem.class);
        }
        catch (ProviderNotFoundException nse) {
            nse.printStackTrace();
            throw new IllegalStateException("No build system service.");
        }
    }
}

