/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.ide.Identifiable;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.extension.PlatformInfo;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.net.URIPath;
import javax.ide.util.MetaResourceString;
import javax.ide.util.Version;

public class DefaultExtension
implements Extension,
Identifiable,
Comparable {
    private String _id;
    private String _name = null;
    private MetaResourceString _nameAsMRS;
    private String _rawName;
    private String _rawOwner;
    private Version _version;
    private Version _edkVersion;
    private String _owner = null;
    private MetaResourceString _ownerAsMRS;
    protected static Collection NONINITIALIZED_DEPENDENCY_LIST = Collections.emptyList();
    private Collection<ExtensionDependency> _dependencies = NONINITIALIZED_DEPENDENCY_LIST;
    private URIPath _classpath = new URIPath();
    private PlatformInfo _platformInfo;
    private ExtensionSource _source;
    private boolean _cycleDetector = false;
    private Collection<String> _allImports;
    private ResourceBundle _resourceBundle = null;

    public DefaultExtension() {
    }

    public DefaultExtension(String id) {
        this._id = id;
    }

    public void setSource(ExtensionSource source) {
        this._source = source;
    }

    public ExtensionSource getSource() {
        return this._source;
    }

    @Override
    public String getID() {
        return this._id;
    }

    @Override
    public String getName() {
        if (this._name == null && this._nameAsMRS != null) {
            this._name = this._nameAsMRS.getValue();
        }
        return this._name;
    }

    @Override
    public String getOwner() {
        if (this._owner == null && this._ownerAsMRS != null) {
            this._owner = this._ownerAsMRS.getValue();
        }
        return this._owner;
    }

    @Override
    public Version getVersion() {
        return this._version;
    }

    @Override
    public Version getEDKVersion() {
        return this._edkVersion;
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return this._platformInfo;
    }

    protected final void setDependencies(Collection<ExtensionDependency> dependencies) {
        this._dependencies = dependencies;
    }

    @Override
    public Collection<ExtensionDependency> getDependencies() {
        return this._dependencies;
    }

    public Collection<String> getAllImportedExtensions(ExtensionRegistry registry) {
        if (this._allImports == null) {
            HashSet<String> allDependencies = new HashSet<String>();
            this.getAllImportedExtensionsImpl(allDependencies, registry);
            this._allImports = Collections.unmodifiableCollection(allDependencies);
        }
        return this._allImports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAllImportedExtensionsImpl(Collection<String> deps, ExtensionRegistry registry) {
        if (this._cycleDetector) {
            return;
        }
        try {
            this._cycleDetector = true;
            for (ExtensionDependency dep : this.getDependencies()) {
                String id = dep.getID();
                Extension ext = registry.findExtension(id);
                if (ext == null || !(ext instanceof DefaultExtension)) continue;
                deps.add(id);
                ((DefaultExtension)ext).getAllImportedExtensionsImpl(deps, registry);
            }
        }
        finally {
            this._cycleDetector = false;
        }
    }

    @Override
    public URIPath getClassPath() {
        return this._classpath;
    }

    String getRawName() {
        return this._rawName;
    }

    void setRawName(String rawName) {
        this._rawName = rawName == null ? "" : rawName.trim();
    }

    String getRawOwner() {
        return this._rawOwner;
    }

    void setRawOwner(String rawOwner) {
        this._rawOwner = rawOwner;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setName(MetaResourceString nameAsMRS) {
        this._nameAsMRS = nameAsMRS;
    }

    public void setOwner(String owner) {
        this._owner = owner;
    }

    public void setOwner(MetaResourceString ownerAsMRS) {
        this._ownerAsMRS = ownerAsMRS;
    }

    public void setVersion(Version version) {
        this._version = version;
    }

    public void setEDKVersion(Version edkVersion) {
        this._edkVersion = edkVersion;
    }

    public void setPlatformInfo(PlatformInfo info) {
        this._platformInfo = info;
    }

    public void addDependency(ExtensionDependency dependency) {
        if (this._dependencies == NONINITIALIZED_DEPENDENCY_LIST) {
            this._dependencies = new ArrayList<ExtensionDependency>();
        }
        this._dependencies.add(dependency);
    }

    public void setClassPath(URIPath classpath) {
        this._classpath = classpath;
    }

    public String toString() {
        return this.getID() + " " + String.valueOf(this.getVersion());
    }

    public int compareTo(Object o) {
        if (o instanceof Extension) {
            return this.getName().compareTo(((Extension)o).getName());
        }
        return -1;
    }

    public void setResourceBundle(ResourceBundle rb) {
        this._resourceBundle = rb;
    }

    public ResourceBundle getResourceBundle() {
        return this._resourceBundle;
    }
}

