/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v70;

import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.PermissionsDB2v70;

public class SSBPermissionsDB2v70
extends AbstractSSBDB2 {
    private AbstractStorageDesignDB2 storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        PermissionsDB2v70 permissions = (PermissionsDB2v70)object;
        if ((permissions.getTable() != null || permissions.getView() != null || permissions.getAuxTable() != null) && permissions.getUser() != null) {
            this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(permissions);
            if (!"".equalsIgnoreCase(permissions.getPrivileges())) {
                this.appendComment(buffer, permissions);
                SSBPermissionsDB2v70.appendStringWithSpace(buffer, "GRANT");
                if (permissions.getPrivilegesSet().contains("ALL PRIVILEGES")) {
                    SSBPermissionsDB2v70.appendString(buffer, "ALL PRIVILEGES");
                } else {
                    SSBPermissionsDB2v70.appendString(buffer, permissions.getPrivileges());
                }
                SSBPermissionsDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsDB2v70.appendStringWithSpace(buffer, "ON");
                if (permissions.getTable() != null) {
                    SSBPermissionsDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getTable().getName()));
                } else if (permissions.getView() != null) {
                    SSBPermissionsDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getView().getName()));
                }
                SSBPermissionsDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsDB2v70.appendStringWithSpace(buffer, "TO");
                SSBPermissionsDB2v70.appendString(buffer, this.storageDesign.getFormatedName(permissions.getUser().getName()));
                SSBPermissionsDB2v70.appendNewLine(buffer, prettyPrint, 0);
                SSBPermissionsDB2v70.appendLineFinisher(buffer, prettyPrint);
                SSBPermissionsDB2v70.appendNewLine(buffer, prettyPrint, 1);
            }
            if (!"".equalsIgnoreCase(permissions.getPrivilegesWithGrantOption())) {
                this.appendComment(buffer, permissions);
                SSBPermissionsDB2v70.appendStringWithSpace(buffer, "GRANT");
                if (permissions.getPrivilegesWithGrantOptionSet().contains("ALL PRIVILEGES")) {
                    SSBPermissionsDB2v70.appendString(buffer, "ALL PRIVILEGES");
                } else {
                    SSBPermissionsDB2v70.appendString(buffer, permissions.getPrivilegesWithGrantOption());
                }
                SSBPermissionsDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsDB2v70.appendStringWithSpace(buffer, "ON");
                if (permissions.getTable() != null) {
                    SSBPermissionsDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getTable().getName()));
                } else if (permissions.getView() != null) {
                    SSBPermissionsDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getView().getName()));
                }
                SSBPermissionsDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsDB2v70.appendStringWithSpace(buffer, "TO");
                SSBPermissionsDB2v70.appendString(buffer, this.storageDesign.getFormatedName(permissions.getUser().getName()));
                SSBPermissionsDB2v70.appendNewLine(buffer, prettyPrint, 1);
                SSBPermissionsDB2v70.appendStringWithSpace(buffer, "WITH GRANT OPTION");
                SSBPermissionsDB2v70.appendNewLine(buffer, prettyPrint, 0);
                SSBPermissionsDB2v70.appendLineFinisher(buffer, prettyPrint);
                SSBPermissionsDB2v70.appendNewLine(buffer, prettyPrint, 1);
            }
            if (!"".equalsIgnoreCase(permissions.getColumnList())) {
                StringTokenizer st = new StringTokenizer(permissions.getColumnList(), "|");
                String priv = "";
                while (st.hasMoreTokens()) {
                    String col = st.nextToken();
                    if (col.indexOf(44) <= -1) continue;
                    priv = col.substring(col.indexOf(44) + 1).trim();
                    col = col.substring(0, col.indexOf(44));
                    this.appendComment(buffer, permissions);
                    SSBPermissionsDB2v70.appendStringWithSpace(buffer, "GRANT");
                    SSBPermissionsDB2v70.appendString(buffer, priv);
                    SSBPermissionsDB2v70.appendNewLine(buffer, prettyPrint, 1);
                    SSBPermissionsDB2v70.appendStringWithSpace(buffer, '(');
                    SSBPermissionsDB2v70.appendStringWithSpace(buffer, col);
                    SSBPermissionsDB2v70.appendStringWithSpace(buffer, ')');
                    SSBPermissionsDB2v70.appendStringWithSpace(buffer, "ON");
                    if (permissions.getTable() != null) {
                        SSBPermissionsDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getTable().getName()));
                    } else if (permissions.getView() != null) {
                        SSBPermissionsDB2v70.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(permissions.getView().getName()));
                    }
                    SSBPermissionsDB2v70.appendNewLine(buffer, prettyPrint, 1);
                    SSBPermissionsDB2v70.appendStringWithSpace(buffer, "TO");
                    SSBPermissionsDB2v70.appendString(buffer, this.storageDesign.getFormatedName(permissions.getUser().getName()));
                    SSBPermissionsDB2v70.appendNewLine(buffer, prettyPrint, 0);
                    SSBPermissionsDB2v70.appendLineFinisher(buffer, prettyPrint);
                    SSBPermissionsDB2v70.appendNewLine(buffer, prettyPrint, 1);
                }
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof PermissionsDB2v70) {
            PermissionsDB2v70 perm = (PermissionsDB2v70)object;
            if (perm.getTable() != null) {
                return true;
            }
            if (perm.getView() != null) {
                return true;
            }
            if (perm.getAuxTable() != null) {
                return true;
            }
        }
        return false;
    }
}

