/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.db2.v80;

import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.exports.ddl.db2.v80.SSBAUXTableIndexDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBAUXTableDB2v80
extends SQLStatementBuilder {
    private AbstractStorageDesignDB2 storageDesign;
    private SSBAUXTableIndexDB2v80 ssbIndex = new SSBAUXTableIndexDB2v80();

    @Override
    public boolean canHandle(Object object) {
        return object instanceof AUXTableDB2 && ((AUXTableDB2)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        AUXTableDB2 auxTable = (AUXTableDB2)object;
        this.storageDesign = (AbstractStorageDesignDB2)this.getStorageDesign(object);
        this.appendComment(buffer, auxTable);
        this.appendSetCurrentRules(buffer, prettyPrint);
        this.appendCreate(buffer);
        SSBAUXTableDB2v80.appendStringWithSpace(buffer, "AUX TABLE");
        SSBAUXTableDB2v80.appendString(buffer, this.storageDesign.getFormatedName(auxTable.getLongNameDDL()));
        this.appendIN(buffer, auxTable, prettyPrint);
        this.appendStores(buffer, auxTable, prettyPrint);
        SSBAUXTableDB2v80.appendNewLine(buffer, prettyPrint, 0);
        SSBAUXTableDB2v80.appendLineFinisher(buffer, prettyPrint);
        DDLFileMaker.incrementCreateAuxTable();
        this.appendIndexes(buffer, auxTable, prettyPrint);
    }

    private void appendSetCurrentRules(StringBuffer buffer, boolean prettyPrint) {
        SSBAUXTableDB2v80.appendStringWithSpace(buffer, "SET CURRENT RULES");
        SSBAUXTableDB2v80.appendStringWithSpace(buffer, '=');
        SSBAUXTableDB2v80.appendString(buffer, '\'');
        SSBAUXTableDB2v80.appendString(buffer, "DB2");
        SSBAUXTableDB2v80.appendStringWithSpace(buffer, '\'');
        SSBAUXTableDB2v80.appendLineFinisher(buffer, prettyPrint);
    }

    private void appendIN(StringBuffer buffer, AUXTableDB2 auxTable, boolean prettyPrint) {
        DataBaseDB2 database = auxTable.getDatabase();
        TableSpaceDB2 tableSpace = auxTable.getTableSpace();
        if (tableSpace != null && this.storageDesign.getAppView().getSettings().isIncludeTablespaceInDDL()) {
            SSBAUXTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBAUXTableDB2v80.appendStringWithSpace(buffer, "IN");
            if (database != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
                SSBAUXTableDB2v80.appendString(buffer, this.storageDesign.getFormatedName(database.getLongNameDDL()));
                SSBAUXTableDB2v80.appendString(buffer, '.');
            }
            SSBAUXTableDB2v80.appendString(buffer, this.storageDesign.getFormatedName(tableSpace.getLongNameDDL()));
        } else if (tableSpace == null && database == null && this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBAUXTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBAUXTableDB2v80.appendStringWithSpace(buffer, "IN");
            SSBAUXTableDB2v80.appendStringWithSpace(buffer, "DATABASE");
            SSBAUXTableDB2v80.appendString(buffer, "DSNDB04");
        }
    }

    private void appendStores(StringBuffer buffer, AUXTableDB2 auxTable, boolean prettyPrint) {
        TableProxyDB2 table = auxTable.getTable();
        ColumnProxyDB2 column = auxTable.getColumn();
        if (table != null && column != null) {
            SSBAUXTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBAUXTableDB2v80.appendStringWithSpace(buffer, "STORES");
            SSBAUXTableDB2v80.appendString(buffer, this.storageDesign.getFormatedName(table.getLongNameDDL()));
            SSBAUXTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
            SSBAUXTableDB2v80.appendStringWithSpace(buffer, "COLUMN");
            SSBAUXTableDB2v80.appendString(buffer, this.storageDesign.getFormatedName(column.getName()));
            if (auxTable.getPartNumber() > 0) {
                SSBAUXTableDB2v80.appendNewLine(buffer, prettyPrint, 1);
                SSBAUXTableDB2v80.appendStringWithSpace(buffer, "PART");
                SSBAUXTableDB2v80.appendString(buffer, auxTable.getPartNumber());
            }
        }
    }

    private void appendIndexes(StringBuffer buffer, AUXTableDB2 auxTable, boolean prettyPrint) {
        for (Object object : auxTable.getAuxIndexes()) {
            if (!this.ssbIndex.canHandle(object)) continue;
            this.ssbIndex.doAppend(buffer, object, prettyPrint);
        }
    }
}

