/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.LoginSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.UserSqlServerv2k;

public class SSBLoginSqlServerv2k
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        LoginSqlServerv2k login = (LoginSqlServerv2k)object;
        this.storageDesign = login.getStorageDesign();
        this.appendComment(buffer, login);
        if (login.getAuthentication().equalsIgnoreCase("WINDOWS")) {
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            this.appendGrantLogin(buffer, login, prettyPrint);
            this.appendDefaultDB(buffer, login, prettyPrint);
            this.appendDefaultLanguage(buffer, login, prettyPrint);
        } else {
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            this.appendAddLogin(buffer, login, prettyPrint);
        }
        this.appendGrantUsersDBAccess(buffer, login, prettyPrint);
        UserSetSqlServer users = ((StorageDesignSqlServer)this.storageDesign).getUserSet();
        for (int i = 0; i < login.getUserSet().size(); ++i) {
            this.appendPrivileges(buffer, (UserSqlServerv2k)users.getByName((String)login.getUserSet().get(i)), prettyPrint);
        }
    }

    private void appendGrantLogin(StringBuffer buffer, LoginSqlServerv2k login, boolean prettyPrint) {
        SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
        SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "sp_grantlogin");
        SSBLoginSqlServerv2k.appendString(buffer, '\'');
        SSBLoginSqlServerv2k.appendString(buffer, login.getName());
        SSBLoginSqlServerv2k.appendString(buffer, '\'');
        SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "GO");
        SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
    }

    private void appendDefaultDB(StringBuffer buffer, LoginSqlServerv2k login, boolean prettyPrint) {
        if (login.getDefaultDatabase() != null) {
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "sp_defaultdb");
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            SSBLoginSqlServerv2k.appendString(buffer, login.getName());
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            this.appendComma(buffer);
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            this.appendString(buffer, login.getDefaultDatabase());
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "GO");
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "sp_defaultdb");
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            SSBLoginSqlServerv2k.appendString(buffer, login.getName());
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            this.appendComma(buffer);
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            SSBLoginSqlServerv2k.appendString(buffer, "master");
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "GO");
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendDefaultLanguage(StringBuffer buffer, LoginSqlServerv2k login, boolean prettyPrint) {
        if (login.getLanguage() != null) {
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "sp_defaultlanguage");
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            SSBLoginSqlServerv2k.appendString(buffer, login.getName());
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            this.appendComma(buffer);
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            SSBLoginSqlServerv2k.appendString(buffer, login.getLanguage());
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "GO");
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendAddLogin(StringBuffer buffer, LoginSqlServerv2k login, boolean prettyPrint) {
        if (login.getDefaultDatabase() != null) {
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "sp_addlogin");
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            SSBLoginSqlServerv2k.appendString(buffer, login.getName());
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            this.appendComma(buffer);
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            SSBLoginSqlServerv2k.appendString(buffer, login.decodePassword());
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            this.appendComma(buffer);
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            SSBLoginSqlServerv2k.appendString(buffer, login.getDefaultDatabase().getName());
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            if (login.getLanguage() != null) {
                this.appendComma(buffer);
                SSBLoginSqlServerv2k.appendString(buffer, '\'');
                SSBLoginSqlServerv2k.appendString(buffer, login.getLanguage());
                SSBLoginSqlServerv2k.appendString(buffer, '\'');
            }
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "GO");
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        } else {
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "-- Invalid login (without specified DB)");
            SSBLoginSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(login.getName()));
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendGrantUsersDBAccess(StringBuffer buffer, LoginSqlServerv2k login, boolean prettyPrint) {
        UserSetSqlServer users = ((StorageDesignSqlServer)login.getStorageDesign()).getUserSet();
        UserSqlServer u = null;
        for (String user : login.getUserSet()) {
            u = (UserSqlServer)users.getByName(user);
            if (u.getDatabase() != null && !u.getDatabase().isNullInstance()) {
                SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "USE");
                SSBLoginSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(u.getDatabase().getName()));
                SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "GO");
                SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            }
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "sp_grantdbaccess");
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            SSBLoginSqlServerv2k.appendString(buffer, login.getName());
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            this.appendComma(buffer);
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            SSBLoginSqlServerv2k.appendString(buffer, user);
            SSBLoginSqlServerv2k.appendString(buffer, '\'');
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "GO");
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private void appendPrivileges(StringBuffer buffer, UserSqlServerv2k user, boolean prettyPrint) {
        if (!"".equalsIgnoreCase(user.getSystemPrivileges())) {
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            if (user.getDatabase() != null && !user.getDatabase().isNullInstance()) {
                SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "USE");
                this.appendStringWithSpace(buffer, user.getDatabase());
                SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBLoginSqlServerv2k.appendString(buffer, "GO");
                SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            }
            SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "GRANT");
            if (user.getPrivilegesSet().contains("ALL")) {
                SSBLoginSqlServerv2k.appendString(buffer, "ALL");
            } else {
                SSBLoginSqlServerv2k.appendString(buffer, user.getSystemPrivileges());
            }
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 1);
            SSBLoginSqlServerv2k.appendStringWithSpace(buffer, "TO");
            this.appendString(buffer, user);
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBLoginSqlServerv2k.appendString(buffer, "GO");
            SSBLoginSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof LoginSqlServerv2k && ((LoginSqlServerv2k)object).getBeforeDefaults() && ((LoginSqlServerv2k)object).isMarkedGenerate();
    }
}

