/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBArcFK_UDB
extends AbstractSSBDB2 {
    private StorageDesign storageDesign;
    int arc_index = 0;

    public SSBArcFK_UDB(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof FKArc;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        FKArc arc = (FKArc)object;
        if (arc.getDesign().getAppView().getSettings().isGenerateFKArcTriggers() && !arc.isViewArc()) {
            StringBuffer buffer = new StringBuffer();
            String advancedComment = "";
            Table table = (Table)arc.getTable();
            List columns = this.getColumnsInArc(table, arc);
            if (table != null && arc.getFkeys().size() > 1 && columns.size() > 0) {
                this.arc_index = table.getArcs().indexOf(arc) + 1;
                this.appendComment(oldbuffer, arc);
                TableProxy tableProxy = (TableProxy)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
                advancedComment = "create Arc constraint INSERT trigger for table " + tableProxy.getLongNameDDL();
                if (DDLFileMaker.getddlAdvancedGenenerator() == null) {
                    SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
                }
                this.appendArcInsertTrigger(buffer, arc, tableProxy, columns, true);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                buffer = new StringBuffer();
                advancedComment = "create Arc constraint UPDATE trigger for table " + this.storageDesign.getFormatedName(tableProxy.getLongNameDDL());
                if (DDLFileMaker.getddlAdvancedGenenerator() == null) {
                    SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
                    SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
                }
                this.appendArcUpdateTrigger(buffer, arc, tableProxy, columns, true);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
            }
        }
    }

    private List getColumnsInArc(Table table, FKArc arc) {
        ArrayList<Column> list = new ArrayList<Column>();
        for (FKIndexAssociation fk : arc.getFkeys()) {
            for (Column column : fk.getLocalFKIndex().getElementsCollection()) {
                list.add(column);
            }
        }
        return list;
    }

    private void appendArcInsertTrigger(StringBuffer buffer, FKArc arc, TableProxy tableProxy, List columns, boolean prettyPrint) {
        String tr_name = this.makeTriggerName(tableProxy, "I");
        SSBArcFK_UDB.appendStringWithSpace(buffer, "CREATE TRIGGER " + this.storageDesign.getFormatedName(tr_name));
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBArcFK_UDB.appendStringWithSpace(buffer, "NO CASCADE BEFORE INSERT ON " + this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBArcFK_UDB.appendStringWithSpace(buffer, "REFERENCING NEW AS N");
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBArcFK_UDB.appendStringWithSpace(buffer, "FOR EACH ROW MODE DB2SQL");
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBArcFK_UDB.appendStringWithSpace(buffer, "BEGIN ATOMIC");
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBArcFK_UDB.appendStringWithSpace(buffer, " DECLARE i SMALLINT DEFAULT 0;");
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        for (Column column : columns) {
            SSBArcFK_UDB.appendStringWithSpace(buffer, " IF N." + column.getName() + " IS NOT NULL THEN");
            SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
            SSBArcFK_UDB.appendStringWithSpace(buffer, "  SET i = i+1;");
            SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
            SSBArcFK_UDB.appendStringWithSpace(buffer, " END IF;");
            SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        }
        SSBArcFK_UDB.appendStringWithSpace(buffer, " IF i>1 THEN");
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBArcFK_UDB.appendStringWithSpace(buffer, "  signal SQLSTATE '85001' ('Arc constraint on " + this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()) + "-one value is permitted in FKs');");
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBArcFK_UDB.appendStringWithSpace(buffer, " END IF;");
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        if (arc.isMandatory()) {
            SSBArcFK_UDB.appendStringWithSpace(buffer, " IF i=0 THEN");
            SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
            SSBArcFK_UDB.appendStringWithSpace(buffer, "  signal SQLSTATE '85002' ('Mandatory Arc constraint on " + this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()) + "-one value should be set in FKs');");
            SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
            SSBArcFK_UDB.appendStringWithSpace(buffer, " END IF;");
            SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        }
        SSBArcFK_UDB.appendStringWithSpace(buffer, "END");
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBArcFK_UDB.appendLineFinisher(buffer, prettyPrint);
    }

    private void appendArcUpdateTrigger(StringBuffer buffer, FKArc arc, TableProxy tableProxy, List columns, boolean prettyPrint) {
        String tr_name = this.makeTriggerName(tableProxy, "U");
        String cols = "";
        boolean first = true;
        for (Column column : columns) {
            String columnName = this.storageDesign.getFormatedName(column.getName());
            if (first) {
                cols = columnName;
                first = false;
                continue;
            }
            cols = cols + "," + columnName;
        }
        SSBArcFK_UDB.appendStringWithSpace(buffer, "CREATE TRIGGER " + this.storageDesign.getFormatedName(tr_name));
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBArcFK_UDB.appendStringWithSpace(buffer, "NO CASCADE BEFORE UPDATE OF " + cols);
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBArcFK_UDB.appendStringWithSpace(buffer, "ON " + this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()));
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBArcFK_UDB.appendStringWithSpace(buffer, "REFERENCING NEW AS N");
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBArcFK_UDB.appendStringWithSpace(buffer, "FOR EACH ROW MODE DB2SQL");
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBArcFK_UDB.appendStringWithSpace(buffer, "BEGIN ATOMIC");
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBArcFK_UDB.appendStringWithSpace(buffer, " DECLARE i SMALLINT DEFAULT 0;");
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        for (Column column : columns) {
            SSBArcFK_UDB.appendStringWithSpace(buffer, " IF N." + column.getName() + " IS NOT NULL THEN");
            SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
            SSBArcFK_UDB.appendStringWithSpace(buffer, "  SET i = i+1;");
            SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
            SSBArcFK_UDB.appendStringWithSpace(buffer, " END IF;");
            SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        }
        SSBArcFK_UDB.appendStringWithSpace(buffer, " IF i>1 THEN");
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBArcFK_UDB.appendStringWithSpace(buffer, "  signal SQLSTATE '85001' ('Arc constraint on " + this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()) + "-one value is permitted in FKs');");
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBArcFK_UDB.appendStringWithSpace(buffer, " END IF;");
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        if (arc.isMandatory()) {
            SSBArcFK_UDB.appendStringWithSpace(buffer, " IF i=0 THEN");
            SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
            SSBArcFK_UDB.appendStringWithSpace(buffer, "  signal SQLSTATE '85002' ('Mandatory Arc constraint on " + this.storageDesign.getFormatedName(tableProxy.getLongNameDDL()) + "-one value should be set in FKs');");
            SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
            SSBArcFK_UDB.appendStringWithSpace(buffer, " END IF;");
            SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        }
        SSBArcFK_UDB.appendStringWithSpace(buffer, "END");
        SSBArcFK_UDB.appendNewLine(buffer, prettyPrint, 0);
        SSBArcFK_UDB.appendLineFinisher(buffer, prettyPrint);
    }

    private String makeTriggerName(TableProxy tableProxy, String type) {
        String name = "";
        int size = 18;
        if (this.storageDesign instanceof StorageDesignUDB) {
            name = "A" + type + this.arc_index + "_";
        } else if (this.storageDesign instanceof StorageDesignDB2v70) {
            name = "A" + type + this.arc_index;
            size = 8;
        } else if (this.storageDesign instanceof StorageDesignDB2v80) {
            name = "ARCTR_" + type + this.arc_index + "_";
            size = 128;
        }
        name = this.storageDesign.getFormatedName(name + this.getStringWithMaxLength(tableProxy.getName(), size - name.length()));
        if (tableProxy.getUserSchema() != null && this.storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
            name = this.storageDesign.getFormatedName(tableProxy.getUserSchema().getName()) + "." + name;
        }
        return name;
    }
}

