/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.TableViewProxyUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBTableViewProxyUDBv71
extends AbstractSSBUDB {
    private StorageDesignUDBv71 storageDesign;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof TableView && ((TableView)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableViewProxyUDBv71 && ((TableViewProxyUDBv71)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        TableView view = null;
        TableViewProxyUDBv71 tableViewProxy = null;
        if (object instanceof TableView) {
            view = (TableView)object;
            if (this.getStorageDesign(object) instanceof StorageDesignUDBv71) {
                this.storageDesign = (StorageDesignUDBv71)this.getStorageDesign(object);
                tableViewProxy = (TableViewProxyUDBv71)this.storageDesign.getProxy(view);
            }
        } else if (object instanceof TableViewProxyUDBv71) {
            tableViewProxy = (TableViewProxyUDBv71)object;
            view = (TableView)tableViewProxy.getObject();
            this.storageDesign = (StorageDesignUDBv71)this.getStorageDesign(object);
        }
        if (!view.isValidSQL()) {
            SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, "--  ERROR: Invalid View " + view.getName());
            DDLFileMaker.incrementErrors();
            SSBTableViewProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            SSBTableViewProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
            return;
        }
        if (tableViewProxy != null) {
            if (tableViewProxy.isCommentChanged()) {
                this.appendComment(buffer, tableViewProxy);
            } else {
                this.appendComment(buffer, view);
            }
            String stmt = tableViewProxy.getDefinition();
            stmt = stmt.trim();
            if (stmt.endsWith(";")) {
                stmt = stmt.substring(0, stmt.length() - 1).trim();
            }
            if (!"".equalsIgnoreCase(stmt)) {
                int index;
                String createViewPart = "";
                boolean includesColumnList = false;
                if (Token.getFirstToken(stmt).equalsIgnoreCase("CREATE") && (index = StringUtilities.indexOf(stmt, "VIEW")) > -1) {
                    int viewNameIndex;
                    int dotIndex;
                    createViewPart = stmt.substring(0, index + 4);
                    String stmtWithoutNL = (stmt = stmt.substring(index + 4).trim()).replaceAll("[\t\n\f\r\u000b]+", " ");
                    String oldViewName = Token.getFirstName(stmtWithoutNL, '\"', '\"');
                    int bracketIndex = oldViewName.indexOf(40);
                    if (bracketIndex > -1) {
                        oldViewName = oldViewName.substring(0, bracketIndex);
                    }
                    if ((dotIndex = oldViewName.indexOf(46)) > -1) {
                        oldViewName = oldViewName.substring(dotIndex + 1);
                    }
                    if ((viewNameIndex = stmt.indexOf(oldViewName, dotIndex)) > -1 && (stmt = stmt.substring(viewNameIndex + oldViewName.length())).startsWith("\"")) {
                        stmt = stmt.substring(1);
                    }
                    if ((stmt = stmt.trim()).toUpperCase().startsWith("AS")) {
                        stmt = stmt.substring(2).trim();
                    } else if (stmt.startsWith("(")) {
                        includesColumnList = true;
                    }
                }
                if (!Token.startsWithString(createViewPart, "CREATE")) {
                    createViewPart = "CREATE VIEW";
                }
                String longName = this.storageDesign.isOpen() ? tableViewProxy.getLongNameDDL() : view.getLongNameDDL();
                createViewPart = createViewPart + ' ' + this.storageDesign.getFormatedName(longName);
                if (view.isBST()) {
                    createViewPart = createViewPart + SSBTableViewProxyUDBv71.appendStructuredType(tableViewProxy);
                }
                if (includesColumnList) {
                    stmt = createViewPart + ' ' + stmt;
                } else {
                    String columnList = this.getColumnList(view);
                    stmt = createViewPart + ' ' + columnList + ' ' + "AS" + NEWLINE + stmt;
                }
                this.appendBeforeCreateScript(buffer, prettyPrint, view);
                SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, stmt);
                this.appendCheckOption(buffer, tableViewProxy, prettyPrint);
                SSBTableViewProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                SSBTableViewProxyUDBv71.appendLineFinisher(buffer, prettyPrint);
                DDLFileMaker.incrementCreateView();
                SSBTableViewProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                this.appendAfterCreateScript(buffer, prettyPrint, view);
            } else if (view.isBST()) {
                SSBTableViewProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                this.appendBeforeCreateScript(buffer, prettyPrint, view);
                SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, "CREATE");
                SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, "VIEW");
                SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(view.getLongNameDDL()));
                SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, "OF");
                StructuredTypeProxyUDB stProxy = (StructuredTypeProxyUDB)this.storageDesign.getStructuredTypeProxySet().getProxy(view.getBasedOnStructuredType().getObjectID());
                if (stProxy != null) {
                    SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(stProxy.getName()));
                } else {
                    SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(view.getBasedOnStructuredType().getName()));
                }
                SSBTableViewProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, "MODE");
                SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, "DB2SQL");
                if (!view.isRoot() && view.isPartOfTypeSubstHierarchy()) {
                    SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, "UNDER");
                    TableViewProxyUDB superViewProxy = (TableViewProxyUDB)this.storageDesign.getTableViewProxySet().getProxy(view.getTypeSubstitution().getParentContainerObject().getObjectID());
                    if (superViewProxy != null) {
                        SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(superViewProxy.getLongNameDDL()));
                    } else {
                        SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(view.getTypeSubstitution().getParentContainerObject().getName()));
                    }
                    SSBTableViewProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, "INHERIT");
                    SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, "SELECT");
                    SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, "PRIVILEGES");
                } else if (!"".equalsIgnoreCase(tableViewProxy.getOidColumnName())) {
                    SSBTableViewProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableViewProxyUDBv71.appendString(buffer, '(');
                    SSBTableViewProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableViewProxyUDBv71.appendString(buffer, ' ');
                    SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, "REF");
                    SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, "IS");
                    SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, tableViewProxy.getOidColumnName());
                    SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, "USER");
                    SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, "GENERATED");
                    if (!tableViewProxy.isOidColumnUniqueness()) {
                        SSBTableViewProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                        SSBTableViewProxyUDBv71.appendString(buffer, ' ');
                        SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, "UNCHECKED");
                    }
                    SSBTableViewProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
                    SSBTableViewProxyUDBv71.appendString(buffer, ')');
                }
                SSBTableViewProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                SSBTableViewProxyUDBv71.appendLineFinisher(buffer, prettyPrint);
                DDLFileMaker.incrementCreateView();
                SSBTableViewProxyUDBv71.appendNewLine(buffer, prettyPrint, 0);
                this.appendAfterCreateScript(buffer, prettyPrint, view);
            } else {
                SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, "--  ERROR: Invalid View " + view.getName() + " with empty body");
                DDLFileMaker.incrementErrors();
            }
            if (view.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendViewCommentOn(this.storageDesign, buffer, view, tableViewProxy, prettyPrint);
            }
        } else if (view != null && view.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendViewCommentOn(this.storageDesign, buffer, view, tableViewProxy, prettyPrint);
        }
    }

    protected String appendOwner(String definition, TableViewProxyUDBv71 view) {
        String result = definition;
        String name = Token.getTokenAfter(result, "VIEW");
        if (name.indexOf(46) == -1) {
            if (view.getOwner() != null && !view.getOwner().getName().equalsIgnoreCase("[Implicit]")) {
                String owner = this.storageDesign.getFormatedName(view.getOwner().getName());
                result = this.appendOwner(result, name, owner);
            } else if (view.getSchema() != null) {
                String owner = this.storageDesign.getFormatedName(view.getSchema().getName());
                result = this.appendOwner(result, name, owner);
            }
        }
        return result;
    }

    protected void appendCheckOption(StringBuffer buffer, TableViewProxyUDBv71 tableViewProxy, boolean prettyPrint) {
        String checkOptionClause;
        if (!tableViewProxy.getDefinition().equalsIgnoreCase("") && tableViewProxy.getCheckOption() && buffer.indexOf(checkOptionClause = "WITH " + tableViewProxy.getCheckOptionScope() + ' ' + "CHECK OPTION") == -1) {
            SSBTableViewProxyUDBv71.appendNewLine(buffer, prettyPrint, 1);
            SSBTableViewProxyUDBv71.appendStringWithSpace(buffer, checkOptionClause);
        }
    }

    public static String appendStructuredType(TableViewProxyUDB view) {
        StringBuffer forInsert = new StringBuffer("");
        forInsert.append(' ');
        forInsert.append("OF");
        forInsert.append(' ');
        StructuredTypeProxy stp = (StructuredTypeProxy)view.getStorageDesign().getStructuredTypeProxySet().getProxy(((TableView)view.getObject()).getBasedOnStructuredType().getObjectID());
        forInsert.append(view.getStorageDesign().getFormatedName(stp.getLongNameDDL()));
        String superViewName = view.getStorageDesign().getFormatedName(view.getLongSuperViewName());
        if (!"".equalsIgnoreCase(superViewName)) {
            forInsert.append(NEWLINE);
            forInsert.append("MODE DB2SQL");
            forInsert.append(' ');
            forInsert.append("UNDER");
            forInsert.append(' ');
            forInsert.append(superViewName);
            forInsert.append(' ');
            forInsert.append("INHERIT");
            forInsert.append(' ');
            forInsert.append("SELECT");
            forInsert.append(' ');
            forInsert.append("PRIVILEGES");
        } else {
            forInsert.append(NEWLINE);
            forInsert.append("MODE DB2SQL");
            forInsert.append(' ');
            forInsert.append("(REF IS oid USER GENERATED) ");
        }
        return forInsert.toString();
    }
}

