/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import java.util.ArrayList;
import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.udb.IndexProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.IndexProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIndexProxyUDBv81
extends AbstractSSBUDB {
    private static final String PCTFREE = "PCTFREE";
    private static final String LEVEL2_PCTFREE = "LEVEL2 PCTFREE";
    private static final String MINPCTUSED = "MINPCTUSED";
    private static final String REVERSE_SCAN = "REVERSE SCANS";
    private static final String CLUSTER = "CLUSTER";
    private static final String UNIQUE = "UNIQUE";
    private static final String INCLUDE = "INCLUDE";
    private static final String COLLECT = "COLLECT";
    private static final String BASIC = "BASIC";
    private static final String STATISTICS = "STATISTICS";
    private static final String PARTITIONED = "PARTITIONED";
    private static final String PAGE_SPLIT = "PAGE SPLIT";
    private static final String GENERATE_KEYS_USING_XMLPATTERN = "GENERATE KEYS USING XMLPATTERN";
    private StorageDesignUDBv81 storageDesign;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && ((Index)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof IndexProxyUDBv81 && ((IndexProxyUDBv81)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        Index index = null;
        IndexProxyUDBv81 indexProxy = null;
        if (object instanceof Index) {
            index = (Index)object;
            this.storageDesign = (StorageDesignUDBv81)this.getStorageDesign(object);
            indexProxy = (IndexProxyUDBv81)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxyUDBv81) {
            indexProxy = (IndexProxyUDBv81)object;
            index = (Index)indexProxy.getObject();
            this.storageDesign = (StorageDesignUDBv81)this.getStorageDesign(object);
        }
        if (indexProxy != null) {
            if (indexProxy.isCommentChanged()) {
                this.appendComment(buffer, indexProxy);
            } else {
                this.appendComment(buffer, indexProxy.getObject());
            }
            this.appendCreate(buffer, indexProxy);
            this.appendOnTable(buffer, indexProxy, prettyPrint);
            if (this.storageDesign instanceof StorageDesignUDBv9) {
                this.appendNotPartitioned(buffer, indexProxy, prettyPrint);
                this.appendInTablespace(buffer, indexProxy, prettyPrint);
            }
            this.appendInclude(buffer, indexProxy, prettyPrint);
            this.appendCluster(buffer, indexProxy, prettyPrint);
            if (this.storageDesign instanceof StorageDesignUDBv9) {
                this.appendXmlSpecification(buffer, indexProxy, prettyPrint);
            }
            this.appendPctfree(buffer, indexProxy, prettyPrint);
            this.appendMinPctfree(buffer, indexProxy, prettyPrint);
            this.appendReverseScan(buffer, indexProxy, prettyPrint);
            this.appendPageSplit(buffer, indexProxy, prettyPrint);
            this.appendCollectStatistics(buffer, indexProxy, prettyPrint);
            SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexProxyUDBv81.appendLineFinisher(buffer, prettyPrint);
            DDLFileMaker.incrementCreateIndex();
            if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendIndexComment(buffer, index, indexProxy, prettyPrint);
            }
            this.appendPrivileges(buffer, indexProxy, prettyPrint);
        } else if (index != null && index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendIndexComment(buffer, index, indexProxy, prettyPrint);
        }
    }

    private void appendIndexComment(StringBuffer buffer, Index index, IndexProxyUDBv81 indexProxy, boolean prettyPrint) {
        if (indexProxy != null && indexProxy.isCommentInRDBMSChanged()) {
            SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "COMMENT ON");
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "INDEX");
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getLongNameDDL()));
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "IS");
            SSBIndexProxyUDBv81.appendString(buffer, '\'');
            SSBIndexProxyUDBv81.appendString(buffer, indexProxy.getCommentInRDBMS());
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, '\'');
            SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexProxyUDBv81.appendLineFinisher(buffer, prettyPrint);
        } else if (index != null && !"".equalsIgnoreCase(index.getCommentInRDBMS().trim())) {
            SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "COMMENT ON");
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "INDEX");
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getLongNameDDL()));
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "IS");
            SSBIndexProxyUDBv81.appendString(buffer, '\'');
            SSBIndexProxyUDBv81.appendString(buffer, index.getCommentInRDBMS());
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, '\'');
            SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexProxyUDBv81.appendLineFinisher(buffer, prettyPrint);
        }
    }

    protected void appendCreate(StringBuffer buffer, IndexProxyUDBv81 indexProxy) {
        this.appendCreate(buffer);
        if (indexProxy.isUnique()) {
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, UNIQUE);
        }
        SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "INDEX");
        SSBIndexProxyUDBv81.appendString(buffer, this.storageDesign.getFormatedName(indexProxy.getLongNameDDL()));
    }

    protected void appendOnTable(StringBuffer buffer, IndexProxyUDBv81 indexProxy, boolean prettyPrint) {
        ColumnProxy[] columns;
        SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "ON");
        SSBIndexProxyUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getTableProxy().getLongNameDDL()));
        SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexProxyUDBv81.appendStringWithSpace(buffer, '(');
        SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 0);
        if (indexProxy.getIndex().hasIndexExpression()) {
            SSBIndexProxyUDBv81.appendString(buffer, "     ");
            SSBIndexProxyUDBv81.appendString(buffer, indexProxy.getIndex().getIndexExpression());
        }
        if ((columns = indexProxy.getColumnProxies()) != null) {
            for (int i = 0; i < columns.length; ++i) {
                SSBIndexProxyUDBv81.appendString(buffer, "     ");
                SSBIndexProxyUDBv81.appendString(buffer, this.storageDesign.getFormatedName(columns[i].getName()));
                SSBIndexProxyUDBv81.appendString(buffer, " ");
                SSBIndexProxyUDBv81.appendString(buffer, indexProxy.getIndex().getColumnSortOrder(columns[i].getColumn()));
                SSBIndexProxyUDBv81.appendString(buffer, " ");
                if (i >= columns.length - 1) continue;
                SSBIndexProxyUDBv81.appendString(buffer, ",\n");
            }
        }
        SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexProxyUDBv81.appendStringWithSpace(buffer, ')');
    }

    protected void appendNotPartitioned(StringBuffer buffer, IndexProxyUDBv81 indexProxy, boolean prettyPrint) {
        if (!indexProxy.getPartitioned() && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "NOT");
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, PARTITIONED);
        }
    }

    protected void appendInTablespace(StringBuffer buffer, IndexProxyUDBv81 indexProxy, boolean prettyPrint) {
        if (indexProxy.getInTablespace() != null && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "IN");
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(indexProxy.getInTablespace().getLongNameDDL()));
        }
    }

    protected void appendInclude(StringBuffer buffer, IndexProxyUDBv81 indexProxy, boolean prettyPrint) {
        if (indexProxy.isUnique() && !indexProxy.getColumnList().equalsIgnoreCase("")) {
            SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, INCLUDE);
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, '(');
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, indexProxy.getColumnList());
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendCluster(StringBuffer buffer, IndexProxyUDBv81 indexProxy, boolean prettyPrint) {
        if (indexProxy.getCluster() && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, CLUSTER);
        }
    }

    protected void appendXmlSpecification(StringBuffer buffer, IndexProxyUDBv81 indexProxy, boolean prettyPrint) {
        if (!"".equals(indexProxy.getXmlPattern()) && !"".equals(indexProxy.getXmlType()) && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, GENERATE_KEYS_USING_XMLPATTERN);
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, '\'' + indexProxy.getXmlPattern() + '\'');
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "AS");
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "SQL");
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, indexProxy.getXmlType());
        }
    }

    protected void appendPctfree(StringBuffer buffer, IndexProxyUDBv81 indexProxy, boolean prettyPrint) {
        if (this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL() && this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
            if (indexProxy.getPercentageFree() >= 0) {
                SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexProxyUDBv81.appendStringWithSpace(buffer, PCTFREE);
                SSBIndexProxyUDBv81.appendStringWithSpace(buffer, indexProxy.getPercentageFree());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexProxyUDBv81.appendStringWithSpace(buffer, PCTFREE);
                SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "10");
            }
            if (indexProxy.getLevel2PercentageFree() >= 0) {
                SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexProxyUDBv81.appendStringWithSpace(buffer, LEVEL2_PCTFREE);
                SSBIndexProxyUDBv81.appendStringWithSpace(buffer, indexProxy.getLevel2PercentageFree());
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
                SSBIndexProxyUDBv81.appendStringWithSpace(buffer, LEVEL2_PCTFREE);
                SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "10");
            }
        }
    }

    protected void appendMinPctfree(StringBuffer buffer, IndexProxyUDBv81 indexProxy, boolean prettyPrint) {
        if (indexProxy.getMinimumPercentageUsed() > 0 && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL() && this.storageDesign.getAppView().getSettings().isIncludePctUsedInDDL()) {
            SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, MINPCTUSED);
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, indexProxy.getMinimumPercentageUsed());
        }
    }

    protected void appendReverseScan(StringBuffer buffer, IndexProxyUDBv81 indexProxy, boolean prettyPrint) {
        SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
        this.appendAllowDisallowWithSpace(buffer, indexProxy.getReverseScanSupport());
        SSBIndexProxyUDBv81.appendStringWithSpace(buffer, REVERSE_SCAN);
    }

    protected void appendPageSplit(StringBuffer buffer, IndexProxyUDBv81 indexProxy, boolean prettyPrint) {
        if (!"".equals(indexProxy.getPageSplit()) && this.storageDesign.getAppView().getSettings().isIncludeStorageInDDL()) {
            SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, PAGE_SPLIT);
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, indexProxy.getPageSplit());
        }
    }

    protected void appendCollectStatistics(StringBuffer buffer, IndexProxyUDBv81 indexProxy, boolean prettyPrint) {
        if (!"NONE".equalsIgnoreCase(indexProxy.getCollectStatistics())) {
            SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, COLLECT);
            if (!BASIC.equalsIgnoreCase(indexProxy.getCollectStatistics())) {
                SSBIndexProxyUDBv81.appendStringWithSpace(buffer, indexProxy.getCollectStatistics());
            }
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, STATISTICS);
        }
    }

    private void appendPrivileges(StringBuffer buffer, IndexProxyUDB index, boolean prettyPrint) {
        if (!index.getUsers().equalsIgnoreCase("") || !index.getGroups().equalsIgnoreCase("")) {
            SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "GRANT");
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "CONTROL");
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "ON");
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "INDEX");
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(index.getLongNameDDL()));
            SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "TO");
            if (!index.getUsers().equalsIgnoreCase("")) {
                int i;
                for (i = 0; i < index.getUserSet().size(); ++i) {
                    if (i > 0) {
                        this.appendComma(buffer);
                    }
                    if (!((String)index.getUserSet().elementAt(i)).trim().equalsIgnoreCase("PUBLIC")) {
                        SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "USER");
                    }
                    this.appendStringWithSpace(buffer, index.getUserSet().elementAt(i));
                }
                if (!index.getGroups().equalsIgnoreCase("")) {
                    for (i = 0; i < index.getUserGroupSet().size(); ++i) {
                        this.appendComma(buffer);
                        SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "GROUP");
                        this.appendStringWithSpace(buffer, index.getUserGroupSet().elementAt(i));
                    }
                }
            } else {
                for (int i = 0; i < index.getUserGroupSet().size(); ++i) {
                    if (i > 0) {
                        this.appendComma(buffer);
                    }
                    SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "GROUP");
                    this.appendStringWithSpace(buffer, index.getUserGroupSet().elementAt(i));
                }
            }
            SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 0);
            SSBIndexProxyUDBv81.appendLineFinisher(buffer, prettyPrint);
            SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    public void appendIndexForConstraint(StringBuffer oldbuffer, Index object, TableProxy tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        Index index = null;
        IndexProxy indexProxy = null;
        index = object;
        StorageDesignUDB storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        if (index.isFK()) {
            indexProxy = (IndexProxy)storageDesign.getFKProxySet().getProxy(index.getObjectID());
        }
        if (index != null && !index.isOidKey()) {
            this.storageDesign = (StorageDesignUDBv81)tableProxy.getStorageDesign();
            if (indexProxy != null && indexProxy.isMarkedGenerate() || indexProxy == null && index.isMarkedGenerate()) {
                if (index.getElements().length > 0) {
                    if (indexProxy != null && indexProxy.isCommentChanged()) {
                        this.appendComment(oldbuffer, indexProxy);
                    } else {
                        this.appendComment(oldbuffer, index);
                    }
                    TableProxy tp = tableProxy;
                    String indName = index.getName();
                    if (indexProxy != null) {
                        indName = indexProxy.getName();
                    }
                    String lname = indName = ApplyNamingStandards.createIndexNameAuto(tp.getName(), indName, index, index.getDesign().getDesignLevelSettings().getNamingStandardRule(), index.getDesignPart().getName(), index.getTable().getAbbreviation());
                    int l = 18;
                    if (indexProxy != null) {
                        l = indexProxy.getMaxNameLength();
                    }
                    if (indName.length() > l) {
                        SSBIndexProxyUDBv81.appendNewLine(oldbuffer, prettyPrint, 0);
                        SSBIndexProxyUDBv81.appendStringWithSpace(oldbuffer, "--  ERROR: Index name length exceeds maximum allowed length(" + l + ")");
                        SSBIndexProxyUDBv81.appendNewLine(oldbuffer, prettyPrint, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "CREATE");
                    if ("Primary Constraint".equals(index.getIndexState()) || "Unique Constraint".equals(index.getIndexState())) {
                        SSBIndexProxyUDBv81.appendStringWithSpace(buffer, UNIQUE);
                    }
                    SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "INDEX");
                    SSBIndexProxyUDBv81.appendStringWithSpace(buffer, storageDesign.getFormatedName(lname));
                    advancedComment = buffer.toString();
                    this.appendTable(buffer, index, true);
                    this.appendConstraintElementList(buffer, index, tableProxy, true);
                    SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 0);
                    SSBIndexProxyUDBv81.appendLineFinisher(buffer, prettyPrint);
                    this.appendToBuffer(oldbuffer, buffer, advancedComment);
                    DDLFileMaker.incrementCreateIndex();
                } else {
                    SSBIndexProxyUDBv81.appendNewLine(oldbuffer, prettyPrint, 0);
                    oldbuffer.append("-- Error - Index ");
                    oldbuffer.append(storageDesign.getFormatedName(index.getName()));
                    oldbuffer.append(" has no columns");
                    SSBIndexProxyUDBv81.appendNewLine(oldbuffer, prettyPrint, 0);
                    DDLFileMaker.incrementErrors();
                }
            }
        }
    }

    private void appendConstraintElementList(StringBuffer buffer, Index index, TableProxy tableProxy, boolean prettyPrint) {
        ColumnProxy column = null;
        ArrayList<ColumnProxy> list = new ArrayList<ColumnProxy>();
        for (Column col : index.getElementsCollectionImmutable()) {
            ColumnProxy cp = tableProxy.getColumnProxy(col.getObjectID());
            if (cp == null) continue;
            list.add(cp);
        }
        Object[] columns = list.toArray();
        SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
        if (columns.length < 1) {
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "-- No Columns");
            SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
        }
        SSBIndexProxyUDBv81.appendStringWithSpace(buffer, '(');
        for (int i = 0; i < columns.length; ++i) {
            if (i != 0) {
                SSBIndexProxyUDBv81.appendStringWithSpace(buffer, ',');
            }
            column = (ColumnProxy)columns[i];
            SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
            SSBIndexProxyUDBv81.appendString(buffer, ' ');
            String columnName = this.storageDesign.getFormatedName(column.getName());
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, columnName);
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, index.getColumnSortOrder(column));
        }
        SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
        SSBIndexProxyUDBv81.appendStringWithSpace(buffer, ')');
    }

    protected void appendTable(StringBuffer buffer, Index index, boolean prettyPrint) {
        Table table = (Table)index.getTopLevelContainer();
        TableProxy tp = (TableProxy)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        SSBIndexProxyUDBv81.appendNewLine(buffer, prettyPrint, 1);
        if (tp != null) {
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, "ON");
            SSBIndexProxyUDBv81.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tp.getLongNameDDL()));
        }
    }
}

