/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.util.Map;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.reports.RSColumns;
import oracle.dbtools.crest.exports.reports.RSExistenceDependencies;
import oracle.dbtools.crest.exports.reports.RSFKeys;
import oracle.dbtools.crest.exports.reports.RSIndexes;
import oracle.dbtools.crest.exports.reports.RSModel;
import oracle.dbtools.crest.exports.reports.RSSchemaObject;
import oracle.dbtools.crest.exports.reports.RSTableArcs;
import oracle.dbtools.crest.exports.reports.RSTableViews;
import oracle.dbtools.crest.exports.reports.RSTables;
import oracle.dbtools.crest.exports.reports.RSViewColumns;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.GUID;

public class RSRelationalModel
extends RSModel {
    public static void export(Design design, Map map, Connection connection, ProgressDialog monitor) throws Exception {
        for (RelationalDesign model : design.getRelationalDesigns()) {
            String modelOVID = new GUID().toString();
            map.put(model.getObjectID(), modelOVID);
            RSRelationalModel.export(model, map, connection, "Relational", null);
        }
        monitor.setNote(Messages.getString("RSRelationalModel.ExportingSchemas"));
        RSSchemaObject.export(design, map, connection);
        monitor.setNote(Messages.getString("RSRelationalModel.ExportingTables"));
        RSTables.export(design, map, connection);
        monitor.setNote(Messages.getString("RSRelationalModel.ExportingViews"));
        RSTableViews.export(design, map, connection);
        monitor.setNote(Messages.getString("RSRelationalModel.ExportingColumns"));
        RSColumns.export(design, map, connection);
        monitor.setNote(Messages.getString("RSRelationalModel.ExportingIndexes"));
        RSIndexes.export(design, map, connection);
        monitor.setNote(Messages.getString("RSRelationalModel.ExportingKeys"));
        RSFKeys.export(design, map, connection);
        monitor.setNote(Messages.getString("RSRelationalModel.ExistenceDependencies"));
        RSExistenceDependencies.export(design, map, connection);
        monitor.setNote(Messages.getString("RSRelationalModel.ExportingTableArcs"));
        RSTableArcs.export(design, map, connection);
        monitor.setNote(Messages.getString("RSRelationalModel.ExportingViewColumns"));
        RSViewColumns.export(design, map, connection);
    }
}

