/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.TSDPPolicy;
import oracle.dbtools.crest.model.TSDPSubPolicy;
import oracle.dbtools.crest.swingui.ApplicationView;

public class RSTSDPSubPolicies
extends RSGeneral {
    public static void export(ApplicationView appView, Map map, Connection connection) throws Exception {
        String checkQuery = "SELECT COUNT(*) FROM DMRS_TSDP_SUB_POLICIES WHERE Object_ID = ? ";
        String insertQuery = "INSERT INTO DMRS_TSDP_SUB_POLICIES (Object_OVID, Object_ID, Container_ID, Container_OVID, Container_Name, TSDP_SubPolicy_Name, Expression, Mask_Type, Mask_Template, Datatype, Length, Parent_Schema, Parent_Table) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String updateQuery = "UPDATE DMRS_TSDP_SUB_POLICIES SET TSDP_SubPolicy_Name = ?, Expression = ?, Mask_Type = ?, Mask_Template = ?, Datatype = ?, Length = ?, Parent_Schema = ?, Parent_Table = ? WHERE Object_ID = ?";
        PreparedStatement stmtCheck = connection.prepareStatement(checkQuery);
        PreparedStatement insertStmt = connection.prepareStatement(insertQuery);
        PreparedStatement updateStmt = connection.prepareStatement(updateQuery);
        for (TSDPSubPolicy p : appView.getTSDPSubPolicySet()) {
            TSDPPolicy pol = p.getTsdpPolicy();
            stmtCheck.setString(1, p.getObjectID());
            ResultSet rsCheck = stmtCheck.executeQuery();
            while (rsCheck.next()) {
                String count = rsCheck.getString(1);
                if (count.equals("0")) {
                    String ovid = RSTSDPSubPolicies.getOrCreateOVID(map, p.getObjectID());
                    insertStmt.setString(1, ovid);
                    insertStmt.setString(2, p.getObjectID());
                    insertStmt.setString(3, pol.getObjectID());
                    insertStmt.setString(4, (String)map.get(pol.getObjectID()));
                    insertStmt.setString(5, pol.getName());
                    insertStmt.setString(6, p.getName());
                    insertStmt.setString(7, p.getExpression());
                    insertStmt.setString(8, p.getMaskType());
                    insertStmt.setString(9, p.getMaskTemplate() != null ? p.getMaskTemplate().getObjectID() : "");
                    insertStmt.setString(10, p.getPropertyDatatype());
                    insertStmt.setString(11, Integer.toString(p.getPropertyLenght()));
                    insertStmt.setString(12, p.getPropertyParentSchema());
                    insertStmt.setString(13, p.getPropertyParentSchema());
                    insertStmt.executeUpdate();
                    continue;
                }
                updateStmt.setString(1, p.getName());
                updateStmt.setString(2, p.getExpression());
                updateStmt.setString(3, p.getMaskType());
                updateStmt.setString(4, p.getMaskTemplate() != null ? p.getMaskTemplate().getObjectID() : "");
                updateStmt.setString(5, p.getPropertyDatatype());
                updateStmt.setString(6, Integer.toString(p.getPropertyLenght()));
                updateStmt.setString(7, p.getPropertyParentSchema());
                updateStmt.setString(8, p.getPropertyParentSchema());
                updateStmt.setString(9, p.getObjectID());
                updateStmt.executeUpdate();
            }
            RSObjectNotes.export(map, connection, p);
            RSComments.export(map, connection, p);
        }
        stmtCheck.close();
        stmtCheck = null;
        insertStmt.close();
        insertStmt = null;
        updateStmt.close();
        updateStmt = null;
    }
}

