/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp;

import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventObject;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.fcp.DMDiagramNode;
import oracle.dbtools.crest.fcp.DataModelerController;
import oracle.dbtools.crest.fcp.OpenEditorRunner;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DPVMainPanel;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.view.View;

public class DMDiagramEditor
extends Editor {
    private Component comp = null;
    private Context context;
    private HelpInfo helpInfo;
    private DataModelerController controller = null;

    public void open() {
    }

    public Component getGUI() {
        return this.comp;
    }

    public synchronized Context getContext(EventObject event) {
        if (this.context != null) {
            this.context.setSelection(this.getSelection());
            this.context.setEvent(event);
            this.context.setView((View)this);
            Design design = null;
            if (this.comp instanceof DPVMainPanel) {
                design = ((DPVMainPanel)this.comp).getDesignPartView().getDesign();
            } else if (this.comp instanceof DesignPartView.NamedTabbedPane) {
                try {
                    design = ((DesignPartView.NamedTabbedPane)this.comp).getDesignPartView().getDesign();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (design != null && design.hasWorkspaceSet() && !ApplicationView.closing) {
                Workspace w = design.getWorkspace();
                this.context.setWorkspace(w);
                this.context.setNode((Node)new DMDiagramNode(w.getURL(), this.comp));
            }
            if (ApplicationView.closing) {
                this.context.setWorkspace(null);
                this.context.setProject(null);
            }
        }
        return this.context;
    }

    public synchronized void setContext(Context context) {
        Element element;
        if (context != null && context != this.context && (element = context.getElement()) instanceof DMDiagramNode) {
            this.comp = ((DMDiagramNode)element).getComponent();
            this.context = context;
        }
    }

    public Component getComponent() {
        return this.comp;
    }

    public void setcomponent(Component comp) {
        this.comp = comp;
    }

    public void update(Object observed, UpdateMessage change) {
    }

    public static Editor openNewDiagram(Component comp) {
        DesignPartView.NamedTabbedPane tabbedPane;
        DesignPartView dpv = null;
        if (comp instanceof DesignPartView.NamedTabbedPane && (tabbedPane = (DesignPartView.NamedTabbedPane)comp).getTabCount() == 0 && tabbedPane.getDesignPartView() != null) {
            dpv = tabbedPane.getDesignPartView();
            tabbedPane.add(tabbedPane.getDesignPartView().getMainPanel());
            tabbedPane.setSelectedComponent(tabbedPane.getDesignPartView().getMainPanel());
            tabbedPane.addChangeListener(tabbedPane.getDesignPartView().getApplicationView());
        }
        try {
            URL url = new URL("file:///dmnode/" + System.currentTimeMillis());
            DMDiagramNode dn = new DMDiagramNode(url, comp);
            Context ctx = Context.newIdeContext((Node)dn);
            if (dpv != null && dpv.getDesign().hasWorkspaceSet()) {
                Workspace w = dpv.getDesign().getWorkspace();
                ctx.setWorkspace(w);
                ctx.setNode((Node)dn);
            }
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(ctx, EmptyEditor.class);
            if (SwingUtilities.isEventDispatchThread()) {
                return EditorManager.getEditorManager().openEditor(openEditorOptions);
            }
            OpenEditorRunner runner = new OpenEditorRunner(openEditorOptions);
            SwingUtilities.invokeLater(runner);
            while (!runner.isFinished()) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
            }
            return runner.getEditor();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Object getEditorAttribute(String attribute) {
        if ("scrollable".equals(attribute)) {
            return Boolean.FALSE;
        }
        if (attribute == "horizontal_scrollbar_policy") {
            return null;
        }
        if (attribute == "vertical_scrollbar_policy") {
            return null;
        }
        return super.getEditorAttribute(attribute);
    }

    protected String getHelpID() {
        DesignPartView dpv = this.getDesignPartView();
        if (dpv != null) {
            if (dpv.getDesignPart() instanceof LogicalDesign) {
                return "LOGICAL_MODEL_PROPERTIES_DIALOG";
            }
            if (dpv.getDesignPart() instanceof RelationalDesign) {
                return "RELATIONAL_MODEL_PROPERTIES_DIALOG";
            }
            if (dpv.getDesignPart() instanceof DataTypesDesign) {
                return "DATATYPES_MODEL_PROPERTIES_DIALOG";
            }
            if (dpv.getDesignPart() instanceof MultidimensionalDesign) {
                return "MULTIDIMENSIONAL_MODEL_PROPERTIES_DIALOG";
            }
            if (dpv.getDesignPart() instanceof DataFlowDesign) {
                return "DATA_FLOW_PROPERTIES_DIALOG";
            }
            if (dpv.getDesignPart() instanceof TransformationTask) {
                return "TRANSFORMATION_TASK_PROPERTIES_DIALOG";
            }
        }
        return "data_modeling.htm";
    }

    public HelpInfo getHelpInfo() {
        if (this.helpInfo == null) {
            this.helpInfo = new HelpInfo(this.getHelpID());
        }
        return this.helpInfo;
    }

    public synchronized Controller getController() {
        if (this.controller == null) {
            this.controller = new DataModelerController();
        }
        return this.controller;
    }

    public DesignPartView getDesignPartView() {
        DesignPartView dpv = null;
        if (this.comp instanceof DPVMainPanel) {
            dpv = ((DPVMainPanel)this.comp).getDesignPartView();
        } else if (this.comp instanceof DesignPartView.NamedTabbedPane) {
            DesignPartView.NamedTabbedPane ntp = (DesignPartView.NamedTabbedPane)this.comp;
            dpv = ntp.getSelectedComponent() instanceof DPVMainPanel ? ((DPVMainPanel)ntp.getSelectedComponent()).getDesignPartView() : ntp.getDesignPartView();
        }
        return dpv;
    }

    public boolean isDiagramForDesign(Design design) {
        DesignPartView dpv = this.getDesignPartView();
        return dpv != null && dpv.getDesign() == design;
    }

    public void clearDiagramForDesign(Design design) {
        Node node;
        Context ctx;
        DesignPartView dpv;
        if (this.comp instanceof DesignPartView.NamedTabbedPane) {
            ((DesignPartView.NamedTabbedPane)this.comp).removeChangeListener(design.getAppView());
        }
        if ((dpv = this.getDesignPartView()) != null && dpv.getDesign() == design && (ctx = dpv.getContext()) != null && (node = ctx.getNode()) != null && node instanceof DMDiagramNode) {
            ((DMDiagramNode)node).clearInstances();
        }
        this.comp = null;
        this.context = null;
        this.controller = null;
    }

    private class EmptyEditor {
        private EmptyEditor() {
        }
    }
}

