/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.fcp.ERDEditorListener;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.SubordinateTables;
import oracle.dbtools.crest.fcp.extension.ExtractionHandlerDB2;
import oracle.dbtools.crest.fcp.extension.ExtractionHandlerODBC;
import oracle.dbtools.crest.fcp.extension.ExtractionHandlerOracle;
import oracle.dbtools.crest.fcp.extension.ExtractionHandlerSQLServer;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.ShowParentAndChildListener;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.browser.ShowDiagramRunner;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.onsd.navigator.OnsdTable;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.db.ConnectionsEvent;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.DisconnectListener;

public class ERDEditor
extends AsynchronousViewerEditor
implements Controller,
DisconnectListener,
ShowParentAndChildListener,
ERDEditorListener {
    private static final String DB_TYPE_ORACLE = "ORACLE";
    public static final String DB_TYPE_MS_SQL_SERVER = "MICROSOFT";
    private static final String DB_TYPE_DB2 = "DB2";
    private static final String DB_TYPE_JDBC = "JDBC";
    public static final int OPEN_IN_DM_CMD_ID = Ide.findOrCreateCmdID((String)"OPEN_IN_DM_CMD_ID");
    public static final int REFRESH_DIAGRAM_CMD_ID = Ide.findOrCreateCmdID((String)"REFRESH_DIAGRAM_CMD_ID");
    private JPanel gui = null;
    private DesignPartView dpv;
    private DBObject dbObject;
    private DBObject _lastdbObject = null;
    private ApplicationView appView;
    private RelationalDesign rd;
    private String dbType = null;
    private boolean zos = false;
    private MergingModels mergingModels;
    private IdeAction openInDMAction;
    private IdeAction refreshDiagramAction;
    private static final String BUTTON = "BUTTON";
    private String connectionName;
    private String catalog;
    private List tablesShown;
    private boolean repaintGUI;
    private static final Logger LOGGER = new Logger(ERDEditor.class);

    protected JComponent createViewerUI() {
        if (this.gui == null) {
            this.gui = new JPanel(new BorderLayout());
            ViewerNode viewerNode = this.getViewerNode();
            if (viewerNode != null) {
                this.dbObject = viewerNode.getDBObject();
                if (this.dbObject.getNode() instanceof OnsdTable) {
                    this.dbType = null;
                } else {
                    this.appView = ApplicationView.getInstance();
                    DatabaseConnections.getInstance().addDisconnectListener((DisconnectListener)this);
                    try {
                        this.connectionName = this.decodeConnectionName(this.dbObject.getConnectionName());
                        this.dbType = this.dbObject.getConnection().getMetaData().getDatabaseProductName();
                        String version = this.dbObject.getConnection().getMetaData().getDatabaseProductVersion();
                        if (this.dbType.toUpperCase().contains(DB_TYPE_DB2)) {
                            if (version != null && (version.toUpperCase().contains("Z") || version.toUpperCase().contains("390"))) {
                                this.zos = true;
                            }
                            if (this.dbType.toUpperCase().contains("Z") || this.dbType.toUpperCase().contains("390")) {
                                this.zos = true;
                            }
                        }
                    }
                    catch (Exception e) {
                        this.dbType = null;
                    }
                    this.rd = (RelationalDesign)this.appView.getHiddenDesign().getRelationalDesigns().getByName(this.connectionName);
                    if (this.rd == null) {
                        this.rd = this.appView.getHiddenDesign().addRelationalDesign(this.connectionName);
                    }
                    this.rd.addERDEditorListener(this);
                    this.tablesShown = new ArrayList();
                    this.repaintGUI = false;
                    this.openInDMAction = IdeAction.findOrCreate((int)OPEN_IN_DM_CMD_ID, null, null);
                    JButton bnOpenInDM = new JButton((Action)this.openInDMAction);
                    bnOpenInDM.setToolTipText(Messages.getString("ERDEditor.CopyToDataModeler"));
                    bnOpenInDM.setIcon(GUIConfiguration.getInstance().getIcon("APPLICATION_ICON"));
                    this.openInDMAction.putValue(BUTTON, (Object)bnOpenInDM);
                    this.openInDMAction.addController((Controller)this);
                    this.refreshDiagramAction = IdeAction.findOrCreate((int)REFRESH_DIAGRAM_CMD_ID, null, null);
                    JButton bnRefresh = new JButton((Action)this.refreshDiagramAction);
                    bnRefresh.setToolTipText(Messages.getString("ERDEditor.RefreshDiagram"));
                    bnRefresh.setIcon(OracleIcons.getIcon((String)"refresh.png"));
                    this.refreshDiagramAction.putValue(BUTTON, (Object)bnRefresh);
                    this.refreshDiagramAction.addController((Controller)this);
                    Toolbar toolbar = this.getToolbar();
                    toolbar.addSeparator();
                    toolbar.add((Component)bnRefresh);
                    toolbar.addSeparator();
                    toolbar.add((Component)bnOpenInDM);
                    toolbar.addSeparator();
                }
                if (this.dbType == null) {
                    JPanel pnMessage = new JPanel(new FlowLayout(1));
                    pnMessage.add(new JLabel("Database is not supported."));
                    this.gui.add(pnMessage);
                }
            }
        }
        return this.gui;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (context.getView() == this.getContext().getView()) {
            int cmdId = action.getCommandId();
            if (cmdId == OPEN_IN_DM_CMD_ID) {
                this.copyToDataModeler();
                return true;
            }
            if (cmdId == REFRESH_DIAGRAM_CMD_ID) {
                UIUtils.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ERDEditor.this.rd.clearAll();
                        ERDEditor.this.repaintGUI = true;
                        ERDEditor.this.rd.updateERDEditors();
                    }
                });
                return true;
            }
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        return false;
    }

    private String getLongName(String schemaName, String tableName) {
        if (this.dbType != null && this.dbType.toUpperCase().contains(DB_TYPE_MS_SQL_SERVER) && this.catalog != null && !"".equalsIgnoreCase(this.catalog)) {
            return this.catalog.concat("_").concat(schemaName).concat(".").concat(tableName);
        }
        return schemaName.concat(".").concat(tableName);
    }

    protected void updateContent(boolean force) {
        UIUtils.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ERDEditor.this.update(false);
            }
        });
    }

    private String getPrivateCatalogField() {
        String catalog = null;
        try {
            Field field = this.dbObject.getClass().getDeclaredField("m_catalog");
            field.setAccessible(true);
            catalog = (String)field.get(this.dbObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return catalog != null ? catalog : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(boolean force) {
        block18: {
            if (this.dbType == null) {
                return;
            }
            try {
                ViewerNode viewerNode = this.getViewerNode();
                if (viewerNode == null) break block18;
                this.dbObject = viewerNode.getDBObject();
                if (!force && this._lastdbObject != null && this.dbObject.checkQualifiedNameEquals(this._lastdbObject) && this.dbObject.getSchemaObject() == this._lastdbObject.getSchemaObject()) break block18;
                String schemaName = this.dbObject.getSchemaName();
                String tableName = this.dbObject.getObjectName();
                this.catalog = this.getPrivateCatalogField();
                this._lastdbObject = this.dbObject;
                if (this.dbType == null) break block18;
                Design oldCurrentDesign = this.appView.getCurrentDesign();
                this.appView.initHiddenDesignLogicalTypes();
                this.appView.setCurrentDesign(this.appView.getHiddenDesign());
                ImportLogger importLog = new ImportLogger();
                ProgressDialog monitor = new ProgressDialog(this.appView, "", 0, 100);
                monitor.setProgress(1);
                try {
                    List objNames;
                    if (this.dpv != null) {
                        this.gui.remove(this.dpv.getMainPanel());
                        this.rd.deleteSubview(this.dpv);
                    }
                    this.rd.getDesign().setRelationalDesign(this.rd);
                    if (force) {
                        objNames = this.updateTables(this.tablesShown, this.catalog, importLog, monitor);
                        this.tablesShown.clear();
                    } else {
                        this.tablesShown.clear();
                        objNames = this.getTableNames(schemaName, tableName, this.catalog, importLog, monitor);
                    }
                    ArrayList<Table> tables = new ArrayList<Table>();
                    Table mainTable = null;
                    for (String name : objNames) {
                        Table table = (Table)this.rd.getTableSet().getByLongName(name);
                        if (table == null) continue;
                        tables.add(table);
                        if (name.equalsIgnoreCase(this.getLongName(schemaName, tableName))) {
                            mainTable = table;
                        }
                        this.addTableShown(name);
                    }
                    this.dpv = this.rd.createSubview(tables, this);
                    this.gui.add(this.dpv.getMainPanel());
                    TopView tv = this.dpv.getViewFor(mainTable);
                    if (tv != null) {
                        tv.setAsMainObject(true);
                    }
                    try {
                        this.rd.resolveFKs();
                        this.rd.createArcsFromTableCheckConstraints();
                    }
                    catch (Exception e) {
                        LOGGER.error("Error in creating Arcs from table Check constraints", e);
                    }
                    if (!force) {
                        Object[] list = this.dpv.getTopviewsList().toArray();
                        for (int i = 0; i < list.length; ++i) {
                            TopView topView = (TopView)list[i];
                            if (!(topView instanceof TVTable)) continue;
                            Object[] arcs = ((Table)topView.getModel()).getArcs().toArray();
                            for (int j = 0; j < arcs.length; ++j) {
                                FKArc arc = (FKArc)arcs[j];
                                arc.addToAllDPVs();
                            }
                        }
                    }
                    this.dpv.straightenLines(false);
                    if (this.repaintGUI) {
                        this.repaintGUI = false;
                        this.gui.revalidate();
                        this.gui.repaint();
                    }
                }
                finally {
                    monitor.close();
                    this.appView.setCurrentDesign(oldCurrentDesign);
                }
            }
            catch (Throwable e) {
                LOGGER.error("ERDEditor.update()", e);
            }
        }
    }

    private List getTableNames(String schemaName, String tableName, String catalog, ImportLogger importLog, ProgressDialog monitor) {
        ArrayList<String> objNames = new ArrayList<String>();
        try {
            AbstractDBMExtractionHandler dbmExtractionHandler;
            List selectedObjects;
            oracle.dbtools.crest.imports.metadata.DBObject dbObj;
            this.rd.getDesign().setRelationalDesign(this.rd);
            this.rd.getDesign().setPropagatePKChahges(false);
            if (this.dbType.toUpperCase().contains(DB_TYPE_MS_SQL_SERVER)) {
                dbObj = new DBObjectSqlServer(true, tableName, "TABLE", schemaName);
                ((DBObjectSqlServer)dbObj).setDb(catalog);
                dbObj.setCatalog(catalog);
            } else {
                dbObj = new oracle.dbtools.crest.imports.metadata.DBObject(true, tableName, "TABLE", schemaName);
            }
            ArrayList<oracle.dbtools.crest.imports.metadata.DBObject> objects = new ArrayList<oracle.dbtools.crest.imports.metadata.DBObject>();
            objects.add(dbObj);
            SubordinateTables sr = new SubordinateTables(this.dbObject.getConnection(), objects);
            if (this.dbType.toUpperCase().contains(DB_TYPE_ORACLE)) {
                selectedObjects = sr.getAllObjectsFromOracleDB();
                dbmExtractionHandler = new ExtractionHandlerOracle(this.appView);
            } else if (this.dbType.toUpperCase().contains(DB_TYPE_MS_SQL_SERVER)) {
                selectedObjects = sr.getAllObjectsFromJDBC(DB_TYPE_MS_SQL_SERVER);
                dbmExtractionHandler = new ExtractionHandlerSQLServer(this.appView);
            } else if (this.dbType.toUpperCase().contains(DB_TYPE_DB2) && !this.zos) {
                selectedObjects = sr.getAllObjectsFromJDBC(DB_TYPE_DB2);
                dbmExtractionHandler = new ExtractionHandlerDB2(this.appView);
            } else {
                selectedObjects = sr.getAllObjectsFromJDBC(DB_TYPE_JDBC);
                dbmExtractionHandler = new ExtractionHandlerODBC(this.appView);
            }
            for (oracle.dbtools.crest.imports.metadata.DBObject obj : selectedObjects) {
                objNames.add(this.getLongName(obj.getSchema(), obj.getName()));
            }
            dbmExtractionHandler.init(this.dbObject.getConnection());
            this.appView.getHiddenDesign().setSelectedRDBMSSite(dbmExtractionHandler.getRDBMSSite());
            this.clearImportedTables(dbmExtractionHandler.getRDBMSSite(), selectedObjects);
            ArrayList selectedCopy = new ArrayList();
            selectedCopy.addAll(selectedObjects);
            dbmExtractionHandler.generateDesign(this.dbObject.getConnection(), selectedObjects, importLog, monitor);
            sr.generateFKs_fromChilds(this.dbObject.getConnection(), selectedCopy, this.appView.getCurrentDesign(), dbmExtractionHandler.getRDBMSSite());
        }
        catch (Throwable e) {
            LOGGER.error("ERDEditor.importTable()", e);
        }
        return objNames;
    }

    private List updateTables(List tablesShown, String catalog, ImportLogger importLog, ProgressDialog monitor) {
        ArrayList<String> objNames = new ArrayList<String>();
        try {
            this.rd.getDesign().setRelationalDesign(this.rd);
            ArrayList<oracle.dbtools.crest.imports.metadata.DBObject> selectedObjects = new ArrayList<oracle.dbtools.crest.imports.metadata.DBObject>();
            for (String longName : tablesShown) {
                oracle.dbtools.crest.imports.metadata.DBObject dbObj;
                String schemaName = longName.substring(0, longName.indexOf(46));
                String tableName = longName.substring(longName.indexOf(46) + 1);
                if (this.dbType.toUpperCase().contains(DB_TYPE_MS_SQL_SERVER)) {
                    String catalogName = catalog.concat("_");
                    if (schemaName.startsWith(catalogName)) {
                        schemaName = schemaName.substring(catalogName.length());
                    }
                    dbObj = new DBObjectSqlServer(true, tableName, "TABLE", schemaName);
                    ((DBObjectSqlServer)dbObj).setDb(catalog);
                    dbObj.setCatalog(catalog);
                } else {
                    dbObj = new oracle.dbtools.crest.imports.metadata.DBObject(true, tableName, "TABLE", schemaName);
                }
                selectedObjects.add(dbObj);
            }
            AbstractDBMExtractionHandler dbmExtractionHandler = this.dbType.toUpperCase().contains(DB_TYPE_ORACLE) ? new ExtractionHandlerOracle(this.appView) : (this.dbType.toUpperCase().contains(DB_TYPE_MS_SQL_SERVER) ? new ExtractionHandlerSQLServer(this.appView) : (this.dbType.toUpperCase().contains(DB_TYPE_DB2) && !this.zos ? new ExtractionHandlerDB2(this.appView) : new ExtractionHandlerODBC(this.appView)));
            for (oracle.dbtools.crest.imports.metadata.DBObject obj : selectedObjects) {
                objNames.add(this.getLongName(obj.getSchema(), obj.getName()));
            }
            dbmExtractionHandler.init(this.dbObject.getConnection());
            this.appView.getHiddenDesign().setSelectedRDBMSSite(dbmExtractionHandler.getRDBMSSite());
            this.clearImportedTables(dbmExtractionHandler.getRDBMSSite(), selectedObjects);
            ArrayList<oracle.dbtools.crest.imports.metadata.DBObject> selectedCopy = new ArrayList<oracle.dbtools.crest.imports.metadata.DBObject>();
            selectedCopy.addAll(selectedObjects);
            dbmExtractionHandler.generateDesign(this.dbObject.getConnection(), selectedObjects, importLog, monitor);
        }
        catch (Throwable e) {
            LOGGER.error("ERDEditor.importTable()", e);
        }
        return objNames;
    }

    private void clearImportedTables(RDBMSSite site, List selectedObjects) {
        ArrayList list = new ArrayList();
        list.addAll(selectedObjects);
        for (oracle.dbtools.crest.imports.metadata.DBObject dbo : list) {
            Table table;
            if (!"TABLE".equalsIgnoreCase(dbo.getType()) || (table = (Table)this.rd.getTableSet().getByLongName(this.getLongName(dbo.getSchema(), dbo.getName()))) == null) continue;
            selectedObjects.remove(dbo);
        }
    }

    protected void cleanUp() {
        if (this.dbType == null) {
            this.gui = null;
            return;
        }
        if (this.dpv != null) {
            this.dpv.getDesignPart().deleteSubview(this.dpv);
        }
        this.gui = null;
        this.rd.removeERDEditorListener(this);
    }

    public Object getPrintable() {
        return this.gui;
    }

    private void copyToDataModeler() {
        try {
            TreeMap objectsMap = new TreeMap();
            TreeMap physComparatorsMap = new TreeMap();
            TreeMap comparatorsMap = new TreeMap();
            RelationalDesign targetModel = (RelationalDesign)this.appView.getCurrentDesign().getRelationalDesigns().getByName(this.connectionName);
            if (targetModel == null) {
                targetModel = this.appView.getCurrentDesign().addRelationalDesign(this.connectionName);
            }
            this.appView.getCurrentDesign().setRelationalDesign(targetModel);
            this.fillExistingObjects(objectsMap, targetModel);
            this.getMergingModels().execute(this.rd, comparatorsMap, physComparatorsMap, objectsMap);
            DesignPartView newDPV = targetModel.createSubview(this.getSubViewObjects(targetModel));
            DesignPartViewPlaceHolder dpvph = new DesignPartViewPlaceHolder((DesignPart)targetModel, newDPV);
            Object[] list = newDPV.getTopviewsList().toArray();
            for (int i = 0; i < list.length; ++i) {
                TopView tv = (TopView)list[i];
                if (!(tv instanceof TVTable)) continue;
                Object[] arcs = ((Table)tv.getModel()).getArcs().toArray();
                for (int j = 0; j < arcs.length; ++j) {
                    FKArc arc = (FKArc)arcs[j];
                    arc.addToAllDPVs();
                }
            }
            SwingUtilities.invokeLater(new ShowDiagramRunner(dpvph));
        }
        catch (Throwable e) {
            LOGGER.error("ERDEditor.copyToDataModeler()", e);
        }
    }

    private void fillExistingObjects(Map map, RelationalDesign targetModel) {
        Iterator it = this.rd.getTableSet().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            Table targetTable = (Table)targetModel.getTableSet().getByImportedID(table.getObjectID());
            if (targetTable == null) continue;
            map.put(table.getObjectID(), targetTable);
            ContainedObject[] sourceColumns = table.getElements();
            for (int i = 0; i < sourceColumns.length; ++i) {
                Column sourceColumn = (Column)sourceColumns[i];
                Column targetColumn = (Column)targetTable.getColumnSet().getByImportedID(sourceColumn.getObjectID());
                if (targetColumn == null) continue;
                map.put(sourceColumn.getObjectID(), targetColumn);
            }
            KeyObject[] sourceKeys = table.getKeys();
            for (int i = 0; i < sourceKeys.length; ++i) {
                KeyObject sourceKey = sourceKeys[i];
                KeyObject targetKey = (KeyObject)targetTable.getKeySet().getByImportedID(sourceKey.getObjectID());
                if (targetKey == null) continue;
                map.put(sourceKey.getObjectID(), targetKey);
            }
            FKIndexAssociation[] fKeys = table.getFKAssociations();
            for (int i = 0; i < fKeys.length; ++i) {
                FKIndexAssociation sourceFK = fKeys[i];
                FKIndexAssociation targetFK = targetTable.getFKIndexAssociationByImportedID(sourceFK.getObjectID());
                if (targetFK == null) continue;
                map.put(sourceFK.getObjectID(), targetFK);
            }
            List checkConstraints = table.getCheckConstraints();
            for (TableLevelConstraint sourceConstraint : checkConstraints) {
                TableLevelConstraint targetConstraint = targetTable.getCheckConstraintByImportedID(sourceConstraint.getObjectID());
                if (targetConstraint == null) continue;
                map.put(sourceConstraint.getObjectID(), targetConstraint);
            }
            for (FKArc sourceArc : table.getArcs()) {
                FKArc targetArc = targetTable.getArcByImportedID(sourceArc.getObjectID());
                if (targetArc == null) continue;
                map.put(sourceArc.getObjectID(), targetArc);
            }
        }
    }

    private List getSubViewObjects(RelationalDesign relModel) {
        ArrayList<Table> list = new ArrayList<Table>();
        if (this.dpv != null) {
            for (TopView tv : this.dpv.getTopviewsList()) {
                Table table;
                String schema;
                Table newTable;
                if (!(tv instanceof TVTable) || (newTable = !"".equalsIgnoreCase(schema = (table = (Table)tv.getModel()).getSchema()) ? relModel.getTableSet().getBySchemaAndName(schema, table.getName()) : (Table)relModel.getTableSet().getByName(table.getName())) == null) continue;
                list.add(newTable);
            }
        }
        return list;
    }

    private String decodeConnectionName(String name) {
        String decoded = name;
        try {
            decoded = URLDecoder.decode(decoded, "utf-8");
            int p = decoded.lastIndexOf(35);
            if (p > 0) {
                decoded = decoded.substring(++p);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decoded;
    }

    public boolean canDisconnect(ConnectionsEvent event) {
        return true;
    }

    public void connectionDisconnected(ConnectionsEvent event) {
        if (this.rd != null && this.connectionName.equalsIgnoreCase(event.getName())) {
            this.rd.clearAll();
            this.rd.clearERDEditorListeners();
            this.rd.getDesign().removeRelationalDesign(this.rd);
            DatabaseConnections.getInstance().removeDisconnectListener((DisconnectListener)this);
        }
    }

    private MergingModels getMergingModels() {
        if (this.mergingModels == null) {
            this.mergingModels = new MergingModels(this.appView.getCurrentDesign());
        }
        return this.mergingModels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showParentAndChild(TopView topView) {
        Design oldCurrentDesign = this.appView.getCurrentDesign();
        this.appView.setCurrentDesign(this.appView.getHiddenDesign());
        ImportLogger importLog = new ImportLogger();
        ProgressDialog monitor = new ProgressDialog(this.appView, "", 0, 100);
        boolean hasNewTopViews = false;
        try {
            Table selTable = (Table)topView.getModel();
            String schemaName = selTable.getSchema();
            String tableName = selTable.getName();
            if (this.dbType.toUpperCase().contains(DB_TYPE_MS_SQL_SERVER) && this.catalog != null && !"".equalsIgnoreCase(this.catalog) && schemaName.startsWith(this.catalog)) {
                schemaName = schemaName.substring(this.catalog.length() + 1);
            }
            List objNames = this.getTableNames(schemaName, tableName, this.catalog, importLog, monitor);
            ArrayList<Table> tables = new ArrayList<Table>();
            for (String name : objNames) {
                Table table = (Table)this.rd.getTableSet().getByLongName(name);
                if (table == null || table == selTable) continue;
                tables.add(table);
                this.addTableShown(name);
            }
            DPVRelational tvDPV = (DPVRelational)topView.getDesignPartView();
            for (DesignObject designObject : tables) {
                TopView tv = tvDPV.getViewFor(designObject);
                if (tv != null) continue;
                tv = tvDPV.addViewFor(designObject, true);
                if (tv instanceof TVTable) {
                    ((TVTable)tv).addTVFKRelations();
                    ((TVTable)tv).addTVTypeSubstitutions();
                    tv.addShowParendAndChildListener(this);
                }
                hasNewTopViews = true;
            }
            this.rd.resolveFKs();
            if (hasNewTopViews) {
                try {
                    this.rd.createArcsFromTableCheckConstraints();
                }
                catch (Exception exception) {
                    LOGGER.error("Error in creating Arcs from table Check constraints", exception);
                }
                tvDPV.rearrangeNewDiagram();
                tvDPV.straightenLines(false);
            }
            Object[] objectArray = tvDPV.getTopviewsList().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                TopView tv = (TopView)objectArray[i];
                if (tv instanceof TVFKRelation) {
                    ((TVFKRelation)tv).resetEdgeParams(true);
                    continue;
                }
                if (!(tv instanceof TVTable)) continue;
                Object[] arcs = ((Table)tv.getModel()).getArcs().toArray();
                for (int j = 0; j < arcs.length; ++j) {
                    FKArc arc = (FKArc)arcs[j];
                    arc.addToAllDPVs();
                }
            }
        }
        finally {
            monitor.close();
            this.appView.setCurrentDesign(oldCurrentDesign);
            if (!hasNewTopViews) {
                MessageDialogs.showMessage(Messages.getString("ERDEditor.NoAdditionalTablesToDisplay"));
            }
        }
    }

    @Override
    public void updateEditor() {
        this.update(true);
    }

    private void addTableShown(String name) {
        if (!this.tablesShown.contains(name)) {
            this.tablesShown.add(name);
        }
    }
}

