/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.dbtools.crest.util.options.Settings;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class DDLPreferences
extends HashStructureAdapter {
    private static final String KEY = "OSDDM_DDLPP";
    private static final String DB2_TC = "db2_term_char";
    private static final String TST = "type_subst_triggers";
    private static final String T_FK_ARC = "fkarct_triggers";
    private static final String T_FK_NT = "fk_none_transferable_triggers";
    private static final String S_CB_DDL = "show_char_byte_in_ddl";
    private static final String S_EXT_CHARS_DDL = "extended_size_for_chars";
    private static final String USE_DT_KIND_C = "use_data_type_kind_in_compare";
    private static final String USE_SP_C = "use_schema_property_in_compare";
    private static final String USE_COP_C = "use_columns_order_property_in_compare";
    private static final String USE_CS_C = "use_case_sensitive_names_in_compare";
    private static final String INCL_PHYS_C = "include_physical_properties_in_compare";
    private static final String INCL_STOR_C = "include_storage_properties_in_compare";
    private static final String INCL_SYS_NAM_C = "include_system_names_in_compare";
    private static final String NN_SF = "not_null_short_form_generation";
    private static final String UQI = "use_quoted_identifiers";
    private static final String REPL_SYS_NAM = "replace_system_names_during_import";
    private static final String CDI = "create_domains_during_import";
    private static final String G_COMM = "generate_comments_in_rdbms";
    private static final String G_IN_C_CC = "generate_inline_column_cc";
    private static final String G_VALID_VAL_CC = "generate_valid_value_cc";
    private static final String INCL_DS_DDL = "include_default_settings_in_ddl";
    private static final String INCL_LG_DDL = "include_logging_in_ddl";
    private static final String INCL_SC_DDL = "include_schema_in_ddl";
    private static final String INCL_ST_DDL = "include_storage_in_ddl";
    private static final String INCL_TS_DDL = "include_tablespace_in_ddl";
    private static final String INCL_REDACT_DDL = "include_redaction_in_ddl";
    private static final String INCL_TSDP_DDL = "include_tsdp_in_ddl";
    private static final String INCL_PROMPT_DDL = "include_prompt";
    private static final String INCL_PCTFRE_DDL = "include_pctfree_in_ddl";
    private static final String INCL_PCTUSE_DDL = "include_pctused_in_ddl";
    private static final String INCL_INITRA_DDL = "include_initrans_in_ddl";
    private static final String INCL_INITEX_DDL = "include_initialextent_in_ddl";
    private static final String INCL_NEXTEX_DDL = "include_nextextent_in_ddl";
    private static final String INCL_MINEXS_DDL = "include_minextents_in_ddl";
    private static final String INCL_MAXEXS_DDL = "include_maxextents_in_ddl";
    private static final String INCL_PCTINC_DDL = "include_pctincrease_in_ddl";
    private static final String INCL_BFPOOL_DDL = "include_bufferpool_in_ddl";
    private static final String INCL_FLISTS_DDL = "include_freelists_in_ddl";
    private static final String INCL_FLGRPS_DDL = "include_freelistgroups_in_ddl";
    private static final String INCL_OPTIMA_DDL = "include_optimal_in_ddl";
    private static final String INCL_ENCRYP_DDL = "include_encryption_in_ddl";
    private static final String USE_SQL_DEV_FORMATTING = "use_sql_dev_formatting";
    private static final String DDDLFP = "def_ddl_files_path";
    private static final String INCL_DES_NAME_IN_DDL_FILES_PATH = "incl_des_name_in_ddl_files_path";
    private static final String CREATE_DATETIME_SNAPSHOT = "create_datetime_snapshot";
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    protected DDLPreferences(HashStructure hash) {
        super(hash);
    }

    public void setDefaultDDLFilesPath(String dp) {
        this._hash.putString(DDDLFP, dp);
    }

    public String getDefaultDDLFilesPath() {
        return this._hash.getString(DDDLFP);
    }

    public void setIncludeDesNameInDDLFilesPath(boolean value) {
        this._hash.putBoolean(INCL_DES_NAME_IN_DDL_FILES_PATH, value);
    }

    public boolean getIncludeDesNameInDDLFilesPath() {
        return this._hash.getBoolean(INCL_DES_NAME_IN_DDL_FILES_PATH);
    }

    public void setCreateDateTimeSnapshot(boolean value) {
        this._hash.putBoolean(CREATE_DATETIME_SNAPSHOT, value);
    }

    public boolean getCreateDateTimeSnapshot() {
        return this._hash.getBoolean(CREATE_DATETIME_SNAPSHOT);
    }

    public static DDLPreferences getInstance(PropertyStorage prefs) {
        return new DDLPreferences(DDLPreferences.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public String getDb2TermChar() {
        return this._hash.getString(DB2_TC);
    }

    public void setDb2TermChar(String db2TermChar) {
        this._hash.putString(DB2_TC, db2TermChar);
    }

    public boolean isSubstTrigger() {
        return this._hash.getBoolean(TST);
    }

    public void setSubstTrigger(boolean substTrigger) {
        this._hash.putBoolean(TST, substTrigger);
    }

    public boolean isfKArcTriggers() {
        return this._hash.getBoolean(T_FK_ARC);
    }

    public void setfKArcTriggers(boolean fKArcTriggers) {
        this._hash.putBoolean(T_FK_ARC, fKArcTriggers);
    }

    public boolean isfKNoneTransferableTriggers() {
        return this._hash.getBoolean(T_FK_NT);
    }

    public void setfKNoneTransferableTriggers(boolean fKNoneTransferableTriggers) {
        this._hash.putBoolean(T_FK_NT, fKNoneTransferableTriggers);
    }

    public boolean isShowByteCharInDDL() {
        return this._hash.getBoolean(S_CB_DDL);
    }

    public void setShowByteCharInDDL(boolean extendedCharsInDDL) {
        this._hash.putBoolean(S_CB_DDL, extendedCharsInDDL);
    }

    public boolean isExtendedCharsInDDL() {
        return this._hash.getBoolean(S_EXT_CHARS_DDL);
    }

    public void setExtendedCharsInDDL(boolean showByteCharInDDL) {
        this._hash.putBoolean(S_CB_DDL, showByteCharInDDL);
    }

    public boolean isUseDataTypeKind() {
        return this._hash.getBoolean(USE_DT_KIND_C);
    }

    public void setUseDataTypeKind(boolean useDataTypeKind) {
        this._hash.putBoolean(USE_DT_KIND_C, useDataTypeKind);
    }

    public boolean isCaseSensitiveNames() {
        return this._hash.getBoolean(USE_CS_C);
    }

    public void setCaseSensitiveNames(boolean caseSensitiveNames) {
        this._hash.putBoolean(USE_CS_C, caseSensitiveNames);
    }

    public boolean isNotNullShortForm() {
        return this._hash.getBoolean(NN_SF);
    }

    public void setNotNullShortForm(boolean notNullShortForm) {
        this._hash.putBoolean(NN_SF, notNullShortForm);
    }

    public boolean isUseQuotedIdentifiers() {
        return this._hash.getBoolean(UQI);
    }

    public void setUseQuotedIdentifiers(boolean useQuotedIdentifiers) {
        this._hash.putBoolean(UQI, useQuotedIdentifiers);
    }

    public boolean isReplaceSystemNamesDuringImport() {
        return this._hash.getBoolean(REPL_SYS_NAM);
    }

    public void setReplaceSystemNamesDuringImport(boolean replaceSystemNamesDuringImport) {
        this._hash.putBoolean(REPL_SYS_NAM, replaceSystemNamesDuringImport);
    }

    public boolean isCreateDomainsDuringImport() {
        return this._hash.getBoolean(CDI);
    }

    public void setCreateDomainsDuringImport(boolean createDomainsDuringImport) {
        this._hash.putBoolean(CDI, createDomainsDuringImport);
    }

    public boolean isGenerateCommentsInRDBMS() {
        return this._hash.getBoolean(G_COMM);
    }

    public void setGenerateCommentsInRDBMS(boolean generateCommentsInRDBMS) {
        this._hash.putBoolean(G_COMM, generateCommentsInRDBMS);
    }

    public boolean isGenerateInlineColumnCC() {
        return this._hash.getBoolean(G_IN_C_CC);
    }

    public void setGenerateInlineColumnCC(boolean generateInlineColumnCC) {
        this._hash.putBoolean(G_IN_C_CC, generateInlineColumnCC);
    }

    public boolean isGenerateValidValueCC() {
        return this._hash.getBoolean(G_VALID_VAL_CC);
    }

    public void setGenerateValidValueCC(boolean generateValidValueCC) {
        this._hash.putBoolean(G_VALID_VAL_CC, generateValidValueCC);
    }

    public boolean isUseSchemaProperty() {
        return this._hash.getBoolean(USE_SP_C);
    }

    public void setUseSchemaProperty(boolean useSchemaProperty) {
        this._hash.putBoolean(USE_SP_C, useSchemaProperty);
    }

    public boolean isUseColumnsOrderProperty() {
        return this._hash.getBoolean(USE_COP_C);
    }

    public void setUseColumnsOrderProperty(boolean useColumnsOrderProperty) {
        this._hash.putBoolean(USE_COP_C, useColumnsOrderProperty);
    }

    public boolean isIncludePhysicalProperties() {
        return this._hash.getBoolean(INCL_PHYS_C);
    }

    public void setIncludePhysicalProperties(boolean includePhysicalProperties) {
        this._hash.putBoolean(INCL_PHYS_C, includePhysicalProperties);
    }

    public boolean isIncludeStorageProperties() {
        return this._hash.getBoolean(INCL_STOR_C);
    }

    public void setIncludeStorageProperties(boolean includeStorageProperties) {
        this._hash.putBoolean(INCL_STOR_C, includeStorageProperties);
    }

    public boolean isIncludeSystemNames() {
        return this._hash.getBoolean(INCL_SYS_NAM_C);
    }

    public void setIncludeSystemNames(boolean includeSystemNames) {
        this._hash.putBoolean(INCL_SYS_NAM_C, includeSystemNames);
    }

    public boolean isIncludeDefaultSettingsInDDL() {
        return this._hash.getBoolean(INCL_DS_DDL);
    }

    public void setIncludeDefaultSettingsInDDL(boolean includeDefaultSettingsInDDL) {
        this._hash.putBoolean(INCL_DS_DDL, includeDefaultSettingsInDDL);
    }

    public boolean isIncludeLoggingInDDL() {
        return this._hash.getBoolean(INCL_LG_DDL);
    }

    public void setIncludeLoggingInDDL(boolean includeLoggingInDDL) {
        this._hash.putBoolean(INCL_LG_DDL, includeLoggingInDDL);
    }

    public boolean isIncludeSchemaInDDL() {
        return this._hash.getBoolean(INCL_SC_DDL);
    }

    public void setIncludeSchemaInDDL(boolean includeSchemaInDDL) {
        this._hash.putBoolean(INCL_SC_DDL, includeSchemaInDDL);
    }

    public boolean isIncludeStorageInDDL() {
        return this._hash.getBoolean(INCL_ST_DDL);
    }

    public void setIncludeStorageInDDL(boolean includeStorageInDDL) {
        this._hash.putBoolean(INCL_ST_DDL, includeStorageInDDL);
    }

    public boolean isIncludeTablespaceInDDL() {
        return this._hash.getBoolean(INCL_TS_DDL);
    }

    public void setIncludeTablespaceInDDL(boolean includeTablespaceInDDL) {
        this._hash.putBoolean(INCL_TS_DDL, includeTablespaceInDDL);
    }

    public boolean isIncludeRedactionInDDL() {
        return this._hash.getBoolean(INCL_REDACT_DDL);
    }

    public void setIncludeRedactionInDDL(boolean includeRedactionInDDL) {
        this._hash.putBoolean(INCL_REDACT_DDL, includeRedactionInDDL);
    }

    public boolean isIncludeTSDPInDDL() {
        return this._hash.getBoolean(INCL_TSDP_DDL);
    }

    public void setIncludeTSDPInDDL(boolean includeTSDPInDDL) {
        this._hash.putBoolean(INCL_TSDP_DDL, includeTSDPInDDL);
    }

    public void setIncludePromptInDDL(boolean includePromptInDDL) {
        this._hash.putBoolean(INCL_PROMPT_DDL, includePromptInDDL);
    }

    public boolean isIncludePromptInDDL() {
        return this._hash.getBoolean(INCL_PROMPT_DDL);
    }

    public boolean isIncludePctFreeInDDL() {
        return this._hash.getBoolean(INCL_PCTFRE_DDL);
    }

    public void setIncludePctFreeInDDL(boolean includePctFree) {
        this._hash.putBoolean(INCL_PCTFRE_DDL, includePctFree);
    }

    public boolean isIncludePctUsedInDDL() {
        return this._hash.getBoolean(INCL_PCTUSE_DDL);
    }

    public void setIncludePctUsedInDDL(boolean includePctUsed) {
        this._hash.putBoolean(INCL_PCTUSE_DDL, includePctUsed);
    }

    public boolean isIncludeInitransInDDL() {
        return this._hash.getBoolean(INCL_INITRA_DDL);
    }

    public void setIncludeInitransInDDL(boolean includeInitrans) {
        this._hash.putBoolean(INCL_INITRA_DDL, includeInitrans);
    }

    public boolean isIncludeInitialExtentInDDL() {
        return this._hash.getBoolean(INCL_INITEX_DDL);
    }

    public void setIncludeInitialExtentInDDL(boolean includeInitialExtent) {
        this._hash.putBoolean(INCL_INITEX_DDL, includeInitialExtent);
    }

    public boolean isIncludeNextExtentInDDL() {
        return this._hash.getBoolean(INCL_NEXTEX_DDL);
    }

    public void setIncludeNextExtentInDDL(boolean includeNextExtent) {
        this._hash.putBoolean(INCL_NEXTEX_DDL, includeNextExtent);
    }

    public boolean isIncludeMinExtentsInDDL() {
        return this._hash.getBoolean(INCL_MINEXS_DDL);
    }

    public void setIncludeMinExtentsInDDL(boolean includeMinExtents) {
        this._hash.putBoolean(INCL_MINEXS_DDL, includeMinExtents);
    }

    public boolean isIncludeMaxExtentsInDDL() {
        return this._hash.getBoolean(INCL_MAXEXS_DDL);
    }

    public void setIncludeMaxExtentsInDDL(boolean includeMaxExtents) {
        this._hash.putBoolean(INCL_MAXEXS_DDL, includeMaxExtents);
    }

    public boolean isIncludePctIncreaseInDDL() {
        return this._hash.getBoolean(INCL_PCTINC_DDL);
    }

    public void setIncludePctIncreaseInDDL(boolean includePctIncrease) {
        this._hash.putBoolean(INCL_PCTINC_DDL, includePctIncrease);
    }

    public boolean isIncludeBufferPoolInDDL() {
        return this._hash.getBoolean(INCL_BFPOOL_DDL);
    }

    public void setIncludeBufferPoolInDDL(boolean includeBufferPool) {
        this._hash.putBoolean(INCL_BFPOOL_DDL, includeBufferPool);
    }

    public boolean isIncludeFreeListsInDDL() {
        return this._hash.getBoolean(INCL_FLISTS_DDL);
    }

    public void setIncludeFreeListsInDDL(boolean includeFreeLists) {
        this._hash.putBoolean(INCL_FLISTS_DDL, includeFreeLists);
    }

    public boolean isIncludeFreeListGroupsInDDL() {
        return this._hash.getBoolean(INCL_FLGRPS_DDL);
    }

    public void setIncludeFreeListGroupsInDDL(boolean includeFreeListGroups) {
        this._hash.putBoolean(INCL_FLGRPS_DDL, includeFreeListGroups);
    }

    public boolean isIncludeOptimalInDDL() {
        return this._hash.getBoolean(INCL_OPTIMA_DDL);
    }

    public void setIncludeOptimalInDDL(boolean includeOptimal) {
        this._hash.putBoolean(INCL_OPTIMA_DDL, includeOptimal);
    }

    public boolean isIncludeEncryptionInDDL() {
        return this._hash.getBoolean(INCL_ENCRYP_DDL);
    }

    public void setIncludeEncryptionInDDL(boolean includeEncryptionInDDL) {
        this._hash.putBoolean(INCL_ENCRYP_DDL, includeEncryptionInDDL);
    }

    public boolean useSQLDevFormatting() {
        return this._hash.getBoolean(USE_SQL_DEV_FORMATTING);
    }

    public void setUseSQLDevFormatting(boolean useSQLDevFormatting) {
        this._hash.putBoolean(USE_SQL_DEV_FORMATTING, useSQLDevFormatting);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    private boolean contains(String key) {
        return this._hash.containsKey(key);
    }

    public void loadToSettings(Settings settings) {
        if (this.contains(TST)) {
            settings.setGenerateTypeSubstTriggers(this.isSubstTrigger());
        }
        if (this.contains(T_FK_ARC)) {
            settings.setGenerateFKArcTriggers(this.isfKArcTriggers());
        }
        if (this.contains(T_FK_NT)) {
            settings.setGenerateFKNoneTransferableTriggers(this.isfKNoneTransferableTriggers());
        }
        if (this.contains(S_CB_DDL)) {
            settings.setShowByteCharInDDL(this.isShowByteCharInDDL());
        }
        if (this.contains(S_EXT_CHARS_DDL)) {
            settings.setExtendedSizeForCharacters(this.isShowByteCharInDDL());
        }
        if (this.contains(USE_DT_KIND_C)) {
            settings.setUseDataTypeKindInCompare(this.isUseDataTypeKind());
        }
        if (this.contains(USE_SP_C)) {
            settings.setUseSchemaPropertyInCompare(this.isUseSchemaProperty());
        }
        if (this.contains(USE_COP_C)) {
            settings.setUseColumnsOrderPropertyInCompare(this.isUseColumnsOrderProperty());
        }
        if (this.contains(INCL_PHYS_C)) {
            settings.setIncludePhysicalPropertiesInCompare(this.isIncludePhysicalProperties());
        }
        if (this.contains(INCL_STOR_C)) {
            settings.setIncludeStoragePropertiesInCompare(this.isIncludeStorageProperties());
        }
        if (this.contains(INCL_SYS_NAM_C)) {
            settings.setIncludeSystemNamesInCompare(this.isIncludeSystemNames());
        }
        if (this.contains(G_VALID_VAL_CC)) {
            settings.setGenerateValidValueCC(this.isGenerateValidValueCC());
        }
        if (this.contains(INCL_DS_DDL)) {
            settings.setIncludeDefaultSettingsInDDL(this.isIncludeDefaultSettingsInDDL());
        }
        if (this.contains(INCL_LG_DDL)) {
            settings.setIncludeLoggingInDDL(this.isIncludeLoggingInDDL());
        }
        if (this.contains(INCL_SC_DDL)) {
            settings.setIncludeSchemaInDDL(this.isIncludeSchemaInDDL());
        }
        if (this.contains(INCL_ST_DDL)) {
            settings.setIncludeStorageInDDL(this.isIncludeStorageInDDL());
        }
        if (this.contains(INCL_TS_DDL)) {
            settings.setIncludeTablespaceInDDL(this.isIncludeTablespaceInDDL());
        }
        if (this.contains(INCL_REDACT_DDL)) {
            settings.setIncludeRedactionInDDL(this.isIncludeRedactionInDDL());
        }
        if (this.contains(INCL_TSDP_DDL)) {
            settings.setIncludeTSDPInDDL(this.isIncludeTSDPInDDL());
        }
        if (this.contains(INCL_PROMPT_DDL)) {
            settings.setIncludePromptInDDL(this.isIncludePromptInDDL());
        }
        if (this.contains(USE_CS_C)) {
            settings.setCaseSensitiveNamesInCompare(this.isCaseSensitiveNames());
        }
        if (this.contains(NN_SF)) {
            settings.setNotNullShortFormGeneration(this.isNotNullShortForm());
        }
        if (this.contains(UQI)) {
            settings.setUseQuotedIdentifiers(this.isUseQuotedIdentifiers());
        }
        if (this.contains(REPL_SYS_NAM)) {
            settings.setReplaceSystemNamesDuringImport(this.isReplaceSystemNamesDuringImport());
        }
        if (this.contains(CDI)) {
            settings.setCreateDomainsDuringImport(this.isCreateDomainsDuringImport());
        }
        if (this.contains(G_COMM)) {
            settings.setGenerateCommentsInRDBMS(this.isGenerateCommentsInRDBMS());
        }
        if (this.contains(G_IN_C_CC)) {
            settings.setGenerateInlineColumnCC(this.isGenerateInlineColumnCC());
        }
        if (this.contains(DB2_TC)) {
            settings.setDB2TerminationCharacter(this.getDb2TermChar() != null ? this.getDb2TermChar().charAt(0) : " ".charAt(0));
        }
        if (this.contains(INCL_PCTFRE_DDL)) {
            settings.setIncludePctFreeInDDL(this.isIncludePctFreeInDDL());
        }
        if (this.contains(INCL_PCTUSE_DDL)) {
            settings.setIncludePctUsedInDDL(this.isIncludePctUsedInDDL());
        }
        if (this.contains(INCL_INITRA_DDL)) {
            settings.setIncludeInitransInDDL(this.isIncludeInitransInDDL());
        }
        if (this.contains(INCL_INITEX_DDL)) {
            settings.setIncludeInitialExtentInDDL(this.isIncludeInitialExtentInDDL());
        }
        if (this.contains(INCL_NEXTEX_DDL)) {
            settings.setIncludeNextExtentInDDL(this.isIncludeNextExtentInDDL());
        }
        if (this.contains(INCL_MINEXS_DDL)) {
            settings.setIncludeMinExtentsInDDL(this.isIncludeMinExtentsInDDL());
        }
        if (this.contains(INCL_MAXEXS_DDL)) {
            settings.setIncludeMaxExtentsInDDL(this.isIncludeMaxExtentsInDDL());
        }
        if (this.contains(INCL_PCTINC_DDL)) {
            settings.setIncludePctIncreaseInDDL(this.isIncludePctIncreaseInDDL());
        }
        if (this.contains(INCL_BFPOOL_DDL)) {
            settings.setIncludeBufferPoolInDDL(this.isIncludeBufferPoolInDDL());
        }
        if (this.contains(INCL_FLISTS_DDL)) {
            settings.setIncludeFreeListsInDDL(this.isIncludeFreeListsInDDL());
        }
        if (this.contains(INCL_FLGRPS_DDL)) {
            settings.setIncludeFreeListGroupsInDDL(this.isIncludeFreeListGroupsInDDL());
        }
        if (this.contains(INCL_OPTIMA_DDL)) {
            settings.setIncludeOptimalInDDL(this.isIncludeOptimalInDDL());
        }
        if (this.contains(INCL_ENCRYP_DDL)) {
            settings.setIncludeEncryptionInDDL(this.isIncludeEncryptionInDDL());
        }
        if (this.contains(USE_SQL_DEV_FORMATTING)) {
            settings.setUseSQLDevFormatting(this.useSQLDevFormatting());
        }
        if (this.contains(DDDLFP)) {
            settings.setDefaultDDLFilesPath(this.getDefaultDDLFilesPath());
        }
        if (this.contains(INCL_DES_NAME_IN_DDL_FILES_PATH)) {
            settings.setIncludeDesgnNameInDDLPath(this.getIncludeDesNameInDDLFilesPath());
        }
        if (this.contains(CREATE_DATETIME_SNAPSHOT)) {
            settings.setCreateDateTimeSnapshot(this.getCreateDateTimeSnapshot());
        }
    }

    public void loadFromSettings(Settings settings) {
        this.setSubstTrigger(settings.isGenerateTypeSubstTriggers());
        this.setfKArcTriggers(settings.isGenerateFKArcTriggers());
        this.setfKNoneTransferableTriggers(settings.isGenerateFKNoneTransferableTriggers());
        this.setShowByteCharInDDL(settings.isShowByteCharInDDL());
        this.setExtendedCharsInDDL(settings.isExtendedSizeForCharacters());
        this.setUseDataTypeKind(settings.isUseDataTypeKindInCompare());
        this.setUseSchemaProperty(settings.isUseSchemaPropertyInCompare());
        this.setUseColumnsOrderProperty(settings.isUseColumnsOrderPropertyInCompare());
        this.setIncludePhysicalProperties(settings.isIncludePhysicalPropertiesInCompare());
        this.setIncludeStorageProperties(settings.isIncludeStoragePropertiesInCompare());
        this.setIncludeSystemNames(settings.isIncludeSystemNamesInCompare());
        this.setIncludeDefaultSettingsInDDL(settings.isIncludeDefaultSettingsInDDL());
        this.setIncludeLoggingInDDL(settings.isIncludeLoggingInDDL());
        this.setIncludeSchemaInDDL(settings.isIncludeSchemaInDDL());
        this.setIncludeStorageInDDL(settings.isIncludeStorageInDDL());
        this.setIncludeTablespaceInDDL(settings.isIncludeTablespaceInDDL());
        this.setCaseSensitiveNames(settings.isCaseSensitiveNamesInCompare());
        this.setNotNullShortForm(settings.notNullShortFormGeneration());
        this.setUseQuotedIdentifiers(settings.isUseQuotedIdentifiers());
        this.setReplaceSystemNamesDuringImport(settings.isReplaceSystemNamesDuringImport());
        this.setCreateDomainsDuringImport(settings.isCreateDomainsDuringImport());
        this.setDb2TermChar(Character.toString(settings.getDB2TerminationCharacter()));
        this.setGenerateCommentsInRDBMS(settings.isGenerateCommentsInRDBMS());
        this.setGenerateInlineColumnCC(settings.isGenerateInlineColumnCC());
        this.setGenerateValidValueCC(settings.isGenerateValidValueCC());
        this.setIncludePctFreeInDDL(settings.isIncludePctFreeInDDL());
        this.setIncludePctUsedInDDL(settings.isIncludePctUsedInDDL());
        this.setIncludeInitransInDDL(settings.isIncludeInitransInDDL());
        this.setIncludeInitialExtentInDDL(settings.isIncludeInitialExtentInDDL());
        this.setIncludeNextExtentInDDL(settings.isIncludeNextExtentInDDL());
        this.setIncludeMinExtentsInDDL(settings.isIncludeMinExtentsInDDL());
        this.setIncludeMaxExtentsInDDL(settings.isIncludeMaxExtentsInDDL());
        this.setIncludePctIncreaseInDDL(settings.isIncludePctIncreaseInDDL());
        this.setIncludeBufferPoolInDDL(settings.isIncludeBufferPoolInDDL());
        this.setIncludeFreeListsInDDL(settings.isIncludeFreeListsInDDL());
        this.setIncludeFreeListGroupsInDDL(settings.isIncludeFreeListGroupsInDDL());
        this.setIncludeOptimalInDDL(settings.isIncludeOptimalInDDL());
        this.setIncludeEncryptionInDDL(settings.isIncludeEncryptionInDDL());
        this.setUseSQLDevFormatting(settings.useSQLDevFormatting());
        this.setDefaultDDLFilesPath(settings.getDefaultDDLFilesPath());
        this.setIncludeDesNameInDDLFilesPath(settings.isIncludeDesgnNameInDDLPath());
        this.setIncludeDesNameInDDLFilesPath(settings.isIncludeDesgnNameInDDLPath());
        this.setIncludeRedactionInDDL(settings.isIncludeRedactionInDDL());
        this.setIncludeTSDPInDDL(settings.isIncludeTSDPInDDL());
        this.setIncludePromptInDDL(settings.isIncludePromptInDDL());
    }
}

