/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dbtools.crest.fcp.Messages;
import oracle.dbtools.crest.fcp.vcs.ChooseActionDialog;
import oracle.dbtools.crest.fcp.vcs.GeneralStorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.MergeConflict;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.VCSClientHelper;
import oracle.dbtools.crest.fcp.vcs.VersioningTreeNode;
import oracle.dbtools.crest.fcp.vcs.git.DMGITOperationResolveConflict;
import oracle.dbtools.crest.fcp.vcs.git.GitClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import org.netbeans.libs.git.GitConflictDescriptor;
import org.netbeans.libs.git.GitStatus;

public class MergeConflictsGitDialog
extends ChooseActionDialog {
    private static final String ACTION_EDIT_CONFLICT = Messages.getString("MergeConflictsDialog.ActionEditConflict");
    private static final String ACTION_EDIT_CONFLICT_AS_TEXT = Messages.getString("MergeConflictsDialog.ActionEditConflictAsText");
    private static final String ACTION_RESOLVE_LATER = Messages.getString("MergeConflictsDialog.ActionResolveLater");
    private static final String ACTION_USE_LOCAL_VERSION = Messages.getString("MergeConflictsDialog.ActionUseLocalVersion");
    private static final String ACTION_USE_REMOTE_VERSION = Messages.getString("MergeConflictsDialog.ActionUseRemoteVersion");
    private static final String ACTION_USE_LOCAL_CONFLICTED = Messages.getString("MergeConflictsDialog.ActionUseLocalConflicted");
    private static final String ACTION_USE_REMOTE_CONFLICTED = Messages.getString("MergeConflictsDialog.ActionUseRemoteConflicted");
    private static final String[] ACTIONS = new String[]{ACTION_EDIT_CONFLICT, ACTION_EDIT_CONFLICT_AS_TEXT, ACTION_RESOLVE_LATER, ACTION_USE_LOCAL_VERSION, ACTION_USE_REMOTE_VERSION};
    protected static final SVNClientHelper SVN_CLIENT_HELPER = SVNClientHelper.getInstance();
    private static final MergeConflictsGitDialog INSTANCE = new MergeConflictsGitDialog();
    private static final Logger LOGGER = new Logger(MergeConflictsGitDialog.class);
    private Map<Conflict, String> conflictActions = new HashMap<Conflict, String>();
    private List<Conflict> mergeConflicts;
    List<VersioningTreeNode> nodesForRefreshing = new ArrayList<VersioningTreeNode>();
    List<VersioningTreeNode> reallyMerged = new ArrayList<VersioningTreeNode>();

    public static MergeConflictsGitDialog getInstance() {
        return new MergeConflictsGitDialog();
    }

    @Override
    protected String getTitle() {
        return Messages.getString("MergeConflictsDialog.MergeConflicts");
    }

    public void checkForConflicts(Design design, List<GitStatus> list) {
        int option;
        if (list.size() > 0 && (option = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("MergeConflictsDialog.ConflictFoundMessage"), Messages.getString("MergeConflictsDialog.ConflictFoundTitle"), 0, 2)) == 0) {
            this.processConflicts(list, true);
        }
    }

    @Override
    protected String[] getActions() {
        return ACTIONS;
    }

    @Override
    protected ActionListener getActionsActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object action = MergeConflictsGitDialog.this.actionsComboBox.getSelectedItem();
                    Conflict mergeConflict = (Conflict)MergeConflictsGitDialog.this.mergeConflicts.get(MergeConflictsGitDialog.this.tbActions.getSelectedRow());
                    mergeConflict.action = (String)action;
                    MergeConflictsGitDialog.this.conflictActions.put(mergeConflict, (String)action);
                    if (ACTION_EDIT_CONFLICT.equals(action) || ACTION_EDIT_CONFLICT_AS_TEXT.equals(action)) {
                        GitConflictDescriptor descr = mergeConflict.status.getConflictDescriptor();
                        URL url = mergeConflict.getURL();
                        if (url != null) {
                            boolean merged = false;
                            if (DMGITOperationResolveConflict.isBothAdded(descr) || DMGITOperationResolveConflict.isBothModified(descr)) {
                                merged = ACTION_EDIT_CONFLICT.equals(action) ? DMGITOperationResolveConflict.resolveMergeConflict(url, true, false) : DMGITOperationResolveConflict.resolveMergeConflict(url, false, false);
                                if (merged) {
                                    MergeConflictsGitDialog.this.mergeConflicts.remove(mergeConflict);
                                } else {
                                    MergeConflictsGitDialog.this.conflictActions.put(mergeConflict, ACTION_RESOLVE_LATER);
                                }
                                int col = MergeConflictsGitDialog.this.tbActions.getEditingColumn();
                                int row = MergeConflictsGitDialog.this.tbActions.getEditingRow();
                                if (row > -1 && col > -1) {
                                    MergeConflictsGitDialog.this.tbActions.getCellEditor(row, col).stopCellEditing();
                                }
                                MergeConflictsGitDialog.this.tbActions.updateUI();
                                if (merged && mergeConflict.node != null) {
                                    MergeConflictsGitDialog.this.nodesForRefreshing.add(mergeConflict.node);
                                    if (!MergeConflictsGitDialog.this.reallyMerged.contains(mergeConflict.node) && mergeConflict.node != null) {
                                        MergeConflictsGitDialog.this.reallyMerged.add(mergeConflict.node);
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.error(ex);
                }
            }
        };
    }

    public List<Conflict> processConflicts() {
        return this.processConflicts(null, true);
    }

    public List<Conflict> processConflicts(List<GitStatus> newMergeConflicts, boolean showEmptyDialog) {
        ArrayList<Conflict> allMergeConflicts = new ArrayList<Conflict>();
        if (!newMergeConflicts.isEmpty() || showEmptyDialog) {
            this.mergeConflicts = MergeConflictsGitDialog.getConflictNodes(newMergeConflicts);
            this.conflictActions.clear();
            this.tbActions.updateUI();
            this.conflictActionsUpdate();
            if (this.showDialog()) {
                for (Conflict mergeConflict : this.conflictActions.keySet()) {
                    String action;
                    mergeConflict.action = action = this.conflictActions.get(mergeConflict);
                    GitConflictDescriptor descr = mergeConflict.status.getConflictDescriptor();
                    if (ACTION_USE_LOCAL_VERSION.equals(action)) {
                        GitClientHelper.resolveConflictWithOURS(mergeConflict.getURL(), DMGITOperationResolveConflict.isBothDeleted(descr) || DMGITOperationResolveConflict.isDeletedByUs(descr));
                        if (this.reallyMerged.contains(mergeConflict.node) || mergeConflict.node == null) continue;
                        this.reallyMerged.add(mergeConflict.node);
                        continue;
                    }
                    if (ACTION_USE_REMOTE_VERSION.equals(action)) {
                        if (DMGITOperationResolveConflict.isBothDeleted(descr)) {
                            GitClientHelper.resolveConflictWithOURS(mergeConflict.getURL(), DMGITOperationResolveConflict.isBothDeleted(descr));
                        } else if (DMGITOperationResolveConflict.isDeletedByThem(descr)) {
                            GitClientHelper.resolveConflictDeletedByThem(mergeConflict.getURL());
                            if (mergeConflict.node != null) {
                                mergeConflict.node.setTextStatus("D");
                            }
                            if (mergeConflict.stor != null) {
                                mergeConflict.stor.setTextStatus("D");
                            }
                        } else if (DMGITOperationResolveConflict.isDeletedByUs(descr)) {
                            GitClientHelper.resolveConflictWithTheirs(mergeConflict.getURL());
                            if (mergeConflict.node != null) {
                                mergeConflict.node.setTextStatus("A");
                            }
                            if (mergeConflict.stor != null) {
                                if (mergeConflict.stor.getStorableObject() != null) {
                                    mergeConflict.stor.setTextStatus("M");
                                    if (mergeConflict.node != null) {
                                        mergeConflict.node.setTextStatus("M");
                                    }
                                } else {
                                    mergeConflict.stor.setTextStatus("A");
                                }
                            }
                        } else {
                            GitClientHelper.resolveConflictWithTheirs(mergeConflict.getURL());
                        }
                        if (this.reallyMerged.contains(mergeConflict.node) || mergeConflict.node == null) continue;
                        this.reallyMerged.add(mergeConflict.node);
                        continue;
                    }
                    if (!ACTION_RESOLVE_LATER.equals(action)) continue;
                }
                VersioningTreeNode.refresh(this.reallyMerged, false, true);
            }
        } else {
            VersioningTreeNode.refresh(this.reallyMerged, false, true);
        }
        return allMergeConflicts;
    }

    private void resolveConflict(MergeConflict mergeConflict) {
        File localFile = mergeConflict.getLocalFile();
        File mineLocalFile = new File(localFile.getAbsoluteFile() + ".mine");
        if (localFile.length() == 0L && mineLocalFile.exists()) {
            localFile.delete();
            mineLocalFile.renameTo(localFile);
        }
        VCS_CLIENT_HELPER.doResolved(localFile);
        this.mergeConflicts.remove(mergeConflict);
        this.tbActions.updateUI();
        VersioningTreeNode nodeForRefreshing = mergeConflict.getNodeForRefreshing();
        if (nodeForRefreshing != null) {
            this.nodesForRefreshing.add(nodeForRefreshing);
        }
    }

    @Override
    protected ChooseActionDialog.ActionsTableModel getActionsTableModel() {
        return new ChooseActionDialog.ActionsTableModel(){

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 2;
            }

            @Override
            public String getColumnName(int column) {
                if (column == 0) {
                    return MergeConflictsGitDialog.this.getActionsTableModelFirstColumnName();
                }
                if (column == 1) {
                    return Messages.getString("MergeConflictsDialog.StatusOT");
                }
                if (column == 2) {
                    return Messages.getString("MergeConflictsDialog.Action");
                }
                return super.getColumnName(column);
            }

            @Override
            public int getRowCount() {
                return MergeConflictsGitDialog.this.mergeConflicts == null ? 0 : MergeConflictsGitDialog.this.mergeConflicts.size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (column == 0) {
                    return ((Conflict)((MergeConflictsGitDialog)MergeConflictsGitDialog.this).mergeConflicts.get((int)row)).stor;
                }
                if (column == 1) {
                    return ((Conflict)MergeConflictsGitDialog.this.mergeConflicts.get(row)).getConflictPresentation();
                }
                if (column == 2) {
                    String action = (String)MergeConflictsGitDialog.this.conflictActions.get(MergeConflictsGitDialog.this.mergeConflicts.get(row));
                    return action == null ? ACTION_RESOLVE_LATER : action;
                }
                return super.getValueAt(row, column);
            }

            @Override
            public void setValueAt(Object action, int row, int column) {
                if (column == 1 && !ACTION_EDIT_CONFLICT.equals(action)) {
                    Conflict mergeConflict = (Conflict)MergeConflictsGitDialog.this.mergeConflicts.get(row);
                    MergeConflictsGitDialog.this.conflictActions.put(mergeConflict, (String)action);
                }
            }
        };
    }

    @Override
    protected String getActionsTableModelFirstColumnName() {
        return Messages.getString("MergeConflictsDialog.ChangedObject");
    }

    @Override
    protected DefaultTableCellRenderer getActionsCellRenderer() {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                StorableObjectStatus storableObjectStatus = (StorableObjectStatus)value;
                this.setText(storableObjectStatus.getStorableObjectName());
                this.setIcon(VCSClientHelper.getIcon(storableObjectStatus.getObjectClass()));
                return this;
            }
        };
    }

    protected void conflictActionsUpdate() {
        for (int i = 0; i < this.tbActions.getRowCount(); ++i) {
            Conflict mC = this.mergeConflicts.get(i);
            this.conflictActions.put(mC, (String)this.tbActions.getModel().getValueAt(i, this.getActionColumnNumber()));
        }
    }

    @Override
    protected int getActionColumnNumber() {
        return 2;
    }

    public static List<Conflict> getConflictNodes(Collection<GitStatus> changed) {
        ArrayList<Conflict> list = new ArrayList<Conflict>();
        for (GitStatus status : changed) {
            File file = status.getFile();
            try {
                URL url = file.toURI().toURL();
                Design d = ApplicationView.getInstance().getDesignForURL(url);
                Object descr = null;
                if (d != null) {
                    d.getObjectDescriptor(url, null);
                }
                GeneralStorableObjectStatus st = new GeneralStorableObjectStatus(d, file, "C");
                VersioningTreeNode tn = new VersioningTreeNode(st);
                if (st.getStorableObjectName() == null) {
                    String name = GitClientHelper.getNameFromXMLFile(file);
                    st.setStorableObjectName(name);
                }
                Conflict c = new Conflict();
                c.status = status;
                c.node = tn;
                c.stor = st;
                list.add(c);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static class Conflict {
        GitStatus status;
        StorableObjectStatus stor;
        VersioningTreeNode node;
        String action = MergeConflictsGitDialog.access$400();

        String getConflictPresentation() {
            String res = "";
            if (this.status != null && this.status.isConflict()) {
                switch (this.status.getConflictDescriptor().getType()) {
                    case DELETED_BY_US: {
                        res = "Deleted / Modified";
                        break;
                    }
                    case DELETED_BY_THEM: {
                        res = "Modified / Deleted";
                        break;
                    }
                    case BOTH_DELETED: {
                        res = "Deleted / Deleted";
                        break;
                    }
                    case ADDED_BY_THEM: {
                        res = ".... / Added by them";
                        break;
                    }
                    case BOTH_ADDED: {
                        res = "Added / Added";
                        break;
                    }
                    case BOTH_MODIFIED: {
                        res = "Modified / Modified";
                        break;
                    }
                    case ADDED_BY_US: {
                        res = "Added by us / ....";
                    }
                }
            }
            return res;
        }

        URL getURL() {
            try {
                return this.status.getFile().toURI().toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

