/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.git;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.swing.JMenu;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.crest.fcp.vcs.GeneralStorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.git.GitClientHelper;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DomainFileWrapper;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.compare.xmlmeta.XMLMetadataComparator;
import oracle.ide.Ide;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.jndi.Names;
import oracle.jdeveloper.compare.CompareViewer;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.compare.URLContributor;
import oracle.jdevimpl.compare.CompareIdeViewer;
import oracle.jdevimpl.resource.CompareArb;

public class CompareGITViewer
extends CompareIdeViewer {
    public static final String JNDI_NAME = "jdeveloper/compareviewer";
    private JMenu m_contextCompareMenu;
    private CompareViewer defaultIdeViewer = null;

    public static final CompareGITViewer createCompareGITViewer() {
        InitialContext ic = Names.newInitialContext();
        CompareGITViewer compareViewer = (CompareGITViewer)((Object)Names.lookup((Context)ic, (String)JNDI_NAME));
        if (compareViewer == null) {
            compareViewer = new CompareGITViewer();
            Names.bind((Context)ic, (String)JNDI_NAME, (Object)((Object)compareViewer));
        }
        return compareViewer;
    }

    public JMenu getMainCompareMenu() {
        return MenuManager.getJMenu((String)"subMenu.FileCompare");
    }

    public JMenu getContextCompareMenu() {
        if (this.m_contextCompareMenu == null) {
            this.m_contextCompareMenu = this.createContextCompareMenu();
        }
        return this.m_contextCompareMenu;
    }

    private CompareViewer getDefaultIdeViewer() {
        if (this.defaultIdeViewer == null) {
            this.defaultIdeViewer = new CompareIdeViewer();
        }
        return this.defaultIdeViewer;
    }

    public void show(CompareContributor left, CompareContributor right, Element contextNode) {
        block38: {
            Locatable node;
            URL url;
            Design design = null;
            if (contextNode != null && contextNode instanceof Locatable && (url = (node = (Locatable)contextNode).getURL()) != null) {
                design = ApplicationView.getInstance().getDesignForURL(url);
            }
            ByteArrayInputStream leftStream = null;
            ByteArrayInputStream rightStream = null;
            String leftRev = "Previous Version";
            String rightRev = "Current Version";
            boolean addOp = false;
            if (left instanceof InputStreamTextContributor) {
                String str;
                int ind;
                String strev;
                InputStreamTextContributor istc = (InputStreamTextContributor)left;
                String rev = istc.getLongLabel();
                if (rev.startsWith(strev = "Revision ")) {
                    ind = (rev = rev.substring(strev.length())).indexOf(32);
                    if (ind > 0) {
                        leftRev = leftRev + " - " + rev.substring(0, ind);
                    }
                } else {
                    ind = rev.lastIndexOf(" - ");
                    if (ind > -1) {
                        try {
                            leftRev = rev.substring(ind + 3);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        ind = rev.indexOf(32);
                        if (ind > 0) {
                            leftRev = leftRev + " - " + rev.substring(0, ind);
                        }
                    }
                }
                if (leftRev.trim().endsWith("No")) {
                    addOp = true;
                }
                if (!(str = istc.getTextBuffer().getString(0, istc.getTextBuffer().getLength())).trim().isEmpty()) {
                    leftStream = new ByteArrayInputStream(str.getBytes(Charset.forName("UTF-8")));
                } else {
                    addOp = true;
                }
            }
            File file = null;
            boolean xmlType = false;
            boolean merge = false;
            String className = null;
            if (!addOp) {
                String str;
                if (right instanceof URLContributor) {
                    URLContributor urlContr = (URLContributor)right;
                    str = urlContr.getTextBuffer().getString(0, urlContr.getTextBuffer().getLength());
                    if (str.indexOf("<<<<<<") <= -1) {
                        rightStream = new ByteArrayInputStream(str.getBytes(Charset.forName("UTF-8")));
                        xmlType = "XML".equalsIgnoreCase(urlContr.getStreamType().name());
                        String path = URLFileSystem.getPath((URL)urlContr.getURL());
                        file = new File(path);
                        merge = file.exists();
                    }
                } else if (right instanceof InputStreamTextContributor) {
                    InputStreamTextContributor istc = (InputStreamTextContributor)right;
                    str = istc.getTextBuffer().getString(0, istc.getTextBuffer().getLength());
                    className = GitClientHelper.getClassFromXML(str);
                    String rev = istc.getLongLabel();
                    int ind = rev.lastIndexOf(" - ");
                    if (ind > 0) {
                        rightRev = rev.substring(ind + 3);
                    } else {
                        ind = rev.indexOf(32);
                        if (ind > -1) {
                            rightRev = "Version - " + rev.substring(0, ind);
                        }
                    }
                    rightStream = new ByteArrayInputStream(str.getBytes(Charset.forName("UTF-8")));
                    xmlType = "XML".equalsIgnoreCase(istc.getStreamType().name());
                }
            }
            if (!addOp && leftStream != null && rightStream != null && xmlType) {
                try {
                    Class<?> cl = null;
                    GeneralStorableObjectStatus st = null;
                    if (file != null) {
                        if (design != null) {
                            st = new GeneralStorableObjectStatus(design, file, "M");
                            cl = st.getObjectClass();
                        }
                        if (cl == null && (className = GitClientHelper.getClassFromXMLFile(file)) != null) {
                            try {
                                cl = Class.forName(className);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    } else if (className != null) {
                        try {
                            cl = Class.forName(className);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (cl != null && (StorableObject.class.isAssignableFrom(cl) || DomainFileWrapper.class.isAssignableFrom(cl))) {
                        merge = merge && st != null;
                        XMLMetadataComparator comparator = merge ? new XMLMetadataComparator(design, null, leftStream, leftRev, rightStream, rightRev, merge) : new XMLMetadataComparator(design, null, rightStream, rightRev, leftStream, leftRev, merge);
                        Map mergedMap = comparator.showModal();
                        if (st != null) {
                            StorableObject so = st.getStorableObject();
                            if (so == null && DesignPart.class.isAssignableFrom(st.getObjectClass())) {
                                so = st.getDesignPart();
                            }
                            if (so != null && mergedMap != null) {
                                SVNClientHelper.getInstance().merge(st, file, mergedMap);
                            }
                        }
                        break block38;
                    }
                    this.getDefaultIdeViewer().show(left, right, contextNode);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.getDefaultIdeViewer().show(left, right, contextNode);
            }
        }
    }

    private final JMenu createContextCompareMenu() {
        JMenu compareMenu = Ide.getMenubar().createSubMenu(StringUtils.stripMnemonic((String)CompareArb.get((String)"COMPARE_WITH_MENU")), new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.get((String)"COMPARE_WITH_MENU"))), 0.2f, MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
        return compareMenu;
    }
}

