/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.vcs.svn;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;

class RelationalModelEstimates {
    public RelationalDesign relationalDesign;
    public int numberOfTables;
    public int numberOfViews;
    public int numberOfForeignKeys;
    public int numberOfSchemas;
    public int numberOfSubViews;
    public int numberOfArcs;
    public List<Boolean> rdbmsSitesSelections = new ArrayList<Boolean>();

    public RelationalModelEstimates(RelationalDesign relationalDesign, int numberOfPossiblePhysicalModels) {
        this.relationalDesign = relationalDesign;
        for (int i = 0; i < numberOfPossiblePhysicalModels; ++i) {
            this.rdbmsSitesSelections.add(new Boolean(this.isPhysicalModelCreated(relationalDesign, i)));
        }
    }

    private boolean isPhysicalModelCreated(RelationalDesign relationalDesign, int rdbmsSiteIndex) {
        RDBMSSite[] rdbmsSiteArray = (RDBMSSite[])relationalDesign.getDesign().getRDBMSSiteSet().toArray();
        StorageDesign[] storageDesignArray = (StorageDesign[])relationalDesign.getSorageDesigns().toArray();
        for (int i = 0; i < storageDesignArray.length; ++i) {
            StorageDesign sd = storageDesignArray[i];
            if (!sd.getRDBMSSite().getLongName().equalsIgnoreCase(rdbmsSiteArray[rdbmsSiteIndex].getLongName())) continue;
            return true;
        }
        return false;
    }

    public void setEstimatedRelationalModelObjectNumbers(String tables, String schemas, String foreignKeys, String views, String subviews, String arcs) {
        this.numberOfTables = new Integer(tables);
        this.numberOfSchemas = new Integer(schemas);
        this.numberOfForeignKeys = new Integer(foreignKeys);
        this.numberOfViews = new Integer(views);
        this.numberOfSubViews = new Integer(subviews);
        this.numberOfArcs = new Integer(arcs);
    }

    public void getEstimatedRelationalModelObjectNumbers(JTextField tfTables, JTextField tfSchemas, JTextField tfForeignKeys, JTextField tfViews, JTextField tfSubViews, JTextField tfArcs) {
        tfTables.setText(new Integer(this.numberOfTables).toString());
        tfSchemas.setText(new Integer(this.numberOfSchemas).toString());
        tfForeignKeys.setText(new Integer(this.numberOfForeignKeys).toString());
        tfViews.setText(new Integer(this.numberOfViews).toString());
        tfSubViews.setText(new Integer(this.numberOfSubViews).toString());
        tfArcs.setText(new Integer(this.numberOfArcs).toString());
    }

    public void setRDBMSSitesCheckBoxes(List<JCheckBox> rdbmsSitesCheckBoxes) {
        this.rdbmsSitesSelections.clear();
        for (int i = 0; i < rdbmsSitesCheckBoxes.size(); ++i) {
            this.rdbmsSitesSelections.add(new Boolean(rdbmsSitesCheckBoxes.get(i).isSelected()));
        }
    }

    public void getRDBMSSitesCheckBoxes(List<JCheckBox> rdbmsSitesCheckBoxes) {
        for (int i = 0; i < this.rdbmsSitesSelections.size(); ++i) {
            rdbmsSitesCheckBoxes.get(i).setSelected(this.rdbmsSitesSelections.get(i));
        }
    }
}

