/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.imports.ddl.DDLFilesInDirectoryCollector;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DDLFiles_LB_Collector {
    public static List<File> getSQLFiles(File rootDir) {
        ArrayList<File> files = new ArrayList<File>();
        DDLFiles_LB_Collector.processFile(rootDir, files);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processFile(File file, List<File> files) {
        block17: {
            if (file != null && file.isFile() && file.exists()) {
                BufferedReader br = null;
                try {
                    FileInputStream is = new FileInputStream(file);
                    br = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                    InputSource inputSource = new InputSource(br);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = null;
                    try {
                        db = dbf.newDocumentBuilder();
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        // empty catch block
                    }
                    if (db == null) break block17;
                    try {
                        Document doc = db.parse(inputSource);
                        Element root = doc.getDocumentElement();
                        if (root != null) {
                            String rootTag = root.getTagName();
                            File dir = file.getParentFile();
                            DDLFiles_LB_Collector.parseXMLDocument((XMLElement)root, dir, files);
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    private static void parseXMLDocument(XMLElement root, File changeLogDir, List<File> files) {
        try {
            File file;
            String rel;
            boolean relative;
            String name;
            Element elem;
            String tagname;
            Node n;
            int i;
            NodeList nodes = root.getChildrenByTagName("include");
            int count = nodes.getLength();
            for (i = 0; i < count; ++i) {
                n = nodes.item(i);
                if (!(n instanceof Element) || !"include".equalsIgnoreCase(tagname = (elem = (Element)n).getTagName()) || (name = elem.getAttribute("file")) == null || "".equals(name)) continue;
                relative = false;
                rel = elem.getAttribute("relativeToChangelogFile");
                if (rel != null && "true".equals(rel)) {
                    relative = true;
                }
                file = null;
                file = relative ? new File(changeLogDir, name) : new File(name);
                if (DDLFilesInDirectoryCollector.accept(file)) {
                    files.add(file);
                    continue;
                }
                if (!name.toLowerCase().endsWith(".xml")) continue;
                DDLFiles_LB_Collector.processFile(file, files);
            }
            nodes = root.getElementsByTagName("sqlFile");
            count = nodes.getLength();
            for (i = 0; i < count; ++i) {
                n = nodes.item(i);
                if (!(n instanceof XMLElement) || !"sqlFile".equalsIgnoreCase(tagname = (elem = (XMLElement)n).getTagName()) || (name = elem.getAttribute("path")) == null || "".equals(name)) continue;
                relative = false;
                rel = elem.getAttribute("relativeToChangelogFile");
                if (rel != null && "true".equals(rel) || rel == null || rel.isEmpty()) {
                    relative = true;
                }
                file = null;
                file = relative ? new File(changeLogDir, name) : new File(name);
                if (DDLFilesInDirectoryCollector.accept(file)) {
                    files.add(file);
                    continue;
                }
                if (!name.toLowerCase().endsWith(".xml")) continue;
                DDLFiles_LB_Collector.processFile(file, files);
            }
            nodes = root.getElementsByTagName("runOracleScript");
            count = nodes.getLength();
            for (i = 0; i < count; ++i) {
                String type;
                n = nodes.item(i);
                if (!(n instanceof XMLElement) || !"n0:runOracleScript".equalsIgnoreCase(tagname = (elem = (XMLElement)n).getTagName()) || (type = elem.getAttribute("sourceType")) == null || !"FILE".equalsIgnoreCase(type)) continue;
                NodeList sources = elem.getElementsByTagName("source");
                int cs = sources.getLength();
                for (int k = 0; k < cs; ++k) {
                    String tname;
                    boolean relative2 = true;
                    Node element = sources.item(k);
                    if (!(element instanceof XMLElement) || !"n0:source".equalsIgnoreCase(tname = ((XMLElement)element).getTagName())) continue;
                    String value = element.getTextContent();
                    File file2 = null;
                    file2 = relative2 ? new File(changeLogDir, value) : new File(value);
                    if (DDLFilesInDirectoryCollector.accept(file2)) {
                        files.add(file2);
                        continue;
                    }
                    if (!type.toLowerCase().endsWith(".xml")) continue;
                    DDLFiles_LB_Collector.processFile(file2, files);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        File file = new File("D:\\tmp5\\sql3\\Relational_1_20200218_113354_LB.xml");
        for (File f : DDLFiles_LB_Collector.getSQLFiles(file)) {
            System.out.println(f.getAbsolutePath());
        }
    }
}

