/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.imports.DDLFileStamp;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.AlterTableHandler;
import oracle.dbtools.crest.imports.ddl.BaseDDLFileHandler;
import oracle.dbtools.crest.imports.ddl.CreateTableHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.DomainHandlerReadDDL;
import oracle.dbtools.crest.imports.ddl.StatementsSorter;
import oracle.dbtools.crest.imports.ddl.db2.DomainHandlerReadDDLDB2;
import oracle.dbtools.crest.imports.ddl.db2.SHAlterTable;
import oracle.dbtools.crest.imports.ddl.db2.SHCommentOn;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateAUXIndex;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateAUXTable;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateAlias;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateDatabase;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateDistinctTypeDB2;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateIndex;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateStoragegroup;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateStoredProcedureDB2;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateSynonym;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateTable;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateTablespace;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateTriggerDB2;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateView;
import oracle.dbtools.crest.imports.ddl.db2.SHGrant;
import oracle.dbtools.crest.imports.ddl.db2.SHLabelOn;
import oracle.dbtools.crest.imports.ddl.db2.v80.DomainHandlerReadDDLDB2v80;
import oracle.dbtools.crest.imports.ddl.db2.v80.SHAlterTableDB2v80;
import oracle.dbtools.crest.imports.ddl.db2.v80.SHCreateDistinctTypeDB2v80;
import oracle.dbtools.crest.imports.ddl.db2.v80.SHCreateIndexDB2v80;
import oracle.dbtools.crest.imports.ddl.db2.v80.SHCreateSequenceDB2v80;
import oracle.dbtools.crest.imports.ddl.db2.v80.SHCreateTableDB2v80;
import oracle.dbtools.crest.imports.ddl.db2.v80.SHCreateTablespaceDB2v80;
import oracle.dbtools.crest.imports.ddl.oracle.SHAlterViewOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCommentOnOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateDirectoryOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateFunctionOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreatePackageBodyOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreatePackageOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateRollbackSegment;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateSequenceOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateSnapshotOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateStoredProcedureOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateSynonymOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateTemporaryTablespaceOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateTriggerOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateUserOracle;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateViewOracle;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.DomainHandlerReadDDLOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHAlterTableOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateClusterOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateCollectionTypeOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateDatabaseOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateDimensionOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateDiskGroupOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateExternalTableOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateRoleOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateSnapshotOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateTableOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateTablespaceOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateTemporaryTablespaceOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateTypeOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateUndoTablespaceOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateUserOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHGrantPermissionsOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.DomainHandlerReadDDLOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHAlterTableOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateClusterOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateCollectionTypeOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateContextOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateDatabaseOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateExternalTableOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateIndexOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateRoleOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateTableOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateTablespaceOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateTypeOraclev9i;
import oracle.dbtools.crest.imports.ddl.oracle.v9i.SHCreateUndoTablespaceOraclev9i;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.DomainHandlerReadDDLSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHAddDataTypeSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHAlterDatabaseSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHAlterTableSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateDatabaseSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateDefaultSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateIndexSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateLoginSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateRoleSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateRuleSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateStoredProcedureSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateTableSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateTriggerSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateViewSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHExtendedPropertiesSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHGrantPermissionsSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHGrantPrivilegesSqlServer;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k12.SHCreateIndexSqlServerv2k12;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k12.SHCreateSequenceSqlServerv2k12;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.DomainHandlerReadDDLSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SCHCreateSchemaSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHAddDataTypeSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHAlterDatabaseSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHAlterTableSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateDatabaseSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateDefaultSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateIndexSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateLoginSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreatePartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreatePartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateRoleSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateRuleSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateStoredProcedureSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateSynonymSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateTableSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateTriggerSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateViewSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHCreateXMLCollectionSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHExtendedPropertiesSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHGrantPermissionsSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.sqlserver.v2k5.SHGrantPrivilegesSqlServerv2k5;
import oracle.dbtools.crest.imports.ddl.udb.DomainHandlerReadDDLUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHAlterTableUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCommentOnUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateAliasUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateBufferPoolUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateDatabaseUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateDistinctTypeUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateFunctionUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateIndexUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateMethodUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateNodeGroupUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateSchemaUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateStoredProcedureUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateTableUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateTablespaceUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateTriggerUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateTypeUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateViewUDB;
import oracle.dbtools.crest.imports.ddl.udb.SHGrantUDB;
import oracle.dbtools.crest.imports.ddl.udb.v81.DomainHandlerReadDDLUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHAlterTableUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateBufferPoolUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateDBPartitionGroupUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateDatabaseUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateIndexUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateSequenceUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateTableUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateTablespaceUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateTriggerUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateTypeUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateViewUDBv81;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHGrantUDBv81;
import oracle.dbtools.crest.model.View;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12cr2.StorageDesignOraclev12cR2;
import oracle.dbtools.crest.model.design.storage.oracle.v20c.StorageDesignOraclev20c;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.compare.CompareModelsDialog;
import oracle.dbtools.crest.swingui.compare.ModelChooserDialog;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.util.gui.swing.JListDialog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class DDLHandler {
    private static final String UNTITLED_DESIGN = oracle.dbtools.crest.model.Messages.getString("Design.Untitled");
    public static final int DB_TYPE_DB2v70 = 0;
    public static final int DB_TYPE_UDBv71 = 2;
    public static final int DB_TYPE_SQL_SERVER2K = 4;
    public static final int DB_TYPE_DB2v80 = 1;
    public static final int DB_TYPE_UDBv81 = 3;
    public static final int DB_TYPE_UDBv9 = 10;
    public static final int DB_TYPE_ORACLEv9i = 7;
    public static final int DB_TYPE_ORACLEv10g = 8;
    public static final int DB_TYPE_SQL_SERVERV2K5 = 5;
    public static final int DB_TYPE_SQL_SERVERV2K8 = 12;
    public static final int DB_TYPE_SQL_SERVERV2K12 = 13;
    public static final int DB_TYPE_ORACLEv11g = 9;
    public static final int DB_TYPE_ORACLEv12c = 11;
    public static final int DB_TYPE_ORACLEv12cR2 = 14;
    public static final int DB_TYPE_ORACLEv20c = 17;
    private DDLStatementHandler chain;
    private DDLStatementHandlerSqlServer chainSqlServer;
    private Design design;
    private Design designDomains;
    private LinkedList statementCollection;
    private Map statementFileMap;
    private String databaseName;
    private ApplicationView view;
    private Object[] files;
    private String oldDesignPath;
    private StorageDesign storageDesign = null;
    private RelationalDesign relModel = null;
    private boolean swapTargetModel = false;
    private Design oldDesign;
    private boolean isNewModel = false;
    private boolean skipMergeDialog = false;
    private List oldStorageDesigns = null;
    private int dbType = 0;
    private RDBMSSite site;
    private ProgressDialog monitor;
    private static final Logger LOGGER = new Logger(DDLHandler.class);

    public DDLHandler(View view, RelationalDesign relModel, boolean swapTargetModel, boolean skipMergeDialog) {
        this(view, relModel, swapTargetModel, skipMergeDialog, null);
    }

    public DDLHandler(View view, RelationalDesign relModel, boolean swapTargetModel, boolean skipMergeDialog, StorageDesign storageDesign) {
        if (view instanceof ApplicationView) {
            this.view = (ApplicationView)view;
        }
        this.storageDesign = storageDesign;
        this.relModel = relModel;
        this.swapTargetModel = swapTargetModel;
        this.skipMergeDialog = skipMergeDialog;
        if (skipMergeDialog) {
            this.design = this.view.getCurrentDesign();
            this.oldStorageDesigns = Arrays.asList(this.design.getRelationalDesign().getStorageDesignFactory().getOpenStorageDesigns());
        } else {
            this.oldDesign = this.view.getCurrentDesign();
            this.design = new Design((ApplicationView)view, this.oldDesign);
            this.oldStorageDesigns = Arrays.asList(this.oldDesign.getRelationalDesign().getStorageDesignFactory().getOpenStorageDesigns());
            ((ApplicationView)view).setCurrentDesign(this.design);
        }
        this.statementCollection = new LinkedList();
        this.statementFileMap = new TreeMap();
    }

    public void parse(Object[] files, String dName, String oldDesignPath) {
        this.oldDesignPath = oldDesignPath;
        this.databaseName = dName;
        this.files = files;
        this.statementCollection.clear();
        this.statementFileMap.clear();
        this.dbType = this.storageDesign != null ? this.getDDLTypeFor(this.storageDesign.getRDBMSSite()) : this.getDDLType();
        if (this.site == null) {
            LOGGER.error("Error getting RDBMS Site: DDLHandler.parse");
            return;
        }
        switch (this.dbType) {
            case 0: {
                this.buildDB2v70Chain();
                break;
            }
            case 2: {
                this.buildUDBv71Chain();
                break;
            }
            case 7: {
                this.buildOraclev9iChain();
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 17: {
                this.buildOraclev10gChain();
                break;
            }
            case 4: {
                this.buildSqlServerChain();
                break;
            }
            case 1: {
                this.buildDB2v80Chain();
                break;
            }
            case 3: 
            case 10: {
                this.buildUDBv81Chain();
                break;
            }
            case 5: 
            case 12: {
                this.buildSqlServerv2k5Chain();
                break;
            }
            case 13: {
                this.buildSqlServerv2k12Chain();
                break;
            }
            default: {
                this.buildDB2v70Chain();
            }
        }
        if (this.skipMergeDialog) {
            if (this.relModel == null && this.storageDesign == null) {
                RelationalDesign newRelDesign = this.design.addRelationalDesign(dName);
                this.design.setRelationalDesign(newRelDesign);
                this.relModel = newRelDesign;
            } else {
                this.design.setRelationalDesign(this.relModel);
            }
            this.design.setSelectedRDBMSSite(this.site);
            this.designDomains = this.design;
            this.design.getStorageDesign(this.site);
            for (int i = 0; i < files.length; ++i) {
                DDLFileStamp stamp = new DDLFileStamp((File)files[i], this.dbType);
                int n = this.design.getRelationalDesign().addImportDDLFileStamp(stamp);
            }
            new Thread(new EmptyRunner()).start();
        } else {
            if (this.relModel == null && this.storageDesign == null) {
                RelationalDesign newRelDesign = this.oldDesign.addRelationalDesign(dName);
                this.oldDesign.setRelationalDesign(newRelDesign);
                this.isNewModel = true;
            } else {
                this.oldDesign.setRelationalDesign(this.relModel);
                this.isNewModel = false;
            }
            if (this.relModel != null) {
                if (this.relModel.isVisible()) {
                    this.relModel.getMainView().getTabbedPane().setSelectedIndex(0);
                    this.view.setCurrentDPV(this.relModel.getMainView());
                } else if (this.relModel.getFKIndexAssociationSet().size() < 300) {
                    this.relModel.setMainViewVisible(true);
                }
                this.design.getRelationalDesign().setRelatedSyncModel(this.relModel);
            }
            this.design.setSelectedRDBMSSite(this.site);
            this.oldDesign.setSelectedRDBMSSite(this.site);
            this.design.getRelationalDesign().setName(dName);
            this.designDomains = this.design;
            this.design.setFileName(this.databaseName);
            this.design.getStorageDesign(this.site);
            for (int i = 0; i < files.length; ++i) {
                DDLFileStamp stamp = new DDLFileStamp((File)files[i], this.dbType);
                int n = this.design.getRelationalDesign().addImportDDLFileStamp(stamp);
            }
            new Thread(new Runner()).start();
        }
    }

    private void constructDomains() {
        try {
            if (this.dbType == 7) {
                DomainHandlerReadDDLOraclev9i domainHandler = new DomainHandlerReadDDLOraclev9i(this.designDomains);
                domainHandler.createDomains(this.statementCollection);
            } else if (this.dbType == 8) {
                DomainHandlerReadDDLOraclev10g domainHandler = new DomainHandlerReadDDLOraclev10g(this.designDomains);
                domainHandler.createDomains(this.statementCollection, StorageDesignOraclev10g.RDBMS_TYPE);
            } else if (this.dbType == 9) {
                DomainHandlerReadDDLOraclev10g domainHandler = new DomainHandlerReadDDLOraclev10g(this.designDomains);
                domainHandler.createDomains(this.statementCollection, StorageDesignOraclev11g.RDBMS_TYPE);
            } else if (this.dbType == 11) {
                DomainHandlerReadDDLOraclev10g domainHandler = new DomainHandlerReadDDLOraclev10g(this.designDomains);
                domainHandler.createDomains(this.statementCollection, StorageDesignOraclev12c.RDBMS_TYPE);
            } else if (this.dbType == 14) {
                DomainHandlerReadDDLOraclev10g domainHandler = new DomainHandlerReadDDLOraclev10g(this.designDomains);
                domainHandler.createDomains(this.statementCollection, StorageDesignOraclev12cR2.RDBMS_TYPE);
            } else if (this.dbType == 17) {
                DomainHandlerReadDDLOraclev10g domainHandler = new DomainHandlerReadDDLOraclev10g(this.designDomains);
                domainHandler.createDomains(this.statementCollection, StorageDesignOraclev20c.RDBMS_TYPE);
            } else if (this.dbType == 4) {
                DomainHandlerReadDDLSqlServer domainHandlerReadDDLSqlServer = new DomainHandlerReadDDLSqlServer(this.designDomains);
                domainHandlerReadDDLSqlServer.createDomains(this.statementCollection);
            } else if (this.dbType == 5 || this.dbType == 12 || this.dbType == 13) {
                DomainHandlerReadDDLSqlServerv2k5 domainHandlerReadDDLSqlServer = new DomainHandlerReadDDLSqlServerv2k5(this.designDomains);
                domainHandlerReadDDLSqlServer.createDomains(this.statementCollection);
            } else if (this.dbType == 0) {
                DomainHandlerReadDDLDB2 domainHandlerReadDDLDB2 = new DomainHandlerReadDDLDB2(this.designDomains);
                domainHandlerReadDDLDB2.createDomains(this.statementCollection);
            } else if (this.dbType == 1) {
                DomainHandlerReadDDLDB2v80 domainHandlerReadDDLDB2v80 = new DomainHandlerReadDDLDB2v80(this.designDomains);
                domainHandlerReadDDLDB2v80.createDomains(this.statementCollection);
            } else if (this.dbType == 2) {
                DomainHandlerReadDDLUDB domainHandlerReadDDLUDB = new DomainHandlerReadDDLUDB(this.designDomains);
                domainHandlerReadDDLUDB.createDomains(this.statementCollection);
            } else if (this.dbType == 3 || this.dbType == 10) {
                DomainHandlerReadDDLUDBv81 domainHandlerReadDDLUDBv81 = new DomainHandlerReadDDLUDBv81(this.designDomains);
                domainHandlerReadDDLUDBv81.createDomains(this.statementCollection);
            } else {
                DomainHandlerReadDDL domainHandler = new DomainHandlerReadDDL(this.designDomains);
                domainHandler.createDomains(this.statementCollection);
            }
            this.designDomains.resetDomains();
        }
        catch (Exception e) {
            LOGGER.error("Unable to create domains!", e);
        }
    }

    private void parseFile(ImportLogger importLog) {
        StorageDesign sd;
        AlterTableHandler ath;
        CreateTableHandler cth;
        String line;
        String fileName;
        this.design.setSelectedRDBMSSite(this.site);
        int counter = 0;
        double step = 10.0;
        int size = this.statementCollection.size();
        Iterator itStatem = this.statementCollection.iterator();
        if (this.dbType == 4 || this.dbType == 5 || this.dbType == 12 || this.dbType == 13) {
            this.chainSqlServer.setCurrentDB("");
            this.chainSqlServer.setImportLog(importLog);
            while (itStatem.hasNext()) {
                if (this.statementFileMap.get(counter) != null) {
                    fileName = (String)this.statementFileMap.get(counter);
                    int fileIndex = this.design.getRelationalDesign().findImportDDLFileStamp(fileName);
                    this.design.getRelationalDesign().setImportDDLFileStampIndex(fileIndex);
                }
                this.monitor.setNote(MessageFormat.format(Messages.getString("DDLHandler.ProcessingStatement"), ++counter));
                this.monitor.setProgress((int)(step += 80.0 / (double)size));
                line = (String)itStatem.next();
                String clearedLine = DDLStatementHandler.clearCR(line).trim();
                if (clearedLine.equalsIgnoreCase("GO")) {
                    importLog.incrementImportedStatements();
                    continue;
                }
                if (clearedLine.toUpperCase().startsWith("USE ")) {
                    this.chainSqlServer.setCurrentDB(Token.getNameAfterToken(clearedLine, "USE", '[', ']').trim(), true);
                    importLog.incrementImportedStatements();
                    continue;
                }
                try {
                    this.chainSqlServer.handle(line);
                }
                catch (Exception e) {
                    LOGGER.error("Unable to handle the line: " + line, e);
                    this.chain.nextHandler(line);
                }
            }
            cth = this.chainSqlServer.getCreateTableHandler();
            cth.setImportLog(importLog);
            if (cth != null) {
                try {
                    cth.processForeignKeys();
                }
                catch (Exception e) {
                    LOGGER.error("Unable to process ForeignKeys", e);
                }
            }
            ath = this.chainSqlServer.getAlterTableHandler();
            ath.setImportLog(importLog);
            if (ath != null) {
                try {
                    ath.processForeignKeys();
                }
                catch (Exception e) {
                    LOGGER.error("Unable to process ForeignKeys", e);
                }
            }
        } else {
            while (itStatem.hasNext()) {
                if (this.statementFileMap.get(counter) != null) {
                    fileName = (String)this.statementFileMap.get(counter);
                    int fileIndex = this.design.getRelationalDesign().findImportDDLFileStamp(fileName);
                    this.design.getRelationalDesign().setImportDDLFileStampIndex(fileIndex);
                }
                this.monitor.setNote(MessageFormat.format(Messages.getString("DDLHandler.ProcessingStatement"), ++counter));
                this.monitor.setProgress((int)(step += 80.0 / (double)size));
                line = (String)itStatem.next();
                if (0 == this.dbType || 1 == this.dbType) {
                    try {
                        this.processSQLIDSettings(this.chain, line, importLog);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to process SQLID Settings: " + line, e);
                        importLog.addError("Unable to process SQLID Settings: " + line);
                        importLog.addFailedStatement(DDLStatementHandler.FormatCR(line, "\n"));
                    }
                } else if (2 == this.dbType || 3 == this.dbType || 10 == this.dbType) {
                    try {
                        this.processCurrentSchemaSettings(this.chain, line, importLog);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to process Set Current SCHEMA Settings: " + line, e);
                        importLog.addError("Unable to process Set Current SCHEMA Settings: " + line);
                        importLog.addFailedStatement(DDLStatementHandler.FormatCR(line, "\n"));
                    }
                }
                try {
                    this.chain.setImportLog(importLog);
                    this.chain.handle(line);
                }
                catch (Exception e) {
                    LOGGER.error("Unable to handle the line: " + line, e);
                    this.chain.nextHandler(line);
                }
            }
            cth = this.chain.getCreateTableHandler();
            if (cth != null) {
                try {
                    cth.processForeignKeys();
                }
                catch (Exception e) {
                    LOGGER.error("Unable to process ForeignKeys", e);
                }
            }
            if ((ath = this.chain.getAlterTableHandler()) != null) {
                try {
                    ath.processForeignKeys();
                }
                catch (Exception e) {
                    LOGGER.error("Unable to process ForeignKeys", e);
                }
            }
            if (0 == this.dbType || 1 == this.dbType) {
                this.processDB2IntegrityIndexes();
            }
        }
        if ((sd = this.design.getStorageDesign(this.design.getSelectedRDBMSSite())) instanceof StorageDesignOracle) {
            ((StorageDesignOracle)sd).migrateOlderExternalTables();
            this.design.getRelationalDesign().parseSQLInViewsAndTables();
        }
        if (this.storageDesign == null) {
            this.monitor.setNote(Messages.getString("DDLHandler.RearrangeTypes"));
            this.monitor.setProgress(85);
            try {
                this.design.getDataTypesDesign().rearrangeTypes();
            }
            catch (Exception e) {
                LOGGER.error("Unable to rearrange Types", e);
            }
            this.monitor.setNote(Messages.getString("DDLHandler.RearrangeTables"));
            this.monitor.setProgress(90);
            try {
                this.design.getRelationalDesign().resolveFKs();
                this.design.getRelationalDesign().createArcsFromTableCheckConstraints();
            }
            catch (Exception e) {
                LOGGER.error("Error in creating Arcs from table Check constraints", e);
            }
            try {
                ((DPVRelational)this.design.getRelationalDesign().getMainView()).rearrangeNewDiagram();
                Iterator itsv = this.design.getRelationalDesign().getMainView().getDisplays().iterator();
                while (itsv.hasNext()) {
                    DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)itsv.next();
                    ((DPVRelational)ph.getDesignPartView()).rearrangeNewDiagram();
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to rearrange Tables", e);
            }
            this.monitor.setNote(Messages.getString("DDLHandler.RearrangeViews"));
            this.monitor.setProgress(93);
            try {
                this.fixFKSelfReferences();
            }
            catch (Exception e) {
                LOGGER.error("Unable to fix FK SelfReferences", e);
            }
            try {
                this.design.getRelationalDesign().createSubviewsOnSchema(this.design.getStorageDesign(this.design.getSelectedRDBMSSite()));
            }
            catch (Exception e) {
                LOGGER.error("Unable to create subviews ", e);
            }
        }
        this.monitor.setProgress(95);
        this.design.setDirty(true);
        this.design.getStorageDesign(this.design.getSelectedRDBMSSite()).setOpen(true);
        this.design.getStorageDesign(this.design.getSelectedRDBMSSite()).setTempModel(false);
        this.design.getStorageDesign(this.design.getSelectedRDBMSSite()).setDirty(true);
    }

    private void processDB2IntegrityIndexes() {
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
        Iterator it = storageDesign.getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxyDB2 tp = (TableProxyDB2)it.next();
            for (IndexProxyDB2 ip : tp.getIntegrityIndexes()) {
                if (ip.isProcessedInDDLImport() || ip.getOwner() != null && !ip.getOwner().isNullInstance()) continue;
                ip.setOwner(((TableProxyDB2)ip.getTableProxy()).getOwner());
            }
        }
    }

    private void processSQLIDSettings(DDLStatementHandler rootHandler, String line, ImportLogger importLog) {
        String statement = line.toUpperCase().trim();
        if (statement.indexOf("--") != 0 && statement.indexOf("SET") > -1 && statement.indexOf("CURRENT") > -1 && statement.indexOf("SQLID") > -1) {
            int eqpos;
            statement = line;
            int semicolPos = statement.indexOf(59);
            if (semicolPos > -1) {
                statement = statement.substring(0, semicolPos);
            }
            if ((eqpos = statement.indexOf(61)) > -1) {
                String user = statement.substring(eqpos + 1).trim();
                if (user.indexOf("'") <= -1) {
                    rootHandler.setOwner(null);
                } else if (!"".equalsIgnoreCase(user = user.substring(1, user.length() - 1))) {
                    RDBMSSite site = this.design.getSelectedRDBMSSite();
                    AbstractStorageDesignDB2 storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
                    Owner owner = (Owner)storageDesign.getOwnerSet().getByName(user);
                    if (owner == null) {
                        owner = (Owner)storageDesign.getOwnerSet().createElement(null);
                        owner.setName(user);
                    }
                    rootHandler.setOwner(owner);
                } else {
                    rootHandler.setOwner(null);
                }
                importLog.incrementImportedStatements();
            } else {
                rootHandler.setOwner(null);
            }
        }
    }

    private void processCurrentSchemaSettings(DDLStatementHandler rootHandler, String line, ImportLogger importLog) {
        String statement = line.replaceAll("[ \t\n\f\r\u000b]+", " ");
        if (statement.indexOf("--") != 0 && Token.startsWithString(statement, "SET CURRENT SCHEMA")) {
            int eqpos;
            statement = line;
            int semicolPos = statement.indexOf(59);
            if (semicolPos > -1) {
                statement = statement.substring(0, semicolPos);
            }
            if ((eqpos = statement.indexOf(61)) > -1) {
                String user = statement.substring(eqpos + 1);
                if (user.indexOf("'") <= -1000) {
                    rootHandler.setOwner(null);
                } else if (!"".equalsIgnoreCase(user = Token.getName(user.trim()).trim())) {
                    RDBMSSite site = this.design.getSelectedRDBMSSite();
                    StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
                    Owner owner = (Owner)storageDesign.getOwnerSet().getByName(user);
                    if (owner == null) {
                        owner = (Owner)storageDesign.getOwnerSet().createElement(null);
                        owner.setName(user);
                    }
                    rootHandler.setOwner(owner);
                } else {
                    rootHandler.setOwner(null);
                }
                importLog.incrementImportedStatements();
            } else {
                rootHandler.setOwner(null);
            }
        }
    }

    public int getDDLType() {
        if (this.view != null) {
            Object[] choices = this.view.getCurrentDesign().getRDBMSSiteSet().toSiteArray();
            if (choices.length > 0) {
                this.site = (RDBMSSite)JListDialog.showDialog(this.view.getFrame(), Messages.getString("DDLHandler.SelectSite"), Messages.getString("DDLHandler.DatabaseSites"), choices);
                return this.getDDLTypeFor(this.site);
            }
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("DDLHandler.UnableToListSites"), Messages.getString("DDLHandler.DatabaseSites"), 0);
            return this.getDDLTypeFor(null);
        }
        return this.getDDLTypeFor(null);
    }

    private int getDDLTypeFor(RDBMSSite rdbmsSite) {
        if (rdbmsSite == null) {
            return 0;
        }
        this.site = rdbmsSite;
        return rdbmsSite.getType().getType();
    }

    private void buildDB2v70Chain() {
        this.chain = new DDLStatementHandler(this.design);
        System.gc();
        this.chain.add(new SHCreateStoragegroup(this.design));
        this.chain.add(new SHCreateDatabase(this.design));
        this.chain.add(new SHCreateTablespace(this.design));
        this.chain.add(new SHCreateTable(this.design));
        this.chain.add(new SHCreateAUXTable(this.design));
        this.chain.add(new SHCreateIndex(this.design));
        this.chain.add(new SHCreateAUXIndex(this.design));
        this.chain.add(new SHAlterTable(this.design));
        this.chain.add(new SHCreateAlias(this.design));
        this.chain.add(new SHCreateSynonym(this.design));
        this.chain.add(new SHCreateView(this.design));
        this.chain.add(new SHCreateTriggerDB2(this.design));
        this.chain.add(new SHCreateStoredProcedureDB2(this.design));
        this.chain.add(new SHLabelOn(this.design));
        this.chain.add(new SHCommentOn(this.design));
        this.chain.add(new SHGrant(this.design));
        this.chain.add(new SHCreateDistinctTypeDB2(this.design));
    }

    private void buildUDBv71Chain() {
        this.chain = new DDLStatementHandler(this.design);
        System.gc();
        this.chain.add(new SHCreateTypeUDB(this.design));
        this.chain.add(new SHCreateMethodUDB(this.design));
        this.chain.add(new SHCreateBufferPoolUDB(this.design));
        this.chain.add(new SHCreateDatabaseUDB(this.design));
        this.chain.add(new SHCreateNodeGroupUDB(this.design));
        this.chain.add(new SHCreateTablespaceUDB(this.design));
        this.chain.add(new SHCreateSchemaUDB(this.design));
        this.chain.add(new SHCreateTableUDB(this.design));
        this.chain.add(new SHCreateIndexUDB(this.design));
        this.chain.add(new SHAlterTableUDB(this.design));
        this.chain.add(new SHCreateAliasUDB(this.design));
        this.chain.add(new SHCreateViewUDB(this.design));
        this.chain.add(new SHCreateTriggerUDB(this.design));
        this.chain.add(new SHCreateStoredProcedureUDB(this.design));
        this.chain.add(new SHCreateFunctionUDB(this.design));
        this.chain.add(new SHCreateDistinctTypeUDB(this.design));
        this.chain.add(new SHGrantUDB(this.design));
        this.chain.add(new SHCommentOnUDB(this.design));
    }

    private void buildUDBv81Chain() {
        this.chain = new DDLStatementHandler(this.design);
        System.gc();
        this.chain.add(new SHCreateTypeUDBv81(this.design));
        this.chain.add(new SHCreateMethodUDB(this.design));
        this.chain.add(new SHCreateBufferPoolUDBv81(this.design));
        this.chain.add(new SHCreateDatabaseUDBv81(this.design));
        this.chain.add(new SHCreateDBPartitionGroupUDBv81(this.design));
        this.chain.add(new SHCreateTablespaceUDBv81(this.design));
        this.chain.add(new SHCreateSchemaUDB(this.design));
        this.chain.add(new SHCreateTableUDBv81(this.design));
        this.chain.add(new SHCreateIndexUDBv81(this.design));
        this.chain.add(new SHAlterTableUDBv81(this.design));
        this.chain.add(new SHCreateAliasUDB(this.design));
        this.chain.add(new SHCreateViewUDBv81(this.design));
        this.chain.add(new SHCreateTriggerUDBv81(this.design));
        this.chain.add(new SHCreateStoredProcedureUDB(this.design));
        this.chain.add(new SHCreateFunctionUDB(this.design));
        this.chain.add(new SHCreateDistinctTypeUDB(this.design));
        this.chain.add(new SHGrantUDBv81(this.design));
        this.chain.add(new SHCreateSequenceUDBv81(this.design));
        this.chain.add(new SHCommentOnUDB(this.design));
    }

    private void buildOraclev9iChain() {
        this.chain = new DDLStatementHandler(this.design);
        System.gc();
        this.chain.add(new SHAlterTableOraclev9i(this.design));
        this.chain.add(new SHCreateTableOraclev9i(this.design));
        this.chain.add(new SHCreateIndexOraclev9i(this.design));
        this.chain.add(new SHCreateViewOracle(this.design));
        this.chain.add(new SHAlterViewOracle(this.design));
        this.chain.add(new SHCreateCollectionTypeOraclev9i(this.design));
        this.chain.add(new SHCreateTypeOraclev9i(this.design));
        this.chain.add(new SHCreateTablespaceOraclev9i(this.design));
        this.chain.add(new SHCreateTemporaryTablespaceOracle(this.design));
        this.chain.add(new SHCreateUndoTablespaceOraclev9i(this.design));
        this.chain.add(new SHCreateRollbackSegment(this.design));
        this.chain.add(new SHCreateRoleOraclev9i(this.design));
        this.chain.add(new SHCreateUserOracle(this.design));
        this.chain.add(new SHCreateClusterOraclev9i(this.design));
        this.chain.add(new SHCreateContextOraclev9i(this.design));
        this.chain.add(new SHCreateExternalTableOraclev9i(this.design));
        this.chain.add(new SHCreateSnapshotOracle(this.design));
        this.chain.add(new SHCreateDimensionOraclev10g(this.design));
        this.chain.add(new SHCreateSequenceOracle(this.design));
        this.chain.add(new SHCreateSynonymOracle(this.design));
        this.chain.add(new SHCreateDirectoryOracle(this.design));
        this.chain.add(new SHCreateTriggerOracle(this.design));
        this.chain.add(new SHCreatePackageBodyOracle(this.design));
        this.chain.add(new SHCreatePackageOracle(this.design));
        this.chain.add(new SHCreateStoredProcedureOracle(this.design));
        this.chain.add(new SHCreateFunctionOracle(this.design));
        this.chain.add(new SHGrantPermissionsOraclev10g(this.design));
        this.chain.add(new SHCommentOnOracle(this.design));
        this.chain.add(new SHCreateDatabaseOraclev9i(this.design));
    }

    private void buildOraclev10gChain() {
        this.chain = new DDLStatementHandler(this.design);
        System.gc();
        this.chain.add(new SHAlterTableOraclev10g(this.design));
        this.chain.add(new SHCreateTableOraclev10g(this.design));
        this.chain.add(new SHCreateIndexOraclev9i(this.design));
        this.chain.add(new SHCreateViewOracle(this.design));
        this.chain.add(new SHAlterViewOracle(this.design));
        this.chain.add(new SHCreateCollectionTypeOraclev10g(this.design));
        this.chain.add(new SHCreateTypeOraclev10g(this.design));
        this.chain.add(new SHCreateTablespaceOraclev10g(this.design));
        this.chain.add(new SHCreateTemporaryTablespaceOraclev10g(this.design));
        this.chain.add(new SHCreateUndoTablespaceOraclev10g(this.design));
        this.chain.add(new SHCreateRollbackSegment(this.design));
        this.chain.add(new SHCreateRoleOraclev10g(this.design));
        this.chain.add(new SHCreateUserOraclev10g(this.design));
        this.chain.add(new SHCreateClusterOraclev10g(this.design));
        this.chain.add(new SHCreateContextOraclev9i(this.design));
        this.chain.add(new SHCreateExternalTableOraclev10g(this.design));
        this.chain.add(new SHCreateSnapshotOraclev10g(this.design));
        this.chain.add(new SHCreateDimensionOraclev10g(this.design));
        this.chain.add(new SHCreateSequenceOracle(this.design));
        this.chain.add(new SHCreateSynonymOracle(this.design));
        this.chain.add(new SHCreateDirectoryOracle(this.design));
        this.chain.add(new SHCreateTriggerOracle(this.design));
        this.chain.add(new SHCreatePackageBodyOracle(this.design));
        this.chain.add(new SHCreatePackageOracle(this.design));
        this.chain.add(new SHCreateStoredProcedureOracle(this.design));
        this.chain.add(new SHCreateFunctionOracle(this.design));
        this.chain.add(new SHGrantPermissionsOraclev10g(this.design));
        this.chain.add(new SHCreateDiskGroupOraclev10g(this.design));
        this.chain.add(new SHCommentOnOracle(this.design));
        this.chain.add(new SHCreateDatabaseOraclev10g(this.design));
    }

    private void buildSqlServerChain() {
        this.chainSqlServer = new DDLStatementHandlerSqlServer(this.design);
        System.gc();
        this.chainSqlServer.add(new SHCreateDatabaseSqlServer(this.design));
        this.chainSqlServer.add(new SHAlterDatabaseSqlServer(this.design));
        this.chainSqlServer.add(new SHCreateLoginSqlServer(this.design));
        this.chainSqlServer.add(new SHCreateRoleSqlServer(this.design));
        this.chainSqlServer.add(new SHGrantPrivilegesSqlServer(this.design));
        this.chainSqlServer.add(new SHCreateRuleSqlServer(this.design));
        this.chainSqlServer.add(new SHCreateTableSqlServer(this.design));
        this.chainSqlServer.add(new SHAlterTableSqlServer(this.design));
        this.chainSqlServer.add(new SHCreateViewSqlServer(this.design));
        this.chainSqlServer.add(new SHCreateIndexSqlServer(this.design));
        this.chainSqlServer.add(new SHGrantPermissionsSqlServer(this.design));
        this.chainSqlServer.add(new SHCreateDefaultSqlServer(this.design));
        this.chainSqlServer.add(new SHExtendedPropertiesSqlServer(this.design));
        this.chainSqlServer.add(new SHCreateTriggerSqlServer(this.design));
        this.chainSqlServer.add(new SHCreateStoredProcedureSqlServer(this.design));
        this.chainSqlServer.add(new SHAddDataTypeSqlServer(this.design));
    }

    private void buildSqlServerv2k5Chain() {
        this.chainSqlServer = new DDLStatementHandlerSqlServer(this.design);
        System.gc();
        this.chainSqlServer.add(new SHCreateDatabaseSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHAlterDatabaseSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateLoginSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SCHCreateSchemaSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateXMLCollectionSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHAddDataTypeSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateRoleSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHGrantPrivilegesSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateRuleSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreatePartitionFunctionSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreatePartitionSchemeSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateTableSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHAlterTableSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateViewSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateIndexSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHGrantPermissionsSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateDefaultSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHExtendedPropertiesSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateTriggerSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateStoredProcedureSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateSynonymSqlServerv2k5(this.design));
    }

    private void buildSqlServerv2k12Chain() {
        this.chainSqlServer = new DDLStatementHandlerSqlServer(this.design);
        System.gc();
        this.chainSqlServer.add(new SHCreateDatabaseSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHAlterDatabaseSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateLoginSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SCHCreateSchemaSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateXMLCollectionSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHAddDataTypeSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateRoleSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHGrantPrivilegesSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateRuleSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreatePartitionFunctionSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreatePartitionSchemeSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateTableSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHAlterTableSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateViewSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateIndexSqlServerv2k12(this.design));
        this.chainSqlServer.add(new SHGrantPermissionsSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateDefaultSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHExtendedPropertiesSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateTriggerSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateStoredProcedureSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateSynonymSqlServerv2k5(this.design));
        this.chainSqlServer.add(new SHCreateSequenceSqlServerv2k12(this.design));
    }

    private void buildDB2v80Chain() {
        this.chain = new DDLStatementHandler(this.design);
        System.gc();
        this.chain.add(new SHCreateStoragegroup(this.design));
        this.chain.add(new SHCreateDatabase(this.design));
        this.chain.add(new SHCreateTablespaceDB2v80(this.design));
        this.chain.add(new SHCreateTableDB2v80(this.design));
        this.chain.add(new SHCreateAUXTable(this.design));
        this.chain.add(new SHCreateIndexDB2v80(this.design));
        this.chain.add(new SHCreateAUXIndex(this.design));
        this.chain.add(new SHAlterTableDB2v80(this.design));
        this.chain.add(new SHCreateAlias(this.design));
        this.chain.add(new SHCreateSynonym(this.design));
        this.chain.add(new SHCreateView(this.design));
        this.chain.add(new SHCreateTriggerDB2(this.design));
        this.chain.add(new SHCreateStoredProcedureDB2(this.design));
        this.chain.add(new SHCreateSequenceDB2v80(this.design));
        this.chain.add(new SHLabelOn(this.design));
        this.chain.add(new SHCommentOn(this.design));
        this.chain.add(new SHGrant(this.design));
        this.chain.add(new SHCreateDistinctTypeDB2v80(this.design));
    }

    private void fixFKSelfReferences() {
        FKIndexAssociation fk;
        Iterator it = this.design.getRelationalDesign().getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            fk = (FKIndexAssociation)it.next();
            fk.repairSelfReference();
        }
        try {
            ApplicationView.loading = true;
            it = this.design.getRelationalDesign().getFKIndexAssociationSet().iterator();
            while (it.hasNext()) {
                fk = (FKIndexAssociation)it.next();
                fk.setMandatory(false);
            }
        }
        finally {
            ApplicationView.loading = false;
        }
        it = this.design.getRelationalDesign().getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            fk = (FKIndexAssociation)it.next();
            fk.resetMandatoryUsingColumns();
        }
    }

    public int getStatementsCount() {
        return this.statementCollection.size();
    }

    private class EmptyRunner
    implements Runnable {
        private EmptyRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DDLHandler.this.relModel.setMainViewVisible(false);
                DDLHandler.this.design.setDisableTreeUpdate(true);
                ImportLogger importLog = new ImportLogger();
                try {
                    if (DDLHandler.this.storageDesign != null) {
                        DDLHandler.this.storageDesign.setImportStorageObjectsOnly(true);
                    }
                    DDLHandler.this.monitor = new ProgressDialog(DDLHandler.this.view, "", 0, 100);
                    ApplicationView.canLogging = false;
                    try {
                        DDLHandler.this.view.setImporting(true);
                        DDLHandler.this.monitor.setNote(Messages.getString("DDLHandler.CollectDDLStatements"));
                        DDLHandler.this.monitor.setProgress(2);
                        List<String> statements = new ArrayList<String>();
                        BaseDDLFileHandler fileHandler = BaseDDLFileHandler.geDDLFileHandler(DDLHandler.this.dbType);
                        for (int i = 0; i < DDLHandler.this.files.length; ++i) {
                            fileHandler.setFile((File)DDLHandler.this.files[i]);
                            DDLHandler.this.statementFileMap.put(DDLHandler.this.statementCollection.size(), ((File)DDLHandler.this.files[i]).getName());
                            statements.addAll(fileHandler.getDDLStatements(DDLHandler.this.dbType));
                        }
                        statements = StatementsSorter.sort(statements);
                        DDLHandler.this.statementCollection.addAll(statements);
                        DDLHandler.this.design.setPropagatePKChahges(false);
                        try {
                            if (DDLHandler.this.design.getAppView().getSettings().isCreateDomainsDuringImport()) {
                                DDLHandler.this.monitor.setNote(Messages.getString("DDLHandler.ConstructDomains"));
                                DDLHandler.this.monitor.setProgress(5);
                                DDLHandler.this.constructDomains();
                            }
                            DDLHandler.this.monitor.setNote(Messages.getString("DDLHandler.ParseFile"));
                            DDLHandler.this.monitor.setProgress(10);
                            DDLHandler.this.parseFile(importLog);
                            DDLHandler.this.monitor.setProgress(100);
                            StorageDesign sd = DDLHandler.this.design.getStorageDesign(DDLHandler.this.design.getSelectedRDBMSSite());
                            sd.setOpen(true);
                            sd.setTempModel(false);
                            sd.sortCollections();
                            System.gc();
                        }
                        finally {
                            if (DDLHandler.this.design != null) {
                                DDLHandler.this.design.setPropagatePKChahges(true);
                                DDLHandler.this.design.setDisableTreeUpdate(false);
                            }
                            DDLHandler.this.view.setImporting(false);
                        }
                    }
                    finally {
                        DDLHandler.this.view.setImporting(false);
                        DDLHandler.this.monitor.close();
                        ApplicationView.canLogging = true;
                        if (DDLHandler.this.storageDesign == null) {
                            DDLHandler.this.design.getDomainSet().sort();
                            DDLHandler.this.design.getDataTypesDesign().sortCollections();
                            DDLHandler.this.design.getRelationalDesign().sortCollections();
                        }
                        ApplicationView.log(Messages.getString("DDLHandler.ImportOfDDLFileFinished"));
                    }
                }
                catch (Throwable throwable) {
                    if (DDLHandler.this.storageDesign != null) {
                        DDLHandler.this.storageDesign.setImportStorageObjectsOnly(false);
                    }
                    DDLHandler.this.view.setCurrentDesign(DDLHandler.this.design);
                    DDLHandler.this.view.getCurrentDesign().setDesignPath(DDLHandler.this.oldDesignPath);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DDLHandler.this.relModel.setMainViewVisible(true);
                            DDLHandler.this.relModel.getMainView().getTabbedPane().setSelectedIndex(0);
                            if (DDLHandler.this.storageDesign == null) {
                                DDLHandler.this.view.centerDesign();
                            }
                            if (!DDLHandler.this.relModel.getMainView().isAutoRoute()) {
                                DDLHandler.this.relModel.createDefaultSelfReferencePoints();
                            }
                            if (DDLHandler.this.relModel.getFKIndexAssociationSet().size() < 300) {
                                DDLHandler.this.relModel.setMainViewVisible(true);
                                DDLHandler.this.relModel.getMainView().getTabbedPane().setSelectedIndex(0);
                                if (DDLHandler.this.storageDesign == null) {
                                    DDLHandler.this.view.centerDesign();
                                }
                            }
                            DDLHandler.this.relModel.getMainView().setDirty(true);
                        }
                    });
                    throw throwable;
                }
                if (DDLHandler.this.storageDesign != null) {
                    DDLHandler.this.storageDesign.setImportStorageObjectsOnly(false);
                }
                DDLHandler.this.view.setCurrentDesign(DDLHandler.this.design);
                DDLHandler.this.view.getCurrentDesign().setDesignPath(DDLHandler.this.oldDesignPath);
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                if (DDLHandler.this.design.getName().startsWith(UNTITLED_DESIGN)) {
                    DDLHandler.this.design.setFileName(DDLHandler.this.databaseName);
                }
                if (DDLHandler.this.view.getSettings().showImportLog()) {
                    LogReport logPanel = new LogReport(DDLHandler.this.view);
                    logPanel.setLog(importLog.generateDDLReport(DDLHandler.this.view, DDLHandler.this.getStatementsCount()));
                    logPanel.showModalDialog(new Dimension(750, 550));
                }
            }
            catch (Exception e) {
                DDLHandler.this.view.setImporting(false);
                DDLHandler.this.design = null;
                LOGGER.error("Error Parsing File: " + DDLHandler.this.databaseName, e);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("DDLHandler.UnableToImportTheFile"), Messages.getString("DDLHandler.ErrorImportingFile"), 0);
            }
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DDLHandler.this.design.setDisableTreeUpdate(true);
                DDLHandler.this.oldDesign.setDisableTreeUpdate(true);
                ImportLogger importLog = new ImportLogger();
                try {
                    if (DDLHandler.this.storageDesign != null) {
                        DDLHandler.this.storageDesign.setImportStorageObjectsOnly(true);
                    }
                    DDLHandler.this.monitor = new ProgressDialog(DDLHandler.this.view, "", 0, 100);
                    ApplicationView.canLogging = false;
                    try {
                        DDLHandler.this.view.setImporting(true);
                        DDLHandler.this.monitor.setNote(Messages.getString("DDLHandler.CollectDDLStatements"));
                        DDLHandler.this.monitor.setProgress(2);
                        List<String> statements = new ArrayList<String>();
                        BaseDDLFileHandler fileHandler = BaseDDLFileHandler.geDDLFileHandler(DDLHandler.this.dbType);
                        for (int i = 0; i < DDLHandler.this.files.length; ++i) {
                            fileHandler.setFile((File)DDLHandler.this.files[i]);
                            DDLHandler.this.statementFileMap.put(DDLHandler.this.statementCollection.size(), ((File)DDLHandler.this.files[i]).getName());
                            statements.addAll(fileHandler.getDDLStatements(DDLHandler.this.dbType));
                        }
                        statements = StatementsSorter.sort(statements);
                        DDLHandler.this.statementCollection.addAll(statements);
                        DDLHandler.this.design.setPropagatePKChahges(false);
                        try {
                            DDLHandler.this.design.getStorageDesign(DDLHandler.this.design.getSelectedRDBMSSite()).setOpen(true);
                            if (DDLHandler.this.design.getAppView().getSettings().isCreateDomainsDuringImport()) {
                                DDLHandler.this.monitor.setNote(Messages.getString("DDLHandler.ConstructDomains"));
                                DDLHandler.this.monitor.setProgress(5);
                                DDLHandler.this.constructDomains();
                            }
                            DDLHandler.this.monitor.setNote(Messages.getString("DDLHandler.ParseFile"));
                            DDLHandler.this.monitor.setProgress(10);
                            DDLHandler.this.parseFile(importLog);
                            DDLHandler.this.monitor.setProgress(100);
                            DDLHandler.this.design.getStorageDesign(DDLHandler.this.design.getSelectedRDBMSSite()).setTempModel(false);
                            DDLHandler.this.design.getStorageDesign(DDLHandler.this.design.getSelectedRDBMSSite()).sortCollections();
                            System.gc();
                        }
                        finally {
                            DDLHandler.this.design.setPropagatePKChahges(true);
                            DDLHandler.this.design.setDisableTreeUpdate(false);
                            DDLHandler.this.oldDesign.setDisableTreeUpdate(false);
                            DDLHandler.this.view.setImporting(false);
                        }
                    }
                    finally {
                        DDLHandler.this.view.setImporting(false);
                        DDLHandler.this.monitor.close();
                        ApplicationView.canLogging = true;
                        if (DDLHandler.this.storageDesign == null) {
                            DDLHandler.this.design.getDomainSet().sort();
                            DDLHandler.this.design.getDataTypesDesign().sortCollections();
                            DDLHandler.this.design.getRelationalDesign().sortCollections();
                            DDLHandler.this.design.getRelationalDesign().getStorageDesign().sortCollections();
                        }
                        ApplicationView.log(Messages.getString("DDLHandler.ImportOfDDLFileFinished"));
                    }
                }
                finally {
                    if (DDLHandler.this.storageDesign != null) {
                        DDLHandler.this.storageDesign.setImportStorageObjectsOnly(false);
                    }
                }
                if (DDLHandler.this.view.getSettings().showImportLog()) {
                    LogReport logPanel = new LogReport(DDLHandler.this.view);
                    logPanel.setLog(importLog.generateDDLReport(DDLHandler.this.view, DDLHandler.this.getStatementsCount()));
                    logPanel.showModalDialog(new Dimension(750, 550));
                }
                RelationalDesign sourceModel = DDLHandler.this.design.getRelationalDesign();
                boolean noDDLPreview = DDLHandler.this.relModel == null || DDLHandler.this.relModel.isEmpty();
                DDLHandler.this.design = DDLHandler.this.oldDesign;
                DDLHandler.this.view.setCurrentDesign(DDLHandler.this.design);
                DDLHandler.this.view.getCurrentDesign().setDesignPath(DDLHandler.this.oldDesignPath);
                DDLHandler.this.design.getStorageDesign(DDLHandler.this.design.getSelectedRDBMSSite()).setOpen(true);
                DDLHandler.this.design.getStorageDesign(DDLHandler.this.design.getSelectedRDBMSSite()).setTempModel(false);
                DDLHandler.this.design.getStorageDesign(DDLHandler.this.design.getSelectedRDBMSSite()).setDirty(true);
                try {
                    CompareModelsDialog compareDialog;
                    PropertiesComparator.DDL_ONLY = true;
                    ModelChooserDialog.isSelectedDatabase = true;
                    if (DDLHandler.this.swapTargetModel) {
                        compareDialog = new CompareModelsDialog(DDLHandler.this.view, DDLHandler.this.design.getRelationalDesign(), sourceModel, noDDLPreview, DDLHandler.this.isNewModel, true, DDLHandler.this.oldStorageDesigns);
                        compareDialog.setImporting(true);
                    } else {
                        compareDialog = new CompareModelsDialog(DDLHandler.this.view, sourceModel, DDLHandler.this.design.getRelationalDesign(), noDDLPreview, DDLHandler.this.isNewModel, false, DDLHandler.this.oldStorageDesigns);
                        compareDialog.setImporting(true);
                    }
                    DDLHandler.this.view.setMerging(false);
                    compareDialog.show();
                }
                finally {
                    PropertiesComparator.DDL_ONLY = false;
                }
                DDLHandler.this.view.setMerging(false);
            }
            catch (Exception e) {
                DDLHandler.this.view.setImporting(false);
                DDLHandler.this.design = DDLHandler.this.oldDesign;
                DDLHandler.this.view.setCurrentDesign(DDLHandler.this.design);
                DDLHandler.this.view.getCurrentDesign().setDesignPath(DDLHandler.this.oldDesignPath);
                DDLHandler.this.design = null;
                LOGGER.error("Error Parsing File: " + DDLHandler.this.databaseName, e);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("DDLHandler.UnableToImportTheFile"), Messages.getString("DDLHandler.ErrorImportingFile"), 0);
            }
        }
    }
}

