/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.IndexProxyDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateIndex
extends DDLStatementHandler {
    private Index index;
    private Table table;
    private String indexName = "";
    private AbstractStorageDesignDB2 stoDesign;
    private boolean unique;
    private boolean failed = false;
    private static final Logger LOGGER = new Logger(SHCreateIndex.class);
    boolean hasIntegrIndex = false;

    public SHCreateIndex(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateIndex.clearCR(line);
        if (Token.startsWithString(statement, "create index") || Token.startsWithString(statement, "create unique index") || Token.startsWithString(statement, "create unique where not null index") || Token.startsWithString(statement, "create type 2 index") || Token.startsWithString(statement, "create type 2 unique index") || Token.startsWithString(statement, "create type 2 unique where not null index") || Token.startsWithString(statement, "create type 1 index") || Token.startsWithString(statement, "create type 1 unique index") || Token.startsWithString(statement, "create type 1 unique where not null index")) {
            this.statement = statement;
            if (this.isTableIndex()) {
                try {
                    this.createIndex();
                    if (this.failed) {
                        this.importLog.addFailedStatement(SHCreateIndex.FormatCR(line, "\n"));
                    } else {
                        this.importLog.incrementImportedStatements();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Parsing " + statement + " for DB2 7.0 failed!", e);
                    this.importLog.addFailedStatement(SHCreateIndex.FormatCR(line, "\n"));
                }
                this.index = null;
                this.table = null;
                this.indexName = "";
                this.stoDesign = null;
                this.unique = false;
                this.failed = false;
            } else {
                this.nextHandler(line);
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void createIndex() {
        try {
            this.indexName = this.initIndexName();
            this.unique = Token.hasToken(this.statement, "UNIQUE");
            this.hasIntegrIndex = false;
            List cnames = this.getColumnsName();
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            this.stoDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
            if (this.table != null) {
                if (this.stoDesign != null && this.stoDesign.importStorageObjectsOnly()) {
                    this.index = this.table.getIndexByName(this.indexName);
                } else {
                    this.constructIndex(this.makeNames(cnames));
                }
            }
            if (this.index != null) {
                IndexProxyDB2v70 indexProxy;
                if (!this.stoDesign.importStorageObjectsOnly()) {
                    if (this.unique && !this.index.isPK() && !this.index.isUnique()) {
                        this.index.setIndexState("Unique Plain Index");
                    }
                    this.setColumnForIndex(cnames);
                }
                if (this.stoDesign != null && (indexProxy = (IndexProxyDB2v70)this.stoDesign.getIndexProxySet().getProxy(this.index.getObjectID())) != null) {
                    indexProxy.setProcessedInDDLImport(true);
                    StorageTemplateDB2 st = this.stoDesign.getStorageTemplateSet().createStorageTemplate();
                    indexProxy.setName(this.indexName);
                    this.design.getRelationalDesign().stampModelObjectDDL(st);
                    indexProxy.setStorageTemplate(st);
                    this.initNotNull(indexProxy);
                    int positionFirstCloseBracket = this.statement.indexOf(41);
                    String usingString = this.statement.substring(positionFirstCloseBracket + 1).trim();
                    int positionSecondOpenBracket = usingString.indexOf(40);
                    if (positionSecondOpenBracket > 0) {
                        usingString = usingString.substring(0, positionSecondOpenBracket);
                    }
                    this.initUsingBlock(indexProxy, usingString);
                    this.initFreeBlock(indexProxy, usingString);
                    this.initGbpcacheBlock(indexProxy, usingString);
                    this.initDefine(indexProxy, usingString);
                    this.initCluster(indexProxy);
                    this.initBufferpool(indexProxy);
                    this.initClose(indexProxy);
                    this.initDefer(indexProxy);
                    this.initCopy(indexProxy);
                    this.initPieceSize(indexProxy);
                    this.initOwner(indexProxy);
                    StorageTemplateDB2 realst = this.stoDesign.getStorageTemplateSet().removeIfExistEqual(indexProxy.getStorageTemplate());
                    if (realst != indexProxy.getStorageTemplate()) {
                        indexProxy.setStorageTemplate(realst);
                    }
                }
            }
        }
        catch (RuntimeException e) {
            StringBuffer message = new StringBuffer(e.getMessage());
            message.append(" in SHCreateIndex.createIndex");
            LOGGER.error(message.toString(), e);
            this.importLog.addError("Creating index for statement " + this.statement + " for DB2 failed");
            this.failed = true;
        }
    }

    public boolean columnsBelongToIndex(Object[] colNames, Index ind) {
        if (ind != null) {
            ContainedObject[] cols = ind.getElements();
            if (cols.length != colNames.length) {
                return false;
            }
            for (int i = 0; i < cols.length; ++i) {
                if (cols[i].getName().equalsIgnoreCase((String)colNames[i])) continue;
                return false;
            }
        }
        return true;
    }

    private void constructIndex(Object[] colNames) {
        Index ind;
        int i;
        Index pk;
        if (this.unique && this.table.hasPK() && !this.hasIntegrIndex && (pk = (Index)this.table.getPK()).getName().equalsIgnoreCase(this.indexName)) {
            this.index = pk;
            return;
        }
        Index[] indexes = (Index[])this.table.getKeys();
        if (this.unique && !this.hasIntegrIndex) {
            for (i = 0; i < indexes.length; ++i) {
                ind = indexes[i];
                if (!ind.isUnique() || !ind.getName().equalsIgnoreCase(this.indexName)) continue;
                this.index = ind;
                return;
            }
        }
        for (i = 0; i < indexes.length; ++i) {
            ind = indexes[i];
            if (!ind.getName().equalsIgnoreCase(this.indexName) || !this.columnsBelongToIndex(colNames, ind)) continue;
            this.index = ind;
            break;
        }
        if (this.index == null || !this.index.getName().equalsIgnoreCase(this.indexName)) {
            this.index = this.table.createIndex();
            this.index.setName(this.indexName);
            this.design.getRelationalDesign().stampModelObjectDDL(this.index);
        }
    }

    private void initNotNull(IndexProxyDB2 indexProxy) {
        boolean hasWhere;
        if (!this.index.isPK() && (hasWhere = Token.hasToken(this.statement, "WHERE"))) {
            indexProxy.setWhereNotNull(true);
        }
    }

    private String initIndexName() {
        String name = Token.getNameAfterToken(this.statement, "INDEX", '\"', '\"').trim();
        if (name.indexOf(46) > -1) {
            name = Token.getValAfterCharacter(name, '.');
        }
        return name;
    }

    private void setColumnForIndex(List cnames) {
        for (ColNameSortOrder cns : cnames) {
            Column columnTable = (Column)this.table.getElementByName(cns.cname);
            this.index.add(columnTable);
            this.index.setColumnSortOrder(columnTable, cns.sortOrder);
        }
    }

    private List getColumnsName() {
        int size = 0;
        ArrayList<ColNameSortOrder> sortMap = new ArrayList<ColNameSortOrder>();
        if (this.table != null) {
            size = this.table.getElements().length;
        }
        if (size > 0) {
            String columnString = Token.getValBetweenBrackets(this.statement, 1);
            boolean functionString = Token.hasCloseAndOpenBrackets(columnString);
            if (functionString) {
                this.index.setIndexExpression(columnString);
                return sortMap;
            }
            columnString = Token.getNamesOnly(columnString);
            StringTokenizer columnToken = new StringTokenizer(columnString, ",");
            while (columnToken.hasMoreTokens()) {
                String columnName = columnToken.nextToken().trim();
                String sortOrder = "ASC";
                int posColumnSpace = columnName.indexOf(" ");
                if (posColumnSpace > 0) {
                    try {
                        if (columnName.substring(posColumnSpace + 1).trim().equalsIgnoreCase("DESC")) {
                            sortOrder = "DESC";
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    columnName = columnName.substring(0, posColumnSpace);
                }
                sortMap.add(new ColNameSortOrder(columnName, sortOrder));
            }
        }
        return sortMap;
    }

    private String getTableName() {
        int posPoint;
        String name = Token.getNameAfterToken(this.statement, "ON", '\"', '\"');
        if (name.indexOf(40) > -1) {
            name = name.substring(0, name.indexOf(40));
        }
        if ((posPoint = name.indexOf(46)) > 0) {
            name = Token.getValAfterCharacter(name, '.');
        }
        return name;
    }

    private void initUsingBlock(IndexProxyDB2 indexProxy, String usingStatement) {
        boolean hasUsing = Token.hasToken(usingStatement, "USING");
        if (hasUsing) {
            String using = Token.getTokenAfter(usingStatement, "USING").trim();
            if (using.equalsIgnoreCase("VCAT")) {
                String vcatName = Token.getTokenAfter(usingStatement, "VCAT").trim();
                for (VCatDB2 vcat : this.stoDesign.getVCatSet()) {
                    if (!vcat.getName().equalsIgnoreCase(vcatName)) continue;
                    indexProxy.getStorageTemplate().setVCat(vcat);
                    break;
                }
            } else if (using.equalsIgnoreCase("STOGROUP")) {
                String stogroupName = Token.getTokenAfter(usingStatement, "STOGROUP").trim();
                StorageGroupSetDB2 stoGroupSet = this.stoDesign.getStorageGroupSet();
                indexProxy.getStorageTemplate().setStorageGroup(stoGroupSet.getOrCreateStorageGroup(stogroupName));
                try {
                    String secqtyString;
                    String priqtyString = Token.getTokenAfter(usingStatement, "PRIQTY").trim();
                    if (!priqtyString.equals("")) {
                        int priqty = Integer.parseInt(priqtyString);
                        indexProxy.getStorageTemplate().setSgPriqty(priqty);
                    }
                    if (!(secqtyString = Token.getTokenAfter(usingStatement, "SECQTY").trim()).equals("")) {
                        int secqty = Integer.parseInt(secqtyString);
                        indexProxy.getStorageTemplate().setSgSeqty(secqty);
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Wrong format in SHCreateIndex.initUsingBlock():", e);
                    this.importLog.addWarning("Wrong using block format in statement " + this.statement);
                }
                String erase = Token.getTokenAfter(this.statement, "ERASE").trim();
                if (erase.equalsIgnoreCase("YES")) {
                    indexProxy.getStorageTemplate().setSgErase(true);
                }
            }
        }
    }

    private void initFreeBlock(IndexProxyDB2 indexProxy, String freeString) {
        try {
            String pctfreeString;
            String freepageString = Token.getTokenAfter(freeString, "FREEPAGE").trim();
            if (!freepageString.equals("")) {
                int freepage = Integer.parseInt(freepageString);
                indexProxy.getStorageTemplate().setFreePage(freepage);
            }
            if (!(pctfreeString = Token.getTokenAfter(freeString, "PCTFREE").trim()).equals("")) {
                int pctfree = Integer.parseInt(pctfreeString);
                indexProxy.getStorageTemplate().setPctFree(pctfree);
            } else {
                indexProxy.getStorageTemplate().setPctFree(10);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error("Wrong format in SHCreateIndex.initFreeBlock:", e);
            this.importLog.addWarning("Wrong free block format in statement " + this.statement);
        }
    }

    private void initGbpcacheBlock(IndexProxyDB2 indexProxy, String gbpCacheString) {
        boolean hasGpb = Token.hasToken(gbpCacheString, "GBPCACHE");
        if (hasGpb) {
            String gbpcache = Token.getTokenAfter(gbpCacheString, "GBPCACHE").trim().toUpperCase();
            String[] choises = StorageTemplateDB2.getGBCacheValues();
            for (int i = 0; i < choises.length; ++i) {
                if (!gbpcache.equalsIgnoreCase(choises[i])) continue;
                indexProxy.getStorageTemplate().setGbCache(choises[i]);
            }
        }
    }

    private void initDefine(IndexProxyDB2 indexProxy, String defineString) {
        boolean hasDefine = Token.hasToken(defineString, "DEFINE");
        if (hasDefine) {
            String define = Token.getTokenAfter(defineString, "DEFINE").trim();
            if (define.equalsIgnoreCase("YES")) {
                indexProxy.getStorageTemplate().setDefine(true);
            } else if (define.equalsIgnoreCase("NO")) {
                indexProxy.getStorageTemplate().setDefine(false);
            }
        }
    }

    private void initCluster(IndexProxyDB2v70 indexProxy) {
        boolean hasCluster = Token.hasToken(this.statement, "CLUSTER");
        if (hasCluster) {
            int positionCluster = this.statement.indexOf("CLUSTER");
            String afterCluster = this.statement.substring(positionCluster);
            if (!(afterCluster = Token.getValBetweenBrackets(afterCluster).trim()).equalsIgnoreCase("")) {
                indexProxy.setClusterType(IndexProxyDB2.CLUSTER_TYPES[2]);
                if (((TableProxyDB2)indexProxy.getTableProxy()).getTableSpace() != null) {
                    ((TableProxyDB2)indexProxy.getTableProxy()).getTableSpace().setPartIndex(indexProxy);
                }
                StringTokenizer parts = new StringTokenizer(afterCluster, ",");
                int pos = 0;
                while (parts.hasMoreElements()) {
                    String part = parts.nextToken().trim();
                    IndexPartitionDB2 indexPartition = this.stoDesign.getIndexPartitionSet().createIndexPartition();
                    this.design.getRelationalDesign().stampModelObjectDDL(indexPartition);
                    indexPartition.setPartNumber(++pos);
                    StorageTemplateDB2 st = this.stoDesign.getStorageTemplateSet().createStorageTemplate();
                    this.design.getRelationalDesign().stampModelObjectDDL(st);
                    indexPartition.setStorageTemplate(st);
                    indexPartition.setIndex(indexProxy);
                    this.initUsingBlockPart(part, indexPartition);
                    this.initFreeBlockPart(part, indexPartition);
                    this.initGbpcacheBlockPart(part, indexPartition);
                    this.initConstantsBlockPart(part, indexPartition);
                    StorageTemplateDB2 realst = this.stoDesign.getStorageTemplateSet().removeIfExistEqual(indexPartition.getStorageTemplate());
                    if (realst == indexProxy.getStorageTemplate()) continue;
                    indexPartition.setStorageTemplate(realst);
                }
            } else {
                indexProxy.setClusterType(IndexProxyDB2.CLUSTER_TYPES[1]);
                indexProxy.setClustered(true);
            }
        }
    }

    private void initUsingBlockPart(String partString, IndexPartitionDB2 partition) {
        String using = Token.getTokenAfter(partString, "USING").trim();
        if (using.equalsIgnoreCase("VCAT")) {
            String vcatName = Token.getTokenAfter(partString, "VCAT").trim();
            VCatDB2 vcat = this.stoDesign.getVCatSet().getOrCreateVCat(vcatName);
            partition.getStorageTemplate().setVCat(vcat);
        } else if (using.equalsIgnoreCase("STOGROUP")) {
            String stogroupName = Token.getTokenAfter(partString, "STOGROUP").trim();
            StorageGroupSetDB2 stoGroupSet = this.stoDesign.getStorageGroupSet();
            partition.getStorageTemplate().setStorageGroup(stoGroupSet.getOrCreateStorageGroup(stogroupName));
            try {
                String secqtyString;
                String priqtyString = Token.getTokenAfter(partString, "PRIQTY").trim();
                if (!priqtyString.equals("")) {
                    int priqty = Integer.parseInt(priqtyString);
                    partition.getStorageTemplate().setSgPriqty(priqty);
                }
                if (!(secqtyString = Token.getTokenAfter(partString, "SECQTY").trim()).equals("")) {
                    int secqty = Integer.parseInt(secqtyString);
                    partition.getStorageTemplate().setSgSeqty(secqty);
                }
            }
            catch (NumberFormatException e) {
                StringBuffer message = new StringBuffer("wrong format in SHCreateTablespace.initUsingBlockPart: ");
                message.append(e.getMessage());
                LOGGER.error(message.toString(), e);
                this.importLog.addWarning("Wrong using block part format in statement " + this.statement);
            }
            String erase = Token.getTokenAfter(partString, "ERASE").trim();
            if (erase.equalsIgnoreCase("YES")) {
                partition.getStorageTemplate().setSgErase(true);
            }
        }
    }

    private void initFreeBlockPart(String partString, IndexPartitionDB2 partition) {
        try {
            String pctfreeString;
            String freepageString = Token.getTokenAfter(partString, "FREEPAGE").trim();
            if (!freepageString.equals("")) {
                int freepage = Integer.parseInt(freepageString);
                partition.getStorageTemplate().setFreePage(freepage);
            }
            if (!(pctfreeString = Token.getTokenAfter(partString, "PCTFREE").trim()).equals("")) {
                int pctfree = Integer.parseInt(pctfreeString);
                partition.getStorageTemplate().setPctFree(pctfree);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong format in SHCreateTablespace.initFreeBlockPart: ");
            message.append(e.getMessage());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong using free block part format in statement " + this.statement);
        }
    }

    private void initGbpcacheBlockPart(String partString, IndexPartitionDB2 partition) {
        String gbpcache = Token.getTokenAfter(partString, "GBPCACHE").trim().toUpperCase();
        if (!gbpcache.equals("")) {
            String[] choices = StorageTemplateDB2.getGBCacheValues();
            for (int i = 0; i < choices.length; ++i) {
                if (!gbpcache.equalsIgnoreCase(choices[i])) continue;
                partition.getStorageTemplate().setGbCache(choices[i]);
            }
        }
    }

    private void initConstantsBlockPart(String partString, IndexPartitionDB2 partition) {
        String constants = Token.getValBetweenBrackets(partString).trim();
        if (!constants.equals("")) {
            partition.setPartConstants(constants);
        }
    }

    private void initBufferpool(IndexProxyDB2 indexProxy) {
        String nameBP = Token.getTokenAfter(this.statement, "BUFFERPOOL").trim();
        BufferPoolSetDB2 bpSet = this.stoDesign.getBufferPoolSet();
        for (BufferPoolDB2 bufferPool : bpSet) {
            if (!bufferPool.getName().equalsIgnoreCase(nameBP)) continue;
            indexProxy.setBufferPool(bufferPool);
        }
    }

    private void initClose(IndexProxyDB2 indexProxy) {
        String close = Token.getTokenAfter(this.statement, "CLOSE").trim();
        if (close.equalsIgnoreCase("NO")) {
            indexProxy.setClose(false);
        }
    }

    private void initDefer(IndexProxyDB2 indexProxy) {
        String defer = Token.getTokenAfter(this.statement, "DEFER").trim();
        if (defer.equalsIgnoreCase("YES")) {
            indexProxy.setDefer(true);
        }
    }

    private void initCopy(IndexProxyDB2 indexProxy) {
        String copy = Token.getTokenAfter(this.statement, "COPY").trim();
        if (copy.equalsIgnoreCase("YES")) {
            indexProxy.setCopy(true);
        }
    }

    private void initPieceSize(IndexProxyDB2 indexProxy) {
        String pieceSize = Token.getStringAfter(this.statement, "PIECESIZE").trim();
        if (!pieceSize.equals("")) {
            if (!pieceSize.endsWith("K") && pieceSize.endsWith("M") && pieceSize.endsWith("G")) {
                pieceSize = Token.getStringAfterToken(this.statement, "PIECESIZE");
                pieceSize = Token.getTokens(pieceSize, 1, 2);
            }
            if (pieceSize.endsWith("M")) {
                try {
                    int ps = Integer.parseInt(pieceSize.substring(0, pieceSize.length() - 2));
                    pieceSize = String.valueOf(ps *= 1024) + " K";
                }
                catch (NumberFormatException e) {
                    pieceSize = "2097152 K";
                }
            } else if (pieceSize.endsWith("G")) {
                try {
                    int ps = Integer.parseInt(pieceSize.substring(0, pieceSize.length() - 1).trim());
                    pieceSize = String.valueOf(ps *= 0x100000) + " K";
                }
                catch (NumberFormatException e) {
                    pieceSize = "2097152 K";
                }
            }
            indexProxy.setPieceSize(pieceSize);
        }
    }

    private void initOwner(IndexProxyDB2 indexProxy) {
        String ownerName = Token.getValBeforeCharacter(Token.getTokenAfter(this.statement, "INDEX").trim(), '.');
        if (!ownerName.equalsIgnoreCase("")) {
            Owner owner = (Owner)((AbstractStorageDesignDB2)indexProxy.getStorageDesign()).getOwnerSet().getByName(ownerName);
            if (owner == null) {
                owner = (Owner)((AbstractStorageDesignDB2)indexProxy.getStorageDesign()).getOwnerSet().createElement(null);
                owner.setName(ownerName);
                this.design.getRelationalDesign().stampModelObjectDDL(owner);
            }
            indexProxy.setOwner(owner);
        } else if (this.getOwner() != null) {
            indexProxy.setOwner(this.getOwner());
        }
    }

    private boolean isTableIndex() {
        String tableName = this.getTableName();
        this.table = (Table)this.design.getRelationalDesign().getTableSet().getByName(tableName);
        return this.table != null;
    }

    private Object[] makeNames(List list) {
        ArrayList<String> names = new ArrayList<String>();
        for (ColNameSortOrder cns : list) {
            names.add(cns.cname);
        }
        return names.toArray();
    }

    private class ColNameSortOrder {
        String cname;
        String sortOrder;

        ColNameSortOrder(String name, String sortOrder) {
            this.sortOrder = sortOrder;
            this.cname = name;
        }
    }
}

