/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.db2.v80;

import java.util.Arrays;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.db2.SHAlterTable;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.util.logging.Logger;

public class SHAlterTableDB2v80
extends SHAlterTable {
    protected static final Logger LOGGER = new Logger(SHAlterTableDB2v80.class);

    public SHAlterTableDB2v80(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHAlterTableDB2v80.clearCR(line);
        if (Token.startsWithString(statement, "alter table") && (this.isUK(statement) || this.isPK(statement) || this.isFK(statement) || this.isCheck(statement))) {
            try {
                if (this.isPK(statement) || this.isUK(statement) || this.isFK(statement) || this.isCheck(statement)) {
                    this.parseAlterTable(statement);
                } else {
                    this.statemensList.add(statement);
                }
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error("Parsing " + statement + " for DB2 8.0 failed!", e);
                this.importLog.addFailedStatement(SHAlterTableDB2v80.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    @Override
    public void parseAlterTable(String altStatement2) {
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        AbstractStorageDesignDB2 storageDesign = (AbstractStorageDesignDB2)this.design.getStorageDesign(site);
        if (!storageDesign.importStorageObjectsOnly()) {
            this.initTable(altStatement2);
            if (this.table != null) {
                String[] splittedConstr = altStatement2.split(" ADD ");
                if (splittedConstr.length == 1) {
                    splittedConstr = altStatement2.split(" add ");
                }
                for (String altStatement2 : Arrays.asList(splittedConstr)) {
                    if (this.isPK(altStatement2)) {
                        this.initPK(altStatement2);
                        continue;
                    }
                    if (this.isUK(altStatement2)) {
                        this.initUnique(altStatement2);
                        continue;
                    }
                    if (this.isFK(altStatement2)) {
                        this.initForeignKey(altStatement2);
                        continue;
                    }
                    if (!this.isCheck(altStatement2)) continue;
                    this.initCheck(altStatement2);
                }
            }
        }
    }

    @Override
    public void processForeignKeys() {
        for (String alterStatement : this.statemensList) {
            this.parseAlterTable(alterStatement);
        }
    }

    private void initCheck(String constr) {
        this.statement = constr;
        if (this.statement.trim().startsWith("(")) {
            this.statement = Token.getValBetweenBrackets(this.statement);
        }
        String constrName = null;
        if (Token.hasToken(this.statement.toUpperCase(), "CONSTRAINT")) {
            constrName = Token.getQuotedNameAfterToken(this.statement, "CONSTRAINT").trim();
        } else {
            String tableName = this.table.getName();
            if (tableName.length() > 123) {
                tableName = tableName.substring(0, 123);
            }
            constrName = tableName + "_CK" + this.table.getCheckConstraints().size();
        }
        String condition = Token.getValBetweenBrackets(Token.getStringAfter(this.statement, "CHECK")).trim();
        try {
            CheckConstraint check;
            Column column = this.getColumnForConstr(this.table, condition);
            if (column != null && (check = column.getCheck()) == null) {
                CheckConstraint constraint = new CheckConstraint();
                constraint.add(this.design.getSelectedRDBMSType(), condition);
                column.setUseDomainConstraints(false);
                column.parseAndSetCheckConstraint(constraint);
                column.setConstraintName(constrName);
                this.design.getRelationalDesign().stampModelObjectDDL(constraint);
                return;
            }
        }
        catch (Exception column) {
            // empty catch block
        }
        TableLevelConstraint constraint = this.table.createCheckConstraint(constrName, condition);
        this.table.addCheckConstraint(constraint);
        this.design.getRelationalDesign().stampModelObjectDDL(constraint);
    }

    private Column getColumnForConstr(Table table, String condition) {
        String check = condition.toUpperCase();
        ContainedObject[] cols = table.getElements();
        Column col = null;
        boolean found = false;
        for (int i = 0; i < cols.length; ++i) {
            col = (Column)cols[i];
            String name = col.getName().toUpperCase();
            if (check.indexOf(name) <= -1) continue;
            found = true;
            for (int k = 0; k < cols.length; ++k) {
                String c2name;
                Column c2 = (Column)cols[k];
                if (col == c2 || check.indexOf(c2name = c2.getName().toUpperCase()) <= -1) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return col;
        }
        return null;
    }
}

