/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.ViewIndex;
import oracle.dbtools.crest.util.logging.Logger;

public class SHAlterViewOracle
extends DDLStatementHandler {
    private TableView view;
    private String line;
    private FKIndexAssociation fkass = null;
    private static final Logger LOGGER = new Logger(SHAlterViewOracle.class);

    public SHAlterViewOracle(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHAlterViewOracle.clearCR(line);
        this.line = line;
        this.statement = statement;
        if (Token.startsWithString(statement, "ALTER VIEW")) {
            this.parseAlterView(statement);
        } else {
            this.nextHandler(line);
        }
    }

    private void parseAlterView(String statement) {
        try {
            this.initView();
            if (this.view != null) {
                String clause = Token.getStringAfter(statement, "ADD").trim();
                if (clause.length() > 0) {
                    this.processClause(clause);
                } else {
                    clause = Token.getStringAfter(statement, "MODIFY CONSTRAINT").trim();
                    if (clause.length() > 0) {
                        this.parseModify(clause);
                    }
                }
                this.importLog.incrementImportedStatements();
            }
        }
        catch (Exception e) {
            LOGGER.error(" Parsing " + statement + " for Oracle failed!", e);
            this.importLog.addFailedStatement(SHAlterViewOracle.FormatCR(this.line, "\n"));
        }
    }

    private void parseModify(String clause) {
        if (Token.hasToken(clause, "RELY")) {
            String constraintName = Token.getFirstName(clause, '\"', '\"');
            ViewIndex index = (ViewIndex)this.view.getKeySet().getByName(constraintName);
            if (index != null && index.isFK() && index.getFKAssociation() != null) {
                index.getFKAssociation().setRely(true);
            }
        }
    }

    private void processClause(String clause) {
        if (this.isFK(clause)) {
            this.parseFK(clause);
        } else if (this.isPK(clause)) {
            this.initPK(clause);
        } else if (this.isUK(clause)) {
            this.initUK(clause);
        }
    }

    private boolean isFK(String st) {
        return Token.hasToken(st, "FOREIGN");
    }

    private boolean isPK(String st) {
        return st.toUpperCase(Locale.ENGLISH).indexOf("PRIMARY KEY") > -1;
    }

    private boolean isUK(String st) {
        return Token.hasToken(st, "UNIQUE");
    }

    public void parseFK(String statement) {
        this.fkass = null;
        if (statement.trim().startsWith("(")) {
            statement = Token.getValBetweenBrackets(statement);
        }
        this.statement = statement;
        int index = statement.toUpperCase(Locale.ENGLISH).indexOf("CONSTRAINT");
        if (index < 0) {
            index = statement.toUpperCase(Locale.ENGLISH).indexOf("FOREIGN");
        }
        if (index > -1) {
            String fks = statement.substring(index);
            String constr = null;
            StringTokenizer tokenizer = new StringTokenizer(fks, ",");
            while (tokenizer.hasMoreTokens()) {
                constr = tokenizer.nextToken().trim();
                while (Token.hasOpenBracketNoClose(constr) && tokenizer.hasMoreTokens()) {
                    constr = constr + ", " + tokenizer.nextToken().trim();
                }
                if (this.view == null || !this.isFK(constr)) continue;
                this.initForeignKey(constr);
            }
        }
    }

    private void initForeignKey(String statement) {
        String stringWithFK = statement;
        if (stringWithFK.trim().startsWith("(")) {
            stringWithFK = Token.getValBetweenBrackets(stringWithFK);
        }
        boolean hasForeignKey = Token.hasToken(stringWithFK, "FOREIGN");
        while (hasForeignKey) {
            FKContainer tableRef;
            String nameFK;
            int positionForeign = stringWithFK.toUpperCase(Locale.ENGLISH).indexOf("FOREIGN");
            String fkString = stringWithFK.substring(positionForeign);
            boolean needsQuotes = false;
            if (Token.hasToken(stringWithFK, "CONSTRAINT")) {
                String afterConstraint = Token.getStringAfterToken(stringWithFK, "CONSTRAINT");
                nameFK = Token.getFirstName(afterConstraint, '\"', '\"');
                needsQuotes = afterConstraint.startsWith("\"") && !nameFK.equals(nameFK.toUpperCase());
            } else {
                String viewName = this.view.getName();
                if (viewName.length() > 25) {
                    viewName = viewName.substring(0, 25);
                }
                nameFK = viewName + "_FK" + this.view.getFKAssociationsCount();
            }
            int positionBracket = fkString.indexOf(41);
            String firstBrackets = fkString.substring(0, positionBracket + 1).trim();
            String columns = Token.getValBetweenBrackets(firstBrackets);
            List columnNames = this.getColumnNames(columns);
            ArrayList<FKElement> columnsRef = new ArrayList<FKElement>();
            FKElement[] columnSet = (FKElement[])this.view.getElementsAndNestedElements();
            block1: for (String name : columnNames) {
                for (int ci = 0; ci < columnSet.length; ++ci) {
                    String colname = columnSet[ci].getName();
                    if (!name.equalsIgnoreCase(colname)) continue;
                    columnsRef.add(columnSet[ci]);
                    continue block1;
                }
            }
            fkString = Token.getStringAfterToken(fkString, "REFERENCES");
            String nameReferenced = Token.getFirstName(fkString, '\"', '\"');
            String userName = "";
            String nameRef = nameReferenced;
            int dotIndex = nameReferenced.indexOf(46);
            if (dotIndex > -1) {
                userName = nameReferenced.substring(0, dotIndex);
                nameRef = nameReferenced.substring(dotIndex + 1);
            }
            if ((tableRef = SHAlterViewOracle.getViewFor(userName, nameRef, this.design)) == null) {
                tableRef = this.getTableFor(userName, nameRef, this.design);
            }
            if (tableRef != null) {
                KeyObject index = null;
                boolean hasBrackets = Token.hasString(fkString, "(");
                if (hasBrackets) {
                    String columnsReferenced = Token.getValBetweenBrackets(fkString, 1);
                    List columnNamesReferenced = this.getColumnNames(columnsReferenced);
                    index = SHAlterViewOracle.getUniqueIndexForColumnNames(tableRef, columnNamesReferenced);
                } else {
                    index = tableRef.getPK();
                }
                if (index != null) {
                    FKIndexAssociationReference reference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                    this.fkass = this.view.addFK(index, null, reference);
                    this.fkass.setName(nameFK);
                    this.design.getRelationalDesign().stampModelObjectDDL(this.fkass);
                    KeyObject localFKIndex = this.fkass.getLocalFKIndex();
                    localFKIndex.setName(nameFK);
                    localFKIndex.setNameHasQuotes(needsQuotes);
                    if (this.design.isPropagatePKChahges()) {
                        this.replaceAllColumns(this.fkass, columnsRef, index);
                    } else {
                        this.fixFKColumns(this.fkass, columnsRef, index);
                    }
                    this.fkass.setRely(Token.hasToken(fkString, "RELY"));
                }
            } else {
                String error = "Referenced table or view " + nameReferenced + " doesn't exist\n" + this.statement;
                this.importLog.addError(error);
            }
            stringWithFK = fkString;
            hasForeignKey = Token.hasToken(stringWithFK, "FOREIGN");
        }
    }

    private void replaceAllColumns(FKIndexAssociation fkAss, List columnsRef, KeyObject pk) {
        KeyObject index = fkAss.getLocalFKIndex();
        FKElement[] pkCol = (FKElement[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Foreign key columns don't match Primary key columns\n    ").append(index.getContainerWithKeyObject().getName()).append(" index ").append(index.getName()).append(" parent table ").append(pk.getContainerWithKeyObject().getName());
            LOGGER.error(buff.toString());
            this.importLog.addError(buff.toString());
        }
        FKElement[] cols = columnsRef.toArray(new FKElement[0]);
        fkAss.swapFKColumnsWith(cols);
    }

    private void fixFKColumns(FKIndexAssociation fkAss, List columnsRef, KeyObject pk) {
        KeyObject index = fkAss.getLocalFKIndex();
        Iterator it = columnsRef.iterator();
        FKElement[] pkCol = (FKElement[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Foreign key columns don't match Primary key columns\n    ").append(index.getContainerWithKeyObject().getName()).append(" index ").append(index.getName()).append(" parent table ").append(pk.getContainerWithKeyObject().getName());
            LOGGER.error(buff.toString());
            this.importLog.addError(buff.toString());
        }
        int p = -1;
        while (it.hasNext()) {
            if (++p == pkCol.length) {
                return;
            }
            FKElement column = (FKElement)it.next();
            column.addFKAssociation(pkCol[p], fkAss);
            index.add(column);
        }
    }

    private List getColumnNames(String columnString) {
        ArrayList<String> columns = new ArrayList<String>();
        StringTokenizer tokColumns = new StringTokenizer(columnString, ",");
        while (tokColumns.hasMoreTokens()) {
            String columnName = tokColumns.nextToken().trim();
            if (columnName.startsWith("\"")) {
                columnName = Token.removeQuotes(columnName);
            }
            columns.add(columnName);
        }
        return columns;
    }

    public static KeyObject getUniqueIndexForColumnNames(FKContainer view, List names) {
        KeyObject ind = view.getPK();
        if (ind != null && SHAlterViewOracle.isIndexForColumnNames(ind, names)) {
            return ind;
        }
        KeyObject[] inds = view.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (!inds[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !SHAlterViewOracle.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }

    private static boolean isIndexForColumnNames(KeyObject index, List names) {
        FKElement[] columns = (FKElement[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equalsIgnoreCase((String)names.get(i))) continue;
            return false;
        }
        return true;
    }

    private void initPK(String statement) {
        String pkName = null;
        if (statement.trim().startsWith("(")) {
            statement = Token.getValBetweenBrackets(statement);
        }
        boolean needsQuotes = false;
        if (Token.hasToken(statement, "CONSTRAINT")) {
            String afterConstraint = Token.getStringAfterToken(statement, "CONSTRAINT");
            pkName = Token.getFirstName(afterConstraint, '\"', '\"');
            needsQuotes = afterConstraint.startsWith("\"") && !pkName.equals(pkName.toUpperCase());
        } else {
            String viewName = this.view.getName();
            if (viewName.length() > 25) {
                viewName = viewName.substring(0, 25);
            }
            pkName = viewName + "_PK";
        }
        ViewIndex indexPK = null;
        String columnsStr = Token.getValBetweenBrackets(Token.getStringAfter(statement, "PRIMARY KEY"), 1).trim();
        List columnNames = this.getColumnNames(columnsStr);
        if (columnNames.size() > 0) {
            indexPK = this.view.createIndex();
            for (String colName : columnNames) {
                FKElement column = this.getColumnFor(this.view, colName);
                if (column == null) continue;
                indexPK.add(column);
            }
            indexPK.makePK();
            if (pkName != null) {
                indexPK.setName(pkName);
                indexPK.setNameHasQuotes(needsQuotes);
            }
            this.design.getRelationalDesign().stampModelObjectDDL(indexPK);
        }
    }

    private FKElement getColumnFor(TableView tableView, String name) {
        FKElement[] columns = (FKElement[])tableView.getElementsAndNestedElements();
        for (int i = 0; i < columns.length; ++i) {
            FKElement temp = columns[i];
            if (!temp.getName().equalsIgnoreCase(name)) continue;
            return temp;
        }
        return null;
    }

    private void initUK(String statement) {
        String ukName = null;
        if (statement.trim().startsWith("(")) {
            statement = Token.getValBetweenBrackets(statement);
        }
        boolean needsQuotes = false;
        if (Token.hasToken(statement, "CONSTRAINT")) {
            String afterConstraint = Token.getStringAfterToken(statement, "CONSTRAINT");
            ukName = Token.getFirstName(afterConstraint, '\"', '\"');
            needsQuotes = afterConstraint.startsWith("\"") && !ukName.equals(ukName.toUpperCase());
        } else {
            String tableName = this.view.getName();
            if (tableName.length() > 25) {
                tableName = tableName.substring(0, 25);
            }
            ukName = tableName + "_UK" + this.view.getUKeys().size();
        }
        ViewIndex indexUK = null;
        String columnsStr = Token.getValBetweenBrackets(Token.getStringAfter(statement, "UNIQUE"), 1).trim();
        List columnNames = this.getColumnNames(columnsStr);
        if (columnNames.size() > 0) {
            indexUK = this.view.createIndex();
            for (String colName : columnNames) {
                FKElement column = this.getColumnFor(this.view, colName);
                if (column == null) continue;
                indexUK.add(column);
            }
            indexUK.setUnique(true);
            if (ukName != null) {
                indexUK.setName(ukName);
                indexUK.setNameHasQuotes(needsQuotes);
            }
            this.design.getRelationalDesign().stampModelObjectDDL(indexUK);
        }
    }

    private void initView() throws ObjectDoesNotExistException {
        this.view = null;
        String name = Token.getNameAfterToken(this.statement, "VIEW", '\"', '\"');
        String viewName = this.getNameFor(name);
        String userName = Token.getValBeforeCharacter(name, '.');
        if (this.view == null) {
            this.view = SHAlterViewOracle.getViewFor(userName, viewName, this.design);
        }
        if (this.view == null) {
            this.importLog.addError("View with name " + name + " does not exist.");
            throw new ObjectDoesNotExistException("View with name " + name);
        }
    }

    private String getNameFor(String name) {
        int posPoint;
        if (name.indexOf(40) > -1) {
            name = name.substring(0, name.indexOf(40)).trim();
        }
        if ((posPoint = name.indexOf(46)) > 0) {
            StringTokenizer tokenName = new StringTokenizer(name, ".");
            String itemName = null;
            do {
                String partName;
                itemName = partName = tokenName.nextToken().trim();
            } while (tokenName.hasMoreTokens());
            int posPointKomma = itemName.indexOf(59);
            if (posPointKomma > 0) {
                itemName = itemName.substring(0, itemName.length() - 1);
            }
            return itemName;
        }
        int posPointKomma = name.indexOf(59);
        if (posPointKomma > 0) {
            name = name.substring(0, name.length() - 1);
        }
        name = Token.getName(name);
        return name;
    }

    public static TableView getViewFor(String userName, String viewName, Design design) {
        RelationalDesign rm;
        TableView view = null;
        if (userName != null && !"".equals(userName)) {
            userName = Token.removeQuotes(userName);
            view = (TableView)design.getRelationalDesign().getTableViewSet().getBySchemaAndName(userName, viewName);
        } else {
            view = (TableView)design.getRelationalDesign().getTableViewSet().getByName(viewName);
        }
        if (view == null && (rm = design.getRelationalDesign().getRelatedSyncModel()) != null) {
            TableView nView = null;
            if (userName != null && !"".equals(userName)) {
                userName = Token.removeQuotes(userName);
                nView = (TableView)rm.getTableViewSet().getBySchemaAndName(userName, viewName);
            } else {
                nView = (TableView)rm.getTableViewSet().getByName(viewName);
            }
            if (nView != null) {
                try {
                    view = design.getRelationalDesign().createTableView();
                    nView.restoreTo(view);
                    view.setCopyForIncrementalDDL(true);
                    SHAlterViewOracle.copyFKeys(nView, view);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return view;
    }

    public Table getTableFor(String userName, String tableName, Design design) {
        RelationalDesign rm;
        Table table = null;
        if (userName != null && !"".equals(userName)) {
            userName = Token.removeQuotes(userName);
            table = design.getRelationalDesign().getTableSet().getBySchemaAndName(userName, tableName);
        } else {
            table = (Table)design.getRelationalDesign().getTableSet().getByName(tableName);
        }
        if (table == null && (rm = design.getRelationalDesign().getRelatedSyncModel()) != null) {
            Table nTable = null;
            if (userName != null && !"".equals(userName)) {
                userName = Token.removeQuotes(userName);
                nTable = rm.getTableSet().getBySchemaAndName(userName, tableName);
            } else {
                nTable = (Table)rm.getTableSet().getByName(tableName);
            }
            if (nTable != null) {
                try {
                    table = design.getRelationalDesign().createTable();
                    nTable.restoreTo(table);
                    table.setCopyForIncrementalDDL(true);
                    SHAlterViewOracle.copyFKeys(nTable, table);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return table;
    }

    private static void copyFKeys(FKContainer source, FKContainer target) {
        FKIndexAssociation[] fkeys;
        for (FKIndexAssociation fk : fkeys = source.getFKAssociations()) {
            ArrayList<FKElement> list = new ArrayList<FKElement>();
            for (FKElement scol : fk.getLocalFKIndex().getElementsCollection()) {
                FKElement tcol = (FKElement)target.getElementByID(scol.getObjectID());
                if (tcol == null) continue;
                list.add(tcol);
            }
            if (list.size() != fk.getLocalFKIndex().getElementsCollection().size()) continue;
            FKIndexAssociation nfk = target.addForeignKey(fk.getRemoteIndex(), list);
            fk.copy(nfk);
            nfk.setCopyForIncrementalDDL(true);
            nfk.setObjectID(fk.getObjectID());
        }
    }
}

