/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.AlterTableHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.imports.ddl.ObjectDoesNotExistException;
import oracle.dbtools.crest.imports.ddl.oracle.SHAlterViewOracle;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHColumnElementsOraclev10g;
import oracle.dbtools.crest.imports.ddl.oracle.v10g.SHCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexHashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.FKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SHAlterTableOraclev10g
extends DDLStatementHandler
implements AlterTableHandler {
    private Table table;
    private RDBMSSite site = null;
    private StorageDesignOraclev10g storageDesign = null;
    private boolean fk_added = false;
    private String line;
    private boolean failed = false;
    protected List statemensList = new ArrayList();
    private static final Logger LOGGER = new Logger(SHAlterTableOraclev10g.class);

    public SHAlterTableOraclev10g(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHAlterTableOraclev10g.clearCR(line);
        if (Token.startsWithString(statement, "ALTER TABLE")) {
            this.failed = false;
            this.line = line;
            this.statement = statement;
            this.parseAlterTable(statement);
        } else {
            this.nextHandler(line);
        }
    }

    private void parseAlterTable(String statement) {
        try {
            this.initTable();
            this.site = this.design.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev10g)this.design.getStorageDesign(this.site);
            TableProxyOraclev10g tp = (TableProxyOraclev10g)this.storageDesign.getStorageObject(this.table.getObjectID());
            this.fk_added = false;
            boolean validRename = false;
            String afterRename = Token.getStringAfter(statement, "RENAME");
            if (!afterRename.isEmpty()) {
                validRename = true;
                String nextToken = Token.getFirstToken(afterRename);
                String remainder = Token.cutTokenFromFront(afterRename, nextToken);
                if (nextToken.equalsIgnoreCase("TO")) {
                    SHAlterTableOraclev10g.processRenameTable(statement, this.table);
                } else if (nextToken.equalsIgnoreCase("COLUMN")) {
                    this.processRenameColumn(remainder);
                } else if (nextToken.equalsIgnoreCase("CONSTRAINT")) {
                    this.statemensList.add(this.statement);
                } else if (!nextToken.equalsIgnoreCase("PARTITION") && !nextToken.equalsIgnoreCase("SUBPARTITION")) {
                    validRename = false;
                }
            }
            if (!validRename) {
                String rest = statement;
                String verb = Token.getFirstToken(rest);
                while (!verb.isEmpty()) {
                    rest = Token.cutTokenFromFront(rest, verb);
                    if (verb.equalsIgnoreCase("ADD") || verb.equalsIgnoreCase("MODIFY") || verb.equalsIgnoreCase("DROP")) break;
                    verb = Token.getFirstToken(rest);
                }
                while (!verb.isEmpty()) {
                    String clause = rest;
                    String temp = rest;
                    String nextVerb = Token.getFirstToken(temp);
                    while (!nextVerb.isEmpty()) {
                        if (nextVerb.equalsIgnoreCase("ADD") || nextVerb.equalsIgnoreCase("MODIFY") || nextVerb.equalsIgnoreCase("DROP")) {
                            rest = Token.getStringAfter(clause, nextVerb);
                            clause = Token.getStringBeforeToken(clause, nextVerb);
                            break;
                        }
                        temp = Token.cutTokenFromFront(temp, nextVerb);
                        nextVerb = Token.getFirstToken(temp);
                    }
                    if (verb.equalsIgnoreCase("ADD")) {
                        this.processAddClause(clause, tp);
                    } else if (verb.equalsIgnoreCase("MODIFY")) {
                        this.processModifyClause(clause);
                    } else if (verb.equalsIgnoreCase("DROP")) {
                        this.processDropClause(clause);
                    }
                    verb = nextVerb;
                }
            }
            if (!this.failed) {
                this.importLog.incrementImportedStatements();
            }
        }
        catch (Exception e) {
            LOGGER.error(" Parsing " + statement + " for Oracle failed", e);
            this.importLog.addFailedStatement(this.line);
        }
    }

    private void processModifyClause(String afterModify) {
        if (afterModify.startsWith("(")) {
            String withinBrackets = Token.getValBetweenBrackets(afterModify, 1);
            int startIndex = 0;
            int commaIndex = 0;
            while (commaIndex > -1) {
                commaIndex = withinBrackets.indexOf(44, startIndex);
                while (commaIndex > -1 && Token.hasOpenBracketNoClose(withinBrackets.substring(startIndex, commaIndex))) {
                    commaIndex = withinBrackets.indexOf(44, commaIndex + 1);
                }
                if (commaIndex <= -1) continue;
                this.processModifyColumn(withinBrackets.substring(startIndex, commaIndex));
                startIndex = commaIndex + 1;
            }
            this.processModifyColumn(withinBrackets.substring(startIndex));
        } else {
            String firstToken = Token.getFirstToken(afterModify);
            if (firstToken.equalsIgnoreCase("CONSTRAINT") || firstToken.equalsIgnoreCase("PRIMARY") || firstToken.equalsIgnoreCase("UNIQUE")) {
                this.parseModifyConstraint(this.statement);
            }
        }
    }

    private void processAddClause(String part_statement, TableProxyOraclev10g tp) {
        int startIndex = 0;
        if (part_statement.startsWith("(")) {
            part_statement = Token.getValBetweenBrackets(part_statement, 1);
            int commaIndex = 0;
            while (commaIndex > -1) {
                commaIndex = part_statement.indexOf(44, startIndex);
                while (commaIndex > -1 && Token.hasOpenBracketNoClose(part_statement.substring(startIndex, commaIndex))) {
                    commaIndex = part_statement.indexOf(44, commaIndex + 1);
                }
                if (commaIndex <= -1) continue;
                this.processAddedObject(part_statement.substring(startIndex, commaIndex), tp);
                startIndex = commaIndex + 1;
            }
        }
        this.processAddedObject(part_statement.substring(startIndex), tp);
    }

    private void processDropClause(String afterDrop) {
        if (afterDrop.startsWith("(")) {
            String withinBrackets = Token.getValBetweenBrackets(afterDrop, 1);
            int startIndex = 0;
            int commaIndex = 0;
            while (commaIndex > -1) {
                commaIndex = withinBrackets.indexOf(44, startIndex);
                if (commaIndex <= -1) continue;
                this.processDroppedColumn(withinBrackets.substring(startIndex, commaIndex));
                startIndex = commaIndex + 1;
            }
            this.processDroppedColumn(withinBrackets.substring(startIndex));
        } else {
            String firstToken = Token.getFirstToken(afterDrop);
            if (firstToken.equalsIgnoreCase("COLUMN")) {
                this.processDroppedColumn(Token.cutTokenFromFront(afterDrop, "COLUMN"));
            } else if (firstToken.equalsIgnoreCase("CONSTRAINT") || firstToken.equalsIgnoreCase("PRIMARY") || firstToken.equalsIgnoreCase("UNIQUE")) {
                this.parseModifyConstraint(this.statement);
            }
        }
    }

    private void processDroppedColumn(String text) {
        String columnName = Token.getFirstName(text, '\"', '\"');
        ContainedObject column = this.table.getElementByName(columnName);
        if (column != null) {
            column.remove();
        }
    }

    private void processModifyColumn(String text) {
        SHColumnElementsOraclev10g columnHandler = new SHColumnElementsOraclev10g();
        Map columnMap = columnHandler.getElementsColumn(text, this.site.getType());
        String columnName = (String)columnMap.get("columnname");
        Column column = null;
        if (columnName.length() > 0) {
            Column[] columnSet = (Column[])this.table.getElementsAndNestedElements();
            for (int ci = 0; ci < columnSet.length; ++ci) {
                String colname = columnSet[ci].getName();
                if (!columnName.equalsIgnoreCase(colname)) continue;
                column = columnSet[ci];
                break;
            }
        }
        if (column != null) {
            SHCreateTableOraclev10g tableHandler = (SHCreateTableOraclev10g)this.getCreateTableHandler();
            tableHandler.initColumnProps(columnMap, this.design, this.table, column);
        }
    }

    private void processRenameColumn(String afterRenameColumn) {
        ContainedObject column;
        String oldName = Token.getFirstName(afterRenameColumn, '\"', '\"');
        String afterTo = Token.getStringAfter(afterRenameColumn, "TO");
        String newName = Token.getFirstName(afterTo, '\"', '\"');
        if (!newName.isEmpty() && (column = this.table.getElementByName(oldName)) != null) {
            column.setName(newName);
            column.setNameHasQuotes(afterTo.startsWith("\"") && !newName.equals(newName.toUpperCase()));
        }
    }

    public static void processRenameTable(String clause, Table table) {
        String nameString = Token.getStringAfter(clause, "RENAME TO");
        if (nameString.length() > 0) {
            String newName = Token.getFirstName(nameString, '\"', '\"');
            if (nameString.startsWith("\"") && !newName.equals(newName.toUpperCase())) {
                table.setNameHasQuotes(true);
            } else {
                table.setNameHasQuotes(false);
            }
            table.setName(newName);
        }
    }

    private void processAddedObject(String clause, TableProxyOraclev10g tp) {
        String clauseUp = clause.toUpperCase(Locale.ROOT);
        if (this.isFK(clause)) {
            if (!this.fk_added) {
                this.statemensList.add(this.statement);
                this.fk_added = true;
            }
        } else if (clauseUp.startsWith("SUPPLEMENTAL LOG")) {
            SHCreateTableOraclev10g.processSupplementalLog(clause, clauseUp, tp);
        } else if (!this.initColumn(clause)) {
            if (this.isPK(clause)) {
                this.initPK(clause);
            } else if (this.isUK(clause)) {
                this.initUK(clause);
            } else if (this.isCheck(clause)) {
                this.initCheck(clause);
            }
        }
    }

    public void parseFK(String statement) {
        int index;
        this.statement = statement;
        if (statement.trim().startsWith("(")) {
            statement = Token.getValBetweenBrackets(statement);
        }
        if ((index = StringUtilities.indexOf(statement, "CONSTRAINT")) < 0) {
            index = StringUtilities.indexOf(statement, "FOREIGN");
        }
        if (index > -1) {
            String fks = statement.substring(index);
            String constr = null;
            StringTokenizer tokenizer = new StringTokenizer(fks, ",");
            while (tokenizer.hasMoreTokens()) {
                constr = tokenizer.nextToken().trim();
                while (Token.hasOpenBracketNoClose(constr) && tokenizer.hasMoreTokens()) {
                    constr = constr + ", " + tokenizer.nextToken().trim();
                }
                if (this.table == null) continue;
                this.site = this.design.getSelectedRDBMSSite();
                this.storageDesign = (StorageDesignOraclev10g)this.design.getStorageDesign(this.site);
                if (!this.isFK(constr)) continue;
                this.initForeignKey(constr);
            }
        }
    }

    private boolean isFK(String st) {
        return Token.hasToken(st, "FOREIGN");
    }

    private void initTable() throws ObjectDoesNotExistException {
        this.table = null;
        String name = Token.getNameAfterToken(this.statement, "TABLE", '\"', '\"');
        String tableName = this.getNameFor(name);
        String userName = Token.getValBeforeCharacter(name, '.');
        if (this.table == null) {
            this.table = SHAlterTableOraclev10g.getTableFor(userName, tableName, this.design);
        }
        if (this.table == null) {
            this.importLog.addError("Table with name " + name + " does not exist.");
            throw new ObjectDoesNotExistException("Table with name " + name);
        }
    }

    private void initForeignKey(String statement) {
        String stringWithFK = statement;
        if (stringWithFK.trim().startsWith("(")) {
            stringWithFK = Token.getValBetweenBrackets(stringWithFK);
        }
        boolean hasForeignKey = Token.hasToken(stringWithFK, "FOREIGN");
        while (hasForeignKey) {
            FKContainer tableRef;
            String nameFK;
            int positionForeign = StringUtilities.indexOf(stringWithFK, "FOREIGN");
            String fkString = stringWithFK.substring(positionForeign);
            boolean needsQuotes = false;
            if (Token.hasToken(stringWithFK, "CONSTRAINT")) {
                String afterConstraint = Token.getStringAfterToken(stringWithFK, "CONSTRAINT");
                nameFK = Token.getFirstName(afterConstraint, '\"', '\"');
                needsQuotes = afterConstraint.startsWith("\"") && !nameFK.equals(nameFK.toUpperCase());
            } else {
                String tableName = this.table.getName();
                if (tableName.length() > 25) {
                    tableName = tableName.substring(0, 25);
                }
                nameFK = tableName + "_FK" + this.table.getFKAssociationsCount();
            }
            int positionBracket = fkString.indexOf(41);
            String firstBrackets = fkString.substring(0, positionBracket + 1).trim();
            String columns = Token.getValBetweenBrackets(firstBrackets);
            List columnNames = this.getColumnNames(columns);
            ArrayList<Column> columnsRef = new ArrayList<Column>();
            Column[] columnSet = (Column[])this.table.getElementsAndNestedElements();
            block1: for (String name : columnNames) {
                for (int ci = 0; ci < columnSet.length; ++ci) {
                    String colname = columnSet[ci].getName();
                    if (!name.equalsIgnoreCase(colname)) continue;
                    columnsRef.add(columnSet[ci]);
                    continue block1;
                }
            }
            fkString = Token.getStringAfterToken(fkString, "REFERENCES");
            String nameReferenced = Token.getFirstName(fkString, '\"', '\"');
            String userName = "";
            String nameRef = nameReferenced;
            int dotIndex = nameReferenced.indexOf(46);
            if (dotIndex > -1) {
                userName = nameReferenced.substring(0, dotIndex);
                nameRef = nameReferenced.substring(dotIndex + 1);
            }
            if ((tableRef = SHAlterTableOraclev10g.getTableFor(userName, nameRef, this.design)) == null) {
                tableRef = SHAlterViewOracle.getViewFor(userName, nameRef, this.design);
            }
            if (tableRef != null) {
                KeyObject index = null;
                boolean hasBrackets = Token.hasString(fkString, "(");
                if (hasBrackets) {
                    String columnsReferenced = Token.getValBetweenBrackets(fkString, 1);
                    List columnNamesReferenced = this.getColumnNames(columnsReferenced);
                    index = SHAlterViewOracle.getUniqueIndexForColumnNames(tableRef, columnNamesReferenced);
                } else {
                    index = tableRef.getPK();
                }
                if (index != null) {
                    FKIndexAssociationReference reference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                    FKIndexAssociation fkass = this.table.addFK(index, null, reference);
                    fkass.setName(nameFK);
                    this.design.getRelationalDesign().stampModelObjectDDL(fkass);
                    KeyObject localFKIndex = fkass.getLocalFKIndex();
                    localFKIndex.setName(nameFK);
                    localFKIndex.setNameHasQuotes(needsQuotes);
                    if (this.design.isPropagatePKChahges()) {
                        this.replaceAllColumns(fkass, columnsRef, index);
                    } else {
                        this.fixFKColumns(fkass, columnsRef, index);
                    }
                    if (tableRef instanceof TableView) {
                        fkass.setRely(Token.hasToken(fkString, "RELY"));
                    } else {
                        FKProxyOraclev10g fk;
                        String onDelete = Token.getStringAfter(fkString, "ON DELETE").toUpperCase();
                        if (onDelete.length() > 0 && (onDelete = onDelete.startsWith("CASCADE") ? "CASCADE" : (onDelete.startsWith("SET NULL") ? "SET NULL" : null)) != null) {
                            fkass.setDeleteRule(onDelete);
                        }
                        if (this.storageDesign != null && (fk = (FKProxyOraclev10g)this.storageDesign.getFKProxySet().getProxy(localFKIndex.getObjectID())) != null) {
                            this.setConstraintState(fk, statement, false);
                        }
                    }
                }
            } else {
                String error = "Referenced table or view " + nameReferenced + " doesn't exist\n" + this.statement;
                this.importLog.addError(error);
            }
            stringWithFK = fkString;
            hasForeignKey = Token.hasToken(stringWithFK, "FOREIGN");
        }
    }

    private List getColumnNames(String columnString) {
        ArrayList<String> columns = new ArrayList<String>();
        StringTokenizer tokColumns = new StringTokenizer(columnString, ",");
        while (tokColumns.hasMoreTokens()) {
            String columnName = tokColumns.nextToken().trim();
            if (columnName.startsWith("\"")) {
                columnName = Token.removeQuotes(columnName);
            }
            columns.add(columnName);
        }
        return columns;
    }

    private String getNameFor(String name) {
        int posPoint;
        if (name.indexOf(40) > -1) {
            name = name.substring(0, name.indexOf(40)).trim();
        }
        if ((posPoint = name.indexOf(46)) > 0) {
            StringTokenizer tokenName = new StringTokenizer(name, ".");
            String itemName = null;
            do {
                String partName;
                itemName = partName = tokenName.nextToken().trim();
            } while (tokenName.hasMoreTokens());
            int posPointKomma = itemName.indexOf(59);
            if (posPointKomma > 0) {
                itemName = itemName.substring(0, itemName.length() - 1);
            }
            return itemName;
        }
        int posPointKomma = name.indexOf(59);
        if (posPointKomma > 0) {
            name = name.substring(0, name.length() - 1);
        }
        name = Token.getName(name);
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Table getTableFor(String userName, String tableName, Design design) {
        Table table;
        block13: {
            RelationalDesign rm;
            table = null;
            if (userName != null && !"".equals(userName)) {
                userName = Token.removeQuotes(userName);
                table = design.getRelationalDesign().getTableSet().getBySchemaAndName(userName, tableName);
            } else {
                table = (Table)design.getRelationalDesign().getTableSet().getByName(tableName);
            }
            if (table == null && (rm = design.getRelationalDesign().getRelatedSyncModel()) != null) {
                Table ntable = null;
                if (userName != null && !"".equals(userName)) {
                    userName = Token.removeQuotes(userName);
                    ntable = rm.getTableSet().getBySchemaAndName(userName, tableName);
                } else {
                    ntable = (Table)rm.getTableSet().getByName(tableName);
                }
                if (ntable != null) {
                    try {
                        table = design.getRelationalDesign().createTable();
                        ntable.restoreTo(table);
                        table.setCopyForIncrementalDDL(true);
                        SHAlterTableOraclev10g.copyFKeys(ntable, table);
                        StorageDesign lsd = design.getRelationalDesign().getStorageDesign();
                        StorageObject remtab = rm.getStorageDesign().getStorageObject(ntable.getObjectID());
                        StorageObject ltab = lsd.getStorageObject(table.getObjectID());
                        if (ltab == null || remtab == null) break block13;
                        XMLTransformationManager trm = ntable.getAppView().getXMLTransformationManager();
                        trm.setCheckDirty(false);
                        Map omap = trm.transformFromObjectToMap(trm);
                        Map cm = lsd.getCorrespondenceMap();
                        try {
                            HashMap map = new HashMap();
                            lsd.setCorrespondenceMap(map);
                            rm.getStorageDesign().copyTablespacesAndSetments(remtab, lsd);
                            trm.transformFromMapToObject(ltab, omap);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            lsd.setCorrespondenceMap(cm);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return table;
    }

    private static void copyFKeys(Table source, Table target) {
        FKIndexAssociation[] fkeys = source.getFKAssociations();
        StorageDesign tsd = target.getRelationalModel().getStorageDesign();
        StorageDesign ssd = source.getRelationalModel().getStorageDesign();
        for (FKIndexAssociation fk : fkeys) {
            ArrayList<Column> list = new ArrayList<Column>();
            for (Column scol : fk.getLocalFKIndex().getElementsCollection()) {
                Column tcol = (Column)target.getElementByID(scol.getObjectID());
                if (tcol == null) continue;
                list.add(tcol);
            }
            if (list.size() != fk.getLocalFKIndex().getElementsCollection().size()) continue;
            FKIndexAssociation nfk = null;
            KeyObject remoteIndex = fk.getRemoteIndex();
            if (remoteIndex != null) {
                nfk = target.addForeignKey(remoteIndex, list);
            } else {
                FKElement[] fcols;
                nfk = target.getRelationalModel().createForeignKey();
                nfk.setContainerWithKeyObject(target);
                nfk.setName(fk.getName());
                target.setLoadedCompletely(true);
                nfk.addToTable();
                KeyObject li = nfk.getLocalFKIndex();
                li.setName(nfk.getName());
                for (FKElement fcol : fcols = fk.getColumns()) {
                    ContainedObject col = target.getElementByName(fcol.getName());
                    if (col == null) continue;
                    li.add(col);
                }
            }
            if (nfk == null) continue;
            fk.copy(nfk);
            nfk.setCopyForIncrementalDDL(true);
            nfk.setObjectID(fk.getObjectID());
            StorageObject sto = ssd.getStorageObject(fk.getObjectID());
            if (sto == null) {
                sto = ssd.getStorageObject(fk.getLocalFKIndex().getObjectID());
            }
            if (sto == null) continue;
            sto.copy(tsd);
        }
    }

    private Column getColumnFor(Table table, String name) {
        Column[] columns = (Column[])table.getElementsAndNestedElements();
        for (int i = 0; i < columns.length; ++i) {
            Column temp = columns[i];
            if (!temp.getName().equalsIgnoreCase(name)) continue;
            return temp;
        }
        return null;
    }

    private void replaceAllColumns(FKIndexAssociation fkAss, List columnsRef, KeyObject pk) {
        KeyObject index = fkAss.getLocalFKIndex();
        FKElement[] pkCol = (FKElement[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Foreign key columns don't match Primary key columns\n    ").append(index.getContainerWithKeyObject().getName()).append(" index ").append(index.getName()).append(" parent table ").append(pk.getContainerWithKeyObject().getName());
            LOGGER.error(buff.toString());
            this.importLog.addError(buff.toString());
        }
        FKElement[] cols = columnsRef.toArray(new FKElement[0]);
        fkAss.swapFKColumnsWith(cols);
    }

    private void fixFKColumns(FKIndexAssociation fkAss, List columnsRef, KeyObject pk) {
        KeyObject index = fkAss.getLocalFKIndex();
        Iterator it = columnsRef.iterator();
        FKElement[] pkCol = (FKElement[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Foreign key columns don't match Primary key columns\n    ").append(index.getContainerWithKeyObject().getName()).append(" index ").append(index.getName()).append(" parent table ").append(pk.getContainerWithKeyObject().getName());
            LOGGER.error(buff.toString());
            this.importLog.addError(buff.toString());
        }
        int p = -1;
        while (it.hasNext()) {
            if (++p == pkCol.length) {
                return;
            }
            FKElement column = (FKElement)it.next();
            column.addFKAssociation(pkCol[p], fkAss);
            index.add(column);
        }
    }

    private boolean isPK(String st) {
        return st.toUpperCase(Locale.ENGLISH).indexOf("PRIMARY KEY") > -1;
    }

    private void initPK(String statement) {
        KeyObject pk = this.table.getPK();
        if (pk != null) {
            this.getImportLog().addError("There is a primary key on table " + this.table.getName());
            this.getImportLog().addFailedStatement(DDLStatementHandler.FormatCR(this.statement, "\n"));
            this.failed = true;
            return;
        }
        String pkName = null;
        if (statement.trim().startsWith("(")) {
            statement = Token.getValBetweenBrackets(statement);
        }
        boolean needsQuotes = false;
        if (Token.hasToken(statement, "CONSTRAINT")) {
            String afterConstraint = Token.getStringAfterToken(statement, "CONSTRAINT");
            pkName = Token.getFirstName(afterConstraint, '\"', '\"');
            needsQuotes = afterConstraint.startsWith("\"") && !pkName.equals(pkName.toUpperCase());
        } else {
            String tableName = this.table.getName();
            if (tableName.length() > 25) {
                tableName = tableName.substring(0, 25);
            }
            pkName = tableName + "_PK";
        }
        Index indexPK = null;
        String columnsStr = Token.getValBetweenBrackets(Token.getStringAfter(statement, "PRIMARY KEY"), 1).trim();
        List columnNames = this.getColumnNames(columnsStr);
        if (columnNames.size() > 0) {
            indexPK = this.table.createIndex(null, true);
            for (String colName : columnNames) {
                Column column = this.getColumnFor(this.table, colName);
                if (column == null) continue;
                indexPK.add(column);
            }
            indexPK.makePK();
            this.table.getKeySet().moveElementTo(indexPK, 0);
            if (pkName != null) {
                indexPK.setName(pkName);
                indexPK.setNameHasQuotes(needsQuotes);
            }
            this.design.getRelationalDesign().stampModelObjectDDL(indexPK);
            PKProxyOraclev10g pkProxy = (PKProxyOraclev10g)this.storageDesign.getPKProxySet().getProxy(indexPK.getObjectID());
            boolean isPKConstraint = Token.hasString(statement.toUpperCase(Locale.ENGLISH), "PRIMARY KEY");
            if (isPKConstraint && pkProxy != null) {
                this.setConstraintState(pkProxy, statement, false);
                String usingIndexStatement = Token.getStringAfter(statement, "USING INDEX");
                if (usingIndexStatement.length() > 0) {
                    String firstToken = Token.getFirstToken(usingIndexStatement);
                    if (firstToken.equalsIgnoreCase("LOCAL")) {
                        pkProxy.setUsingIndex("LOCAL");
                    } else if (firstToken.equalsIgnoreCase("GLOBAL")) {
                        IndexGlobalPartitionsListOraclev10g igpl = (IndexGlobalPartitionsListOraclev10g)this.storageDesign.getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                        this.design.getRelationalDesign().stampModelObjectDDL(igpl);
                        pkProxy.setIndexGlobalPL(igpl);
                        igpl.setIndex(pkProxy);
                        String partitionBy = Token.getStringAfter(usingIndexStatement, "PARTITION BY");
                        if (Token.getFirstToken(partitionBy).equalsIgnoreCase("RANGE")) {
                            pkProxy.setUsingIndex("GLOBAL BY RANGE");
                        } else if (Token.getFirstToken(partitionBy).equalsIgnoreCase("HASH") && Token.hasToken(partitionBy, "PARTITIONS")) {
                            TableSpaceOraclev10g tableSpace;
                            String t;
                            StringTokenizer tokenizer;
                            pkProxy.setUsingIndex("GLOBAL HASH PARTITIONED BY QUANTITY");
                            try {
                                int quantity = Integer.parseInt(Token.getTokenAfter(partitionBy, "PARTITIONS"));
                                igpl.setHashPQuantity(quantity);
                            }
                            catch (NumberFormatException e) {
                                LOGGER.error("wrong format in SHAlterTableOraclev10g.initPK : " + e.getMessage());
                                this.importLog.addWarning("Wrong QUANTITY format in statement " + statement);
                            }
                            String storeIn = Token.getStringAfter(partitionBy, "STORE IN (");
                            storeIn = Token.getTokenBefore(storeIn, ")");
                            if (storeIn != null && !storeIn.trim().equalsIgnoreCase("")) {
                                tokenizer = new StringTokenizer(storeIn, ",");
                                while (tokenizer.hasMoreTokens()) {
                                    t = Token.getName(tokenizer.nextToken().trim());
                                    tableSpace = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(t);
                                    if (t.equalsIgnoreCase("")) continue;
                                    if (tableSpace == null && !"SYSTEM".equalsIgnoreCase(t)) {
                                        tableSpace = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                        tableSpace.setName(t);
                                        this.design.getRelationalDesign().stampModelObjectDDL(tableSpace);
                                    }
                                    if (tableSpace == null) continue;
                                    igpl.setHashPTableSpaces(tableSpace.getObjectID());
                                }
                            }
                            storeIn = Token.getStringAfter(partitionBy, "OVERFLOW");
                            storeIn = Token.getStringAfter(storeIn, "STORE IN");
                            if ((storeIn = Token.getValBetweenBrackets(storeIn, 1)) != null && !storeIn.trim().equalsIgnoreCase("")) {
                                tokenizer = new StringTokenizer(storeIn, ",");
                                while (tokenizer.hasMoreTokens()) {
                                    t = Token.getName(tokenizer.nextToken().trim());
                                    tableSpace = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(t);
                                    if (tableSpace == null && !"SYSTEM".equalsIgnoreCase(t)) {
                                        tableSpace = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                        tableSpace.setName(t);
                                        this.design.getRelationalDesign().stampModelObjectDDL(tableSpace);
                                    }
                                    if (tableSpace == null) continue;
                                    igpl.setIOTOverflowHashPTSSet(tableSpace.getObjectID());
                                }
                            }
                        } else {
                            pkProxy.setUsingIndex("GLOBAL HASH PARTITIONED BY LIST");
                            String partitions = Token.getStringAfter(partitionBy, "PARTITION");
                            int index = StringUtilities.indexOf(partitions, "PARTITION ");
                            if (index > -1) {
                                String levels = partitions.substring(index);
                                while (levels.toUpperCase(Locale.ENGLISH).indexOf("PARTITION ") > -1) {
                                    TableSpaceOraclev10g ts;
                                    String tsName;
                                    String token;
                                    int nextPartitionIndex = StringUtilities.indexOf(levels, "PARTITION ", 9);
                                    if (nextPartitionIndex > -1) {
                                        token = levels.substring(0, nextPartitionIndex);
                                        levels = levels.substring(nextPartitionIndex);
                                    } else {
                                        token = levels;
                                        levels = "";
                                    }
                                    token = Token.cutFirstToken(token);
                                    IndexHashPartitionOracle hashPartition = this.storageDesign.getIndexHashPartitionSet().createIndexHashPartition();
                                    String hashName = Token.getFirstToken(token).trim();
                                    hashPartition.setName(hashName);
                                    this.design.getRelationalDesign().stampModelObjectDDL(hashPartition);
                                    hashPartition.setIndexGlobalPartList(igpl);
                                    pkProxy.getGlobalPartitions().add(hashPartition);
                                    String tsString = token;
                                    if (Token.hasToken(token, "LOB")) {
                                        tsString = Token.getStringBeforeToken(tsString, "LOB");
                                    }
                                    if (Token.hasString(tsString.toUpperCase(Locale.ENGLISH), "OVERFLOW TABLESPACE")) {
                                        tsName = Token.getStringAfterToken(tsString, "OVERFLOW");
                                        tsName = Token.getQuotedNameAfterToken(tsName, "TABLESPACE");
                                        tsString = Token.getStringBefore(tsString, "OVERFLOW TABLESPACE");
                                        ts = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(tsName);
                                        if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                                            ts = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                            ts.setName(tsName);
                                            this.design.getRelationalDesign().stampModelObjectDDL(ts);
                                        }
                                        if (ts != null) {
                                            hashPartition.setOverflowTableSpace(ts);
                                        }
                                    }
                                    if (!Token.hasToken(tsString, "TABLESPACE") || (tsName = Token.getQuotedNameAfterToken(tsString, "TABLESPACE")).equalsIgnoreCase("")) continue;
                                    ts = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(tsName);
                                    if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                                        ts = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                        ts.setName(tsName);
                                        this.design.getRelationalDesign().stampModelObjectDDL(ts);
                                    }
                                    if (ts == null) continue;
                                    hashPartition.setTableSpace(ts);
                                }
                            }
                        }
                        String restOfStatement = Token.getStringAfter(statement, "GLOBAL PARTITION");
                        String columnList = Token.getStringAfter(restOfStatement, "(");
                        if (Token.hasToken(columnList, ")")) {
                            columnList = Token.getStringBefore(columnList, ")");
                        }
                        igpl.setGlobalPartColumns(igpl.columnNamesToColumnIDs(columnList));
                    } else if (firstToken.equalsIgnoreCase("(")) {
                        pkProxy.setUsingIndex("BY CREATE INDEX STATEMENT");
                        pkProxy.setCreateIndexStatement(Token.getValBetweenBrackets(usingIndexStatement));
                    } else {
                        pkProxy.setUsingIndex("BY INDEX NAME");
                        if (firstToken.equalsIgnoreCase("PCTFREE") || firstToken.equalsIgnoreCase("INITRANS") || firstToken.equalsIgnoreCase("MAXTRANS") || firstToken.equalsIgnoreCase("STORAGE") || firstToken.equalsIgnoreCase("LOGGING") || firstToken.equalsIgnoreCase("NOLOGGING") || firstToken.equalsIgnoreCase("ONLINE") || firstToken.equalsIgnoreCase("TABLESPACE") || firstToken.equalsIgnoreCase("COMPRESS") || firstToken.equalsIgnoreCase("NOCOMPRESS") || firstToken.equalsIgnoreCase("SORT") || firstToken.equalsIgnoreCase("NOSORT") || firstToken.equalsIgnoreCase("REVERSE") || firstToken.equalsIgnoreCase("VISIBLE") || firstToken.equalsIgnoreCase("INVISIBLE")) {
                            pkProxy.setExistingIndex(null);
                        } else {
                            String iName = Token.getFirstName(usingIndexStatement, '\"', '\"');
                            String indName = this.getNameFor(iName);
                            String userName = Token.getValBeforeCharacter(iName, '.');
                            Index idx = this.table.getIndexByNameAndSchema(userName, indName);
                            if (idx == null) {
                                idx = this.table.getIndexByName(indName);
                            }
                            if (idx != null) {
                                IndexProxyOracle indexProxy = (IndexProxyOracle)this.storageDesign.getIndexProxySet().getProxy(idx.getObjectID());
                                pkProxy.setExistingIndex(indexProxy);
                            }
                        }
                    }
                    if (pkProxy.getExistingIndex() == null && !pkProxy.getUsingIndex().equals("BY CREATE INDEX STATEMENT")) {
                        String tsName;
                        boolean storage;
                        String initransStr;
                        SegmentOracle segment = null;
                        String pctFreeStr = Token.getTokenAfter(usingIndexStatement, "PCTFREE");
                        if (!"".equalsIgnoreCase(pctFreeStr) && this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                            try {
                                int pctFree = Integer.parseInt(pctFreeStr);
                                segment = this.getSegment(segment);
                                segment.setPCTFree(pctFree);
                            }
                            catch (NumberFormatException pctFree) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase(initransStr = Token.getTokenAfter(usingIndexStatement, "INITRANS")) && this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                            try {
                                int value = Integer.parseInt(initransStr);
                                segment = this.getSegment(segment);
                                segment.setInitrans(value);
                            }
                            catch (NumberFormatException value) {
                                // empty catch block
                            }
                        }
                        if (storage = Token.hasToken(usingIndexStatement, "STORAGE")) {
                            String groupsStr;
                            String freeListsStr;
                            String maxExtentsStr;
                            String minExtentsStr;
                            String pctIncStr;
                            String nextStr;
                            String storageStatement = Token.getStringAfter(usingIndexStatement, "STORAGE");
                            String initialStr = Token.getTokenAfter(storageStatement, "INITIAL");
                            if (!"".equalsIgnoreCase(initialStr) && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                                try {
                                    long value = Long.parseLong(this.getNumberOnly(initialStr));
                                    segment = this.getSegment(segment);
                                    segment.setSCInitialExtent(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(nextStr = Token.getTokenAfter(storageStatement, "NEXT")) && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                                try {
                                    long value = Long.parseLong(this.getNumberOnly(nextStr));
                                    segment = this.getSegment(segment);
                                    segment.setSCNextExtent(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(pctIncStr = Token.getTokenAfter(storageStatement, "PCTINCREASE")) && this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                                try {
                                    int value = Integer.parseInt(pctIncStr);
                                    segment = this.getSegment(segment);
                                    segment.setSCPctIncrease(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(minExtentsStr = Token.getTokenAfter(storageStatement, "MINEXTENTS")) && this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                                try {
                                    int value = Integer.parseInt(minExtentsStr);
                                    segment = this.getSegment(segment);
                                    segment.setSCMinExtents(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(maxExtentsStr = Token.getTokenAfter(storageStatement, "MAXEXTENTS")) && this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                                segment = this.getSegment(segment);
                                segment.setSCMaxExtents(maxExtentsStr);
                            }
                            if (!"".equalsIgnoreCase(freeListsStr = Token.getTokenAfter(storageStatement, "FREELISTS")) && this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                                try {
                                    int value = Integer.parseInt(freeListsStr);
                                    segment = this.getSegment(segment);
                                    segment.setSCFreeLists(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(groupsStr = Token.getTokenAfter(storageStatement, "GROUPS")) && this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                                try {
                                    int value = Integer.parseInt(groupsStr);
                                    segment = this.getSegment(segment);
                                    segment.setSCFreelistGroups(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            String bufferPool = Token.getQuotedNameAfterToken(storageStatement, "BUFFER_POOL");
                            if (!"".equalsIgnoreCase(groupsStr) && this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                                segment = this.getSegment(segment);
                                segment.setSCBufferPool(bufferPool);
                            }
                        }
                        if (!((tsName = Token.getQuotedNameAfterToken(usingIndexStatement, "TABLESPACE")).equalsIgnoreCase("LOGGING") || tsName.equalsIgnoreCase(pkProxy.getIndexSort()) || tsName.equalsIgnoreCase(""))) {
                            TableSpaceOraclev10g ts = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(tsName);
                            if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                                ts = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                ts.setName(tsName);
                                this.design.getRelationalDesign().stampModelObjectDDL(ts);
                            }
                            if (ts != null) {
                                pkProxy.setTableSpace(ts);
                            }
                        }
                        if (Token.hasToken(usingIndexStatement, "COMPRESS")) {
                            try {
                                int value = Integer.parseInt(Token.getTokenAfter(usingIndexStatement, "COMPRESS"));
                                pkProxy.setCompress(value);
                            }
                            catch (NumberFormatException value) {
                                // empty catch block
                            }
                        }
                        if (Token.hasToken(usingIndexStatement, "NOSORT")) {
                            pkProxy.setIndexSort("NO");
                        } else if (Token.hasToken(usingIndexStatement, "REVERSE")) {
                            pkProxy.setIndexSort("REVERSE");
                        } else {
                            pkProxy.setIndexSort("SORTED");
                        }
                        if (Token.hasToken(usingIndexStatement, "NOLOGGING")) {
                            pkProxy.setLogging("NO");
                        } else if (Token.hasToken(usingIndexStatement, "LOGGING")) {
                            pkProxy.setLogging("YES");
                        } else {
                            pkProxy.setLogging("");
                        }
                        boolean computeStatistics = Token.hasString(usingIndexStatement.toUpperCase(Locale.ENGLISH), "COMPUTE STATISTICS");
                        if (computeStatistics) {
                            pkProxy.setComputeStatistics("YES");
                        } else {
                            pkProxy.setComputeStatistics("NO");
                        }
                        if (segment != null) {
                            SegmentOracle equalSegment = this.storageDesign.getSegmentSet().findEqual(segment);
                            pkProxy.setIndexSegment(equalSegment);
                        }
                    }
                }
            }
        }
    }

    private SegmentOracle getSegment(SegmentOracle segment) {
        if (segment == null) {
            segment = this.storageDesign.getSegmentSet().createSegment();
            this.design.getRelationalDesign().stampModelObjectDDL(segment);
        }
        return segment;
    }

    private boolean isUK(String st) {
        return Token.hasToken(st, "UNIQUE");
    }

    private void initUK(String statement) {
        String ukName = null;
        if (statement.trim().startsWith("(")) {
            statement = Token.getValBetweenBrackets(statement);
        }
        boolean needsQuotes = false;
        if (Token.hasToken(statement, "CONSTRAINT")) {
            String afterConstraint = Token.getStringAfterToken(statement, "CONSTRAINT");
            ukName = Token.getFirstName(afterConstraint, '\"', '\"');
            needsQuotes = afterConstraint.startsWith("\"") && !ukName.equals(ukName.toUpperCase());
        } else {
            String tableName = this.table.getName();
            if (tableName.length() > 25) {
                tableName = tableName.substring(0, 25);
            }
            ukName = tableName + "_UK" + this.table.getUKeys().size();
        }
        Index indexUK = null;
        String columnsStr = Token.getValBetweenBrackets(Token.getStringAfter(statement, "UNIQUE"), 1).trim();
        List columnNames = this.getColumnNames(columnsStr);
        if (columnNames.size() > 0) {
            indexUK = this.table.createIndex();
            for (String colName : columnNames) {
                Column column = this.getColumnFor(this.table, colName);
                if (column == null) continue;
                indexUK.add(column);
            }
            indexUK.setUnique(true);
            if (ukName != null) {
                indexUK.setName(ukName);
                indexUK.setNameHasQuotes(needsQuotes);
            }
            this.design.getRelationalDesign().stampModelObjectDDL(indexUK);
            UniqueOraclev10g unique = (UniqueOraclev10g)this.storageDesign.getUniqueSet().getProxy(indexUK.getObjectID());
            if (unique != null) {
                this.setConstraintState(unique, statement, false);
                String usingIndexStatement = Token.getStringAfter(statement, "USING INDEX");
                if (usingIndexStatement.length() > 0) {
                    String firstToken = Token.getFirstToken(usingIndexStatement);
                    if (firstToken.equalsIgnoreCase("LOCAL")) {
                        unique.setUsingIndex("LOCAL");
                    } else if (firstToken.equalsIgnoreCase("GLOBAL")) {
                        IndexGlobalPartitionsListOraclev10g igpl = (IndexGlobalPartitionsListOraclev10g)this.storageDesign.getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                        this.design.getRelationalDesign().stampModelObjectDDL(igpl);
                        unique.setUsingIndexGlobalPL(igpl);
                        igpl.setIndex(unique);
                        String partitionBy = Token.getStringAfter(usingIndexStatement, "PARTITION BY");
                        if (Token.getFirstToken(partitionBy).equalsIgnoreCase("RANGE")) {
                            unique.setUsingIndex("GLOBAL BY RANGE");
                        } else if (Token.getFirstToken(partitionBy).equalsIgnoreCase("HASH") && Token.hasToken(partitionBy, "PARTITIONS")) {
                            TableSpaceOraclev10g tableSpace;
                            String t;
                            StringTokenizer tokenizer;
                            unique.setUsingIndex("GLOBAL HASH PARTITIONED BY QUANTITY");
                            try {
                                int quantity = Integer.parseInt(Token.getTokenAfter(partitionBy, "PARTITIONS"));
                                igpl.setHashPQuantity(quantity);
                            }
                            catch (NumberFormatException e) {
                                LOGGER.error("wrong format in SHAlterTableOraclev10g.initPK : " + e.getMessage());
                                this.importLog.addWarning("Wrong QUANTITY format in statement " + statement);
                            }
                            String storeIn = Token.getStringAfter(partitionBy, "STORE IN (");
                            storeIn = Token.getTokenBefore(storeIn, ")");
                            if (storeIn != null && !storeIn.trim().equalsIgnoreCase("")) {
                                tokenizer = new StringTokenizer(storeIn, ",");
                                while (tokenizer.hasMoreTokens()) {
                                    t = Token.getName(tokenizer.nextToken().trim());
                                    tableSpace = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(t);
                                    if (!t.equalsIgnoreCase("") && tableSpace == null && !"SYSTEM".equalsIgnoreCase(t)) {
                                        tableSpace = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                        tableSpace.setName(t);
                                        this.design.getRelationalDesign().stampModelObjectDDL(tableSpace);
                                    }
                                    if (tableSpace == null) continue;
                                    igpl.setHashPTableSpaces(tableSpace.getObjectID());
                                }
                            }
                            storeIn = Token.getStringAfter(partitionBy, "OVERFLOW");
                            storeIn = Token.getStringAfter(storeIn, "STORE IN");
                            if ((storeIn = Token.getValBetweenBrackets(storeIn, 1)) != null && !storeIn.trim().equalsIgnoreCase("")) {
                                tokenizer = new StringTokenizer(storeIn, ",");
                                while (tokenizer.hasMoreTokens()) {
                                    t = Token.getName(tokenizer.nextToken().trim());
                                    tableSpace = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(t);
                                    if (tableSpace == null && !"SYSTEM".equalsIgnoreCase(t)) {
                                        tableSpace = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                        tableSpace.setName(t);
                                        this.design.getRelationalDesign().stampModelObjectDDL(tableSpace);
                                    }
                                    if (tableSpace == null) continue;
                                    igpl.setIOTOverflowHashPTSSet(tableSpace.getObjectID());
                                }
                            }
                        } else {
                            unique.setUsingIndex("GLOBAL HASH PARTITIONED BY LIST");
                            String partitions = Token.getStringAfter(partitionBy, "PARTITION");
                            int index = StringUtilities.indexOf(partitions, "PARTITION ");
                            if (index > -1) {
                                String levels = partitions.substring(index);
                                while (levels.toUpperCase(Locale.ENGLISH).indexOf("PARTITION ") > -1) {
                                    String tsName;
                                    String token;
                                    int nextPartitionIndex = StringUtilities.indexOf(levels, "PARTITION ", 9);
                                    if (nextPartitionIndex > -1) {
                                        token = levels.substring(0, nextPartitionIndex);
                                        levels = levels.substring(nextPartitionIndex);
                                    } else {
                                        token = levels;
                                        levels = "";
                                    }
                                    token = Token.cutFirstToken(token);
                                    IndexHashPartitionOracle hashPartition = this.storageDesign.getIndexHashPartitionSet().createIndexHashPartition();
                                    String hashName = Token.getFirstToken(token).trim();
                                    hashPartition.setName(hashName);
                                    this.design.getRelationalDesign().stampModelObjectDDL(hashPartition);
                                    hashPartition.setIndexGlobalPartList(igpl);
                                    unique.getGlobalPartitions().add(hashPartition);
                                    String tsString = token;
                                    if (Token.hasToken(token, "LOB")) {
                                        tsString = Token.getStringBeforeToken(tsString, "LOB");
                                    }
                                    if (Token.hasToken(tsString, "TABLESPACE") && !(tsName = Token.getQuotedNameAfterToken(tsString, "TABLESPACE")).equalsIgnoreCase("")) {
                                        TableSpaceOraclev10g ts = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(tsName);
                                        if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                                            ts = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                            ts.setName(tsName);
                                            this.design.getRelationalDesign().stampModelObjectDDL(ts);
                                        }
                                        if (ts != null) {
                                            hashPartition.setTableSpace(ts);
                                        }
                                    }
                                    tsString = Token.getStringAfter(partitionBy, "OVERFLOW");
                                    tsString = Token.getStringAfter(tsString, "STORE IN");
                                    if ((tsString = Token.getValBetweenBrackets(tsString, 1)) == null || tsString.trim().equalsIgnoreCase("")) continue;
                                    StringTokenizer tokenizer = new StringTokenizer(tsString, ",");
                                    while (tokenizer.hasMoreTokens()) {
                                        String t = Token.getName(tokenizer.nextToken().trim());
                                        TableSpaceOraclev10g tableSpace = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(t);
                                        if (tableSpace == null && !"SYSTEM".equalsIgnoreCase(t)) {
                                            tableSpace = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                            tableSpace.setName(t);
                                            this.design.getRelationalDesign().stampModelObjectDDL(tableSpace);
                                        }
                                        if (tableSpace == null) continue;
                                        igpl.setIOTOverflowHashPTSSet(tableSpace.getObjectID());
                                    }
                                }
                            }
                        }
                        String restOfStatement = Token.getStringAfter(statement, "GLOBAL PARTITION");
                        String columnList = Token.getStringAfter(restOfStatement, "(");
                        if (Token.hasToken(columnList, ")")) {
                            columnList = Token.getStringBefore(columnList, ")");
                        }
                        igpl.setGlobalPartColumns(igpl.columnNamesToColumnIDs(columnList));
                    } else if (firstToken.equalsIgnoreCase("(")) {
                        unique.setUsingIndex("BY CREATE INDEX STATEMENT");
                        unique.setCreateIndexStatement(Token.getValBetweenBrackets(usingIndexStatement));
                    } else {
                        unique.setUsingIndex("BY INDEX NAME");
                        if (firstToken.equalsIgnoreCase("PCTFREE") || firstToken.equalsIgnoreCase("INITRANS") || firstToken.equalsIgnoreCase("MAXTRANS") || firstToken.equalsIgnoreCase("STORAGE") || firstToken.equalsIgnoreCase("LOGGING") || firstToken.equalsIgnoreCase("NOLOGGING") || firstToken.equalsIgnoreCase("ONLINE") || firstToken.equalsIgnoreCase("TABLESPACE") || firstToken.equalsIgnoreCase("COMPRESS") || firstToken.equalsIgnoreCase("NOCOMPRESS") || firstToken.equalsIgnoreCase("SORT") || firstToken.equalsIgnoreCase("NOSORT") || firstToken.equalsIgnoreCase("REVERSE") || firstToken.equalsIgnoreCase("VISIBLE") || firstToken.equalsIgnoreCase("INVISIBLE")) {
                            unique.setExistingIndex(null);
                        } else {
                            String iName = Token.getFirstName(usingIndexStatement, '\"', '\"');
                            String indName = this.getNameFor(iName);
                            String userName = Token.getValBeforeCharacter(iName, '.');
                            Index idx = this.table.getIndexByNameAndSchema(userName, indName);
                            if (idx == null) {
                                this.table.getIndexByName(indName);
                            }
                            if (idx != null) {
                                IndexProxyOracle indexProxy = (IndexProxyOracle)this.storageDesign.getIndexProxySet().getProxy(idx.getObjectID());
                                unique.setExistingIndex(indexProxy);
                            }
                        }
                    }
                    if (unique.getExistingIndex() == null && !unique.getUsingIndex().equals("BY CREATE INDEX STATEMENT")) {
                        String tsName;
                        boolean storage;
                        String initransStr;
                        SegmentOracle segment = null;
                        String pctFreeStr = Token.getTokenAfter(usingIndexStatement, "PCTFREE");
                        if (!"".equalsIgnoreCase(pctFreeStr) && this.storageDesign.getAppView().getSettings().isIncludePctFreeInDDL()) {
                            try {
                                int pctFree = Integer.parseInt(pctFreeStr);
                                segment = this.getSegment(segment);
                                segment.setPCTFree(pctFree);
                            }
                            catch (NumberFormatException pctFree) {
                                // empty catch block
                            }
                        }
                        if (!"".equalsIgnoreCase(initransStr = Token.getTokenAfter(usingIndexStatement, "INITRANS")) && this.storageDesign.getAppView().getSettings().isIncludeInitransInDDL()) {
                            try {
                                int value = Integer.parseInt(initransStr);
                                segment = this.getSegment(segment);
                                segment.setInitrans(value);
                            }
                            catch (NumberFormatException value) {
                                // empty catch block
                            }
                        }
                        if (storage = Token.hasToken(usingIndexStatement, "STORAGE")) {
                            String groupsStr;
                            String freeListsStr;
                            String maxExtentsStr;
                            String minExtentsStr;
                            String pctIncStr;
                            String nextStr;
                            String storageStatement = Token.getStringAfter(usingIndexStatement, "STORAGE");
                            String initialStr = Token.getTokenAfter(storageStatement, "INITIAL");
                            if (!"".equalsIgnoreCase(initialStr) && this.storageDesign.getAppView().getSettings().isIncludeInitialExtentInDDL()) {
                                try {
                                    long value = Long.parseLong(this.getNumberOnly(initialStr));
                                    segment = this.getSegment(segment);
                                    segment.setSCInitialExtent(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(nextStr = Token.getTokenAfter(storageStatement, "NEXT")) && this.storageDesign.getAppView().getSettings().isIncludeNextExtentInDDL()) {
                                try {
                                    long value = Long.parseLong(this.getNumberOnly(nextStr));
                                    segment = this.getSegment(segment);
                                    segment.setSCNextExtent(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(pctIncStr = Token.getTokenAfter(storageStatement, "PCTINCREASE")) && this.storageDesign.getAppView().getSettings().isIncludePctIncreaseInDDL()) {
                                try {
                                    int value = Integer.parseInt(pctIncStr);
                                    segment = this.getSegment(segment);
                                    segment.setSCPctIncrease(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(minExtentsStr = Token.getTokenAfter(storageStatement, "MINEXTENTS")) && this.storageDesign.getAppView().getSettings().isIncludeMinExtentsInDDL()) {
                                try {
                                    int value = Integer.parseInt(minExtentsStr);
                                    segment = this.getSegment(segment);
                                    segment.setSCMinExtents(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(maxExtentsStr = Token.getTokenAfter(storageStatement, "MAXEXTENTS")) && this.storageDesign.getAppView().getSettings().isIncludeMaxExtentsInDDL()) {
                                segment = this.getSegment(segment);
                                segment.setSCMaxExtents(maxExtentsStr);
                            }
                            if (!"".equalsIgnoreCase(freeListsStr = Token.getTokenAfter(storageStatement, "FREELISTS")) && this.storageDesign.getAppView().getSettings().isIncludeFreeListsInDDL()) {
                                try {
                                    int value = Integer.parseInt(freeListsStr);
                                    segment = this.getSegment(segment);
                                    segment.setSCFreeLists(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            if (!"".equalsIgnoreCase(groupsStr = Token.getTokenAfter(storageStatement, "GROUPS")) && this.storageDesign.getAppView().getSettings().isIncludeFreeListGroupsInDDL()) {
                                try {
                                    int value = Integer.parseInt(groupsStr);
                                    segment = this.getSegment(segment);
                                    segment.setSCFreelistGroups(value);
                                }
                                catch (NumberFormatException value) {
                                    // empty catch block
                                }
                            }
                            String bufferPool = Token.getQuotedNameAfterToken(storageStatement, "BUFFER_POOL");
                            if (!"".equalsIgnoreCase(groupsStr) && this.storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL()) {
                                segment = this.getSegment(segment);
                                segment.setSCBufferPool(bufferPool);
                            }
                        }
                        if (!(tsName = Token.getQuotedNameAfterToken(usingIndexStatement, "TABLESPACE")).equalsIgnoreCase("")) {
                            TableSpaceOraclev10g ts = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().getByName(tsName);
                            if (ts == null && !"SYSTEM".equalsIgnoreCase(tsName)) {
                                ts = (TableSpaceOraclev10g)this.storageDesign.getTableSpaceSet().createTableSpace();
                                ts.setName(tsName);
                                this.design.getRelationalDesign().stampModelObjectDDL(ts);
                            }
                            if (ts != null) {
                                unique.setTableSpace(ts);
                            }
                        }
                        if (Token.hasToken(usingIndexStatement, "COMPRESS")) {
                            try {
                                int value = Integer.parseInt(Token.getTokenAfter(usingIndexStatement, "COMPRESS"));
                                unique.setCompress(value);
                            }
                            catch (NumberFormatException value) {
                                // empty catch block
                            }
                        }
                        if (Token.hasToken(usingIndexStatement, "NOSORT")) {
                            unique.setIndexSort("NO");
                        } else if (Token.hasToken(usingIndexStatement, "REVERSE")) {
                            unique.setIndexSort("REVERSE");
                        } else {
                            unique.setIndexSort("SORTED");
                        }
                        if (Token.hasToken(usingIndexStatement, "NOLOGGING")) {
                            unique.setLogging("NO");
                        } else if (Token.hasToken(usingIndexStatement, "LOGGING")) {
                            unique.setLogging("YES");
                        } else {
                            unique.setLogging("");
                        }
                        boolean computeStatistics = Token.hasString(usingIndexStatement.toUpperCase(Locale.ENGLISH), "COMPUTE STATISTICS");
                        if (computeStatistics) {
                            unique.setComputeStatistics("YES");
                        } else {
                            unique.setComputeStatistics("NO");
                        }
                        if (segment != null) {
                            SegmentOracle equalSegment = this.storageDesign.getSegmentSet().findEqual(segment);
                            unique.setIndexSegment(equalSegment);
                        }
                    }
                }
            }
        }
    }

    private Column getColumnForConstr(Table table, String condition) {
        String check = condition.toUpperCase();
        ContainedObject[] cols = table.getElements();
        Column col = null;
        boolean found = false;
        for (int i = 0; i < cols.length; ++i) {
            col = (Column)cols[i];
            String name = col.getName().toUpperCase();
            if (check.indexOf(name) <= -1) continue;
            found = true;
            for (int k = 0; k < cols.length; ++k) {
                String c2name;
                Column c2 = (Column)cols[k];
                if (col == c2 || check.indexOf(c2name = c2.getName().toUpperCase()) <= -1) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return col;
        }
        return null;
    }

    private boolean isCheck(String st) {
        return Token.hasToken(st, "CHECK");
    }

    private void initCheck(String constr) {
        TableProxyOracle tableProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(this.table.getObjectID());
        this.statement = constr;
        if (this.statement.trim().startsWith("(")) {
            this.statement = Token.getValBetweenBrackets(this.statement);
        }
        String constrName = "";
        if (Token.hasToken(this.statement, "CONSTRAINT")) {
            constrName = Token.getQuotedNameAfterToken(this.statement, "CONSTRAINT");
        }
        String condition = Token.getValBetweenBrackets(Token.getStringAfter(this.statement, "CHECK")).trim();
        try {
            CheckConstraint check;
            Column column = this.getColumnForConstr(this.table, condition);
            if (column != null && (check = column.getCheck()) == null) {
                CheckConstraint constraint = new CheckConstraint();
                constraint.add(this.storageDesign.getRDBMSType(), condition);
                column.setUseDomainConstraints(false);
                column.parseAndSetCheckConstraint(constraint);
                column.setConstraintName(constrName);
                this.design.getRelationalDesign().stampModelObjectDDL(constraint);
                ColumnProxyOracle columnProxy = (ColumnProxyOracle)tableProxy.getColumnProxy(column.getObjectID());
                if (columnProxy != null) {
                    this.setConstraintState(columnProxy, this.statement, false);
                }
                return;
            }
        }
        catch (Exception column) {
            // empty catch block
        }
        TableLevelConstraint constraint = this.table.createCheckConstraint(constrName, condition);
        this.table.addCheckConstraint(constraint);
        this.design.getRelationalDesign().stampModelObjectDDL(constraint);
        TableCheckConstraintOracle proxy = tableProxy.getTableConstraint(constraint);
        if (proxy != null) {
            this.setConstraintState(proxy, this.statement, false);
        }
    }

    private boolean initColumn(String constr) {
        SHColumnElementsOraclev10g columnHandler = new SHColumnElementsOraclev10g();
        Map columnMap = columnHandler.getElementsColumn(constr, this.site.getType());
        SHCreateTableOraclev10g tableHandler = (SHCreateTableOraclev10g)this.getCreateTableHandler();
        return tableHandler.initColumn(columnMap, this.design, this.table);
    }

    private static boolean isIndexForColumnNames(Index index, List names) {
        Column[] columns = (Column[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equalsIgnoreCase((String)names.get(i))) continue;
            return false;
        }
        return true;
    }

    public static Index getUniqueIndexForColumnNames(Table table, List names) {
        Index ind = (Index)table.getPK();
        if (ind != null && SHAlterTableOraclev10g.isIndexForColumnNames(ind, names)) {
            return ind;
        }
        Index[] inds = (Index[])table.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (!inds[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !SHAlterTableOraclev10g.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }

    @Override
    public void processForeignKeys() {
        Iterator it = this.statemensList.iterator();
        while (it.hasNext()) {
            String alterStatement;
            this.statement = alterStatement = (String)it.next();
            try {
                this.initTable();
            }
            catch (ObjectDoesNotExistException objectDoesNotExistException) {
                // empty catch block
            }
            if (this.table == null) continue;
            String[] splittedConstr = alterStatement.split(" ADD ");
            if (splittedConstr.length == 1) {
                splittedConstr = alterStatement.split(" add ");
            }
            Iterator<String> it2 = Arrays.asList(splittedConstr).iterator();
            while (it2.hasNext()) {
                String clause;
                String part_statement = it2.next().trim();
                int startIndex = 0;
                if (part_statement.startsWith("(")) {
                    part_statement = Token.getValBetweenBrackets(part_statement, 1);
                    int commaIndex = 0;
                    while (commaIndex > -1) {
                        commaIndex = part_statement.indexOf(44, startIndex);
                        while (commaIndex > -1 && Token.hasOpenBracketNoClose(part_statement.substring(startIndex, commaIndex))) {
                            commaIndex = part_statement.indexOf(44, commaIndex + 1);
                        }
                        if (commaIndex <= -1) continue;
                        String clause2 = part_statement.substring(startIndex, commaIndex);
                        if (this.isFK(clause2)) {
                            this.parseFK(clause2);
                        } else {
                            this.parseModifyConstraint(clause2);
                        }
                        startIndex = commaIndex + 1;
                    }
                }
                if (this.isFK(clause = part_statement.substring(startIndex))) {
                    this.parseFK(clause);
                    continue;
                }
                this.parseModifyConstraint(clause);
            }
        }
    }

    private void parseModifyConstraint(String clause) {
        block18: {
            String constraintName;
            String modifyConstraint;
            String verb;
            block20: {
                String afterTo;
                String newName;
                DesignObject constraintObject;
                block24: {
                    block21: {
                        block23: {
                            block22: {
                                String tokenAfterVerb;
                                block17: {
                                    KeyObject pk;
                                    block19: {
                                        if (Token.hasToken(clause, "MODIFY")) {
                                            verb = "MODIFY";
                                        } else if (Token.hasToken(clause, "DROP")) {
                                            verb = "DROP";
                                        } else if (Token.hasToken(clause, "RENAME")) {
                                            verb = "RENAME";
                                        } else {
                                            return;
                                        }
                                        modifyConstraint = Token.getStringAfter(clause, verb);
                                        tokenAfterVerb = Token.getFirstToken(modifyConstraint);
                                        if (!tokenAfterVerb.equalsIgnoreCase("PRIMARY")) break block17;
                                        pk = this.table.getPK();
                                        if (pk == null) break block18;
                                        if (!verb.equals("MODIFY")) break block19;
                                        RelationalObjectProxy pkProxy = this.storageDesign.getPKProxySet().getProxy(pk.getObjectID());
                                        if (pkProxy == null) break block18;
                                        this.setConstraintState(pkProxy, clause, false);
                                        break block18;
                                    }
                                    if (!verb.equals("DROP")) break block18;
                                    pk.remove();
                                    break block18;
                                }
                                if (!tokenAfterVerb.equalsIgnoreCase("CONSTRAINT")) break block18;
                                modifyConstraint = Token.cutTokenFromFront(modifyConstraint, "CONSTRAINT");
                                constraintName = Token.getFirstName(modifyConstraint, '\"', '\"');
                                constraintObject = null;
                                for (KeyObject pkUk : this.table.getPKandUKConstraints()) {
                                    if (!pkUk.getName().equalsIgnoreCase(constraintName)) continue;
                                    constraintObject = pkUk;
                                    break;
                                }
                                if (constraintObject == null) {
                                    for (FKIndexAssociation fk : this.table.getFKAssociationsList()) {
                                        if (!fk.getName().equalsIgnoreCase(constraintName)) continue;
                                        constraintObject = fk;
                                        break;
                                    }
                                    if (constraintObject == null) {
                                        for (TableLevelConstraint tlc : this.table.getCheckConstraints()) {
                                            if (!tlc.getName().equalsIgnoreCase(constraintName)) continue;
                                            constraintObject = tlc;
                                            break;
                                        }
                                    }
                                }
                                if (constraintObject == null) break block20;
                                if (!verb.equals("MODIFY")) break block21;
                                StorageObject proxy = this.storageDesign.getStorageObject(constraintObject.getObjectID());
                                if (proxy == null) break block22;
                                this.setConstraintState(proxy, clause, false);
                                break block18;
                            }
                            if (!(constraintObject instanceof FKIndexAssociation)) break block18;
                            if (!Token.hasToken(modifyConstraint, "RELY")) break block23;
                            ((FKIndexAssociation)constraintObject).setRely(true);
                            break block18;
                        }
                        if (!Token.hasToken(modifyConstraint, "NORELY")) break block18;
                        ((FKIndexAssociation)constraintObject).setRely(false);
                        break block18;
                    }
                    if (!verb.equals("DROP")) break block24;
                    constraintObject.remove();
                    break block18;
                }
                if (!verb.equals("RENAME") || (newName = Token.getFirstName(afterTo = Token.getStringAfter(modifyConstraint, "TO"), '\"', '\"')).isEmpty()) break block18;
                constraintObject.setName(newName);
                constraintObject.setNameHasQuotes(afterTo.startsWith("\"") && !newName.equals(newName.toUpperCase()));
                break block18;
            }
            for (Column column : this.table.getElementsAndNestedElementsCollection()) {
                String afterTo;
                String newName;
                String columnCheckConstraintName = column.getConstraintName();
                if (constraintName.equalsIgnoreCase(columnCheckConstraintName)) {
                    String afterTo2;
                    String newName2;
                    if (verb.equals("MODIFY")) {
                        RelationalObjectProxy columnProxy = this.storageDesign.getColumnProxySet().getProxy(column.getObjectID());
                        if (columnProxy == null) break;
                        this.setConstraintState(columnProxy, clause, false);
                        break;
                    }
                    if (verb.equals("DROP")) {
                        column.setCheck(null);
                        column.setValueList(null);
                        column.clearAVTs();
                        break;
                    }
                    if (!verb.equals("RENAME") || (newName2 = Token.getFirstName(afterTo2 = Token.getStringAfter(modifyConstraint, "TO"), '\"', '\"')).isEmpty()) break;
                    column.setConstraintName(newName2);
                    break;
                }
                String columnProxyNncName = column.getNotNullConstraintName();
                if (!constraintName.equalsIgnoreCase(columnProxyNncName)) continue;
                if (verb.equals("MODIFY")) {
                    RelationalObjectProxy columnProxy = this.storageDesign.getColumnProxySet().getProxy(column.getObjectID());
                    if (columnProxy == null) break;
                    this.setConstraintState(columnProxy, clause, true);
                    break;
                }
                if (verb.equals("DROP")) {
                    column.setNullsAllowed(true);
                    break;
                }
                if (!verb.equals("RENAME") || (newName = Token.getFirstName(afterTo = Token.getStringAfter(modifyConstraint, "TO"), '\"', '\"')).isEmpty()) break;
                column.setNotNullConstraintName(newName);
                break;
            }
        }
    }

    private void setConstraintState(StorageObject constraintObject, String clause, boolean notNullConstraint) {
        String deferrable = null;
        String initially = null;
        String enable = null;
        String validate = null;
        String rely = null;
        if (Token.hasToken(clause, "DEFERRABLE")) {
            deferrable = Token.getTokenBefore(clause, "DEFERRABLE").equalsIgnoreCase("NOT") ? "NO" : "YES";
        }
        if (Token.hasToken(clause, "INITIALLY")) {
            initially = Token.getTokenAfter(clause, "INITIALLY").toUpperCase(Locale.ENGLISH);
        }
        if (Token.hasToken(clause, "DISABLE")) {
            enable = "NO";
            validate = "NO";
        } else if (Token.hasToken(clause, "ENABLE")) {
            enable = "YES";
        }
        if (Token.hasToken(clause, "NOVALIDATE")) {
            validate = "NO";
        } else if (Token.hasToken(clause, "VALIDATE")) {
            validate = "YES";
        }
        if (Token.hasToken(clause, "NORELY")) {
            rely = "NO";
        } else if (Token.hasToken(clause, "RELY")) {
            rely = "YES";
        }
        TableProxyOracle excTable = null;
        String exceptionsTable = Token.getStringAfter(clause, "EXCEPTIONS INTO");
        if (exceptionsTable.length() > 0) {
            String excTableName = Token.getFirstName(exceptionsTable, '\"', '\"');
            int dotIndex = excTableName.indexOf(46);
            if (dotIndex > 0) {
                String userName = excTableName.substring(0, dotIndex);
                excTableName = excTableName.substring(dotIndex + 1);
                excTable = (TableProxyOracle)this.storageDesign.getTableProxySet().getByUserSchemaAndName(userName, excTableName);
            }
            if (excTable == null) {
                excTable = (TableProxyOracle)this.storageDesign.getTableProxySet().getByName(excTableName);
            }
        }
        if (constraintObject instanceof PKProxyOracle) {
            PKProxyOracle pkProxy = (PKProxyOracle)constraintObject;
            if (deferrable != null) {
                pkProxy.setDeferrable(deferrable);
            }
            if (initially != null) {
                pkProxy.setInitially(initially);
            }
            if (enable != null) {
                pkProxy.setEnable(enable);
            }
            if (validate != null) {
                pkProxy.setValidate(validate);
            }
            if (rely != null) {
                pkProxy.setRely(rely);
            }
            if (excTable != null) {
                pkProxy.setExceptionsTable(excTable);
            }
        } else if (constraintObject instanceof UniqueOracle) {
            UniqueOracle unique = (UniqueOracle)constraintObject;
            if (deferrable != null) {
                unique.setDeferrable(deferrable);
            }
            if (initially != null) {
                unique.setInitially(initially);
            }
            if (enable != null) {
                unique.setEnable(enable);
            }
            if (validate != null) {
                unique.setValidate(validate);
            }
            if (rely != null) {
                unique.setRely(rely);
            }
            if (excTable != null) {
                unique.setExceptionsTable(excTable);
            }
        } else if (constraintObject instanceof FKProxyOracle) {
            FKProxyOracle fkProxy = (FKProxyOracle)constraintObject;
            if (deferrable != null) {
                fkProxy.setDeferrable(deferrable);
            }
            if (initially != null) {
                fkProxy.setInitially(initially);
            }
            if (enable != null) {
                fkProxy.setEnable(enable);
            }
            if (validate != null) {
                fkProxy.setValidate(validate);
            }
            if (rely != null) {
                fkProxy.setRely(rely);
            }
            if (excTable != null) {
                fkProxy.setExceptionsTable(excTable);
            }
        } else if (constraintObject instanceof TableCheckConstraintOracle) {
            TableCheckConstraintOracle checkProxy = (TableCheckConstraintOracle)constraintObject;
            if (deferrable != null) {
                checkProxy.setDeferrable(deferrable);
            }
            if (initially != null) {
                checkProxy.setInitially(initially);
            }
            if (enable != null) {
                checkProxy.setEnable(enable);
            }
            if (validate != null) {
                checkProxy.setValidate(validate);
            }
            if (excTable != null) {
                checkProxy.setExceptionsTable(excTable);
            }
        } else if (constraintObject instanceof ColumnProxyOracle) {
            ColumnProxyOracle columnProxy = (ColumnProxyOracle)constraintObject;
            if (deferrable != null) {
                if (notNullConstraint) {
                    columnProxy.setNncDeferrable(deferrable);
                } else {
                    columnProxy.setDeferrable(deferrable);
                }
            }
            if (initially != null) {
                if (notNullConstraint) {
                    columnProxy.setNncInitially(initially);
                } else {
                    columnProxy.setInitially(initially);
                }
            }
            if (enable != null) {
                if (notNullConstraint) {
                    columnProxy.setNncEnable(enable);
                } else {
                    columnProxy.setEnable(enable);
                }
            }
            if (validate != null) {
                if (notNullConstraint) {
                    columnProxy.setNncValidate(validate);
                } else {
                    columnProxy.setValidate(validate);
                }
            }
            if (rely != null && notNullConstraint) {
                columnProxy.setNncRely(rely);
            }
            if (excTable != null) {
                if (notNullConstraint) {
                    columnProxy.setNncExceptionsTable(excTable);
                } else {
                    columnProxy.setExceptionsTable(excTable);
                }
            }
        }
    }
}

