/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateDatabaseSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataFileSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.FileGroupSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateDatabaseSqlServerv2k5
extends SHCreateDatabaseSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateDatabaseSqlServerv2k5.class);
    private DataBaseSqlServerv2k5 db;

    public SHCreateDatabaseSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateDatabaseSqlServerv2k5.clearCR(line);
        if (Token.startsWithString(statement, "create database")) {
            try {
                this.parseDatabase(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(e);
                this.importLog.addFailedStatement(SHCreateDatabaseSqlServerv2k5.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    @Override
    public void parseDatabase(String statement) {
        this.statement = statement;
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(site);
        if (storageDesign != null) {
            this.db = (DataBaseSqlServerv2k5)storageDesign.getDataBaseSet().createDataBase();
            if (this.db != null) {
                if (Token.hasToken(this.statement, "ON") && !Token.getTokenBefore(this.statement, "ON").equalsIgnoreCase("LOG")) {
                    ((StorageObjectCollection)this.db.getChild(0)).removeAll();
                }
                String nameDB = this.initDatabaseName();
                this.db.setName(nameDB);
                this.design.getRelationalDesign().stampModelObjectDDL(this.db);
                this.initOn(this.db, storageDesign);
                this.initLogOn(this.db, storageDesign);
                this.initCollate();
            }
        }
    }

    private String initDatabaseName() {
        String temp = Token.getTokenAfter(this.statement, "DATABASE").trim();
        String name = temp.startsWith("[") ? Token.getNameAfterToken(this.statement, "DATABASE", '[', ']').trim() : Token.getNameAfterToken(this.statement, "DATABASE", '\"', '\"').trim();
        return name;
    }

    private void initOn(DataBaseSqlServerv2k5 db, StorageDesignSqlServerv2k5 storageDesign) {
        if (Token.hasToken(this.statement, "ON") && !Token.getTokenBefore(this.statement, "ON").equalsIgnoreCase("LOG")) {
            String values = Token.getStringAfter(this.statement, "ON").trim();
            if (Token.hasString(values, "LOG ON")) {
                values = values.substring(0, values.toUpperCase().indexOf("LOG ON"));
            }
            FileGroupSqlServerv2k5 fgroup = null;
            DataFileSqlServerv2k5 datafile = null;
            String groupToken = Token.getStringBefore(values, "FILEGROUP").trim();
            values = values.substring(groupToken.length());
            if ("".equalsIgnoreCase(groupToken)) {
                groupToken = values;
            }
            String groupName = "";
            boolean lastGroup = true;
            while (!groupToken.equalsIgnoreCase("")) {
                if (groupToken.toUpperCase().startsWith("FILEGROUP")) {
                    groupToken = groupToken.substring(10);
                }
                groupName = Token.getTokenBefore(groupToken, "(");
                groupToken = groupToken.substring(groupName.length());
                if (groupName.equalsIgnoreCase("")) {
                    groupName = "PRIMARY";
                }
                String fGroupName = Token.getValBetweenSquareBrackets(groupName.trim());
                fgroup = (FileGroupSqlServerv2k5)storageDesign.getFileGroupSet().getByName(fGroupName);
                if (fgroup == null || fgroup.getDataBase() != db) {
                    fgroup = (FileGroupSqlServerv2k5)storageDesign.getFileGroupSet().createFileGroup();
                    this.design.getRelationalDesign().stampModelObjectDDL(fgroup);
                    fgroup.setDataBase(db);
                    fgroup.setName(Token.getValBetweenSquareBrackets(groupName.trim()));
                    StorageObjectCollection groups = (StorageObjectCollection)db.getChild(0);
                    fgroup.setParent(groups);
                    groups.add(fgroup);
                }
                while (!groupToken.equalsIgnoreCase("") && Token.hasCloseAndOpenBrackets(groupToken) && !Token.getValBetweenBrackets(groupToken, 1).trim().equalsIgnoreCase("")) {
                    String log = Token.getValBetweenBrackets(groupToken, 1);
                    StringTokenizer tokens = new StringTokenizer(log, ",");
                    String token = "";
                    datafile = (DataFileSqlServerv2k5)storageDesign.getDataFileSet().createDataFile();
                    this.design.getRelationalDesign().stampModelObjectDDL(datafile);
                    datafile.setFileGroup(fgroup);
                    StorageObjectCollection files = (StorageObjectCollection)fgroup.getChild(0);
                    datafile.setParent(files);
                    files.add(datafile);
                    if (tokens.hasMoreTokens()) {
                        token = tokens.nextToken();
                        token = this.initLogName(datafile, tokens, token);
                        token = this.initLogFileName(datafile, tokens, token);
                        token = this.initLogSize(datafile, tokens, token);
                        token = this.initLogMaxSize(datafile, tokens, token);
                        this.initLogFileGrowth(datafile, token);
                    }
                    groupToken = groupToken.trim().substring(log.length() + 2);
                }
                if (values.trim().toUpperCase().startsWith("FILEGROUP")) {
                    String tmp = values.trim().substring(10);
                    if (Token.hasToken(tmp, "FILEGROUP")) {
                        tmp = Token.getStringBefore(tmp, "FILEGROUP");
                    }
                    groupToken = "FILEGROUP " + tmp;
                } else {
                    groupToken = Token.getStringBefore(values, "FILEGROUP").trim();
                }
                if ("".equalsIgnoreCase(groupToken)) continue;
                if ((values = values.trim().substring(groupToken.length()).trim()).startsWith(",")) {
                    values = values.substring(1).trim();
                }
                if (!groupToken.equalsIgnoreCase("") || values.equalsIgnoreCase("") || values.equalsIgnoreCase(")") || !lastGroup) continue;
                groupToken = values;
                lastGroup = false;
            }
        }
    }

    private void initLogOn(DataBaseSqlServerv2k5 db, StorageDesignSqlServerv2k5 storageDesign) {
        if (Token.hasToken(this.statement, "LOG") && Token.getTokenAfter(this.statement, "LOG").trim().equalsIgnoreCase("ON")) {
            String values = Token.getStringAfter(this.statement, "LOG ON").trim();
            DataFileSqlServerv2k5 logfile = null;
            if (Token.hasString(values, "COLLATE")) {
                values = Token.getStringBefore(values, "COLLATE");
            }
            while (!values.equalsIgnoreCase("") && !Token.getValBetweenBrackets(values, 1).trim().equalsIgnoreCase("")) {
                String log = Token.getValBetweenBrackets(values, 1);
                StringTokenizer tokens = new StringTokenizer(log, ",");
                String token = "";
                logfile = (DataFileSqlServerv2k5)storageDesign.getDataFileSet().createDataFile();
                this.design.getRelationalDesign().stampModelObjectDDL(logfile);
                logfile.setDataBase(db);
                StorageObjectCollection logs = (StorageObjectCollection)db.getChild(1);
                logfile.setParent(logs);
                logs.add(logfile);
                if (tokens.hasMoreTokens()) {
                    token = tokens.nextToken();
                    token = this.initLogName(logfile, tokens, token);
                    token = this.initLogFileName(logfile, tokens, token);
                    token = this.initLogSize(logfile, tokens, token);
                    token = this.initLogMaxSize(logfile, tokens, token);
                    this.initLogFileGrowth(logfile, token);
                }
                values = values.trim().substring(log.length() + 2);
            }
        }
    }

    private String initLogName(DataFileSqlServerv2k5 logfile, StringTokenizer tokens, String token) {
        if (token.trim().toUpperCase().startsWith("NAME")) {
            String logname = Token.getStringAfter(token, "NAME").trim();
            if ((logname = Token.getStringAfter(logname, "=").trim()).startsWith("N'")) {
                logname = logname.substring(1);
            }
            if (logname.startsWith("'")) {
                logname = Token.getValBetweenQuotationMarks(logname);
            }
            logfile.setName(Token.getValBetweenSquareBrackets(logname));
            if (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
            }
        }
        return token;
    }

    private String initLogFileName(DataFileSqlServerv2k5 logfile, StringTokenizer tokens, String token) {
        if (token.trim().toUpperCase().startsWith("FILENAME")) {
            String fname = Token.getStringAfter(token, "FILENAME").trim();
            if ((fname = Token.getStringAfter(fname, "=").trim()).startsWith("N'")) {
                fname = fname.substring(1);
            }
            if (fname.startsWith("'")) {
                fname = Token.getValBetweenQuotationMarks(fname);
            }
            logfile.setFileName(Token.getValBetweenSquareBrackets(fname));
            if (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
            }
        }
        return token;
    }

    private String initLogSize(DataFileSqlServerv2k5 logfile, StringTokenizer tokens, String token) {
        if (token.trim().toUpperCase().startsWith("SIZE")) {
            String size = Token.getStringAfter(token, "SIZE");
            size = Token.getStringAfter(size, "=").trim();
            try {
                String unit = this.parseForUnit(size);
                if (!unit.equals("")) {
                    String inUnit = logfile.getSizeInUnitFromUnit(unit);
                    if (!inUnit.equals("")) {
                        logfile.setInitialSizeInUnit(inUnit);
                    }
                    size = size.substring(0, size.length() - 2).trim();
                }
                logfile.setInitialSize(Integer.parseInt(size));
            }
            catch (NumberFormatException e) {
                LOGGER.error("Wrong format:", e);
                this.importLog.addWarning("Unknown initialial size of file " + logfile.getName());
            }
            if (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
            }
        }
        return token;
    }

    private String initLogMaxSize(DataFileSqlServerv2k5 logfile, StringTokenizer tokens, String token) {
        if (token.trim().toUpperCase().startsWith("MAXSIZE")) {
            String maxsize = Token.getStringAfter(token, "MAXSIZE");
            if ((maxsize = Token.getStringAfter(maxsize, "=").trim()).equalsIgnoreCase("UNLIMITED")) {
                logfile.setIsUnlimited(true);
            } else {
                try {
                    String unit = this.parseForUnit(maxsize);
                    if (!unit.equals("")) {
                        String inUnit = logfile.getSizeInUnitFromUnit(unit);
                        if (!inUnit.equals("")) {
                            logfile.setMaxSizeInUnit(inUnit);
                        }
                        maxsize = maxsize.substring(0, maxsize.length() - 2).trim();
                    }
                    logfile.setMaxSize(Integer.parseInt(maxsize));
                    logfile.setIsUnlimited(false);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("", e);
                    this.importLog.addWarning("Unknown max size of file " + logfile.getName());
                }
            }
            if (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
            }
        }
        return token;
    }

    private void initLogFileGrowth(DataFileSqlServerv2k5 logfile, String token) {
        if (token.trim().toUpperCase().startsWith("FILEGROWTH")) {
            String filegrowth = Token.getStringAfter(token, "FILEGROWTH").trim();
            filegrowth = Token.getStringAfter(token, "=").trim();
            if (Token.hasString(filegrowth, "%")) {
                logfile.setGrowthMethod("By Percent");
                filegrowth = filegrowth.substring(0, filegrowth.length() - 1).trim();
            } else {
                logfile.setGrowthMethod("In MegaBytes");
            }
            try {
                String unit = this.parseForUnit(filegrowth);
                if (!unit.equals("")) {
                    String inUnit = logfile.getSizeInUnitFromUnit(unit);
                    if (!inUnit.equals("")) {
                        logfile.setGrowthMethod(inUnit);
                    }
                    filegrowth = filegrowth.substring(0, filegrowth.length() - 2).trim();
                }
                logfile.setGrowthValue(Integer.parseInt(filegrowth));
            }
            catch (NumberFormatException e) {
                LOGGER.error("Wrong format:", e);
                this.importLog.addWarning("Unknown filegrowth of file " + logfile.getName());
            }
        }
    }

    private void initCollate() {
        if (Token.hasToken(this.statement, "COLLATE")) {
            String collate = Token.getStringAfter(this.statement, "COLLATE");
            this.db.setCollationName(collate);
        }
    }

    private String parseForUnit(String spec) {
        String unit;
        if (spec.length() > 2 && ((unit = spec.substring(spec.length() - 2)).equalsIgnoreCase("KB") || unit.equalsIgnoreCase("MB") || unit.equalsIgnoreCase("GB") || unit.equalsIgnoreCase("TB"))) {
            return unit;
        }
        return "";
    }
}

