/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBMOConstants;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTableOracle;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.ValidTimeDimension;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.util.Closeables;

public class CheckConstraintsImport
implements DBMOConstants {
    private StorageDesign sd;
    private boolean dbaUser;
    private static final Logger LOGGER = new Logger(CheckConstraintsImport.class);
    AbstractDBMExtractionHandler handler;
    private final String NOT_NULL_PATTERN = " IS NOT NULL";

    public CheckConstraintsImport(StorageDesign sd, boolean dbaUser, AbstractDBMExtractionHandler handler) {
        this.sd = sd;
        this.dbaUser = dbaUser;
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCHECK_Constraints(Connection sqlConnection, List<DBObject> dbos) throws Exception {
        StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
        ArrayList<MOHTableOracle.ConstrHelper> clist = new ArrayList<MOHTableOracle.ConstrHelper>();
        StringBuffer buffer = new StringBuffer();
        PreparedStatement statement = null;
        TreeMap map = new TreeMap();
        try {
            boolean canChangeContainer = true;
            HashMap<String, List<String>> tmap = new HashMap<String, List<String>>();
            ArrayList<String> schList = new ArrayList<String>();
            HashMap nmap = new HashMap();
            MOHTableOracle.prepareNameMaps(schList, tmap, nmap, dbos);
            for (String schema : schList) {
                List tlist = (List)tmap.get(schema);
                String incl = tlist.size() > 990 ? MOHTableOracle.getInParamExpr(tlist.size(), "table_name", 600) : MOHTableOracle.getInParamExpr(tlist.size(), "table_name");
                Table temp = null;
                statement = null;
                buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("TABLE_NAME").append(',').append(' ');
                buffer.append("CONSTRAINT_NAME").append(',').append(' ');
                buffer.append("CONSTRAINT_TYPE").append(',').append(' ');
                buffer.append("DEFERRED").append(',').append(' ');
                buffer.append("STATUS").append(',').append(' ');
                buffer.append("DEFERRABLE").append(',').append(' ');
                buffer.append("VALIDATED").append(',').append(' ');
                buffer.append("RELY").append(',').append(' ');
                if (storage instanceof StorageDesignOraclev12c) {
                    buffer.append("SEARCH_CONDITION_VC as SEARCH_CONDITION").append(',');
                    buffer.append("ORIGIN_CON_ID").append(' ');
                } else {
                    buffer.append("SEARCH_CONDITION").append(' ');
                }
                buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_constraints" : "all_constraints").append(' ');
                buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
                buffer.append("AND").append(' ').append("CONSTRAINT_TYPE").append(' ').append('=').append(' ').append("'C'");
                buffer.append("AND").append(' ').append(incl);
                buffer.append("ORDER BY").append(' ').append("CONSTRAINT_NAME");
                String sql = buffer.toString();
                boolean first = true;
                String ownerName = schema;
                ResultSet rs = null;
                try {
                    statement = sqlConnection.prepareStatement(sql);
                    statement.setString(1, ownerName);
                    if (storage instanceof StorageDesignOraclev12c) {
                        statement.setFetchSize(100);
                    }
                    int k = 1;
                    for (String tname : tlist) {
                        statement.setString(++k, tname);
                    }
                    rs = statement.executeQuery();
                    first = true;
                    if (rs == null) continue;
                    while (rs.next()) {
                        String t_name = rs.getString(1);
                        DBObject dbo = (DBObject)nmap.get(schema + "." + t_name);
                        Table table = (Table)dbo.getTable();
                        TableProxyOracle tableProxy = (TableProxyOracle)dbo.getTableProxy();
                        if (table != temp) {
                            first = true;
                            temp = table;
                        }
                        String constrName = rs.getString("CONSTRAINT_NAME");
                        String constrType = rs.getString("CONSTRAINT_TYPE");
                        String deferred = rs.getString("DEFERRED");
                        String status = rs.getString("STATUS");
                        String deferrable = rs.getString("DEFERRABLE");
                        String validated = rs.getString("VALIDATED");
                        String rely = rs.getString("RELY");
                        String condition = rs.getString("SEARCH_CONDITION");
                        MOHTableOracle.ConstrHelper ch = new MOHTableOracle.ConstrHelper();
                        clist.add(ch);
                        ch.owner = ownerName;
                        ch.cname = constrName;
                        ch.deferred = deferred;
                        ch.deferrable = deferrable;
                        ch.status = status;
                        ch.validated = validated;
                        ch.condition = condition;
                        ch.table = table;
                        ch.tableProxy = tableProxy;
                        if (canChangeContainer && condition != null && condition.length() >= 4000 && storage instanceof StorageDesignOraclev12c) {
                            String containerName = null;
                            int conId = rs.getInt("ORIGIN_CON_ID");
                            if (conId == 1) {
                                containerName = "CDB$ROOT";
                            } else if (conId == 2) {
                                containerName = "PDB$SEED";
                            }
                            if (containerName != null) {
                                String savedConName = null;
                                Statement st = sqlConnection.createStatement();
                                ResultSet rSet = st.executeQuery("SELECT SYS_CONTEXT('USERENV', 'CON_NAME') FROM DUAL");
                                if (rSet != null) {
                                    if (rSet.next()) {
                                        savedConName = rSet.getString(1);
                                    }
                                    rSet.close();
                                }
                                if (savedConName != null) {
                                    boolean containerChanged = false;
                                    try {
                                        st.execute("ALTER SESSION SET CONTAINER = " + containerName);
                                        containerChanged = true;
                                        try {
                                            buffer = new StringBuffer();
                                            buffer.append("SELECT").append(' ');
                                            buffer.append("SEARCH_CONDITION").append(' ');
                                            buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_constraints" : "all_constraints").append(' ');
                                            buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
                                            buffer.append("AND").append(' ').append("TABLE_NAME").append('=').append('?').append(' ');
                                            buffer.append("AND").append(' ').append("CONSTRAINT_NAME").append('=').append('?');
                                            PreparedStatement conditionQuery = sqlConnection.prepareStatement(buffer.toString());
                                            conditionQuery.setString(1, ownerName);
                                            conditionQuery.setString(2, dbo.getName());
                                            conditionQuery.setString(3, constrName);
                                            ResultSet newRS = conditionQuery.executeQuery();
                                            if (newRS != null) {
                                                while (newRS.next()) {
                                                    String searchCondition = newRS.getString("SEARCH_CONDITION");
                                                    if (searchCondition == null) continue;
                                                    condition = searchCondition;
                                                }
                                            }
                                            conditionQuery.close();
                                        }
                                        catch (Exception e) {
                                            LOGGER.error("CheckConstraintsImport.initCHECK_Constraints():", e);
                                        }
                                    }
                                    catch (Exception e) {
                                        canChangeContainer = false;
                                        LOGGER.error("CheckConstraintsImport: ALTER SESSION SET CONTAINER failed", e);
                                    }
                                    if (containerChanged) {
                                        try {
                                            st.execute("ALTER SESSION SET CONTAINER = " + savedConName);
                                        }
                                        catch (Exception e) {
                                            LOGGER.error("CheckConstraintsImport: Reinstate Container failed", e);
                                        }
                                    }
                                }
                                st.close();
                            }
                        }
                        if (condition == null) continue;
                        ch.condition = condition;
                    }
                    rs.close();
                }
                catch (Exception e) {
                    LOGGER.error("CheckConstraintsImport.initCHECK_Constraints():", e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("CheckConstraintsImport.initCHECK_Constraints():", e);
        }
        finally {
            Closeables.close(statement);
        }
        TimeLog.log("Check ConstraintColumns begin");
        MOHTableOracle.initConstraintColumns(sqlConnection, Collections.EMPTY_MAP, Collections.EMPTY_LIST, clist, this.dbaUser);
        TimeLog.log("Check ConstraintColumns end");
        for (MOHTableOracle.ConstrHelper ch : clist) {
            this.processCheckConstr(ch);
        }
    }

    private void processCheckConstr(MOHTableOracle.ConstrHelper ch) {
        Object colName;
        Column column;
        String constrName = ch.cname;
        String deferred = ch.deferred;
        String status = ch.status;
        String deferrable = ch.deferrable;
        String validated = ch.validated;
        String condition = ch.condition;
        List<String> columns = ch.columns;
        TableProxyOracle tableProxy = ch.tableProxy;
        Table table = (Table)ch.table;
        if (columns != null && columns.size() == 1 && (column = (Column)table.getElementByName((String)(colName = columns.get(0)))) != null) {
            String nn_pat = (String)colName + " IS NOT NULL";
            if (nn_pat.equalsIgnoreCase(condition.trim().replaceAll("\"", ""))) {
                ColumnProxyOracle cp;
                column.setNullsAllowed(false);
                Column colOrNestedCol = (Column)table.getElementByName((String)colName);
                if (colOrNestedCol != null && (cp = (ColumnProxyOracle)tableProxy.getColumnProxy(colOrNestedCol.getObjectID())) != null) {
                    if ("ENABLED".equalsIgnoreCase(status)) {
                        cp.setNncEnable("YES");
                    } else {
                        cp.setNncEnable("NO");
                    }
                    if (deferrable.equals("DEFERRABLE")) {
                        cp.setNncDeferrable("YES");
                    } else {
                        cp.setNncDeferrable("NO");
                    }
                    if (deferred.equals("DEFERRED")) {
                        cp.setNncInitially("DEFERRED");
                    } else {
                        cp.setNncInitially("IMMEDIATE");
                    }
                    if (validated.equals("VALIDATED")) {
                        cp.setNncValidate("YES");
                    } else {
                        cp.setNncValidate("NO");
                    }
                    if (!constrName.startsWith("SYS_C") || !column.getAppView().getSettings().isReplaceSystemNamesDuringImport()) {
                        column.setNotNullConstraintName(constrName);
                    }
                }
                return;
            }
            if (column.getCheck() == null) {
                ColumnProxyOracle cp;
                String checkPart = condition;
                boolean separated = column.setSeparatedConstraints(condition);
                if (separated) {
                    checkPart = column.getSeparatedCheckConstraint();
                }
                if (!"".equals(checkPart)) {
                    CheckConstraint cconstraint = new CheckConstraint();
                    cconstraint.setDesign(table.getDesign());
                    cconstraint.setName(constrName);
                    this.stampModelObject(cconstraint, table.getName(), constrName);
                    RDBMSType rdbmsType = StorageDesignOraclev11g.RDBMS_TYPE;
                    if (this.getStorageDesign() != null) {
                        rdbmsType = this.getStorageDesign().getRDBMSType();
                    }
                    cconstraint.add(rdbmsType, checkPart);
                    column.setUseDomainConstraints(false);
                    column.setCheck(cconstraint);
                    column.setConstraintName(constrName);
                    column.setCheckConstraintValue(checkPart);
                }
                if (separated) {
                    String rangeList = column.getSeparatedRangeConstraint();
                    if (!"".equals(rangeList)) {
                        String[] rangeParts = rangeList.split(",");
                        int i = 0;
                        while (i < rangeParts.length) {
                            String rangeFrom = rangeParts[i++];
                            String rangeTo = rangeParts[i++];
                            AVT avt = new AVT(rangeFrom.trim(), rangeTo.trim(), "");
                            column.setUseDomainConstraints(false);
                            column.addAVT(avt);
                            column.setConstraintName(constrName);
                        }
                    }
                    String valueList = column.getSeparatedValueConstraint();
                    String likeList = column.getSeparatedLikeConstraint();
                    if (!"".equals(valueList) || !"".equals(likeList)) {
                        ConstraintEnumeration lov = new ConstraintEnumeration();
                        if (!valueList.isEmpty()) {
                            String[] valueParts = valueList.split(",");
                            for (int i = 0; i < valueParts.length; ++i) {
                                lov.add(valueParts[i].trim());
                            }
                        }
                        if (!likeList.isEmpty()) {
                            String[] likeParts = likeList.split(",");
                            for (int i = 0; i < likeParts.length; ++i) {
                                lov.add(likeParts[i].trim(), "LIKE");
                            }
                        }
                        column.setUseDomainConstraints(false);
                        column.setValueList(lov);
                        column.setConstraintName(constrName);
                    }
                }
                if ((cp = (ColumnProxyOracle)tableProxy.getColumnProxyByName((String)colName)) != null) {
                    if ("ENABLED".equalsIgnoreCase(status)) {
                        cp.setEnable("YES");
                    } else {
                        cp.setEnable("NO");
                    }
                    if (deferrable.equals("DEFERRABLE")) {
                        cp.setDeferrable("YES");
                    } else {
                        cp.setDeferrable("NO");
                    }
                    if (deferred.equals("DEFERRED")) {
                        cp.setInitially("DEFERRED");
                    } else {
                        cp.setInitially("IMMEDIATE");
                    }
                    if (validated.equals("VALIDATED")) {
                        cp.setValidate("YES");
                    } else {
                        cp.setValidate("NO");
                    }
                }
                return;
            }
        }
        if (columns != null && columns.size() > 1) {
            for (ValidTimeDimension validTimeDimension : table.getValidTimeDimensions()) {
                int lessThanIndex;
                String vdtName = validTimeDimension.getName();
                if (!constrName.startsWith(vdtName)) continue;
                boolean hasVDTRef = false;
                boolean hasOtherRef = false;
                for (String colName2 : columns) {
                    if (colName2.equals(vdtName)) {
                        hasVDTRef = true;
                        continue;
                    }
                    if (colName2.startsWith(vdtName + '_')) continue;
                    hasOtherRef = true;
                }
                if (!hasVDTRef && hasOtherRef) continue;
                String text = condition;
                if (text.startsWith("(")) {
                    text = Token.getValBetweenBrackets(text, 1);
                }
                if ((lessThanIndex = text.indexOf(60)) > -1) {
                    String startColName = Token.getFirstName(text.substring(0, lessThanIndex), '\"', '\"');
                    String endColName = Token.getFirstName(text.substring(lessThanIndex + 1), '\"', '\"');
                    Column startCol = (Column)table.getElementByName(startColName);
                    Column endCol = (Column)table.getElementByName(endColName);
                    if (startCol != null && endCol != null) {
                        validTimeDimension.setStartTimeColumn(startCol);
                        validTimeDimension.setEndTimeColumn(endCol);
                    }
                }
                return;
            }
        }
        TableLevelConstraint constraint = table.createCheckConstraint(constrName, condition);
        if (!constrName.equals(constrName.toUpperCase())) {
            constraint.setNameHasQuotes(true);
        }
        table.addCheckConstraint(constraint);
        this.stampModelObject(constraint, table.getSchema(), constrName);
        TableCheckConstraintOracle proxy = tableProxy.getTableConstraint(constraint);
        if (proxy != null) {
            if (status.equals("ENABLED")) {
                proxy.setEnable("YES");
            } else {
                proxy.setEnable("NO");
            }
            if (deferrable.equals("DEFERRABLE")) {
                proxy.setDeferrable("YES");
            } else {
                proxy.setDeferrable("NO");
            }
            if (deferred.equals("DEFERRED")) {
                proxy.setInitially("DEFERRED");
            } else {
                proxy.setInitially("IMMEDIATE");
            }
            if (validated.equals("VALIDATED")) {
                proxy.setValidate("YES");
            } else {
                proxy.setValidate("NO");
            }
        }
    }

    private AbstractDBMExtractionHandler getDbmeHandler() {
        return this.handler;
    }

    private StorageDesign getStorageDesign() {
        return this.sd;
    }

    private Design getDesign() {
        return this.sd.getDesign();
    }

    private RelationalDesign getRelationalDesign() {
        if (this.sd != null) {
            return this.sd.getPhysicalDesign();
        }
        return null;
    }

    public void stampModelObject(ModelObject obj, String schemaName, String objectName) {
        RelationalDesign rel = this.getRelationalDesign();
        if (obj instanceof DesignObject) {
            if (((DesignObject)obj).getDesignPart() instanceof RelationalDesign) {
                rel = (RelationalDesign)((DesignObject)obj).getDesignPart();
            }
        } else if (obj instanceof StorageObject) {
            rel = ((StorageObject)obj).getStorageDesign().getPhysicalDesign();
        }
        if (!rel.getImportConnectionStamps().isEmpty() && rel.getImportConnectionStampIndex() > -1) {
            int index = rel.getImportConnectionStampIndex();
            DBConnectionStamp importConnStamp = rel.getImportConnectionStamp(index);
            obj.setSourceConnName(importConnStamp.getConnName());
            obj.setSourceObjSchema(schemaName != null ? schemaName : "");
            obj.setSourceObjName(objectName);
        }
    }
}

