/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import com.adbs.ast.KeywordFormat;
import com.adbs.querybuilder.PlainTextSQLBuilder;
import com.adbs.querybuilder.QueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.OptimizerHint;
import oracle.dbtools.crest.imports.ddl.db2.SHCreateView;
import oracle.dbtools.crest.imports.ddl.oracle.SHCreateViewOracle;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHCreateViewSqlServer;
import oracle.dbtools.crest.imports.ddl.udb.SHCreateViewUDB;
import oracle.dbtools.crest.imports.ddl.udb.v81.SHCreateViewUDBv81;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.ContainerObjectPH_ShortName;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.KeyObjectSet;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.ViewIndex;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.viewbuilder.QBUtils;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class AbstractView
extends FKContainer
implements ContainerObjectListener {
    public static final String PK_INDEX = "PK_INDEX.class";
    private static final Object[] INDEX_ASSOCIATION_PROTO = FKIndexAssociationSet.PROTOTYPE_ARRAY;
    public static final String VALUE_ASCENDING = "ASC";
    public static final String VALUE_DESCENDING = "DESC";
    public static final String CONTAINER_ID = "containerID";
    public static final String ALIAS = "alias";
    private static final String ID = "id";
    private static final String SORT = "sort";
    private static final String NAME = "name";
    private static final String REF_ELEM_ID = "relem_id";
    private static final String REF_VIEW_ELEM_ID = "rvelem_id";
    public static final String[] SORT_ORDER_CHOICES = new String[]{"ASC", "DESC"};
    public static final String DB2_SYNTAX_PROVIDER = "DB2";
    public static final String FIREBIRD_SYNTAX_PROVIDER = "Firebird";
    public static final String INFORMIX_SYNTAX_PROVIDER = "Informix";
    public static final String MSSQL_SYNTAX_PROVIDER = "MSSQL";
    public static final String MYSQL_SYNTAX_PROVIDER = "MySQL";
    public static final String ORACLE_SYNTAX_PROVIDER = "Oracle";
    public static final String POSTGRESQL_SYNTAX_PROVIDER = "PostgreSQL";
    public static final String SQL2003_SYNTAX_PROVIDER = "SQL2003";
    public static final String SQL89_SYNTAX_PROVIDER = "SQL89";
    public static final String SQL92_SYNTAX_PROVIDER = "SQL92";
    public static final String SQLITE_SYNTAX_PROVIDER = "SQLite";
    public static final String SYBASE_SYNTAX_PROVIDER = "Sybase";
    public static final String[] DB_SYNTAX_PROVIDERS = new String[]{"DB2", "Firebird", "Informix", "MSSQL", "MySQL", "Oracle", "PostgreSQL", "SQLite", "Sybase"};
    protected String where = "";
    protected String groupBy = "";
    protected String having = "";
    protected boolean userDefined = false;
    protected String userDefinedSQL = "";
    String selectDef = null;
    protected Map containerMap = new HashMap();
    protected List tables;
    protected List views;
    protected Map orderByMap = new HashMap();
    protected List orderByList;
    protected List groupByList = new ArrayList();
    protected List<OptimizerHint> optimizerHints = new ArrayList<OptimizerHint>();
    protected DesignObjectCollection phelements = new DesignObjectCollection();
    protected List usedContainers = new ArrayList();
    protected List viewsNotAdded = new ArrayList();
    private String layoutSQL = "";
    protected List sqlNames = new ArrayList();
    private boolean includeSchemaNameInQuery = false;
    private boolean validSQL = true;
    private boolean parsed = false;
    private boolean incorrectSQL = false;
    private String useObjectsOnlyFrom = "";
    private String syntaxProvider = "Oracle";
    private String abbreviation = "";
    protected DesignObjectCollection fkSet;
    protected DesignObjectCollection indSet;
    protected DesignObjectCollection pkSet;
    protected DesignObjectCollection unSet;
    private KeyObjectSet allkeys;
    protected DesignObjectCollection indexOnlySet;
    private Map generatedLists = new TreeMap();
    private String originalTableID = "";
    private static final Logger LOGGER = new Logger(AbstractView.class);
    public static final String TYPE_NAME = "View";

    public AbstractView(DesignPart designPart) {
        super(designPart);
        this.phelements.setParent(this);
        this.orderByList = new ArrayList();
        this.tables = new ArrayList();
        this.views = new ArrayList();
        if (designPart instanceof RelationalDesign) {
            this.initIndexFilters();
        }
    }

    public void initIndexFilters() {
        this.allkeys = this.getKeySet();
        this.indSet = new DesignObjectCollection();
        this.pkSet = new DesignObjectCollection();
        this.unSet = new DesignObjectCollection();
        this.fkSet = new DesignObjectCollection();
        this.unSet.setParent(this);
        this.pkSet.setParent(this);
        this.indSet.setParent(this);
        this.fkSet.setParent(this);
        this.indSet.setDesign(this.getDesign());
        this.indSet.setName(Messages.getString("Table.Indexes"));
        this.indSet.setParent(this);
        this.fkSet.setDesign(this.getDesign());
        this.fkSet.setName(Messages.getString("Table.ForeignKeys"));
        this.pkSet.setDesign(this.getDesign());
        this.pkSet.setName(Messages.getString("Table.PrimaryKeys"));
        this.unSet.setDesign(this.getDesign());
        this.unSet.setName(Messages.getString("Table.UniqueConstraints"));
        this.fkSet.setParent(this);
        this.allkeys.addSetListener(this);
        if (this.getDesignPart() != null) {
            this.indexOnlySet = ((RelationalDesign)this.getDesignPart()).getIndexOnlyPlaceHolderSet();
        }
        this.indSet.setElementDescriptor(ViewIndex.class);
        this.pkSet.setElementDescriptor(PK_INDEX);
        this.unSet.setElementDescriptor(ViewIndex.class);
        this.fkSet.setElementDescriptor(FKIndexAssociation.class);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    public void setContainers(DesignObjectSet set) {
        throw new RuntimeException("Should not be used, table set is found dynamically");
    }

    @Override
    public abstract String getIDPrefix();

    @Override
    public abstract DesignObjectSet getContainedSet();

    public abstract void addToContainers(ContainerObject var1, String var2);

    public abstract void addToContainers(String var1, String var2);

    public abstract void clearContainers();

    public abstract void clearElements(ContainerObject var1);

    public abstract void clearOrderByElements(ContainerObject var1);

    public abstract void importView(DesignObject var1);

    public abstract void updateElements(List var1);

    public abstract AbstractViewElement createViewElement(DesignPart var1);

    public abstract DesignObjectSet getTableSet();

    @Override
    public int getIndexOf(ContainedObject object) {
        return this.phelements.getIndexOf(object);
    }

    @Override
    public int getNumberOfChildren() {
        return this.phelements.size();
    }

    @Override
    public ModelObject getChild(int index) {
        return this.phelements.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        return this.phelements.getIndexForChild(child);
    }

    @Override
    public boolean isLeaf() {
        return this.phelements.size() < 1;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public String getHaving() {
        return this.having;
    }

    public void setHaving(String having) {
        this.having = having;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public void removeAllFromOrderBy() {
        this.orderByMap.clear();
        this.orderByList.clear();
    }

    public String getSortOrder(ContainedObject column) {
        String sortOrder = (String)this.orderByMap.get(column.getObjectID());
        if (sortOrder == null) {
            sortOrder = VALUE_ASCENDING;
        }
        return sortOrder;
    }

    public List getOrderByList() {
        return this.orderByList;
    }

    public String getSortOrder(String objectID) {
        String sortOrder = (String)this.orderByMap.get(objectID);
        if (sortOrder == null) {
            sortOrder = VALUE_ASCENDING;
        }
        return sortOrder;
    }

    public Map getOrderByMap() {
        return this.orderByMap;
    }

    public void removeAllElements() {
        ArrayList list = new ArrayList();
        Iterator it = this.getElementsCollection().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        it = list.iterator();
        while (it.hasNext()) {
            this.remove((ContainedObject)it.next());
        }
    }

    public void removeAllFromElements() {
        this.containerMap.clear();
        this.tables.clear();
        this.views.clear();
        this.usedContainers.clear();
        this.orderByList.clear();
        this.orderByMap.clear();
    }

    @Override
    public void setDesign(Design design) {
        super.setDesign(design);
    }

    public void removeFromOrderBy(ContainedObject object) {
        this.orderByMap.remove(object.getObjectID());
        this.orderByList.remove(object);
    }

    public String getContainerID(String alias) {
        return (String)this.containerMap.get(alias);
    }

    public List getTables() {
        return this.tables;
    }

    public void setTables(List tables) {
        this.tables = tables;
    }

    public List getViews() {
        return this.views;
    }

    public void setViews(List views) {
        this.views = views;
    }

    public Map getContainerMap() {
        return this.containerMap;
    }

    public boolean getUserDefined() {
        return this.userDefined;
    }

    public void setUserDefined(boolean userDefined) {
        this.userDefined = userDefined;
    }

    @Override
    public String getUserDefinedSQL() {
        return this.userDefinedSQL;
    }

    public String getUserDefinedSQL(String newName) {
        return this.userDefinedSQL.replaceAll(this.getName(), newName);
    }

    @Override
    public void setUserDefinedSQL(String userDefinedSQL) {
        this.userDefinedSQL = userDefinedSQL;
        if (!"".equals(userDefinedSQL.trim())) {
            this.setUserDefined(true);
        }
    }

    public void clear(ContainerObject container) {
        this.tables.remove(container);
        this.views.remove(container);
        Object[] obj = this.containerMap.keySet().toArray();
        for (int i = obj.length - 1; i >= 0; --i) {
            String alias = (String)obj[i];
            String containerID = (String)this.containerMap.get(alias);
            if (!container.getObjectID().equalsIgnoreCase(containerID)) continue;
            this.containerMap.remove(alias);
        }
        if (container != this) {
            this.clearElements(container);
        }
        this.clearOrderByElements(container);
    }

    public String getCaption() {
        return "Query";
    }

    public List getGroupByList() {
        return this.groupByList;
    }

    public void addGroupByList(ContainedObject element) {
        this.groupByList.add(element);
    }

    public void removeAllGroupByList() {
        this.groupByList.clear();
    }

    public List<OptimizerHint> getOptimizerHints() {
        return this.optimizerHints;
    }

    public void setOptimizerHints(List<OptimizerHint> optimizerHints) {
        this.optimizerHints = optimizerHints;
    }

    public OptimizerHint createOptimizerHint() {
        OptimizerHint hint = new OptimizerHint("");
        this.optimizerHints.add(hint);
        return hint;
    }

    @Override
    public boolean canCopy() {
        return true;
    }

    public DesignObject getObjectByID(List list, String objectID) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            DesignObject object = (DesignObject)it.next();
            if (!objectID.equals(object.getObjectID())) continue;
            it = null;
            return object;
        }
        return null;
    }

    @Override
    protected void clearStructure() {
        this.userDefinedSQL = "";
        this.where = "";
        this.groupBy = "";
        this.having = "";
        this.removeAll();
    }

    @Override
    protected void updateStructure() {
        if (this.isBST()) {
            TypeElement te;
            int i;
            StructuredType st = this.getBasedOnStructuredType();
            List stElems = st.getAllElements();
            ContainedObject[] coar = this.getElements();
            for (i = 0; i < coar.length; ++i) {
                if (coar[i].isOid() || (te = this.findTypeElement(stElems, coar[i].getStructAttributeID())) != null) continue;
                coar[i].remove();
            }
            this.updateElements(stElems);
            for (i = 0; i < stElems.size(); ++i) {
                te = (TypeElement)stElems.get(i);
                ContainedObject co = this.getElementByStructAttributeID(te.getObjectID());
                if (co == null) continue;
                this.moveToIndex(co, i);
            }
        }
    }

    private TypeElement findTypeElement(List list, String id) {
        for (int i = 0; i < list.size(); ++i) {
            TypeElement te = (TypeElement)list.get(i);
            if (!te.getObjectID().equalsIgnoreCase(id)) continue;
            return te;
        }
        return null;
    }

    public void getElements(String statement) {
        this.getElements(statement, true);
    }

    public void getElements(String statement, boolean asSelectOnly) {
        int type = this.getDesignPart().getAppView().getSettings().getDefaultRDBMSType();
        switch (type) {
            case 0: 
            case 1: {
                SHCreateView viewDB2 = new SHCreateView(this.getDesign());
                viewDB2.setStatement(statement);
                viewDB2.setAsSelectOnly(asSelectOnly);
                viewDB2.setView(this);
                if (viewDB2.initCols()) break;
                viewDB2.initCol();
                break;
            }
            case 2: {
                SHCreateViewUDB viewUDB7 = new SHCreateViewUDB(this.getDesign());
                viewUDB7.setStatement(statement);
                viewUDB7.setAsSelectOnly(asSelectOnly);
                viewUDB7.setView(this);
                if (viewUDB7.initCols()) break;
                viewUDB7.initCol();
                break;
            }
            case 3: 
            case 10: {
                SHCreateViewUDBv81 viewUDB8 = new SHCreateViewUDBv81(this.getDesign());
                viewUDB8.setStatement(statement);
                viewUDB8.setAsSelectOnly(asSelectOnly);
                viewUDB8.setView(this);
                if (viewUDB8.initCols()) break;
                viewUDB8.initCol();
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                SHCreateViewOracle viewOracle = new SHCreateViewOracle(this.getDesign());
                viewOracle.setStatement(statement);
                viewOracle.setAsSelectOnly(asSelectOnly);
                viewOracle.setView(this);
                viewOracle.initCols();
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 13: {
                SHCreateViewSqlServer viewSQLServer = new SHCreateViewSqlServer(this.getDesign());
                viewSQLServer.setStatement(statement);
                viewSQLServer.setAsSelectOnly(asSelectOnly);
                viewSQLServer.setView(this);
                if (viewSQLServer.initCols()) break;
                try {
                    viewSQLServer.initCol();
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("Error in parsing columns!", e);
                }
            }
        }
    }

    protected String appendQuotes(String name) {
        if (name.trim().indexOf(32) > -1) {
            return "\"" + name + "\"";
        }
        return name;
    }

    public String generateSQL() {
        return this.generateSQL(null);
    }

    protected String generateGroupBy() {
        StringBuffer buff = new StringBuffer();
        boolean first = true;
        for (AbstractViewElement elem : this.groupByList) {
            if (first) {
                first = false;
            } else {
                buff.append(",");
                buff.append("\n");
            }
            buff.append(this.getGroupByValue(elem));
        }
        return buff.toString();
    }

    private String getGroupByValue(AbstractViewElement clmView) {
        if (!"".equals(clmView.getExpression())) {
            return clmView.getExpression();
        }
        String name = this.appendQuotes(clmView.getName());
        if (!clmView.getTableAlias().equalsIgnoreCase("")) {
            return this.appendQuotes(clmView.getTableAlias()) + "." + name;
        }
        return name;
    }

    public String generateSQL(StorageDesign sdin) {
        StorageDesign sd = sdin;
        if (sd == null) {
            DesignPart dp = this.getDesignPart();
            sd = dp instanceof RelationalDesign ? ((RelationalDesign)dp).getStorageDesign() : dp.getDesign().getStorageDesign(dp.getSelectedRDBMSSite());
        }
        StringBuffer buff = new StringBuffer();
        ContainedObject[] allElements = this.getElements();
        if (allElements.length > 0) {
            String name;
            AbstractViewElement col;
            int a;
            buff = new StringBuffer("CREATE VIEW ");
            buff.append(sd.getFormatedName(this));
            int i = 0;
            for (a = 0; a < allElements.length; ++a) {
                col = (AbstractViewElement)allElements[a];
                name = col.getAlias().trim();
                if ("".equals(name)) {
                    name = col.getReferencedName();
                }
                if (name.equalsIgnoreCase("")) continue;
                if (i == 0) {
                    buff.append("\n");
                    buff.append("  (");
                } else {
                    buff.append("\n   ,");
                }
                buff.append(' ');
                buff.append(sd.getFormatedName(name));
                ++i;
            }
            buff.append(' ');
            buff.append(')');
            buff.append("\n");
            buff.append(" AS SELECT");
            if (!this.optimizerHints.isEmpty()) {
                for (int j = 0; j < this.optimizerHints.size(); ++j) {
                    OptimizerHint hint = this.optimizerHints.get(j);
                    if (!hint.isOrderedHint()) continue;
                    buff.append(" /*+ ");
                    buff.append(hint.getHint());
                    buff.append(" */");
                    break;
                }
            }
            buff.append("\n   ");
            i = 0;
            for (a = 0; a < allElements.length; ++a) {
                col = (AbstractViewElement)allElements[a];
                name = sd.getFormatedName(col.getReferencedName());
                ContainerObject container = col.getReferencedContainer();
                if (container != null) {
                    ContainerHolder ch = this.getContainerHolderFor(container);
                    if (ch != null && ch.getAlias() != null && !"".equals(ch.getAlias().trim())) {
                        name = sd.getFormatedName(ch.getAlias().trim()) + "." + name;
                    }
                    if (!"".equalsIgnoreCase(col.getAlias())) {
                        name = name + " " + sd.getFormatedName(col.getAlias().trim());
                    }
                } else {
                    name = !col.getExpression().equalsIgnoreCase("") ? col.getExpression() + " " + sd.getFormatedName(col.getAlias().trim()) : name + " " + sd.getFormatedName(col.getAlias().trim());
                }
                if (i > 0) {
                    buff.append("\n   ,");
                }
                buff.append(' ').append(name);
                ++i;
            }
            ArrayList allTables = new ArrayList();
            allTables.addAll(this.tables);
            allTables.addAll(this.views);
            if (allElements.length > 0) {
                if (allTables.size() > 0) {
                    buff.append("\n");
                    buff.append(" FROM \n");
                }
                i = 0;
                Iterator it = this.getUsedContainers().iterator();
                while (it.hasNext()) {
                    if (i > 0) {
                        buff.append(",\n    ");
                    } else {
                        buff.append("    ");
                    }
                    ContainerHolder ch = (ContainerHolder)it.next();
                    ContainerObject dobj = ch.getContainer();
                    String contName = dobj.getName();
                    if (sd != null) {
                        RelationalObjectProxy tp;
                        if (dobj instanceof Table) {
                            tp = (TableProxy)sd.getTableProxySet().getObjectGeneratedBy(dobj.getObjectID());
                            if (tp != null) {
                                contName = tp.getLongName();
                            }
                        } else if (dobj instanceof TableView && (tp = (TableViewProxy)sd.getTableViewProxySet().getObjectGeneratedBy(dobj.getObjectID())) != null) {
                            contName = tp.getLongName();
                        }
                    }
                    buff.append(sd.getFormatedName(contName)).append(" ").append(sd.getFormatedName(ch.getAlias()));
                    ++i;
                }
            }
            if (!"".equalsIgnoreCase(this.where)) {
                buff.append("\n");
                buff.append(" WHERE \n    ");
                buff.append(this.where);
            }
            if ("".equalsIgnoreCase(this.groupBy)) {
                this.groupBy = this.generateGroupBy();
            }
            if (!"".equalsIgnoreCase(this.groupBy)) {
                buff.append("\n");
                buff.append(" GROUP BY \n    ");
                buff.append(this.groupBy);
            }
            if (!"".equalsIgnoreCase(this.having)) {
                buff.append("\n");
                buff.append(" HAVING \n    ");
                buff.append(this.having);
            }
            if (this.orderByList.size() > 0) {
                buff.append("\n");
                buff.append(" ORDER BY \n");
                i = 0;
                for (AbstractViewElement clmView : this.orderByList) {
                    String colName = "";
                    for (int a2 = 0; a2 < allElements.length; ++a2) {
                        AbstractViewElement col2 = (AbstractViewElement)allElements[a2];
                        if (!clmView.getName().equalsIgnoreCase(col2.getName())) continue;
                        colName = col2.getAlias().trim();
                        break;
                    }
                    if (colName.equalsIgnoreCase("")) {
                        colName = clmView.getName();
                    }
                    String sort = this.getOrderByMap().get(clmView.getObjectID()).toString();
                    if (i > 0) {
                        buff.append(",\n   ");
                    } else {
                        buff.append("   ");
                    }
                    buff.append(' ');
                    buff.append(sd.getFormatedName(colName));
                    buff.append(' ');
                    buff.append(sort);
                    ++i;
                }
                buff.append("\n");
            }
            buff.append(';');
        }
        return buff.toString();
    }

    public List getUsedContainers() {
        if (!ApplicationView.loading && this.viewsNotAdded.size() > 0) {
            for (ViewNotAdded view : this.viewsNotAdded) {
                ContainerHolder ch = null;
                ch = this.getDesignPart() instanceof LogicalDesign ? new ContainerHolder((EntityView)((LogicalDesign)this.getDesignPart()).getEntityViewSet().getObjectByID(view.getId()), view.getAlias()) : new ContainerHolder((TableView)((RelationalDesign)this.getDesignPart()).getTableViewSet().getObjectByID(view.getId()), view.getAlias());
                if (ch.getContainer() == null || this.usedContainers.contains(ch) || !this.checkObjectId(view.getId(), view.getAlias())) continue;
                int index = this.viewsNotAdded.indexOf(view);
                this.usedContainers.add(index, ch);
            }
            this.viewsNotAdded.clear();
        }
        return this.usedContainers;
    }

    private boolean checkObjectId(String id, String alias) {
        for (ContainerHolder ch : this.usedContainers) {
            if (ch.getContainer() == null || !ch.getContainer().getObjectID().equalsIgnoreCase(id) || !ch.getAlias().equalsIgnoreCase(alias)) continue;
            return false;
        }
        return true;
    }

    public ContainerHolder getContainerHolderFor(ContainerObject container) {
        for (ContainerHolder ch : this.usedContainers) {
            if (ch.container != container) continue;
            return ch;
        }
        return null;
    }

    public List getViewsNotAdded() {
        return this.viewsNotAdded;
    }

    public AbstractViewElement createViewElement(boolean addToElems) {
        AbstractViewElement elem = this.createViewElement(this.getDesignPart());
        elem.setContainer(this);
        if (addToElems) {
            this.add(elem);
        }
        return elem;
    }

    public AbstractViewElement createViewElement() {
        return this.createViewElement(true);
    }

    public List getContainersMaps() {
        ArrayList list = new ArrayList();
        for (ContainerHolder ch : this.getUsedContainers()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(CONTAINER_ID, ch.getContainer().getObjectID());
            if (ch.getAlias() != null && !"".equals(ch.getAlias())) {
                map.put(ALIAS, ch.getAlias());
            }
            list.add(map);
        }
        return list;
    }

    public void applyContainers(List maps) {
        this.usedContainers.clear();
        this.viewsNotAdded.clear();
        for (Map map : maps) {
            String id = (String)map.get(CONTAINER_ID);
            if (id == null) continue;
            String alias = (String)map.get(ALIAS);
            if (alias != null) {
                this.addToContainers(id, alias);
                continue;
            }
            this.addToContainers(id, "");
        }
    }

    public List getOrderByMaps() {
        if (this.orderByList.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        Iterator it = this.orderByList.iterator();
        while (it.hasNext()) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            AbstractViewElement co = (AbstractViewElement)it.next();
            String coid = co.getObjectID();
            map.put(ID, coid);
            String sort = this.getSortOrder(coid);
            if (VALUE_DESCENDING.equals(sort)) {
                map.put(SORT, VALUE_DESCENDING);
            }
            String name = co.getName();
            map.put(NAME, name);
            if (co.getReferencedColumn() != null) {
                String relid = co.getReferencedColumn().getObjectID();
                map.put(REF_ELEM_ID, relid);
            } else if (co.getReferencedColumnView() != null) {
                String rv_elid = co.getReferencedColumnView().getObjectID();
                map.put(REF_VIEW_ELEM_ID, rv_elid);
            }
            list.add(map);
        }
        return list;
    }

    public void applyOrderByMaps(List maps) {
        ArrayList<AbstractViewElement> list = new ArrayList<AbstractViewElement>();
        for (Map map : maps) {
            String id = (String)map.get(ID);
            boolean existing = true;
            AbstractViewElement co = this.getOrderElemByID(id);
            if (co == null) {
                existing = false;
                co = this.createViewElement(false);
                co.setObjectID(id);
            }
            String name = (String)map.get(NAME);
            co.setName(name);
            String sort = (String)map.get(SORT);
            if (sort == null) {
                sort = VALUE_ASCENDING;
            }
            String relid = (String)map.get(REF_ELEM_ID);
            ContainedObjectWithDomain dobj = (ContainedObjectWithDomain)this.getDesign().getDesignObject(relid);
            if (dobj != null) {
                co.setReferencedColumn(dobj);
            }
            String rv_elid = (String)map.get(REF_VIEW_ELEM_ID);
            co.setReferencedColumnViewID(rv_elid);
            list.add(co);
            if (existing) continue;
            this.addToOrderBy(co, sort);
        }
        this.orderByList.clear();
        this.orderByList.addAll(list);
    }

    private AbstractViewElement getOrderElemByID(String id) {
        for (AbstractViewElement co : this.orderByList) {
            if (!co.getObjectID().equals(id)) continue;
            return co;
        }
        return null;
    }

    public abstract void addToOrderBy(ContainedObject var1, String var2);

    @Override
    public String getLayoutSQL() {
        return this.layoutSQL;
    }

    public void setLayoutSQL(String layoutSQL) {
        this.layoutSQL = layoutSQL;
    }

    @Override
    public List getSQLNames() {
        return this.sqlNames;
    }

    public List<SQLNameHelper> getUsedTablesAndViews() {
        ArrayList<SQLNameHelper> list = new ArrayList<SQLNameHelper>();
        for (SQLNameHelper helper : this.sqlNames) {
            if (!helper.isContainer()) continue;
            list.add(helper);
        }
        return list;
    }

    public SQLNameHelper getOldName2(DesignObject designObject) {
        for (SQLNameHelper helper : this.sqlNames) {
            if (!helper.getID().equalsIgnoreCase(designObject.getObjectID())) continue;
            return helper;
        }
        return null;
    }

    public void validateSQL() {
        QueryBuilder queryBuilder = new QueryBuilder(true);
        PlainTextSQLBuilder plainTextSQLBuilder = new PlainTextSQLBuilder();
        plainTextSQLBuilder.setKeywordFormat(KeywordFormat.UpperCase);
        plainTextSQLBuilder.setQueryBuilder(queryBuilder);
        QBUtils.initProperties(this, queryBuilder, plainTextSQLBuilder, null, null, this.includeSchemaNameInQuery(), false);
        QBUtils.updateMetadata(this, queryBuilder, plainTextSQLBuilder, this.includeSchemaNameInQuery());
        if (!this.isBST()) {
            QBUtils.updateColumns(this, queryBuilder);
        }
        QBUtils.setViewSQL(this, queryBuilder, plainTextSQLBuilder, true);
        this.setValidSQL(true);
        this.setParsed(true);
    }

    public void parseOlderStyleView(QueryBuilder queryBuilder, PlainTextSQLBuilder plainTextSQLBuilder) {
        QBUtils.initSQL(this, queryBuilder);
        if (!this.isBST() && !this.isIncorrectSQL()) {
            QBUtils.updateColumns(this, queryBuilder);
        }
        if (!this.isIncorrectSQL()) {
            this.updateSQLNames(queryBuilder);
            this.setValidSQL(true);
            this.setParsed(true);
            this.setDirty(true);
        }
    }

    public boolean includeSchemaNameInQuery() {
        return this.includeSchemaNameInQuery;
    }

    public void setIncludeSchemaNameInQuery(boolean includeSchemaNameInQuery) {
        this.includeSchemaNameInQuery = includeSchemaNameInQuery;
    }

    public List getUsedObjectsList() {
        return this.sqlNames;
    }

    public void addUsedObject(SQLNameHelper helper) {
        this.sqlNames.add(helper);
    }

    public SQLNameHelper createSQLNameHelper() {
        return new SQLNameHelper();
    }

    public SQLNameHelper getSQLNameHelperByID(String id) {
        if (id != null) {
            for (SQLNameHelper sh : this.sqlNames) {
                if (!id.equalsIgnoreCase(sh.getID())) continue;
                return sh;
            }
        }
        return null;
    }

    @Override
    public boolean isValidSQL() {
        return this.validSQL;
    }

    @Override
    public void setValidSQL(boolean validSQL) {
        if (this.validSQL != validSQL) {
            this.validSQL = validSQL;
            this.setDirty(true);
        }
    }

    @Override
    public boolean isParsed() {
        if (!this.parsed) {
            return this.userDefinedSQL == null || this.userDefinedSQL.length() == 0;
        }
        if (this.userDefinedSQL != null && !this.userDefinedSQL.isEmpty() && this.getElementsCollection().size() == 0) {
            return false;
        }
        return this.parsed;
    }

    @Override
    public void setParsed(boolean parsed) {
        if (this.parsed != parsed) {
            this.parsed = parsed;
            this.setDirty(true);
        }
    }

    @Override
    public boolean isIncorrectSQL() {
        return this.incorrectSQL;
    }

    @Override
    public void setIncorrectSQL(boolean incorrectSQL) {
        if (this.incorrectSQL != incorrectSQL) {
            this.incorrectSQL = incorrectSQL;
            this.setDirty(true);
        }
    }

    public String getUseObjectsOnlyFrom() {
        return this.useObjectsOnlyFrom;
    }

    public void setUseObjectsOnlyFrom(String useObjectsOnlyFrom) {
        this.useObjectsOnlyFrom = useObjectsOnlyFrom;
    }

    public void clearElements() {
        this.phelements.removeAll();
        this.getElementsCollection().clear();
        this.fireChange(this.sharedEvent);
    }

    @Override
    public String getSyntaxProvider() {
        return this.syntaxProvider;
    }

    @Override
    public void setSyntaxProvider(String syntaxProvider) {
        this.syntaxProvider = syntaxProvider;
    }

    public void copySQLNames(AbstractView view) {
        view.getSQLNames().clear();
        for (SQLNameHelper sqlh : this.getSQLNames()) {
            view.addUsedObject(sqlh.clone());
            if (view.isBackup() || sqlh.desObj == null) continue;
            sqlh.desObj.addObjectListener(view);
        }
    }

    public boolean hasValidHeader() {
        return false;
    }

    @Override
    public void changed(ContainerObject container, ContainerObjectEvent event) {
        if (event.isType(1)) {
            this.remove((ContainedObject)event.getElement());
        }
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (set instanceof StructuredTypeSet || set instanceof SchemaObjectSet) {
            super.changed(set, event);
            return;
        }
        if (event == SetEvent.OBJECT_ADDED) {
            if (event.getAffected() instanceof KeyObject) {
                KeyObject index = (KeyObject)event.getAffected();
                index.addObjectListener(this);
                if (index.isFK()) {
                    if (!this.fkSet.containsPlaceHolderFor(index.getFKAssociation())) {
                        this.fkSet.add(new DesignObjectPH_ShortName((DesignObject)index.getFKAssociation()));
                    }
                } else if (!index.isUnique() && !index.isPK()) {
                    this.indSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), index));
                    if (!this.isBackup()) {
                        this.indexOnlySet.add(new ContainerObjectPlaceHolder(this.getDesignPart(), index));
                    }
                } else if (index.isUnique()) {
                    this.unSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), index));
                } else {
                    this.pkSet.add(new ContainerObjectPH_ShortName(this.getDesignPart(), index));
                }
            }
        } else if (event == SetEvent.OBJECT_REMOVED && event.getAffected() instanceof KeyObject) {
            KeyObject obj = (KeyObject)event.getAffected();
            if (obj.isFK()) {
                this.fkSet.removePlaceHolderFor(obj.getFKAssociation());
            } else {
                this.indSet.removePlaceHolderFor(obj);
                this.indexOnlySet.removePlaceHolderFor(obj);
                this.pkSet.removePlaceHolderFor(obj);
                this.unSet.removePlaceHolderFor(obj);
            }
        }
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    @Override
    public RelationalDesign getRelationalModel() {
        return (RelationalDesign)this.getDesignPart();
    }

    @Override
    public List getCheckConstraints() {
        return null;
    }

    @Override
    public FKElement getFKColumn(FKIndexAssociation association, FKElement delegate) {
        FKElement[] columns = (FKElement[])this.getElementsAndNestedElements();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].isReferingTo(association, delegate)) continue;
            return columns[i];
        }
        return null;
    }

    @Override
    public FKElement getColumnForDelegate(FKIndexAssociation fk, FKElement delegate) {
        FKElement[] cols = (FKElement[])this.getElementsAndNestedElements();
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].isReferingTo(fk, delegate)) continue;
            return cols[i];
        }
        return null;
    }

    @Override
    public FKElement createColumnFK(FKElement referencedColumn, FKIndexAssociation fkAss) {
        ColumnView column = new ColumnView(this.getDesignPart(), referencedColumn, fkAss);
        column.setDesign(this.getDesign());
        column.setPreviousColumn(false);
        column.setUse(referencedColumn.getUse());
        column.setReference(referencedColumn.isReference());
        column.setDomain(referencedColumn.getDomain());
        column.setLogicalDatatype(referencedColumn.getLogicalDatatype());
        column.setStructuredType(referencedColumn.getStructuredType());
        column.setCollectionType(referencedColumn.getCollectionType());
        column.copyParametersFrom(referencedColumn);
        column.setContainer(this);
        this.add(column);
        this.addToContainers(referencedColumn.getContainer(), "");
        column.addFKAssociation(referencedColumn, fkAss);
        fkAss.getLocalFKIndex().add(column);
        return column;
    }

    @Override
    public Column createRefToStructuredType(StructuredType type, FKIndexAssociation fkAss) {
        return null;
    }

    @Override
    public List<FKIndexAssociation> getFKAssociationsList() {
        return this.fkList;
    }

    @Override
    public void addRecreateFKAssociation(FKIndexAssociation fkAssociation) {
        this.recreateFK(fkAssociation, fkAssociation.getRemoteIndex(), fkAssociation.getLocalFKIndex().getObjectID(), fkAssociation.getDeleteRule());
    }

    @Override
    public FKIndexAssociation recreateFK(FKIndexAssociation association, KeyObject fkObject, String localIndexId, String deleteRule) {
        association.setDesign(this.getDesign());
        association.setContainerWithKeyObject(this);
        if (!association.isBackupFK() && !this.isBackup()) {
            association.setParent(((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet());
        }
        association.setKeyObject(fkObject);
        association.setDeleteRule(deleteRule);
        if (localIndexId != null) {
            KeyObject localIndex = this.getKeyObject(localIndexId);
            association.setLocalFKIndex(localIndex);
            localIndex.setFKAssociation(association);
        }
        this.getRelationalModel().getFKIndexAssociationSet().add(association);
        if (!this.fkList.contains(association)) {
            this.fkList.add(association);
        }
        this.assignLocalID(association);
        this.getDesign().addDesignObject(association);
        if (fkObject != null) {
            this.addToMap(fkObject.getGeneratorID(), association);
        }
        KeyObject key = association.getLocalFKIndex();
        if (!this.fkSet.containsPlaceHolderFor(association)) {
            this.fkSet.add(new DesignObjectPH_ShortName((DesignObject)association));
        }
        this.indSet.removePlaceHolderFor(key);
        this.indexOnlySet.removePlaceHolderFor(key);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(association);
        this.fireChange(ObjectChangeEvent.FKINDEX_ADDED);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(null);
        return association;
    }

    protected void addToMap(String generatorID, FKIndexAssociation association) {
        if (generatorID != null) {
            HashSet<FKIndexAssociation> set = (HashSet<FKIndexAssociation>)this.generatedLists.get(generatorID);
            if (set == null) {
                set = new HashSet<FKIndexAssociation>();
                this.generatedLists.put(generatorID, set);
            }
            set.add(association);
        }
    }

    @Override
    public void restoreFKAssociation(FKIndexAssociation fkAssociation, String index_id) {
        fkAssociation.setContainerWithKeyObject(this);
        ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().add(fkAssociation);
        KeyObject key = this.createIndexFK(fkAssociation, index_id);
        this.fkList.add(fkAssociation);
        if (!this.fkSet.containsPlaceHolderFor(fkAssociation)) {
            this.fkSet.add(new DesignObjectPH_ShortName((DesignObject)fkAssociation));
        }
        this.indSet.removePlaceHolderFor(key);
        this.indexOnlySet.removePlaceHolderFor(key);
    }

    public KeyObject createIndexFK(FKIndexAssociation fkass, String index_id) {
        KeyObject key = fkass.getLocalFKIndex();
        key.setBackup(this.isBackup());
        fkass.setBackup(this.isBackup());
        key.setObjectID(index_id);
        key.setFKAssociation(fkass);
        this.add(key);
        return key;
    }

    @Override
    public FKIndexAssociation[] getFKAssociations() {
        return (FKIndexAssociation[])this.fkList.toArray(INDEX_ASSOCIATION_PROTO);
    }

    @Override
    public KeyObject createIndexFK(FKIndexAssociation fkass) {
        ViewIndex key = new ViewIndex(this.getDesignPart(), fkass);
        key.setBackup(this.isBackup());
        key.setObjectID(null);
        key.setFKAssociation(fkass);
        this.add(key);
        return key;
    }

    @Override
    public FKElement[] getAllFKColumns(FKIndexAssociation fkAssociation) {
        ArrayList<FKElement> fkcolumns = new ArrayList<FKElement>();
        FKElement[] columns = (FKElement[])this.getElementsAndNestedElements();
        for (int i = 0; i < columns.length; ++i) {
            FKElement cfk;
            if (!columns[i].isFKColumn() || !(cfk = columns[i]).isPartOfFKIndexAssociation(fkAssociation)) continue;
            fkcolumns.add(columns[i]);
        }
        return fkcolumns.toArray(new FKElement[0]);
    }

    @Override
    public void removeFKAssociationFromList(FKIndexAssociation fkAssociation) {
        this.fkList.remove(fkAssociation);
    }

    @Override
    public List getColumnsDependinOn(FKIndexAssociation fk) {
        ArrayList<FKElement> list = null;
        for (FKElement col : this.getElementsCollection()) {
            if (fk != col.getDependOnForeignKey()) continue;
            if (list == null) {
                list = new ArrayList<FKElement>();
            }
            list.add(col);
        }
        if (list != null) {
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public KeyObject getIndexByID(String objectID) {
        Iterator indexesIterator = this.getKeySet().iterator();
        while (indexesIterator.hasNext()) {
            KeyObject index = (KeyObject)indexesIterator.next();
            if (!index.getObjectID().equals(objectID)) continue;
            return index;
        }
        return null;
    }

    @Override
    public List getPK_UKList() {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        KeyObject key = this.getPK();
        if (key != null) {
            list.add(key);
        }
        Iterator it = this.getKeySet().iterator();
        while (it.hasNext()) {
            KeyObject index = (KeyObject)it.next();
            if (!index.isUnique()) continue;
            list.add(index);
        }
        return list;
    }

    @Override
    public FKIndexAssociation addFK(KeyObject fkObject) {
        return this.addFK(fkObject, fkObject.getGeneratorID());
    }

    public FKIndexAssociation addFK(KeyObject fkObject, String generatorID) {
        return this.addFK(fkObject, generatorID, null);
    }

    public FKIndexAssociation addFK(KeyObject fkObject, String generatorID, FKIndexAssociationReference reference) {
        return this.addFK(fkObject, generatorID, reference, null);
    }

    public FKIndexAssociation addFK(KeyObject fkObject, String generatorID, FKIndexAssociationReference reference, FKIndexAssociation originatingFK) {
        FKIndexAssociation association = new FKIndexAssociation(this.getDesignPart(), originatingFK);
        if (reference != null) {
            reference.setObject(association);
        }
        if (!association.isBackupFK()) {
            association.setParent(((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet());
        }
        association.setDesign(this.getDesign());
        this.assignLocalID(association);
        if (!this.isBackup()) {
            this.getDesign().addDesignObject(association);
        }
        association.setKeyObject(fkObject);
        association.setGeneratorID(generatorID);
        association.setDeleteRule(this.getDesign().getAppView().getSettings().getDefaultFKDeleteRule());
        this.addFKAssociation(association);
        this.addToMap(generatorID, association);
        KeyObject ind = association.getLocalFKIndex();
        if (ind != null) {
            if (generatorID == null) {
                generatorID = "User generated";
            }
            ind.setGeneratorID(generatorID);
        }
        return association;
    }

    public void addFKAssociation(FKIndexAssociation fkAssociation) {
        fkAssociation.setContainerWithKeyObject(this);
        if (!fkAssociation.isBackupFK()) {
            ((RelationalDesign)this.getDesignPart()).getFKIndexAssociationSet().add(fkAssociation);
        }
        if (this.getDesign().isPropagatePKChahges() && !fkAssociation.isBackupFK()) {
            fkAssociation.addAllFKElements();
        }
        this.fkList.add(fkAssociation);
        KeyObject key = fkAssociation.getLocalFKIndex();
        if (!this.fkSet.containsPlaceHolderFor(fkAssociation)) {
            this.fkSet.add(new DesignObjectPH_ShortName((DesignObject)fkAssociation));
        }
        this.indSet.removePlaceHolderFor(key);
        this.indexOnlySet.removePlaceHolderFor(key);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(fkAssociation);
        this.fireChange(ObjectChangeEvent.FKINDEX_ADDED);
        ObjectChangeEvent.FKINDEX_ADDED.setAffected(null);
    }

    @Override
    public FKIndexAssociation addForeignKey(KeyObject refferedKey, List localColumns) {
        return null;
    }

    public String getOriginalTableID() {
        if (this.originalTableID == null) {
            this.originalTableID = "";
        }
        return this.originalTableID;
    }

    public void setOriginalTableID(String originalTableID) {
        this.originalTableID = originalTableID;
    }

    public boolean isUsedInDefinition(ContainerObject cont) {
        for (SQLNameHelper nh : this.getSQLNames()) {
            if (!nh.isContainer() || !nh.getID().equals(cont.getObjectID())) continue;
            return true;
        }
        if (this.tables.contains(cont)) {
            return true;
        }
        return this.views.contains(cont);
    }

    public String getSelectDef() {
        return this.selectDef;
    }

    public void setSelectDef(String selectDef) {
        this.selectDef = selectDef;
    }

    public class DesignObjectPH_ShortName
    extends DesignObjectPlaceHolder {
        public DesignObjectPH_ShortName(DesignObject object) {
            super(object);
        }

        @Override
        public String toString() {
            return this.getDesignObject().getName();
        }
    }

    public class ViewNotAdded {
        private String id = "";
        private String alias = "";

        public ViewNotAdded(String id, String alias) {
            if (alias != null) {
                this.alias = alias;
            }
            this.id = id;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getId() {
            return this.id;
        }
    }

    public class ContainerHolder {
        private String alias = "";
        private ContainerObject container;

        public ContainerHolder(ContainerObject container, String alias) {
            if (alias != null) {
                this.alias = alias;
            }
            this.container = container;
        }

        public String getAlias() {
            return this.alias;
        }

        public ContainerObject getContainer() {
            return this.container;
        }
    }
}

