/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.IDGenerator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.NameSpaceController;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.SubsetCO;
import oracle.dbtools.crest.model.Task;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class ContainerObject
extends MultiShapedDesignObject
implements ObjectListener,
SetListener {
    public static Comparator longNameSorter = new ModelObjectSet.LongNameComparator();
    private List elements = new ArrayList();
    private Set containerListeners = new HashSet();
    protected ContainerObjectEvent sharedEvent = new ContainerObjectEvent();
    private IDGenerator localIDGenerator;
    private Map localIDs = new TreeMap();
    protected List typeSubstitutions = new ArrayList();
    private TypeSubstitution typeSubstitution;
    private String typeSubstitutionID;
    private String typeSubstitutionParentID;
    protected List nestedElements = new ArrayList();
    private String beforeDrop = "";
    private String beforeCreate = "";
    private String beforeAlter = "";
    private String afterCreate = "";
    private String afterAlter = "";
    private String endOfScript = "";
    private boolean beforeAlterAdded = false;
    private boolean afterAlterAdded = false;
    private boolean shouldGenerateScript = false;
    private boolean allowTypeSubstitution = true;
    private String schema;
    private String remoteSchemaName;
    protected SchemaObject schemaObject;
    private SchemaObject oldSchemaObject;
    protected StructuredType basedOnStructuredType = null;
    private static final Logger LOGGER = new Logger(ContainerObject.class);
    public static final String TYPE_FACT = Messages.getString("ContainerObject.TypeFact");
    public static final String TYPE_DIMENSION = Messages.getString("ContainerObject.TypeDimension");
    public static final String TYPE_CONSOLIDATED = Messages.getString("ContainerObject.TypeConsolidated");
    public static final String TYPE_SUMMARY = Messages.getString("ContainerObject.TypeSummary");
    public static final String TYPE_TEMPORARY = Messages.getString("ContainerObject.TypeTemporary");
    public static final String TYPE_LOGGING = Messages.getString("ContainerObject.TypeLogging");
    public static final String TYPE_EXTERNAL = Messages.getString("ContainerObject.TypeExternal");

    public ContainerObject(DesignPart designPart) {
        super(designPart);
    }

    public abstract DesignObjectSet getContainedSet();

    public abstract ContainedObject createContainedObject(String var1);

    public ContainedObject createContainedObject() {
        return this.createContainedObject(null);
    }

    public void add(ContainedObject object) {
        if (object == null || this.isReadOnly()) {
            return;
        }
        if (!this.acceptDoubles() && this.contains(object)) {
            return;
        }
        if (this.getContainedClass().isAssignableFrom(object.getClass())) {
            Datatype datatype;
            this.assignLocalID(object);
            if (!object.isNested() || this instanceof KeyObject) {
                this.elements.add(object);
            } else {
                this.nestedElements.add(object);
            }
            if (!(this instanceof SubsetCO)) {
                object.setContainer(this);
            }
            object.addObjectListener(this);
            if (!this.isBackup()) {
                this.getDesign().addDesignObject(object);
            }
            this.sharedEvent.setElement(object);
            this.sharedEvent.setType(0);
            this.fireChange(this.sharedEvent);
            if (!(this instanceof KeyObject) && object instanceof ContainedObjectWithDomain && (datatype = ((ContainedObjectWithDomain)object).getDataType()) instanceof StructuredType) {
                ((StructuredType)datatype).addObjectListener(this);
                if (!((ContainedObjectWithDomain)object).isReference()) {
                    this.updateStructure();
                }
            }
        } else {
            LOGGER.error("Class: " + object.getClass());
            LOGGER.error("Expected: " + this.getContainedClass());
            throw new RuntimeException("Wrong class added to container.");
        }
    }

    public boolean contains(ContainedObject element) {
        return this.elements.contains(element);
    }

    public Map getReferIDMap() {
        return null;
    }

    public boolean containsAll(Collection elements) {
        return this.elements.containsAll(elements);
    }

    public boolean acceptDoubles() {
        return false;
    }

    public ContainerObject getTopLevelContainer() {
        return this;
    }

    @Override
    public void remove() {
        if (this.basedOnStructuredType != null) {
            this.basedOnStructuredType.removeObjectListener(this);
            this.getDesign().getDataTypesDesign().getStructuredTypeSet().removeSetListener(this);
        }
        if (this.typeSubstitution != null) {
            this.typeSubstitution.remove();
        }
        Object[] ts_arr = this.typeSubstitutions.toArray();
        for (int i = 0; i < ts_arr.length; ++i) {
            ((TypeSubstitution)ts_arr[i]).remove();
        }
        this.removeAll();
        this.localIDs.clear();
        super.remove();
        this.basedOnStructuredType = null;
    }

    public void remove(ContainedObject object) {
        if (object != null && this.isWriteable()) {
            this.elements.remove(object);
            this.removeNestedCOFor(object);
            this.nestedElements.remove(object);
            if (!(this instanceof SubsetCO)) {
                object.setContainer(null);
            }
            this.localIDs.remove(object.getObjectID());
            object.removeObjectListener(this);
            object.setParent(this);
            this.getDesign().removeDesignObject(object);
            this.sharedEvent.setElement(object);
            this.sharedEvent.setType(1);
            this.fireChange(this.sharedEvent);
        }
    }

    public void removeNestedCOFor(ContainedObject parent) {
        Object[] nelements = this.nestedElements.toArray();
        for (int i = 0; i < nelements.length; ++i) {
            ContainedObject co = (ContainedObject)nelements[i];
            if (co.getParentObject() != parent) continue;
            this.removeNestedCOFor(co);
            co.remove();
            this.nestedElements.remove(co);
        }
    }

    public ContainedObject[] removeAll() {
        ContainedObject[] elms = this.getElements();
        for (int i = 0; i < elms.length; ++i) {
            elms[i].remove();
        }
        return elms;
    }

    @Override
    public void clearAll() {
        ContainedObject[] elms = this.getElements();
        for (int i = 0; i < elms.length; ++i) {
            elms[i].remove();
        }
    }

    public Collection getElementsCollection() {
        return this.elements;
    }

    public Collection getElementsCollectionImmutable() {
        return Collections.unmodifiableList(this.elements);
    }

    protected void removeLocalId(String localID) {
        this.localIDs.remove(localID);
    }

    public ContainedObject[] getElements() {
        return this.toContainedObjectArray(this.elements);
    }

    public Collection getElementsAndNestedElementsCollection() {
        if (this.nestedElements.size() == 0) {
            return this.elements;
        }
        ArrayList combinedList = new ArrayList(this.elements);
        combinedList.addAll(this.nestedElements);
        return combinedList;
    }

    public ContainedObject[] getElementsAndNestedElements() {
        return this.toContainedObjectArray(this.getElementsAndNestedElementsCollection());
    }

    public ContainedObject getElement(int index) {
        return (ContainedObject)this.elements.get(index);
    }

    public ContainedObject[] toContainedObjectArray(Collection collection) {
        return (ContainedObject[])collection.toArray((Object[])Array.newInstance(this.getContainedClass(), 0));
    }

    public Class getContainedClass() {
        return ContainedObject.class;
    }

    public void addContainerListener(ContainerObjectListener listener) {
        this.containerListeners.add(listener);
    }

    public void removeContainerListener(ContainerObjectListener listener) {
        this.containerListeners.remove(listener);
    }

    public Collection getContainerListeners() {
        return this.containerListeners;
    }

    protected void fireChange(ContainerObjectEvent event) {
        Object[] array = this.containerListeners.toArray();
        for (int i = 0; i < array.length; ++i) {
            try {
                ((ContainerObjectListener)array[i]).changed(this, event);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("ContainerListener caused exception", e);
            }
        }
    }

    protected void assignLocalID(ModelIDObject object) {
        String id = object.getObjectID();
        if (id == null) {
            while (this.localIDs.containsKey(id = this.getLocalIDGenerator().createNewID())) {
            }
            this.localIDs.put(id, object);
            object.setObjectID(id);
        } else if (this.localIDs.containsKey(id)) {
            while (this.localIDs.containsKey(id = this.getLocalIDGenerator().createNewID())) {
            }
        }
    }

    public ModelIDObject getLocalObject(String localId) {
        ModelIDObject object = (ModelIDObject)this.localIDs.get(localId);
        if (object == null) {
            object = this.getElementByID(localId);
        }
        return object;
    }

    public void updateLocalObjectId(String oldId, String newId) {
        Object object = this.localIDs.get(oldId);
        if (object != null) {
            this.localIDs.remove(oldId);
            this.localIDs.put(newId, object);
        }
    }

    public void putInLocalIDMap(String id, ModelIDObject co) {
        this.localIDs.put(id, co);
    }

    public IDGenerator getLocalIDGenerator() {
        if (this.localIDGenerator == null) {
            this.localIDGenerator = new IDGenerator();
            this.localIDGenerator.initializeWith(10000L, 3000000L);
        }
        return this.localIDGenerator;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    public int size() {
        return this.elements.size();
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        Datatype coDatatype;
        if (object instanceof StructuredType) {
            this.updateStructure();
        }
        if (object instanceof ContainedObjectWithDomain && (coDatatype = ((ContainedObjectWithDomain)object).getDataType()) instanceof StructuredType) {
            if (ObjectChangeEvent.OBJECT_REMOVED == event) {
                ((StructuredType)coDatatype).removeObjectListener(this);
            } else {
                ((StructuredType)coDatatype).addObjectListener(this);
            }
        }
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (set instanceof StructuredTypeSet && event.isRemoved() && event.getAffected() == this.basedOnStructuredType) {
            this.basedOnStructuredType.removeObjectListener(this);
            this.getDesign().getDataTypesDesign().getStructuredTypeSet().removeSetListener(this);
            this.clearTypeSubstitutions();
            this.clearStructure();
            this.basedOnStructuredType = null;
        }
        if (this.schemaObject != null && set instanceof SchemaObjectSet && event.isRemoved() && event.getAffected() == this.schemaObject) {
            this.schemaObject = null;
            set.removeSetListener(this);
            this.setDirty(true);
        }
    }

    public ContainedObject getElementGeneratedBy(DesignObject object) {
        return this.getElementGeneratedBy(object.getObjectID());
    }

    public ContainedObject getElementGeneratedBy(String generatorID) {
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            ContainedObject co = (ContainedObject)it.next();
            if (!generatorID.equals(co.getGeneratorID())) continue;
            it = null;
            return co;
        }
        it = null;
        return null;
    }

    public ContainedObject[] getAllElementsGeneratedBy(DesignObject object) {
        return this.getAllElementsGeneratedBy(object.getObjectID());
    }

    public ContainedObject[] getAllElementsGeneratedBy(String generatorID) {
        List list = this.getAllElementsListGeneratedBy(generatorID);
        return this.toContainedObjectArray(list);
    }

    public List getAllElementsListGeneratedBy(ModelIDObject object) {
        return this.getAllElementsListGeneratedBy(object.getObjectID());
    }

    public List getAllElementsListGeneratedBy(String generatorID) {
        ArrayList<ContainedObject> list = new ArrayList<ContainedObject>();
        for (ContainedObject co : this.getElementsAndNestedElementsCollection()) {
            if (!generatorID.equals(co.getGeneratorID())) continue;
            list.add(co);
        }
        return list;
    }

    public ContainedObject getElementByID(String localID) {
        if (localID == null) {
            return null;
        }
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            ContainedObject co = (ContainedObject)it.next();
            if (!localID.equals(co.getObjectID())) continue;
            it = null;
            return co;
        }
        for (ContainedObject co : this.nestedElements) {
            if (!localID.equals(co.getObjectID())) continue;
            return co;
        }
        return null;
    }

    public ContainedObject getElementByRemoteObjectID(String remoteID) {
        if (remoteID != null) {
            for (ContainedObject co : this.elements) {
                if (!remoteID.equalsIgnoreCase(co.getRemoteObjectID())) continue;
                return co;
            }
        }
        return null;
    }

    public ContainedObject getElementByName(String name) {
        if (name != null) {
            for (ContainedObject co : this.elements) {
                if (!name.equalsIgnoreCase(co.getName())) continue;
                return co;
            }
            if (name.indexOf(46) > -1) {
                name = name.replaceAll("\"", "");
                for (ContainedObject co : this.nestedElements) {
                    if (!name.equalsIgnoreCase(co.getName())) continue;
                    return co;
                }
            }
        }
        return null;
    }

    public boolean moveAfter(ContainedObject object, ContainedObject target) {
        if (this.elements.contains(object) && this.elements.contains(target) && !object.equals(target)) {
            this.elements.remove(object);
            int index1 = this.elements.indexOf(target) + 1;
            this.elements.add(index1, object);
            this.sharedEvent.setType(7);
            this.sharedEvent.setElement(object);
            this.fireChange(this.sharedEvent);
            return true;
        }
        return false;
    }

    public boolean moveToIndex(ContainedObject object, int index) {
        if (this.elements.contains(object) && this.elements.size() > index && index >= 0) {
            this.elements.remove(object);
            this.elements.add(index, object);
            this.sharedEvent.setType(7);
            this.sharedEvent.setElement(object);
            this.fireChange(this.sharedEvent);
            return true;
        }
        return false;
    }

    public int getIndexOf(ContainedObject object) {
        return this.elements.indexOf(object);
    }

    @Override
    public int getNumberOfChildren() {
        return this.elements.size();
    }

    @Override
    public ModelObject getChild(int index) {
        return (ModelObject)this.elements.get(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        return this.elements.indexOf(child);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public int getNumberOfNullsAllowingElements() {
        int count = 0;
        ContainedObject[] elements = this.getElements();
        for (int i = 0; i < elements.length; ++i) {
            if (!elements[i].getNullsAllowed()) continue;
            ++count;
        }
        return count;
    }

    protected int getByteSize(String rdbmsName) {
        if (this.getContainedClass().isAssignableFrom(ContainedObjectWithDomain.class)) {
            int count = 0;
            ContainedObjectWithDomain[] elements = (ContainedObjectWithDomain[])this.getElements();
            for (int i = 0; i < elements.length; ++i) {
                count += elements[i].getDomain().getDataType(rdbmsName).getByteSize();
            }
            return count;
        }
        throw new IllegalStateException("Only ContainerObjects containing ContainedObjectWithDomain elements can calculate bytesizes");
    }

    public StructuredType getBasedOnStructuredType() {
        return this.basedOnStructuredType;
    }

    public void setBasedOnStructuredType(StructuredType basedOnStructuredType) {
        if (this.basedOnStructuredType != basedOnStructuredType) {
            if (this.basedOnStructuredType != null) {
                this.basedOnStructuredType.removeObjectListener(this);
                this.getDesign().getDataTypesDesign().getStructuredTypeSet().removeSetListener(this);
            }
            if (!this.getDesign().isLoading()) {
                this.clearTypeSubstitutions();
                this.clearStructure();
                this.basedOnStructuredType = basedOnStructuredType;
                if (this.basedOnStructuredType != null) {
                    if (!this.isBackup()) {
                        this.basedOnStructuredType.addObjectListener(this);
                        this.getDesign().getDataTypesDesign().getStructuredTypeSet().addSetListener(this);
                    }
                    this.updateStructure();
                }
            } else {
                this.basedOnStructuredType = basedOnStructuredType;
                if (this.basedOnStructuredType != null) {
                    this.basedOnStructuredType.addObjectListener(this);
                    this.getDesign().getDataTypesDesign().getStructuredTypeSet().addSetListener(this);
                }
            }
        }
    }

    public boolean isBST() {
        return this.basedOnStructuredType != null;
    }

    protected abstract void clearStructure();

    protected abstract void updateStructure();

    public ContainedObject getElementByStructAttributeID(String id) {
        if (id != null && !"".equals(id)) {
            for (ContainedObject co : this.elements) {
                if (!co.getStructAttributeID().equalsIgnoreCase(id)) continue;
                return co;
            }
        }
        return null;
    }

    public ContainedObject getElementByStructAttributeID(String id, ContainedObject parent) {
        if (id != null) {
            for (ContainedObject co : this.elements) {
                if (!co.getStructAttributeID().equalsIgnoreCase(id) || co.getParentObject() != parent) continue;
                return co;
            }
            for (ContainedObject co : this.nestedElements) {
                if (!co.getStructAttributeID().equalsIgnoreCase(id) || co.getParentObject() != parent) continue;
                return co;
            }
        }
        return null;
    }

    public ContainedObject getNestedElementByStructAttributeID(String id) {
        if (id != null) {
            for (ContainedObject co : this.nestedElements) {
                if (!co.getStructAttributeID().equalsIgnoreCase(id)) continue;
                return co;
            }
        }
        return null;
    }

    public ContainedObject getOidElement() {
        if (this.isBST()) {
            for (ContainedObject co : this.getElementsCollection()) {
                if (!co.isOid()) continue;
                return co;
            }
        }
        return null;
    }

    public List getSubTypeSubstitutions() {
        return this.typeSubstitutions;
    }

    public TypeSubstitution getTypeSubstitution() {
        return this.typeSubstitution;
    }

    public void setTypeSubstitution(TypeSubstitution typeSubstitution) {
        if (this.typeSubstitution != typeSubstitution) {
            this.typeSubstitution = typeSubstitution;
            this.fireChange(ObjectChangeEvent.ROOT_CHANGED);
        }
    }

    public void clearTypeSubstitution(TypeSubstitution typeSubstitution) {
        if (this.typeSubstitution == typeSubstitution) {
            this.typeSubstitution = null;
            this.typeSubstitutionID = null;
            this.typeSubstitutionParentID = null;
            if (typeSubstitution != null) {
                this.fireChange(ObjectChangeEvent.ROOT_CHANGED);
            }
        }
    }

    public boolean isSubstitutable() {
        return this.hasTypeSubstitutionChildren() || this.isAllowTypeSubstitution();
    }

    public boolean hasTypeSubstitutionChildren() {
        return this.getSubTypeSubstitutions().size() > 0;
    }

    public boolean isRoot() {
        if (this.isBST()) {
            if (this.hasTypeSubstitutionChildren()) {
                return this.getTypeSubstitution() == null;
            }
            return this.getTypeSubstitution() == null;
        }
        return false;
    }

    public boolean isPartOfTypeSubstHierarchy() {
        return this.hasTypeSubstitutionChildren() || this.getTypeSubstitution() != null;
    }

    public List getNestedElements() {
        return this.nestedElements;
    }

    public static String getContainerID_From(String id) {
        int ind = id.lastIndexOf(35);
        if (ind > 0) {
            return id.substring(0, ind);
        }
        return "null";
    }

    public String getAfterAlter() {
        return this.afterAlter;
    }

    public void setAfterAlter(String afterAlter) {
        this.afterAlter = afterAlter;
    }

    public String getAfterCreate() {
        return this.afterCreate;
    }

    public void setAfterCreate(String afterCreate) {
        this.afterCreate = afterCreate;
    }

    public String getBeforeAlter() {
        return this.beforeAlter;
    }

    public void setBeforeAlter(String beforeAlter) {
        this.beforeAlter = beforeAlter;
    }

    public String getBeforeCreate() {
        return this.beforeCreate;
    }

    public void setBeforeCreate(String beforeCreate) {
        this.beforeCreate = beforeCreate;
    }

    public String getBeforeDrop() {
        return this.beforeDrop;
    }

    public void setBeforeDrop(String beforeDrop) {
        this.beforeDrop = beforeDrop;
    }

    public String getEndOfScript() {
        return this.endOfScript;
    }

    public void setEndOfScript(String endOfScript) {
        this.endOfScript = endOfScript;
    }

    public boolean isAfterAlterAdded() {
        return this.afterAlterAdded;
    }

    public void setAfterAlterAdded(boolean afterAlterAdded) {
        this.afterAlterAdded = afterAlterAdded;
    }

    public boolean isBeforeAlterAdded() {
        return this.beforeAlterAdded;
    }

    public void setBeforeAlterAdded(boolean beforeAlterAdded) {
        this.beforeAlterAdded = beforeAlterAdded;
    }

    public boolean getShouldGenerateScript() {
        return this.shouldGenerateScript;
    }

    public void setShouldGenerateScript(boolean shouldGenerateScript) {
        this.shouldGenerateScript = shouldGenerateScript;
    }

    public boolean isAllowTypeSubstitution() {
        return this.allowTypeSubstitution;
    }

    public void setAllowTypeSubstitution(boolean allowTypeSubstitution) {
        this.allowTypeSubstitution = allowTypeSubstitution;
    }

    public List getElementsByStructuredType(StructuredType st) {
        ArrayList<ContainedObject> list = new ArrayList<ContainedObject>();
        if (st != null) {
            TypeElement[] elems = st.getElements();
            for (int i = 0; i < elems.length; ++i) {
                ContainedObject dobj = this.getElementByStructAttributeID(elems[i].getObjectID());
                if (dobj == null) continue;
                list.add(dobj);
            }
        }
        return list;
    }

    @Override
    public String getSchema() {
        if (this.getSchemaObject() != null) {
            return this.getSchemaObject().getName();
        }
        if (this.schema == null) {
            return "";
        }
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
        if (this.getDesignPart() instanceof RelationalDesign && this.getSchemaObject() == null && schema != null && !"".equals(schema)) {
            RelationalDesign rd = (RelationalDesign)this.getDesignPart();
            SchemaObject so = (SchemaObject)rd.getSchemaObjectSet().getByName(schema);
            if (so == null) {
                so = rd.getSchemaObjectSet().createSchemaObject(null);
                so.setName(schema);
            }
            this.setSchemaObject(so);
        }
    }

    public String getTypeSubstitutionParentID() {
        if (this.typeSubstitution != null && this.typeSubstitution.getParentContainerObject() != null) {
            this.typeSubstitutionParentID = this.typeSubstitution.getParentContainerObject().getObjectID();
        }
        return this.typeSubstitutionParentID;
    }

    public void setTypeSubstitutionParentID(String typeSubstitutionParentID) {
        this.typeSubstitutionParentID = typeSubstitutionParentID;
    }

    public String getTypeSubstitutionID() {
        if (this.typeSubstitution != null) {
            this.typeSubstitutionID = this.typeSubstitution.getObjectID();
        }
        return this.typeSubstitutionID;
    }

    private void createTypeSubstitution() {
        ContainerObject cob = (ContainerObject)this.getDesign().getDesignObject(this.typeSubstitutionParentID);
        if (cob != null) {
            TypeSubstitution ts = (TypeSubstitution)this.getDesign().getDesignObject(this.typeSubstitutionID);
            if (ts == null) {
                DesignPart dp = this.getDesignPart();
                if (dp instanceof LogicalDesign) {
                    ts = ((LogicalDesign)dp).createTypeSubstitution(this.typeSubstitutionID);
                } else if (dp instanceof RelationalDesign) {
                    ts = ((RelationalDesign)dp).createTypeSubstitution(this.typeSubstitutionID);
                }
            }
            if (ts != null) {
                ts.setChildContainerObject(this);
                ts.setParentContainerObject(cob);
            }
        }
    }

    public void setTypeSubstitutionID(String typeSubstitutionID) {
        this.typeSubstitutionID = typeSubstitutionID;
        if (typeSubstitutionID != null && !"".equals(typeSubstitutionID)) {
            ContainerObject cob;
            if (this.typeSubstitution != null && !this.typeSubstitution.getObjectID().equals(typeSubstitutionID)) {
                this.typeSubstitution.remove();
            }
            if ((cob = (ContainerObject)this.getDesign().getDesignObject(this.typeSubstitutionParentID)) != null) {
                this.createTypeSubstitution();
            } else {
                this.getDesignPart().addTask(new CreateTypeSubstitutionTask(this));
            }
        } else if (this.typeSubstitution != null) {
            this.typeSubstitution.remove();
        }
    }

    public SchemaObject getSchemaObject() {
        return this.schemaObject;
    }

    public SchemaObject getOldSchemaObject() {
        return this.oldSchemaObject;
    }

    public void setSchemaObject(SchemaObject schemaObject) {
        List<ModelIDObject> list = this.getDependentConstrainedObjects();
        Map oldStat = this.getNameStatusMap(list);
        this.oldSchemaObject = this.getSchemaObject();
        String oldName = this.getName();
        if (this.schemaObject != schemaObject) {
            this.setDirty(true);
            if (schemaObject != null && !this.isBackup()) {
                schemaObject.getDesignObjectSet().addSetListener(this);
                schemaObject.addObjectListener(this);
            }
            if (this.oldSchemaObject != null && !this.isBackup()) {
                this.oldSchemaObject.removeObjectListener(this);
            }
        }
        this.schemaObject = schemaObject;
        if (!this.isBackup() && !this.getDesignObjectSet().updateNamesMap(this.oldSchemaObject, oldName, schemaObject, oldName, this)) {
            String newName = null;
            newName = schemaObject != null ? this.attemptNameVariant(schemaObject.getName(), oldName) : this.attemptNameVariant(oldName);
            if (newName != null && !oldName.equals(newName)) {
                this.name = newName;
                this.getDesignObjectSet().updateNamesMap(this.oldSchemaObject, oldName, schemaObject, newName, this);
            }
        }
        Map newStat = this.getNameStatusMap(list);
        this.processDependentConstrainedObjects(oldStat, newStat);
        this.schema = null;
        if (this.isRemoteObject() && schemaObject != null && schemaObject.isRemoteObject()) {
            this.remoteSchemaName = schemaObject.getName();
        }
        this.fireChange(ObjectChangeEvent.SCHEMA_CHANGED);
    }

    public void setSchemaObject(SchemaObject schemaObject, String oldSchemaName) {
        List<ModelIDObject> list = this.getDependentConstrainedObjects();
        Map oldStat = this.getNameStatusMap(list);
        String oldName = this.getName();
        this.oldSchemaObject = this.getSchemaObject();
        if (this.oldSchemaObject == schemaObject && schemaObject != null && !this.isBackup() && !oldSchemaName.equals(schemaObject.getName())) {
            this.getDesignObjectSet().updateNamesMapStr(oldSchemaName, this.getName(), schemaObject.getName(), oldName, this);
        }
        if (this.schemaObject != schemaObject) {
            this.setDirty(true);
            if (schemaObject != null && !this.isBackup()) {
                schemaObject.getDesignObjectSet().addSetListener(this);
                schemaObject.addObjectListener(this);
            }
            if (this.oldSchemaObject != null && !this.isBackup()) {
                this.oldSchemaObject.removeObjectListener(this);
            }
        }
        this.schemaObject = schemaObject;
        if (!this.isBackup() && this.oldSchemaObject != schemaObject && !this.getDesignObjectSet().updateNamesMap(this.oldSchemaObject, oldName, schemaObject, oldName, this)) {
            String newName = null;
            newName = schemaObject != null ? this.attemptNameVariant(schemaObject.getName(), oldName) : this.attemptNameVariant(oldName);
            if (newName != null) {
                this.name = newName;
                this.getDesignObjectSet().updateNamesMap(this.oldSchemaObject, oldName, schemaObject, newName, this);
            }
        }
        Map newStat = this.getNameStatusMap(list);
        this.processDependentConstrainedObjects(oldStat, newStat);
        this.schema = null;
        this.fireChange(ObjectChangeEvent.SCHEMA_CHANGED);
    }

    @Override
    public void copy(DesignObject desObject) {
        this.copySchemaObject((ContainerObject)desObject);
        super.copy(desObject);
    }

    private void copySchemaObject(ContainerObject co) {
        if (this.getDesignPart() == co.getDesignPart()) {
            co.setSchemaObject(this.getSchemaObject());
        } else if (this.getDesignPart() instanceof RelationalDesign && this.getSchemaObject() != null) {
            RelationalDesign rd = (RelationalDesign)co.getDesignPart();
            SchemaObject so = (SchemaObject)rd.getSchemaObjectSet().getByName(this.getSchemaObject().getName());
            if (so == null) {
                so = rd.getSchemaObjectSet().createSchemaObject(null);
                so.setName(this.getSchemaObject().getName());
                StorageDesign sd = rd.getStorageDesign();
                if (sd.isOpen()) {
                    StorageObject ob = (StorageObject)sd.getUserSchemaSet().getByName(this.getSchemaObject().getName());
                    if (ob == null) {
                        ob = (StorageObject)sd.getUserSchemaSet().createElement(null);
                    }
                    if (ob != null) {
                        ob.setName(so.getName());
                        ob.setSchemaObject(so);
                    }
                }
            }
            co.setSchemaObject(so);
        }
    }

    private void clearTypeSubstitutions() {
        Object[] subst = this.getSubTypeSubstitutions().toArray();
        for (int i = 0; i < subst.length; ++i) {
            if (!(subst[i] instanceof TypeSubstitution)) continue;
            ((TypeSubstitution)subst[i]).remove();
        }
        if (this.getTypeSubstitution() != null) {
            this.getTypeSubstitution().remove();
        }
    }

    protected List<ModelIDObject> getDependentConstrainedObjects() {
        return Collections.EMPTY_LIST;
    }

    private void processDependentConstrainedObjects(Map oldStatus, Map newStatus) {
        for (Map.Entry entry : oldStatus.entrySet()) {
            DesignObject obj;
            NameSpaceController nsc;
            NameStatus ostat = (NameStatus)entry.getValue();
            NameStatus nstat = (NameStatus)newStatus.get(entry.getKey());
            if (ostat == null || nstat == null || ostat.longName.equals(nstat.longName) || !(nstat.object instanceof DesignObject) || (nsc = (obj = (DesignObject)nstat.object).getDesignObjectSet().getNameSpaceController()) == null) continue;
            String newName = nstat.name;
            String newSchema = this.getSchemaFromLongName(nstat.longName, nstat.name);
            String validName = nsc.getValidName(obj, newSchema, newName);
            if (newName.equals(validName)) {
                String oldSchema = this.getSchemaFromLongName(ostat.longName, ostat.name);
                nsc.updateNamesMapStr(oldSchema, ostat.name, newSchema, newName, obj);
                continue;
            }
            obj.setName(validName);
        }
    }

    private String getSchemaFromLongName(String longname, String name) {
        if (longname.equals(name)) {
            return "";
        }
        int ind = longname.indexOf(name);
        if (ind > 1) {
            return longname.substring(0, ind - 1);
        }
        return "";
    }

    private Map getNameStatusMap(List<ModelIDObject> objects) {
        if (objects.size() > 0) {
            HashMap<ModelIDObject, NameStatus> map = new HashMap<ModelIDObject, NameStatus>();
            for (ModelIDObject obj : objects) {
                NameStatus stat = new NameStatus();
                stat.object = obj;
                stat.name = obj.getName();
                stat.longName = obj.getLongName();
                map.put(obj, stat);
            }
            return map;
        }
        return Collections.EMPTY_MAP;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        DesignPart design = this.getDesignPart();
        DesignObject result = design.getDesign().getDesignObject(id);
        if (result == null && design != null && design instanceof RelationalDesign && this.getDesign() != null) {
            RelationalDesign rd = (RelationalDesign)design;
            Map map = design.getDesign().getCorrespondenceMap();
            if (map != null) {
                result = map.get(id);
            }
            if (result == null && this.getRemoteObjectID() != null && "schemaObject".equals(propertyName)) {
                result = rd.getSchemaObjectSet().getObjectByRemoteObjectID(id);
            }
            return result;
        }
        return result;
    }

    public String getRemoteSchemaName() {
        if (this.isRemoteObject() && this.getSchemaObject() != null && this.getSchemaObject().isRemoteObject()) {
            this.remoteSchemaName = this.getSchemaObject().getName();
        }
        return this.remoteSchemaName;
    }

    public void setRemoteSchemaName(String remoteSchemaName) {
        this.remoteSchemaName = remoteSchemaName;
    }

    class NameStatus {
        ModelIDObject object;
        String name;
        String longName;

        NameStatus() {
        }
    }

    public class CreateTypeSubstitutionTask
    implements Task {
        private static final String TASK_NAME = "create TypeSubstitution task";
        ContainerObject co;

        CreateTypeSubstitutionTask(ContainerObject co) {
            this.co = co;
        }

        @Override
        public boolean execute() {
            this.co.createTypeSubstitution();
            return this.co.typeSubstitution != null;
        }

        public String toString() {
            return TASK_NAME;
        }
    }
}

