/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.oracle.FKComparatorOracle;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class FKComparator
extends PropertiesComparator {
    public static final String RELY = FKComparator.removeColon(Messages.getString("ForeignKeyPropertiesDialogEx.Rely"));
    private FKIndexAssociation lfk;
    private FKIndexAssociation rfk;
    private KeyObject right_key;
    private KeyObject left_key;
    private boolean matchingRemoteKey;
    private boolean matchingColumns;
    private Map objectsMap;
    private StorageDesign sourceSD;
    private StorageDesign targetSD;

    public FKComparator(FKIndexAssociation left_fk, FKIndexAssociation right_fk, boolean matchingRemoteKey, boolean matchingColumns, Map objectsMap, StorageDesign sourceSD, StorageDesign targetSD) {
        super(left_fk, right_fk);
        this.lfk = left_fk;
        this.rfk = right_fk;
        this.left_key = left_fk != null ? left_fk.getKeyObject() : null;
        this.right_key = right_fk != null ? right_fk.getKeyObject() : null;
        this.matchingRemoteKey = matchingRemoteKey;
        this.matchingColumns = matchingColumns;
        this.objectsMap = objectsMap;
        this.sourceSD = sourceSD;
        this.targetSD = targetSD;
        this.initPropertiesList();
        this.initDynamicProperties();
        this.initPropertiesFilterList();
        this.initPhysicalPropertiesComparator();
    }

    private void initPhysicalPropertiesComparator() {
        if (this.sourceSD instanceof StorageDesignOracle && this.targetSD instanceof StorageDesignOracle) {
            FKProxyOracle sourceFKProxy = null;
            if (this.lfk != null) {
                sourceFKProxy = (FKProxyOracle)((StorageDesignOracle)this.sourceSD).getFKProxySet().getProxy(this.lfk.getLocalFKIndex().getObjectID());
            }
            FKProxyOracle targetFKProxy = null;
            if (this.rfk != null) {
                targetFKProxy = (FKProxyOracle)((StorageDesignOracle)this.targetSD).getFKProxySet().getProxy(this.rfk.getLocalFKIndex().getObjectID());
            }
            this.setPhysicalPropertiesComparator(new FKComparatorOracle(sourceFKProxy, targetFKProxy));
        }
    }

    @Override
    protected void initPropertiesList() {
        PropertyHolder ph;
        this.initNameProperty();
        this.initCommentsAndNotes();
        if (!DDL_ONLY) {
            ph = new PropertyHolder(MANDATORY);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.lfk != null ? String.valueOf(this.lfk.isMandatory()) : "");
            ph.setRightValue(this.rfk != null ? String.valueOf(this.rfk.isMandatory()) : "");
            if (this.isExcludedFromComparison(MANDATORY)) {
                ph.setExcluded(true);
            } else if (this.rfk != null && this.lfk != null && this.rfk.isMandatory() != this.lfk.isMandatory()) {
                ph.setModified(true);
                ph.setSelected(true);
                ph.setEditable(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(TRANSFERABLE);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.lfk != null ? String.valueOf(this.lfk.isTransferable()) : "");
            ph.setRightValue(this.rfk != null ? String.valueOf(this.rfk.isTransferable()) : "");
            if (this.isExcludedFromComparison(TRANSFERABLE)) {
                ph.setExcluded(true);
            } else if (this.rfk != null && this.lfk != null && this.rfk.isTransferable() != this.lfk.isTransferable()) {
                ph.setModified(true);
                ph.setSelected(true);
                ph.setEditable(true);
            }
            this.propertiesList.add(ph);
        }
        ph = new PropertyHolder(DELETE_RULE);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.lfk != null ? this.lfk.getValidDeleteRule() : "");
        ph.setRightValue(this.rfk != null ? this.rfk.getValidDeleteRule() : "");
        if (this.isExcludedFromComparison(DELETE_RULE)) {
            ph.setExcluded(true);
        } else if (this.rfk != null && this.lfk != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
            ph.setEditable(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(IN_ARC);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.lfk != null && this.lfk.getArc() != null ? this.lfk.getArc().getName() : "");
        ph.setRightValue(this.rfk != null && this.rfk.getArc() != null ? this.rfk.getArc().getName() : "");
        if (this.isExcludedFromComparison(IN_ARC)) {
            ph.setExcluded(true);
        } else if (this.rfk != null && this.lfk != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
            ph.setEditable(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(PRIMARY_KEY);
        ph.setLeftValue(this.left_key != null ? this.left_key.getName() : "");
        ph.setRightValue(this.right_key != null ? this.right_key.getName() : "");
        if (this.isExcludedFromComparison(PRIMARY_KEY)) {
            ph.setExcluded(true);
        } else if (!DDL_ONLY && this.rfk != null && this.lfk != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            if (this.lfk != null && !this.lfk.isRefColumnsChanged()) {
                ph.setSelected(false);
            } else {
                ph.setSelected(true);
            }
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(REFERRED_COLUMNS);
        ph.setLeftValue(this.lfk != null ? FKComparator.getReferredColumnNames(this.lfk) : "");
        ph.setRightValue(this.rfk != null ? FKComparator.getReferredColumnNames(this.rfk) : "");
        if (this.isExcludedFromComparison(REFERRED_COLUMNS)) {
            ph.setExcluded(true);
        } else if (this.rfk != null && this.lfk != null && !ph.getLeftValue().equalsIgnoreCase(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(!this.areListsWithSameMembers(ph.getLeftValue(), ph.getRightValue()));
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(COLUMN_ASSOCIATION);
        ph.setLeftValue(this.lfk != null ? this.getElementsToString(this.lfk) : "");
        ph.setRightValue(this.rfk != null ? this.getElementsToString(this.rfk) : "");
        if (this.isExcludedFromComparison(COLUMN_ASSOCIATION)) {
            ph.setExcluded(true);
        } else if (this.rfk != null && this.lfk != null && !ph.getLeftValue().equalsIgnoreCase(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(!this.areListsWithSameMembers(ph.getLeftValue(), ph.getRightValue()));
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(RELY);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.lfk != null ? String.valueOf(this.lfk.isRely()) : "");
        ph.setRightValue(this.rfk != null ? String.valueOf(this.rfk.isRely()) : "");
        if (this.isExcludedFromComparison(RELY)) {
            ph.setExcluded(true);
        } else if (this.rfk != null && this.lfk != null && this.rfk.isRely() != this.lfk.isRely()) {
            ph.setModified(true);
            ph.setSelected(true);
            ph.setEditable(true);
        }
        this.propertiesList.add(ph);
        if (!DDL_ONLY) {
            ph = new PropertyHolder(DISCRIMINATOR_COLUMN);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.lfk != null ? this.getDiscriminatorName(this.lfk) : "");
            ph.setRightValue(this.rfk != null ? this.getDiscriminatorName(this.rfk) : "");
            if (this.isExcludedFromComparison(DISCRIMINATOR_COLUMN)) {
                ph.setExcluded(true);
            } else if (this.rfk != null && this.lfk != null && !ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                ph.setSelected(true);
                ph.setEditable(true);
            }
            this.propertiesList.add(ph);
            ph = new PropertyHolder(DISCRIMINATOR_VALUE);
            ph.setDDLHolder(false);
            ph.setLeftValue(this.lfk != null ? String.valueOf(this.lfk.getDiscriminatorValue()) : "");
            ph.setRightValue(this.rfk != null ? String.valueOf(this.rfk.getDiscriminatorValue()) : "");
            if (this.isExcludedFromComparison(DISCRIMINATOR_VALUE)) {
                ph.setExcluded(true);
            } else if (this.rfk != null && this.lfk != null && !ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                ph.setSelected(true);
                ph.setEditable(true);
            }
            this.propertiesList.add(ph);
        }
    }

    static String getReferredColumnNames(FKIndexAssociation fk) {
        String res = null;
        KeyObject key = fk.getRemoteIndex();
        if (key != null) {
            for (ContainedObject co : key.getElementsCollection()) {
                if (res == null) {
                    res = co.getName();
                    continue;
                }
                res = res + "," + co.getName();
            }
        } else {
            res = fk.getReferredColumnNames();
        }
        if (res == null) {
            return "";
        }
        return res;
    }

    private boolean areListsWithSameMembers(String left, String right) {
        String[] rparts;
        String[] lparts = left.split(",");
        if (lparts.length != (rparts = right.split(",")).length) {
            return false;
        }
        for (String ls : lparts) {
            String l = ls.trim();
            boolean found = false;
            for (String rs : rparts) {
                String r = rs.trim();
                if (!l.equalsIgnoreCase(r)) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private String getDiscriminatorName(FKIndexAssociation fk) {
        String discriminatorName = "";
        FKElement discriminatorColumn = fk.getDiscriminatorColumn();
        if (discriminatorColumn != null) {
            discriminatorName = discriminatorColumn.toString();
        }
        return discriminatorName;
    }

    private String getElementsToString(FKIndexAssociation fk) {
        StringBuffer sb = new StringBuffer();
        Iterator<FKElement> it = Arrays.asList(fk.getColumns()).iterator();
        boolean first = true;
        while (it.hasNext()) {
            ContainedObject co = it.next();
            if (first) {
                sb.append(co.getName());
                first = false;
                continue;
            }
            sb.append(",").append(co.getName());
        }
        return sb.toString();
    }

    private boolean hasColumnWithChangedName(FKIndexAssociation fk) {
        for (ContainedObject co : fk.getLocalFKIndex().getElementsCollection()) {
            if (!co.isNameChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromLeftFK();
    }

    private void copyPropertiesFromLeftFK() {
        if (this.rfk != null && this.lfk != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected() || !ph.getName().equals(COLUMN_ASSOCIATION)) continue;
                MergingModels.synchronizeColumnsFromIndexToKey(this.lfk.getLocalFKIndex(), this.rfk.getLocalFKIndex());
                break;
            }
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(MANDATORY)) {
                    this.rfk.setMandatory(this.lfk.isMandatory());
                    continue;
                }
                if (ph.getName().equals(TRANSFERABLE)) {
                    this.rfk.setTransferable(this.lfk.isTransferable());
                    continue;
                }
                if (ph.getName().equals(DELETE_RULE)) {
                    this.rfk.setDeleteRule(this.lfk.getDeleteRule());
                    continue;
                }
                if (ph.getName().equals(IN_ARC)) {
                    FKArc tArc = null;
                    FKArc sArc = this.lfk.getArc();
                    if (sArc != null) {
                        tArc = (FKArc)this.objectsMap.get(sArc.getObjectID());
                    }
                    this.rfk.setArc(tArc);
                    continue;
                }
                if (ph.getName().equals(PRIMARY_KEY)) {
                    KeyObject tKey = null;
                    KeyObject sKey = this.lfk.getKeyObject();
                    if (sKey != null) {
                        tKey = (KeyObject)this.objectsMap.get(sKey.getObjectID());
                    }
                    this.rfk.setKeyObject(tKey);
                    continue;
                }
                if (ph.getName().equals(RELY)) {
                    this.rfk.setRely(this.lfk.isRely());
                    continue;
                }
                if (ph.getName().equals(DISCRIMINATOR_COLUMN)) {
                    FKElement col = this.lfk.getDiscriminatorColumn();
                    if (col != null) {
                        FKElement tcol = (FKElement)this.objectsMap.get(col.getObjectID());
                        if (tcol == null) continue;
                        this.rfk.setDiscriminatorColumn(tcol);
                        continue;
                    }
                    this.rfk.setDiscriminatorColumn(null);
                    continue;
                }
                if (!ph.getName().equals(DISCRIMINATOR_VALUE)) continue;
                this.rfk.setDiscriminatorValue(this.lfk.getDiscriminatorValue());
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.lfk != null ? this.lfk.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.rfk != null ? this.rfk.getLongName() : "";
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.lfk == null && this.rfk != null) {
            return true;
        }
        return super.hasToBeDrop();
    }
}

