/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl;

import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGeneratorLiquibase;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBFKOraclev10g;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTableOracle;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.swingui.compare.CompareModelsDialog;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public abstract class AbstractCSSBOracle
extends SQLStatementBuilder {
    public static final String PREFIX = "bcp_";
    public static final String EXT_PREFIX = "EXT_";

    @Override
    protected void appendComment(StringBuffer buffer, ModelIDObject object) {
        if (CompareModelsDialog.isIncludeComments()) {
            StringTokenizer stok = new StringTokenizer(object.getComment(), "\n");
            buffer.append(NEWLINE);
            while (stok.hasMoreTokens()) {
                String line = stok.nextToken();
                while (line.length() > 76) {
                    int ind = 76;
                    if (line.indexOf(76) != 32 && line.indexOf(76) != 9 && line.indexOf(76) != 10) {
                        ind = line.substring(0, 76).lastIndexOf(32);
                        int ind2 = line.substring(0, 76).lastIndexOf(9);
                        int ind3 = line.substring(0, 76).lastIndexOf(10);
                        if (ind2 > ind) {
                            ind = ind2;
                        }
                        if (ind3 > ind) {
                            ind = ind3;
                        }
                        if (ind == -1) {
                            ind = 76;
                        }
                    }
                    buffer.append("--  ").append(line.substring(0, ind)).append(NEWLINE);
                    line = line.substring(ind + 1);
                }
                buffer.append("--  ").append(line).append(NEWLINE);
            }
        }
    }

    protected void appendTableCommentOn(StringBuffer oldbuffer, CompareObjectSelection tableObj, TableProxyOracle tableProxy, StorageDesignOracle storageDesign, boolean prettyPrint) {
        String tableCommentOn;
        StringBuffer buffer = new StringBuffer();
        if (tableProxy != null && this.isNotEmpty(tableCommentOn = tableProxy.isCommentInRDBMSChanged() ? tableProxy.getCommentInRDBMS() : tableObj.getChoosedPropertyValue(PropertiesComparator.COMMENT_IN_RDBMS))) {
            AbstractCSSBOracle.appendNewLine(oldbuffer, prettyPrint, 0);
            AbstractCSSBOracle.appendStringWithSpace(buffer, "COMMENT ON");
            AbstractCSSBOracle.appendStringWithSpace(buffer, "TABLE");
            AbstractCSSBOracle.appendStringWithSpace(buffer, AbstractCSSBOracle.getFormattedTableName(tableObj, storageDesign));
            String advancedComment = buffer.toString();
            AbstractCSSBOracle.appendStringWithSpace(buffer, "IS");
            AbstractCSSBOracle.appendString(buffer, '\'');
            AbstractCSSBOracle.appendString(buffer, this.replaceSingleQuote(tableCommentOn));
            AbstractCSSBOracle.appendStringWithSpace(buffer, '\'');
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            AbstractCSSBOracle.appendNewLine(buffer, prettyPrint, 0);
            AbstractCSSBOracle.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
        List columns = tableObj.getChildObjects(0);
        for (CompareObjectSelection columnSel : columns) {
            String comment;
            if (columnSel.canBeCreate() && !columnSel.isSelected() || columnSel.canBeDrop() && columnSel.isSelected() || (comment = columnSel.getChoosedPropertyValue(PropertiesComparator.COMMENT_IN_RDBMS, columnSel.isSelected())).trim().equals("")) continue;
            AbstractCSSBOracle.appendNewLine(oldbuffer, prettyPrint, 0);
            AbstractCSSBOracle.appendStringWithSpace(buffer, "COMMENT ON");
            AbstractCSSBOracle.appendStringWithSpace(buffer, "COLUMN");
            AbstractCSSBOracle.appendStringWithSpace(buffer, AbstractCSSBOracle.getFormattedTableName(tableObj, storageDesign) + '.' + AbstractCSSBOracle.getFormattedSelectedName(columnSel, storageDesign));
            String advancedComment = buffer.toString();
            AbstractCSSBOracle.appendStringWithSpace(buffer, "IS");
            AbstractCSSBOracle.appendString(buffer, '\'');
            AbstractCSSBOracle.appendString(buffer, this.replaceSingleQuote(comment));
            AbstractCSSBOracle.appendStringWithSpace(buffer, '\'');
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            AbstractCSSBOracle.appendNewLine(buffer, prettyPrint, 0);
            AbstractCSSBOracle.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }

    @Override
    protected String addQuotesToDefault(String dataType, String defaultValue) {
        String df = defaultValue.trim();
        String dfUpper = df.toUpperCase();
        if (("TRUE".equals(dfUpper) || "FALSE".equals(dfUpper)) && "DECIMAL".equalsIgnoreCase(dataType)) {
            return "TRUE".equals(dfUpper) ? "1" : "0";
        }
        if ("NULL".equals(dfUpper) || "ROWID".equals(dfUpper) || "CURRENT_DATE".equals(dfUpper) || "CURRENT_TIMESTAMP".equals(dfUpper) || "DBTIMEZONE".equals(dfUpper) || "LOCALTIMESTAMP".equals(dfUpper) || "SESSIONTIMEZONE".equals(dfUpper) || "SYSDATE".equals(dfUpper) || "SYSTIMESTAMP".equals(dfUpper) || "USER".equals(dfUpper) || dfUpper.endsWith(".CURRVAL") || dfUpper.endsWith(".NEXTVAL")) {
            return df;
        }
        return super.addQuotesToDefault(dataType, defaultValue);
    }

    @Override
    public void appendToBuffer(StringBuffer toBuffer, StringBuffer fromBuffer, String comment) {
        if (this.canAppendBuffer(fromBuffer)) {
            if (CDDLFileMaker.getddlAdvancedGenenerator() != null) {
                if (this.isNotLineFinisher(fromBuffer.toString())) {
                    if (DDLFileMaker.getddlAdvancedGenenerator() instanceof DDLAdvancedGeneratorLiquibase) {
                        DDLAdvancedGeneratorLiquibase gen = (DDLAdvancedGeneratorLiquibase)DDLFileMaker.getddlAdvancedGenenerator();
                        this.appendFormatedBufferLB(toBuffer, fromBuffer, comment, DDLFileMaker.getAdvancedStep(), true, false, gen.getAuthor(), gen.getBaseID());
                    } else {
                        toBuffer.append("-- Step").append(DDLFileMaker.getAdvancedStep());
                        this.appendFormatedBuffer(toBuffer, fromBuffer, comment, DDLFileMaker.getAdvancedStep(), true);
                    }
                    CDDLFileMaker.incrementAdvancedStep();
                }
            } else {
                toBuffer.append(fromBuffer);
            }
            fromBuffer.setLength(0);
        }
    }

    @Override
    protected boolean hasToBeBackup() {
        return CompareModelsDialog.isBackup();
    }

    protected void appendScriptExecution(StringBuffer toBuffer, String name) {
        if (CDDLFileMaker.getddlAdvancedGenenerator() != null) {
            AbstractCSSBOracle.appendNewLine(toBuffer, true, 0);
            toBuffer.append("-- stop_script execution");
            AbstractCSSBOracle.appendNewLine(toBuffer, true, 0);
            toBuffer.append("-- Step").append(CDDLFileMaker.getAdvancedStep());
            AbstractCSSBOracle.appendNewLine(toBuffer, true, 0);
            AbstractCSSBOracle.appendString(toBuffer, "declare");
            AbstractCSSBOracle.appendNewLine(toBuffer, true, 1);
            AbstractCSSBOracle.appendString(toBuffer, "start_step NUMBER;");
            AbstractCSSBOracle.appendNewLine(toBuffer, true, 1);
            AbstractCSSBOracle.appendString(toBuffer, "stop_step NUMBER;");
            AbstractCSSBOracle.appendNewLine(toBuffer, true, 0);
            AbstractCSSBOracle.appendString(toBuffer, "begin");
            AbstractCSSBOracle.appendNewLine(toBuffer, true, 1);
            AbstractCSSBOracle.appendString(toBuffer, "start_step := adv_scripting.GET_START_STEP();");
            AbstractCSSBOracle.appendNewLine(toBuffer, true, 1);
            AbstractCSSBOracle.appendString(toBuffer, "stop_step := adv_scripting.GET_STOP_STEP();");
            AbstractCSSBOracle.appendNewLine(toBuffer, true, 1);
            AbstractCSSBOracle.appendString(toBuffer, "if ");
            AbstractCSSBOracle.appendString(toBuffer, CDDLFileMaker.getAdvancedStep());
            AbstractCSSBOracle.appendString(toBuffer, "  > start_step and (stop_step = 0 OR ");
            AbstractCSSBOracle.appendString(toBuffer, CDDLFileMaker.getAdvancedStep());
            AbstractCSSBOracle.appendString(toBuffer, " <= stop_step) then");
            AbstractCSSBOracle.appendNewLine(toBuffer, true, 1);
            AbstractCSSBOracle.appendString(toBuffer, "  DBMS_OUTPUT.PUT_LINE('Step ");
            AbstractCSSBOracle.appendString(toBuffer, CDDLFileMaker.getAdvancedStep());
            AbstractCSSBOracle.appendString(toBuffer, " USER BREAK');");
            AbstractCSSBOracle.appendNewLine(toBuffer, true, 1);
            AbstractCSSBOracle.appendString(toBuffer, "  adv_scripting.STOP_EXECUTION('");
            AbstractCSSBOracle.appendString(toBuffer, name);
            AbstractCSSBOracle.appendString(toBuffer, "');");
            AbstractCSSBOracle.appendNewLine(toBuffer, true, 1);
            AbstractCSSBOracle.appendString(toBuffer, "end if;");
            AbstractCSSBOracle.appendNewLine(toBuffer, true, 0);
            AbstractCSSBOracle.appendString(toBuffer, "end;");
            AbstractCSSBOracle.appendNewLine(toBuffer, true, 0);
            AbstractCSSBOracle.appendString(toBuffer, "/");
            AbstractCSSBOracle.appendNewLine(toBuffer, true, 0);
            toBuffer.append("-- end Step").append(CDDLFileMaker.getAdvancedStep());
            AbstractCSSBOracle.appendNewLine(toBuffer, true, 0);
            AbstractCSSBOracle.appendNewLine(toBuffer, true, 0);
            CDDLFileMaker.incrementAdvancedStep();
        }
    }

    protected void appendUnloadHeader(StringBuffer toBuffer, StringBuffer fromBuffer, String tableName, String partitionName) {
        if (CDDLFileMaker.getddlAdvancedGenenerator() != null) {
            AbstractCSSBOracle.appendNewLine(fromBuffer, true, 0);
            AbstractCSSBOracle.appendNewLine(fromBuffer, true, 0);
            fromBuffer.append("-- Step").append(CDDLFileMaker.getAdvancedStep());
            AbstractCSSBOracle.appendNewLine(fromBuffer, true, 0);
            fromBuffer.append("declare");
            AbstractCSSBOracle.appendNewLine(fromBuffer, true, 0);
            fromBuffer.append("    start_step NUMBER;");
            AbstractCSSBOracle.appendNewLine(fromBuffer, true, 0);
            fromBuffer.append("    stop_step NUMBER;");
            AbstractCSSBOracle.appendNewLine(fromBuffer, true, 0);
            fromBuffer.append("    query varchar2(4000);");
            AbstractCSSBOracle.appendNewLine(fromBuffer, true, 0);
            fromBuffer.append("    begin");
            AbstractCSSBOracle.appendNewLine(fromBuffer, true, 0);
            fromBuffer.append("    start_step := adv_scripting.GET_START_STEP(); ");
            AbstractCSSBOracle.appendNewLine(fromBuffer, true, 0);
            fromBuffer.append("    stop_step := adv_scripting.GET_STOP_STEP(); ");
            AbstractCSSBOracle.appendNewLine(fromBuffer, true, 0);
            AbstractCSSBOracle.appendString(fromBuffer, "    if ");
            AbstractCSSBOracle.appendString(fromBuffer, CDDLFileMaker.getAdvancedStep());
            AbstractCSSBOracle.appendString(fromBuffer, "  > start_step and (stop_step = 0 OR ");
            AbstractCSSBOracle.appendString(fromBuffer, CDDLFileMaker.getAdvancedStep());
            AbstractCSSBOracle.appendString(fromBuffer, " <= stop_step) then");
            AbstractCSSBOracle.appendNewLine(fromBuffer, true, 0);
            AbstractCSSBOracle.appendString(fromBuffer, "    DBMS_OUTPUT.PUT_LINE('Step ");
            AbstractCSSBOracle.appendString(fromBuffer, CDDLFileMaker.getAdvancedStep());
            AbstractCSSBOracle.appendString(fromBuffer, " unload for table ");
            AbstractCSSBOracle.appendString(fromBuffer, tableName);
            if (this.isNotEmpty(partitionName)) {
                AbstractCSSBOracle.appendString(fromBuffer, "  partition ");
                AbstractCSSBOracle.appendString(fromBuffer, partitionName);
            }
            AbstractCSSBOracle.appendString(fromBuffer, "');");
            toBuffer.append(fromBuffer);
            CDDLFileMaker.incrementAdvancedStep();
        }
        fromBuffer.setLength(0);
    }

    protected void appendSegment(StringBuffer buffer, SegmentOracle segment, boolean prettyPrint, TableSpaceOracle tableSpace, String logging, List propList) {
        StorageDesignOracle storageDesign;
        if (segment != null && (storageDesign = (StorageDesignOracle)segment.getStorageDesign()).getAppView().getSettings().isIncludeStorageInDDL()) {
            if (storageDesign.getAppView().getSettings().isIncludePctFreeInDDL() && (propList == null || propList.contains("PCTFREE"))) {
                AbstractCSSBOracle.appendNewLine(buffer, prettyPrint, 2);
                AbstractCSSBOracle.appendStringWithSpace(buffer, "PCTFREE");
                AbstractCSSBOracle.appendStringWithSpace(buffer, segment.getPCTFree());
            }
            if (storageDesign.getAppView().getSettings().isIncludePctUsedInDDL() && (propList == null || propList.contains("PCTUSED"))) {
                AbstractCSSBOracle.appendNewLine(buffer, prettyPrint, 2);
                AbstractCSSBOracle.appendStringWithSpace(buffer, "PCTUSED");
                AbstractCSSBOracle.appendStringWithSpace(buffer, segment.getPCTUsed());
            }
            if (storageDesign.getAppView().getSettings().isIncludeInitransInDDL() && (propList == null || propList.contains("INITRANS"))) {
                AbstractCSSBOracle.appendNewLine(buffer, prettyPrint, 2);
                AbstractCSSBOracle.appendStringWithSpace(buffer, "INITRANS");
                AbstractCSSBOracle.appendStringWithSpace(buffer, segment.getInitrans());
                if (!(storageDesign instanceof StorageDesignOraclev10g) && (propList == null || propList.contains("MAXTRANS"))) {
                    AbstractCSSBOracle.appendNewLine(buffer, prettyPrint, 2);
                    AbstractCSSBOracle.appendStringWithSpace(buffer, "MAXTRANS");
                    AbstractCSSBOracle.appendStringWithSpace(buffer, segment.getMaxTrans());
                }
            }
            if (storageDesign.getAppView().getSettings().isIncludeBufferPoolInDDL() && (propList == null || propList.contains("BUFFER_POOL"))) {
                AbstractCSSBOracle.appendNewLine(buffer, prettyPrint, 2);
                AbstractCSSBOracle.appendStringWithSpace(buffer, "STORAGE");
                AbstractCSSBOracle.appendStringWithSpace(buffer, '(');
                AbstractCSSBOracle.appendNewLine(buffer, prettyPrint, 2);
                AbstractCSSBOracle.appendStringWithSpace(buffer, "BUFFER_POOL");
                AbstractCSSBOracle.appendStringWithSpace(buffer, segment.getSCBufferPool());
                AbstractCSSBOracle.appendNewLine(buffer, prettyPrint, 1);
                AbstractCSSBOracle.appendStringWithSpace(buffer, ')');
            }
        }
    }

    protected static String getFormattedSelectedName(CompareObjectSelection obj, StorageDesign storageDesign) {
        if (obj != null) {
            PropertiesComparator propsComparator = obj.getPropertiesComparator();
            ModelIDObject modelObj = propsComparator.getLeftObject();
            if (modelObj == null || !obj.isSelected() || propsComparator.isTargetSelected(PropertiesComparator.NAME)) {
                modelObj = propsComparator.getRightObject();
            }
            if (modelObj != null) {
                return storageDesign.getFormatedName(modelObj);
            }
        }
        return "";
    }

    public static String getFormattedTableName(CompareObjectSelection tableSel, StorageDesign storageDesign) {
        if (tableSel != null) {
            ModelIDObject userOrSchema = null;
            if (storageDesign.getAppView().getSettings().isIncludeSchemaInDDL()) {
                RelationalObjectProxy proxyObj;
                CompareObjectSelection selectedObj = tableSel.getPropertiesComparator().getLeftSelectionObject();
                if (selectedObj != null) {
                    if (tableSel.isTargetSelected(PropertiesComparator.SCHEMA)) {
                        selectedObj = selectedObj.getCorrespondentNode();
                    }
                    if (selectedObj != null) {
                        tableSel = selectedObj;
                    }
                }
                if ((proxyObj = tableSel.getProxy()) == null || !proxyObj.getStorageDesign().isOpen()) {
                    ModelIDObject containerObj = tableSel.getObject();
                    if (containerObj instanceof ContainerObject) {
                        userOrSchema = ((ContainerObject)containerObj).getSchemaObject();
                    }
                } else if (proxyObj instanceof TableProxy) {
                    userOrSchema = ((TableProxy)proxyObj).getSchemaImplementingObject();
                } else if (proxyObj instanceof TableViewProxy) {
                    userOrSchema = ((TableViewProxy)proxyObj).getSchemaImplementingObject();
                }
            }
            String name = AbstractCSSBOracle.getFormattedSelectedName(tableSel, storageDesign);
            if (userOrSchema != null) {
                return storageDesign.getFormatedName(userOrSchema) + '.' + name;
            }
            return name;
        }
        return "";
    }

    protected void appendTo(StringBuffer buffer, PermissionsOracle permissions, StorageDesign storageDesign) {
        AbstractCSSBOracle.appendStringWithSpace(buffer, "TO");
        if ("YES".equalsIgnoreCase(permissions.getPublic())) {
            AbstractCSSBOracle.appendStringWithSpace(buffer, "PUBLIC");
        } else {
            AbstractStorageObjectOracle userOrRole = permissions.getUser();
            if (userOrRole == null) {
                userOrRole = permissions.getRole();
            }
            if (userOrRole != null) {
                if (userOrRole.getName().equals("PUBLIC")) {
                    AbstractCSSBOracle.appendStringWithSpace(buffer, "PUBLIC");
                } else {
                    AbstractCSSBOracle.appendStringWithSpace(buffer, storageDesign.getFormatedName(userOrRole));
                }
            }
        }
    }

    protected void appendRestoreFKs(List list, Map sourceIndexes, StringBuffer oldbuffer, StorageDesignOracle storageDesign, Table table, boolean excludeExistingFKs) {
        Connection conn;
        HashMap<String, MOHTableOracle.PK_UK_helper> cmap = null;
        if (list.size() > 0) {
            cmap = new HashMap<String, MOHTableOracle.PK_UK_helper>();
        }
        for (Index cind : list) {
            Index sind = (Index)sourceIndexes.get(cind);
            MOHTableOracle.PK_UK_helper hlp = new MOHTableOracle.PK_UK_helper(cind, sind);
            cmap.put(hlp.getID(), hlp);
        }
        if (cmap != null && cmap.size() > 0 && (conn = this.getDDLGenerator().getDatabaseConnection()) != null) {
            List<MOHTableOracle.FKTemp> flist = MOHTableOracle.getFKDefinitionsForPK_UK(conn, cmap, this.getDDLGenerator().isDbaUser());
            if (excludeExistingFKs) {
                FKIndexAssociationSet fkset = table.getRelationalModel().getFKIndexAssociationSet();
                for (int i = flist.size() - 1; i >= 0; --i) {
                    MOHTableOracle.FKTemp fkt = flist.get(i);
                    if (fkset.getBySchemaAndName(fkt.owner, fkt.name) == null) continue;
                    flist.remove(i);
                }
            }
            SSBFKOraclev10g.appendFK_DDL(oldbuffer, flist, storageDesign, this);
        }
    }

    protected List<MOHTableOracle.FKTemp> getFKDescriptorsForRestoreFKs(List list, Map sourceIndexes, StorageDesignOracle storageDesign, FKContainer table, boolean excludeExistingFKs) {
        Connection conn;
        HashMap<String, MOHTableOracle.PK_UK_helper> cmap = null;
        if (list.size() > 0) {
            cmap = new HashMap<String, MOHTableOracle.PK_UK_helper>();
        }
        for (KeyObject cind : list) {
            KeyObject sind = (KeyObject)sourceIndexes.get(cind);
            MOHTableOracle.PK_UK_helper hlp = new MOHTableOracle.PK_UK_helper(cind, sind);
            cmap.put(hlp.getID(), hlp);
        }
        if (cmap != null && cmap.size() > 0 && (conn = this.getDDLGenerator().getDatabaseConnection()) != null) {
            List<MOHTableOracle.FKTemp> flist = MOHTableOracle.getFKDefinitionsForPK_UK(conn, cmap, this.getDDLGenerator().isDbaUser());
            if (excludeExistingFKs) {
                FKIndexAssociationSet fkset = table.getRelationalModel().getFKIndexAssociationSet();
                for (int i = flist.size() - 1; i >= 0; --i) {
                    MOHTableOracle.FKTemp fkt = flist.get(i);
                    if (fkset.getBySchemaAndName(fkt.owner, fkt.name) == null) continue;
                    flist.remove(i);
                }
            }
            return flist;
        }
        return Collections.EMPTY_LIST;
    }

    public Map getPropertiesMap(CompareObjectSelection obj) {
        TreeMap<String, EngPropertyHolder> propMap = new TreeMap<String, EngPropertyHolder>();
        for (EngPropertyHolder ph : obj.getPropertiesComparator().getPropertiesList()) {
            if (!ph.isSelected() || !ph.isModified() || !ph.isDDLHolder() || ph.isExcluded() || ph.isFiltered()) continue;
            propMap.put(ph.getName(), ph);
        }
        return propMap;
    }

    protected void appendRestoreFKs(List list, Map sourceIndexes, StringBuffer oldbuffer, StorageDesignOracle storageDesign, FKContainer table, boolean excludeExistingFKs) {
        List<MOHTableOracle.FKTemp> flist = this.getFKDescriptorsForRestoreFKs(list, sourceIndexes, storageDesign, table, excludeExistingFKs);
        SSBFKOraclev10g.appendFK_DDL(oldbuffer, flist, storageDesign, this);
    }
}

